/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.protocols;

import com.ivistaportal.solibrary.protocols.SpreadsheetProtocol;
import com.ivistaportal.solibrary.protocols.Utils;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XCellRangeReferrer;
import com.sun.star.sheet.XNamedRange;
import com.sun.star.sheet.XNamedRanges;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XSelectionChangeListener;
import com.sun.star.view.XSelectionSupplier;
import java.util.Vector;

public class SpreadsheetDocumentProtocol {
    static /* synthetic */ Class class$com$sun$star$container$XIndexAccess;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeReferrer;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeAddressable;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;

    public static synchronized XSpreadsheet addNewSheet(XSpreadsheetDocument _document, String _sheetName) throws Exception {
        Object result = null;
        _document.getSheets().insertNewByName(_sheetName, (short)0);
        return SpreadsheetDocumentProtocol.getSpreadsheetByName(_document, _sheetName);
    }

    public static synchronized void addSelectionChangeListener(XSpreadsheetDocument _xSpreadsheetDocument, XSelectionChangeListener _xSelectionChangeListener) {
        XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel != null ? class$com$sun$star$frame$XModel : (class$com$sun$star$frame$XModel = SpreadsheetDocumentProtocol.class$("com.sun.star.frame.XModel"))), (Object)_xSpreadsheetDocument);
        XController xCurrentController = xModel.getCurrentController();
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier != null ? class$com$sun$star$view$XSelectionSupplier : (class$com$sun$star$view$XSelectionSupplier = SpreadsheetDocumentProtocol.class$("com.sun.star.view.XSelectionSupplier"))), (Object)xCurrentController);
        xSelectionSupplier.addSelectionChangeListener(_xSelectionChangeListener);
    }

    protected static synchronized Vector checkRangeSyntax(String _rangeStr) throws Exception {
        Vector rangeTokens = Utils.rangeStrParser(_rangeStr);
        if (rangeTokens.size() < 2) {
            throw new Exception("Range: " + _rangeStr + " is not correct");
        }
        return rangeTokens;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static synchronized void copyRangeByNames(XSpreadsheetDocument _xSpreadsheetDocument, String _sourceCellRange, String _destCellAddress) throws Exception {
        String temp;
        String sourceCellRange = _sourceCellRange;
        String destCellAddress = _destCellAddress;
        try {
            sourceCellRange = temp = SpreadsheetDocumentProtocol.getNamedRangeContent(_xSpreadsheetDocument, _sourceCellRange);
        }
        catch (Exception exception) {}
        try {
            destCellAddress = temp = SpreadsheetDocumentProtocol.getNamedRangeContent(_xSpreadsheetDocument, _destCellAddress);
        }
        catch (Exception exception) {}
        StringBuffer str = new StringBuffer(sourceCellRange);
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '$') {
                str.deleteCharAt(i);
            }
            ++i;
        }
        sourceCellRange = str.toString();
        str = new StringBuffer(destCellAddress);
        int i2 = 0;
        while (i2 < str.length()) {
            if (str.charAt(i2) == '$') {
                str.deleteCharAt(i2);
            }
            ++i2;
        }
        destCellAddress = str.toString();
        Vector source = SpreadsheetDocumentProtocol.checkRangeSyntax(sourceCellRange);
        Vector dest = SpreadsheetDocumentProtocol.checkRangeSyntax(destCellAddress);
        String sourceSheetName = (String)source.elementAt(0);
        String destSheetName = (String)dest.elementAt(0);
        XSpreadsheet xSourceSpreadsheet = SpreadsheetDocumentProtocol.getSpreadsheetByName(_xSpreadsheetDocument, sourceSheetName);
        if (sourceSheetName.toUpperCase().equals(destSheetName.toUpperCase())) {
            SpreadsheetProtocol.copyRangeByNames(xSourceSpreadsheet, sourceCellRange, destCellAddress);
        } else {
            CellRangeAddress sourceCellRangeAddress = SpreadsheetProtocol.getCellRangeAddr(xSourceSpreadsheet, sourceCellRange);
            XSpreadsheet xDestSpreadsheet = SpreadsheetDocumentProtocol.getSpreadsheetByName(_xSpreadsheetDocument, destSheetName);
            CellRangeAddress cellRangeAddr = SpreadsheetProtocol.getCellRangeAddr(xDestSpreadsheet, destCellAddress);
            CellAddress cellAddress = new CellAddress();
            cellAddress.Sheet = cellRangeAddr.Sheet;
            cellAddress.Column = cellRangeAddr.StartColumn;
            cellAddress.Row = cellRangeAddr.StartRow;
            SpreadsheetProtocol.copyRangeByRangeAddress(xSourceSpreadsheet, cellAddress, sourceCellRangeAddress);
        }
    }

    public static synchronized XCellRange getCellRangeByNamedRange(XSpreadsheetDocument _xSpreadsheetDocument, String _namedRange) throws Exception {
        XCellRange xCellRange = null;
        try {
            XNamedRanges xNamedRanges = (XNamedRanges)SpreadsheetDocumentProtocol.getPropertyValue(_xSpreadsheetDocument, "NamedRanges");
            XNamedRange xNamedRange = (XNamedRange)xNamedRanges.getByName(_namedRange);
            XCellRangeReferrer xCellRangeReferrer = (XCellRangeReferrer)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeReferrer != null ? class$com$sun$star$sheet$XCellRangeReferrer : (class$com$sun$star$sheet$XCellRangeReferrer = SpreadsheetDocumentProtocol.class$("com.sun.star.sheet.XCellRangeReferrer"))), (Object)xNamedRange);
            xCellRange = xCellRangeReferrer.getReferredCells();
        }
        catch (NoSuchElementException ex) {
            throw new Exception(ex.getMessage());
        }
        return xCellRange;
    }

    public static synchronized String getCurrentSelection(XSpreadsheetDocument _xSpreadsheetDocument) throws Exception {
        String result = "";
        if (_xSpreadsheetDocument != null) {
            XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel != null ? class$com$sun$star$frame$XModel : (class$com$sun$star$frame$XModel = SpreadsheetDocumentProtocol.class$("com.sun.star.frame.XModel"))), (Object)_xSpreadsheetDocument);
            XInterface xInterface = (XInterface)xModel.getCurrentSelection();
            XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable != null ? class$com$sun$star$sheet$XCellRangeAddressable : (class$com$sun$star$sheet$XCellRangeAddressable = SpreadsheetDocumentProtocol.class$("com.sun.star.sheet.XCellRangeAddressable"))), (Object)xInterface);
            CellRangeAddress cellRangeAddress = xCellRangeAddressable.getRangeAddress();
            XSpreadsheet xSpreadsheet = SpreadsheetDocumentProtocol.getSpreadsheetByIndex(_xSpreadsheetDocument, cellRangeAddress.Sheet);
            String sheetName = SpreadsheetProtocol.getSheetName(xSpreadsheet);
            StringBuffer prevResult = new StringBuffer();
            prevResult.append(String.valueOf(sheetName) + ".");
            prevResult.append(Utils.getCellAddessAsString(cellRangeAddress.StartColumn, cellRangeAddress.StartRow));
            prevResult.append(":");
            prevResult.append(Utils.getCellAddessAsString(cellRangeAddress.EndColumn, cellRangeAddress.EndRow));
            result = prevResult.toString();
        }
        return result;
    }

    public static synchronized XSpreadsheet getCurrentSheet(XSpreadsheetDocument _document) throws Exception {
        XSpreadsheet result = null;
        if (_document != null) {
            XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel != null ? class$com$sun$star$frame$XModel : (class$com$sun$star$frame$XModel = SpreadsheetDocumentProtocol.class$("com.sun.star.frame.XModel"))), (Object)_document);
            XInterface xInterface = (XInterface)xModel.getCurrentSelection();
            XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable != null ? class$com$sun$star$sheet$XCellRangeAddressable : (class$com$sun$star$sheet$XCellRangeAddressable = SpreadsheetDocumentProtocol.class$("com.sun.star.sheet.XCellRangeAddressable"))), (Object)xInterface);
            CellRangeAddress cellRangeAddress = xCellRangeAddressable.getRangeAddress();
            result = SpreadsheetDocumentProtocol.getSpreadsheetByIndex(_document, cellRangeAddress.Sheet);
        }
        return result;
    }

    public static synchronized String getDocumentURL(XSpreadsheetDocument _xSpreadsheetDocument) {
        String docName = "";
        XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel != null ? class$com$sun$star$frame$XModel : (class$com$sun$star$frame$XModel = SpreadsheetDocumentProtocol.class$("com.sun.star.frame.XModel"))), (Object)_xSpreadsheetDocument);
        docName = xModel.getURL();
        return docName;
    }

    public static synchronized String getNamedRangeContent(XSpreadsheetDocument _xSpreadsheetDocument, String _namedRange) throws Exception {
        String namedRangeContent = "";
        try {
            XNamedRanges xNamedRanges = (XNamedRanges)SpreadsheetDocumentProtocol.getPropertyValue(_xSpreadsheetDocument, "NamedRanges");
            XNamedRange xNamedRange = (XNamedRange)xNamedRanges.getByName(_namedRange);
            namedRangeContent = xNamedRange.getContent();
        }
        catch (NoSuchElementException ex) {
            throw new Exception(ex.getMessage());
        }
        return namedRangeContent;
    }

    public static synchronized String[] getNamedRangeNames(XSpreadsheetDocument _xSpreadsheetDocument) throws Exception {
        XNamedRanges xNamedRanges = (XNamedRanges)SpreadsheetDocumentProtocol.getPropertyValue(_xSpreadsheetDocument, "NamedRanges");
        String[] namedRangeNames = xNamedRanges.getElementNames();
        return namedRangeNames;
    }

    private static synchronized XInterface getPropertyValue(XSpreadsheetDocument _xSpreadsheetDocument, String _propertyName) throws Exception {
        XInterface xInterface = null;
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : (class$com$sun$star$beans$XPropertySet = SpreadsheetDocumentProtocol.class$("com.sun.star.beans.XPropertySet"))), (Object)_xSpreadsheetDocument);
            xInterface = (XInterface)xPropertySet.getPropertyValue(_propertyName);
        }
        catch (WrappedTargetException ex) {
            throw new Exception(ex.getMessage());
        }
        catch (UnknownPropertyException ex) {
            throw new Exception(ex.getMessage());
        }
        return xInterface;
    }

    public static synchronized String[] getSheetNames(XSpreadsheetDocument _xSpreadsheetDocument) {
        return _xSpreadsheetDocument.getSheets().getElementNames();
    }

    public static synchronized XSpreadsheet getSpreadsheetByIndex(XSpreadsheetDocument _xSpreadsheetDocument, int _index) throws Exception {
        XSpreadsheet xSpreadsheet = null;
        try {
            XSpreadsheets xSpreadsheets = _xSpreadsheetDocument.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess != null ? class$com$sun$star$container$XIndexAccess : (class$com$sun$star$container$XIndexAccess = SpreadsheetDocumentProtocol.class$("com.sun.star.container.XIndexAccess"))), (Object)xSpreadsheets);
            xSpreadsheet = (XSpreadsheet)xIndexAccess.getByIndex(_index);
        }
        catch (WrappedTargetException ex) {
            throw new Exception(ex.getMessage());
        }
        return xSpreadsheet;
    }

    public static synchronized XSpreadsheet getSpreadsheetByName(XSpreadsheetDocument _xSpreadsheetDocument, String _SpreadsheetName) throws Exception {
        XSpreadsheet xSpreadsheet = null;
        try {
            xSpreadsheet = (XSpreadsheet)_xSpreadsheetDocument.getSheets().getByName(_SpreadsheetName);
        }
        catch (WrappedTargetException ex) {
            throw new Exception(ex.getMessage());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Exception("Spreadsheet " + _SpreadsheetName + " was not founded");
        }
        return xSpreadsheet;
    }

    public static synchronized void removeSelectionChangeListener(XSpreadsheetDocument _xSpreadsheetDocument, XSelectionChangeListener _xSelectionChangeListener) {
        XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel != null ? class$com$sun$star$frame$XModel : (class$com$sun$star$frame$XModel = SpreadsheetDocumentProtocol.class$("com.sun.star.frame.XModel"))), (Object)_xSpreadsheetDocument);
        XController xCurrentController = xModel.getCurrentController();
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier != null ? class$com$sun$star$view$XSelectionSupplier : (class$com$sun$star$view$XSelectionSupplier = SpreadsheetDocumentProtocol.class$("com.sun.star.view.XSelectionSupplier"))), (Object)xCurrentController);
        xSelectionSupplier.removeSelectionChangeListener(_xSelectionChangeListener);
    }

    public static synchronized void saveSpreadsheetDocumentAsURL(XSpreadsheetDocument _xSpreadsheetDocument, String _URL) throws Exception {
        if (_xSpreadsheetDocument != null) {
            XStorable xStore = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable != null ? class$com$sun$star$frame$XStorable : (class$com$sun$star$frame$XStorable = SpreadsheetDocumentProtocol.class$("com.sun.star.frame.XStorable"))), (Object)_xSpreadsheetDocument);
            PropertyValue[] xValues = new PropertyValue[1];
            PropertyValue xValue = new PropertyValue();
            xValue.Name = "Overwrite";
            xValues[0] = xValue;
            xStore.storeAsURL(_URL, xValues);
        }
    }
}

