/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.protocols;

import com.ivistaportal.solibrary.protocols.Utils;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.XChartData;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.container.XNamed;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.sheet.XCellRangeMovement;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.Vector;

public class SpreadsheetProtocol {
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeMovement;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeAddressable;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeData;
    static /* synthetic */ Class class$com$sun$star$chart$XChartData;
    static /* synthetic */ Class class$com$sun$star$table$XTableChartsSupplier;
    static /* synthetic */ Class class$com$sun$star$document$XEmbeddedObjectSupplier;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$chart$XDiagram;
    static /* synthetic */ Class class$com$sun$star$chart$XChartDocument;
    static /* synthetic */ Class class$com$sun$star$drawing$XDrawPageSupplier;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;

    public static synchronized XChartDocument addNewChart(XSpreadsheet _xSpreadsheet, String _chartName, String _rangeStr, String _chartType, int _xPos, int _yPos, int _width, int _height) throws Exception {
        SpreadsheetProtocol.checkRangeCorrectSyntax(_xSpreadsheet, _rangeStr);
        CellRangeAddress cellRangeAddress = SpreadsheetProtocol.getCellRangeAddr(_xSpreadsheet, _rangeStr);
        CellRangeAddress[] cellRangeArray = new CellRangeAddress[]{cellRangeAddress};
        XTableCharts xTableCharts = SpreadsheetProtocol.getChartContainerInterface(_xSpreadsheet);
        Rectangle posAndSize = new Rectangle(_xPos, _yPos, _width, _height);
        xTableCharts.addNewByName(_chartName, posAndSize, cellRangeArray, false, false);
        XTableChart tchart = SpreadsheetProtocol.getChartByName(_xSpreadsheet, _chartName);
        XEmbeddedObjectSupplier embeddedObj = (XEmbeddedObjectSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$document$XEmbeddedObjectSupplier != null ? class$com$sun$star$document$XEmbeddedObjectSupplier : (class$com$sun$star$document$XEmbeddedObjectSupplier = SpreadsheetProtocol.class$("com.sun.star.document.XEmbeddedObjectSupplier"))), (Object)tchart);
        XComponent comp = embeddedObj.getEmbeddedObject();
        XMultiServiceFactory chartFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory != null ? class$com$sun$star$lang$XMultiServiceFactory : (class$com$sun$star$lang$XMultiServiceFactory = SpreadsheetProtocol.class$("com.sun.star.lang.XMultiServiceFactory"))), (Object)comp);
        Object diagramObj = chartFactory.createInstance(_chartType);
        XDiagram _xDiagram = (XDiagram)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XDiagram != null ? class$com$sun$star$chart$XDiagram : (class$com$sun$star$chart$XDiagram = SpreadsheetProtocol.class$("com.sun.star.chart.XDiagram"))), (Object)diagramObj);
        XChartDocument xChartDocument = (XChartDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartDocument != null ? class$com$sun$star$chart$XChartDocument : (class$com$sun$star$chart$XChartDocument = SpreadsheetProtocol.class$("com.sun.star.chart.XChartDocument"))), (Object)comp);
        xChartDocument.setDiagram(_xDiagram);
        return xChartDocument;
    }

    public static synchronized void addNewChartByName(XSpreadsheet _xSpreadsheet, String _chartName, String _rangeStr) throws Exception {
        SpreadsheetProtocol.checkRangeCorrectSyntax(_xSpreadsheet, _rangeStr);
        CellRangeAddress cellRangeAddress = SpreadsheetProtocol.getCellRangeAddr(_xSpreadsheet, _rangeStr);
        CellRangeAddress[] cellRangeArray = new CellRangeAddress[]{cellRangeAddress};
        XTableCharts xTableCharts = SpreadsheetProtocol.getChartContainerInterface(_xSpreadsheet);
        Rectangle aRect = new Rectangle(8000, 1000, 10000, 10000);
        xTableCharts.addNewByName(_chartName, aRect, cellRangeArray, false, false);
    }

    public static synchronized XChartDocument addNewOLEChart(XSpreadsheetDocument _document, XSpreadsheet _sheet, String _chartName, String _chartType, int _xPos, int _yPos, int _width, int _height) throws Exception {
        Object oshape = SpreadsheetProtocol.addNewOLEShape(_document, _sheet, _chartType, _xPos, _yPos, _width, _height);
        XChartDocument xChartDoc = SpreadsheetProtocol.shapeToChart(oshape);
        return xChartDoc;
    }

    public static synchronized Object addNewOLEShape(XSpreadsheetDocument _document, XSpreadsheet _sheet, String _chartType, int _xPos, int _yPos, int _width, int _height) throws Exception {
        XDrawPageSupplier xdrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XDrawPageSupplier != null ? class$com$sun$star$drawing$XDrawPageSupplier : (class$com$sun$star$drawing$XDrawPageSupplier = SpreadsheetProtocol.class$("com.sun.star.drawing.XDrawPageSupplier"))), (Object)_sheet);
        XDrawPage xdrawPage = xdrawPageSupplier.getDrawPage();
        XMultiServiceFactory xmsf = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory != null ? class$com$sun$star$lang$XMultiServiceFactory : (class$com$sun$star$lang$XMultiServiceFactory = SpreadsheetProtocol.class$("com.sun.star.lang.XMultiServiceFactory"))), (Object)_document);
        Object oshape = xmsf.createInstance("com.sun.star.drawing.OLE2Shape");
        XShape xshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = SpreadsheetProtocol.class$("com.sun.star.drawing.XShape"))), (Object)oshape);
        xdrawPage.add(xshape);
        xshape.setPosition(new Point(_xPos, _yPos));
        xshape.setSize(new Size(_width, _height));
        return oshape;
    }

    public static synchronized void checkRangeCorrectSyntax(XSpreadsheet _xSpreadsheet, String _rangeStr) throws Exception {
        String tempSheetName;
        String sheetName = SpreadsheetProtocol.getSheetName(_xSpreadsheet).toUpperCase();
        Vector temp = Utils.rangeStrParser(_rangeStr);
        if (temp.size() > 1 && !(tempSheetName = (String)temp.elementAt(0)).toUpperCase().equals(sheetName)) {
            throw new Exception("Syntax of range: " + _rangeStr + " is not correct");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static synchronized void copyRangeByNames(XSpreadsheet _xSpreadsheet, String _sourceCellRange, String _destCellAddress) throws Exception {
        SpreadsheetProtocol.checkRangeCorrectSyntax(_xSpreadsheet, _sourceCellRange);
        SpreadsheetProtocol.checkRangeCorrectSyntax(_xSpreadsheet, _destCellAddress);
        CellRangeAddress cellRangeAddress = SpreadsheetProtocol.getCellRangeAddr(_xSpreadsheet, _sourceCellRange);
        CellRangeAddress cellRangeAddr = SpreadsheetProtocol.getCellRangeAddr(_xSpreadsheet, _destCellAddress);
        CellAddress cellAddress = new CellAddress();
        cellAddress.Sheet = cellRangeAddr.Sheet;
        cellAddress.Column = cellRangeAddr.StartColumn;
        cellAddress.Row = cellRangeAddr.StartRow;
        SpreadsheetProtocol.copyRangeByRangeAddress(_xSpreadsheet, cellAddress, cellRangeAddress);
    }

    public static synchronized void copyRangeByRangeAddress(XSpreadsheet _xSpreadsheet, CellAddress _cellAddress, CellRangeAddress _cellRangeAddress) {
        XCellRangeMovement xCellRangeMovement = (XCellRangeMovement)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeMovement != null ? class$com$sun$star$sheet$XCellRangeMovement : (class$com$sun$star$sheet$XCellRangeMovement = SpreadsheetProtocol.class$("com.sun.star.sheet.XCellRangeMovement"))), (Object)_xSpreadsheet);
        xCellRangeMovement.copyRange(_cellAddress, _cellRangeAddress);
    }

    public static synchronized XCellRange getCellRange(XSpreadsheet _sheet, int _left, int _top, int _right, int _bottom) throws Exception {
        return _sheet.getCellRangeByPosition(_left, _top, _right, _bottom);
    }

    public static synchronized XCellRange getCellRange(XSpreadsheet _sheet, String _range) throws Exception {
        return _sheet.getCellRangeByName(_range);
    }

    public static synchronized CellRangeAddress getCellRangeAddr(XSpreadsheet _xSpreadsheet, String _rangeStr) throws Exception {
        XCellRange xCellRange;
        CellRangeAddress cellRangeAddress = null;
        XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable != null ? class$com$sun$star$sheet$XCellRangeAddressable : (class$com$sun$star$sheet$XCellRangeAddressable = SpreadsheetProtocol.class$("com.sun.star.sheet.XCellRangeAddressable"))), (Object)(xCellRange = _xSpreadsheet.getCellRangeByName(_rangeStr)));
        if (xCellRangeAddressable == null) {
            throw new Exception("CellRange: " + _rangeStr + " is not correct");
        }
        cellRangeAddress = xCellRangeAddressable.getRangeAddress();
        return cellRangeAddress;
    }

    public static synchronized XTableChart getChartByName(XSpreadsheet _xSpreadsheet, String _chartName) throws Exception {
        XTableCharts xTableCharts = SpreadsheetProtocol.getChartContainerInterface(_xSpreadsheet);
        XTableChart xTableChart = (XTableChart)xTableCharts.getByName(_chartName);
        return xTableChart;
    }

    public static synchronized XTableCharts getChartContainerInterface(XSpreadsheet _xSpreadsheet) {
        XTableChartsSupplier xTableChartsSupplier = (XTableChartsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XTableChartsSupplier != null ? class$com$sun$star$table$XTableChartsSupplier : (class$com$sun$star$table$XTableChartsSupplier = SpreadsheetProtocol.class$("com.sun.star.table.XTableChartsSupplier"))), (Object)_xSpreadsheet);
        return xTableChartsSupplier.getCharts();
    }

    public static synchronized String[] getChartNames(XSpreadsheet _xSpreadsheet) {
        XTableCharts xTableCharts = SpreadsheetProtocol.getChartContainerInterface(_xSpreadsheet);
        return xTableCharts.getElementNames();
    }

    public static synchronized double getNotANumber(XSpreadsheet _xSpreadsheet) {
        XChartData xChartData = (XChartData)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartData != null ? class$com$sun$star$chart$XChartData : (class$com$sun$star$chart$XChartData = SpreadsheetProtocol.class$("com.sun.star.chart.XChartData"))), (Object)_xSpreadsheet);
        return xChartData.getNotANumber();
    }

    private static synchronized XInterface getPropertyValue(XSpreadsheet _xSpreadsheet, String _propertyName) throws Exception {
        XInterface xInterface = null;
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : (class$com$sun$star$beans$XPropertySet = SpreadsheetProtocol.class$("com.sun.star.beans.XPropertySet"))), (Object)_xSpreadsheet);
            xInterface = (XInterface)xPropertySet.getPropertyValue(_propertyName);
        }
        catch (WrappedTargetException ex) {
            throw new Exception(ex.getMessage());
        }
        catch (UnknownPropertyException ex) {
            throw new Exception(ex.getMessage());
        }
        return xInterface;
    }

    public static synchronized Object[][] getRangeData(XSpreadsheet _xSpreadsheet, String _rangeStr) throws Exception {
        XCellRange xCellRange = null;
        XCellRangeData xCellRangeData = null;
        xCellRange = _xSpreadsheet.getCellRangeByName(_rangeStr);
        xCellRangeData = (XCellRangeData)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeData != null ? class$com$sun$star$sheet$XCellRangeData : (class$com$sun$star$sheet$XCellRangeData = SpreadsheetProtocol.class$("com.sun.star.sheet.XCellRangeData"))), (Object)xCellRange);
        return xCellRangeData.getDataArray();
    }

    public static synchronized String getSheetName(XSpreadsheet _xSpreadsheet) {
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed != null ? class$com$sun$star$container$XNamed : (class$com$sun$star$container$XNamed = SpreadsheetProtocol.class$("com.sun.star.container.XNamed"))), (Object)_xSpreadsheet);
        return xNamed.getName();
    }

    public static synchronized void setChartShapePos(Object _oshape, int _xPos, int _yPos) throws Exception {
        XShape xshape = (XShape)UnoRuntime.queryInterface((Class)(class$com$sun$star$drawing$XShape != null ? class$com$sun$star$drawing$XShape : (class$com$sun$star$drawing$XShape = SpreadsheetProtocol.class$("com.sun.star.drawing.XShape"))), (Object)_oshape);
        xshape.setPosition(new Point(_xPos, _yPos));
    }

    public static synchronized void setRangeData(XSpreadsheet _xSpreadsheet, String _rangeStr, Object[][] data) throws Exception {
        XCellRange xCellRange = null;
        XCellRangeData xCellRangeData = null;
        xCellRange = _xSpreadsheet.getCellRangeByName(_rangeStr);
        xCellRangeData = (XCellRangeData)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeData != null ? class$com$sun$star$sheet$XCellRangeData : (class$com$sun$star$sheet$XCellRangeData = SpreadsheetProtocol.class$("com.sun.star.sheet.XCellRangeData"))), (Object)xCellRange);
        xCellRangeData.setDataArray(data);
    }

    public static synchronized void setSheetVisible(XSpreadsheet _xSpreadsheet, boolean _Visible) throws Exception {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : (class$com$sun$star$beans$XPropertySet = SpreadsheetProtocol.class$("com.sun.star.beans.XPropertySet"))), (Object)_xSpreadsheet);
            xPropertySet.setPropertyValue("IsVisible", (Object)new Boolean(_Visible));
        }
        catch (WrappedTargetException ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public static synchronized XChartDocument shapeToChart(Object _oshape) throws Exception {
        XPropertySet oshapePropSet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet != null ? class$com$sun$star$beans$XPropertySet : (class$com$sun$star$beans$XPropertySet = SpreadsheetProtocol.class$("com.sun.star.beans.XPropertySet"))), (Object)_oshape);
        oshapePropSet.setPropertyValue("CLSID", (Object)"bf884321-85dd-11d1-89d0-008029e4b0b1");
        Object ochart = oshapePropSet.getPropertyValue("Model");
        XChartDocument result = (XChartDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartDocument != null ? class$com$sun$star$chart$XChartDocument : (class$com$sun$star$chart$XChartDocument = SpreadsheetProtocol.class$("com.sun.star.chart.XChartDocument"))), (Object)ochart);
        return result;
    }
}

