/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.spreadsheet;

import com.ivistaportal.solibrary.protocols.Utils;
import com.ivistaportal.solibrary.spreadsheet.SORangeSelectionEvent;
import com.ivistaportal.solibrary.spreadsheet.SORangeSelectionListener;
import com.ivistaportal.solibrary.spreadsheet.SOSpreadsheetDocument;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.sheet.RangeSelectionEvent;
import com.sun.star.sheet.XRangeSelection;
import com.sun.star.sheet.XRangeSelectionChangeListener;
import com.sun.star.sheet.XRangeSelectionListener;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.util.Vector;

public class RangeSelection {
    private XSpreadsheetDocument m_xSpreadsheetDocument = null;
    private XRangeSelection m_xrangeSelection = null;
    private String m_initialValue = "";
    private String m_title = "Select Range";
    private boolean m_closeOnMouseRelease = true;
    private RangeSelectionListener m_selectionListener = new RangeSelectionListener();
    private RangeSelectionChangeListener m_selectionChangeListener = new RangeSelectionChangeListener();
    private static final String PROP_INITIALVALUE = "InitialValue";
    private static final String PROP_TITLE = "Title";
    private static final String PROP_MOUSERELEASE = "CloseOnMouseRelease";
    private static final int INDEX_INITIALVALUE = 0;
    private static final int INDEX_TITLE = 1;
    private static final int INDEX_MOUSERELEASE = 2;
    private transient Vector rangeSelectionListeners;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$sheet$XRangeSelection;

    public RangeSelection(SOSpreadsheetDocument _document) {
        this.m_xSpreadsheetDocument = _document.getXSpreadsheetDocument();
    }

    public synchronized void addRangeSelectionListener(SORangeSelectionListener l) {
        Vector v;
        Vector vector = v = this.rangeSelectionListeners == null ? new Vector(2) : (Vector)this.rangeSelectionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.rangeSelectionListeners = v;
        }
    }

    void changedRangeSelection(String _range) {
        SORangeSelectionEvent event = new SORangeSelectionEvent(this, _range);
        this.fireSelectionChanged(event);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void endRangeSelection(String _range, boolean _state) {
        SORangeSelectionEvent event = new SORangeSelectionEvent(this, _range);
        if (_state) {
            this.fireSelectionDone(event);
        } else {
            this.fireSelectionAborted(event);
        }
        if (this.m_xrangeSelection != null) {
            this.m_xrangeSelection.removeRangeSelectionChangeListener((XRangeSelectionChangeListener)this.m_selectionChangeListener);
            this.m_xrangeSelection.removeRangeSelectionListener((XRangeSelectionListener)this.m_selectionListener);
            this.m_xrangeSelection.abortRangeSelection();
        }
    }

    protected void fireSelectionAborted(SORangeSelectionEvent e) {
        if (this.rangeSelectionListeners != null) {
            Vector listeners = this.rangeSelectionListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((SORangeSelectionListener)listeners.elementAt(i)).selectionAborted(e);
                ++i;
            }
        }
    }

    protected void fireSelectionChanged(SORangeSelectionEvent e) {
        if (this.rangeSelectionListeners != null) {
            Vector listeners = this.rangeSelectionListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((SORangeSelectionListener)listeners.elementAt(i)).selectionChanged(e);
                ++i;
            }
        }
    }

    protected void fireSelectionDone(SORangeSelectionEvent e) {
        if (this.rangeSelectionListeners != null) {
            Vector listeners = this.rangeSelectionListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((SORangeSelectionListener)listeners.elementAt(i)).selectionDone(e);
                ++i;
            }
        }
    }

    public boolean getCloseOnMouseRelease() {
        return this.m_closeOnMouseRelease;
    }

    public String getInitialValue() {
        return this.m_initialValue;
    }

    public String getTitle() {
        return this.m_title;
    }

    public synchronized void removeRangeSelectionListener(SORangeSelectionListener l) {
        if (this.rangeSelectionListeners != null && this.rangeSelectionListeners.contains(l)) {
            Vector v = (Vector)this.rangeSelectionListeners.clone();
            v.removeElement(l);
            this.rangeSelectionListeners = v;
        }
    }

    public void setCloseOnMouseRelease(boolean _value) {
        this.m_closeOnMouseRelease = _value;
    }

    public void setInitialValue(String _value) {
        this.m_initialValue = _value;
    }

    public void setTitle(String _value) {
        this.m_title = _value;
    }

    public void startRangeSelection() {
        XModel xmodel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel != null ? class$com$sun$star$frame$XModel : (class$com$sun$star$frame$XModel = RangeSelection.class$("com.sun.star.frame.XModel"))), (Object)this.m_xSpreadsheetDocument);
        XController xcontroller = xmodel.getCurrentController();
        this.m_xrangeSelection = (XRangeSelection)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XRangeSelection != null ? class$com$sun$star$sheet$XRangeSelection : (class$com$sun$star$sheet$XRangeSelection = RangeSelection.class$("com.sun.star.sheet.XRangeSelection"))), (Object)xcontroller);
        PropertyValue[] props = new PropertyValue[3];
        props[0] = new PropertyValue();
        props[0].Name = PROP_INITIALVALUE;
        props[0].Value = this.m_initialValue;
        props[1] = new PropertyValue();
        props[1].Name = PROP_TITLE;
        props[1].Value = this.m_title;
        props[2] = new PropertyValue();
        props[2].Name = PROP_MOUSERELEASE;
        props[2].Value = new Boolean(this.m_closeOnMouseRelease);
        this.m_xrangeSelection.addRangeSelectionListener((XRangeSelectionListener)this.m_selectionListener);
        this.m_xrangeSelection.addRangeSelectionChangeListener((XRangeSelectionChangeListener)this.m_selectionChangeListener);
        this.m_xrangeSelection.startRangeSelection(props);
    }

    public class RangeSelectionListener
    implements XRangeSelectionListener {
        public void aborted(RangeSelectionEvent evnt) throws RuntimeException {
            String address = Utils.normalizeAddress(evnt.RangeDescriptor);
            RangeSelection.this.endRangeSelection(address, false);
        }

        public void disposing(EventObject evnt) throws RuntimeException {
            System.out.println("RangeSelection disposing");
        }

        public void done(RangeSelectionEvent evnt) throws RuntimeException {
            String address = Utils.normalizeAddress(evnt.RangeDescriptor);
            RangeSelection.this.endRangeSelection(address, true);
        }
    }

    public class RangeSelectionChangeListener
    implements XRangeSelectionChangeListener {
        public void descriptorChanged(RangeSelectionEvent evnt) throws RuntimeException {
            String address = Utils.normalizeAddress(evnt.RangeDescriptor);
            RangeSelection.this.changedRangeSelection(address);
        }

        public void disposing(EventObject evnt) throws RuntimeException {
            System.out.println("RangeSelection disposing");
        }
    }
}

