/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.spreadsheet;

import com.ivistaportal.solibrary.protocols.CellRangeProtocol;
import com.ivistaportal.solibrary.utils.SOTableBorder;
import com.ivistaportal.solibrary.utils.SoRangeStyle;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.table.CellHoriJustify;
import com.sun.star.table.XCellRange;

public class SOCellRange {
    private XCellRange m_xcellRange;

    public SOCellRange(XCellRange _range) {
        this.m_xcellRange = _range;
    }

    public void applyAlignment(CellHoriJustify _alignment) throws Exception {
        CellRangeProtocol.setHorizentalAlignment(this.m_xcellRange, _alignment);
    }

    public void applyBackGround(long _color) throws Exception {
        Integer color = new Integer((int)_color);
        CellRangeProtocol.setBackColor(this.m_xcellRange, color);
    }

    public void applyBold(boolean _isBold) throws Exception {
        CellRangeProtocol.setBold(this.m_xcellRange, _isBold);
    }

    public void applyBorderCell(SOTableBorder _soTableBorder) throws Exception {
        CellRangeProtocol.setBorder(this.m_xcellRange, _soTableBorder.getTableBorder());
    }

    public void applyDecimalPoint(int _points) throws Exception {
        CellRangeProtocol.setDecimalPoints(this.m_xcellRange, _points);
    }

    public void applyFontHeigth(double _font) throws Exception {
        CellRangeProtocol.setFontHeight(this.m_xcellRange, _font);
    }

    public void applyForeGround(long _color) throws Exception {
        Integer color = new Integer((int)_color);
        CellRangeProtocol.setForeColor(this.m_xcellRange, color);
    }

    public void applyItalic(boolean _isItalic) throws Exception {
        CellRangeProtocol.setItalic(this.m_xcellRange, _isItalic);
    }

    public void applyNumberFormat(int _numberFormat) throws Exception {
        CellRangeProtocol.setNumberFormat(this.m_xcellRange, _numberFormat);
    }

    public void applyStyle(SoRangeStyle _style) throws Exception {
        this.applyBold(_style.isBold());
        this.applyItalic(_style.isItalic());
        this.applyUnderScore(_style.isUnderScore());
        this.applyForeGround(_style.getForeGround());
        this.applyBackGround(_style.getBackGround());
        this.applyFontHeigth(_style.getFontHeigth());
        this.applyBorderCell(_style.getTableBorder());
        this.applyNumberFormat(_style.getNumberFormat());
        this.applyAlignment(_style.getAlignment());
        this.applyDecimalPoint(_style.getDecimalPoint());
    }

    public void applySubRangeAlignment(CellHoriJustify _alignment, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setHorizentalAlignment(xSubRange, _alignment);
    }

    public void applySubRangeBackGround(long _color, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        Integer color = new Integer((int)_color);
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setBackColor(xSubRange, color);
    }

    public void applySubRangeBold(boolean _isBold, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setBold(xSubRange, _isBold);
    }

    public void applySubRangeBorderCell(SOTableBorder _soTableBorder, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setBorder(xSubRange, _soTableBorder.getTableBorder());
    }

    public void applySubRangeDecimalPoint(int _points, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setDecimalPoints(xSubRange, _points);
    }

    public void applySubRangeFontHeigth(double _font, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setFontHeight(xSubRange, _font);
    }

    public void applySubRangeForeGround(long _color, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        Integer color = new Integer((int)_color);
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setForeColor(xSubRange, color);
    }

    public void applySubRangeItalic(boolean _isItalic, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setItalic(xSubRange, _isItalic);
    }

    public void applySubRangeNumberFormat(int _numberFormat, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setNumberFormat(xSubRange, _numberFormat);
    }

    public void applySubRangeStyle(SoRangeStyle _style, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        this.applySubRangeBold(_style.isBold(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeItalic(_style.isItalic(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeUnderScore(_style.isUnderScore(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeForeGround(_style.getForeGround(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeBackGround(_style.getBackGround(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeFontHeigth(_style.getFontHeigth(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeBorderCell(_style.getTableBorder(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeNumberFormat(_style.getNumberFormat(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeAlignment(_style.getAlignment(), _xStart, _yStart, _xEnd, _yEnd);
        this.applySubRangeDecimalPoint(_style.getDecimalPoint(), _xStart, _yStart, _xEnd, _yEnd);
    }

    public void applySubRangeUnderScore(boolean _isUnderScore, int _xStart, int _yStart, int _xEnd, int _yEnd) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xStart, _yStart, _xEnd, _yEnd);
        CellRangeProtocol.setUnderScore(xSubRange, _isUnderScore);
    }

    public void applyUnderScore(boolean _isUnderScore) throws Exception {
        CellRangeProtocol.setUnderScore(this.m_xcellRange, _isUnderScore);
    }

    public int getCellNumberFormat(int _xPosition, int _yPosition) throws Exception {
        XCellRange xSubRange = this.m_xcellRange.getCellRangeByPosition(_xPosition, _yPosition, _xPosition, _yPosition);
        return CellRangeProtocol.getCellNumberFromat(xSubRange);
    }

    public Point getPosition() throws Exception {
        return CellRangeProtocol.getRangePosition(this.m_xcellRange);
    }

    public Object[][] getRangeData() throws Exception {
        return CellRangeProtocol.getRangeData(this.m_xcellRange);
    }

    public SOCellRange getSOCellRange(int _x, int _y, int _width, int _height) throws Exception {
        XCellRange range = this.m_xcellRange.getCellRangeByPosition(_x, _y, _x + _width - 1, _y + _height - 1);
        return new SOCellRange(range);
    }

    public Size getSize() throws Exception {
        return CellRangeProtocol.getRangeSize(this.m_xcellRange);
    }

    public void putRangeData(Object[][] _data) throws Exception {
        CellRangeProtocol.setRangeData(this.m_xcellRange, _data);
    }
}

