/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.spreadsheet;

import com.ivistaportal.solibrary.protocols.SpreadsheetDocumentProtocol;
import com.ivistaportal.solibrary.protocols.SpreadsheetProtocol;
import com.ivistaportal.solibrary.spreadsheet.SOSpreadsheet;
import com.ivistaportal.solibrary.spreadsheet.SpreadsheetSelectionChangedEvent;
import com.ivistaportal.solibrary.spreadsheet.SpreadsheetSelectionChangedListener;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.view.XSelectionChangeListener;
import java.util.Vector;

public class SOSpreadsheetDocument {
    private XSpreadsheetDocument m_xSpreadsheetDocument = null;
    private String m_docName = "";
    private SOSelectionListener m_selectionListener = null;
    private XWindow m_xWindow = null;
    private XTopWindow m_xTopWindow = null;
    private transient Vector spreadsheetSelectionChangedListeners;

    public SOSpreadsheetDocument() {
    }

    public SOSpreadsheetDocument(XSpreadsheetDocument _xSpreadsheetDocument, String _docName) {
        this.m_xSpreadsheetDocument = _xSpreadsheetDocument;
        this.m_docName = _docName;
    }

    public SOSpreadsheet addNewStreadSheet(String _sheetName) throws Exception {
        SOSpreadsheet result = null;
        XSpreadsheet sheet = SpreadsheetDocumentProtocol.addNewSheet(this.m_xSpreadsheetDocument, _sheetName);
        result = new SOSpreadsheet(this.m_xSpreadsheetDocument, sheet, _sheetName);
        return result;
    }

    public synchronized void addSpreadsheetSelectionChangedListener(SpreadsheetSelectionChangedListener l) {
        Vector v;
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new SOSelectionListener();
        }
        Vector vector = v = this.spreadsheetSelectionChangedListeners == null ? new Vector(2) : (Vector)this.spreadsheetSelectionChangedListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.spreadsheetSelectionChangedListeners = v;
        }
    }

    public void copyRangeByNames(String _sourceCellRange, String _destCellAddress) throws Exception {
        if (this.m_xSpreadsheetDocument != null) {
            SpreadsheetDocumentProtocol.copyRangeByNames(this.m_xSpreadsheetDocument, _sourceCellRange, _destCellAddress);
        }
    }

    protected void fireSelectionChanged(SpreadsheetSelectionChangedEvent e) {
        if (this.spreadsheetSelectionChangedListeners != null) {
            Vector listeners = this.spreadsheetSelectionChangedListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((SpreadsheetSelectionChangedListener)listeners.elementAt(i)).selectionChanged(e);
                ++i;
            }
        }
    }

    public String getCurrentSelection() throws Exception {
        return SpreadsheetDocumentProtocol.getCurrentSelection(this.m_xSpreadsheetDocument);
    }

    public String getCurrentSpreadsheetName() throws Exception {
        String result = "";
        XSpreadsheet current = SpreadsheetDocumentProtocol.getCurrentSheet(this.m_xSpreadsheetDocument);
        result = SpreadsheetProtocol.getSheetName(current);
        return result;
    }

    public String getDocName() {
        if (this.m_docName == "" && this.m_xSpreadsheetDocument != null) {
            this.m_docName = SpreadsheetDocumentProtocol.getDocumentURL(this.m_xSpreadsheetDocument);
        }
        return this.m_docName;
    }

    public String getNamedRangeContent(String _namedRange) throws Exception {
        return SpreadsheetDocumentProtocol.getNamedRangeContent(this.m_xSpreadsheetDocument, _namedRange);
    }

    public String[] getNamedRangeNames() throws Exception {
        return SpreadsheetDocumentProtocol.getNamedRangeNames(this.m_xSpreadsheetDocument);
    }

    public String[] getSheetNames() {
        return SpreadsheetDocumentProtocol.getSheetNames(this.m_xSpreadsheetDocument);
    }

    public SOSpreadsheet getSpreadsheetByName(String _spreadsheetName) throws Exception {
        SOSpreadsheet soSpreadsheet = null;
        if (this.m_xSpreadsheetDocument != null) {
            XSpreadsheet xSpreadsheet = SpreadsheetDocumentProtocol.getSpreadsheetByName(this.m_xSpreadsheetDocument, _spreadsheetName);
            soSpreadsheet = new SOSpreadsheet(this.m_xSpreadsheetDocument, xSpreadsheet, _spreadsheetName);
        }
        return soSpreadsheet;
    }

    public XSpreadsheetDocument getXSpreadsheetDocument() {
        return this.m_xSpreadsheetDocument;
    }

    public XTopWindow getXTopWindow() {
        return this.m_xTopWindow;
    }

    public XWindow getXWindow() {
        return this.m_xWindow;
    }

    public synchronized void removeSpreadsheetSelectionChangedListener(SpreadsheetSelectionChangedListener l) {
        if (this.spreadsheetSelectionChangedListeners != null && this.spreadsheetSelectionChangedListeners.contains(l)) {
            if (this.m_selectionListener != null) {
                SpreadsheetDocumentProtocol.removeSelectionChangeListener(this.m_xSpreadsheetDocument, this.m_selectionListener);
            }
            Vector v = (Vector)this.spreadsheetSelectionChangedListeners.clone();
            v.removeElement(l);
            this.spreadsheetSelectionChangedListeners = v;
        }
    }

    public void setDocName(String _docName) {
        this.m_docName = _docName;
    }

    public void setXSpreadsheetDocument(XSpreadsheetDocument _xSpreadsheetDocument) {
        this.m_xSpreadsheetDocument = _xSpreadsheetDocument;
    }

    public void setXTopWindow(XTopWindow _xTopWindow) {
        this.m_xTopWindow = _xTopWindow;
    }

    public void setXWindow(XWindow _xWindow) {
        this.m_xWindow = _xWindow;
    }

    public class SOSelectionListener
    implements XSelectionChangeListener {
        public SOSelectionListener() {
            SpreadsheetDocumentProtocol.addSelectionChangeListener(SOSpreadsheetDocument.this.getXSpreadsheetDocument(), this);
        }

        public void disposing(EventObject p1) {
            System.out.println("SOSelectionListener is disposed");
        }

        public void selectionChanged(EventObject pl) {
            XSpreadsheetDocument xSpreadsheetDocument = SOSpreadsheetDocument.this.getXSpreadsheetDocument();
            try {
                String str = SpreadsheetDocumentProtocol.getCurrentSelection(xSpreadsheetDocument);
                SOSpreadsheetDocument.this.fireSelectionChanged(new SpreadsheetSelectionChangedEvent(xSpreadsheetDocument, str));
            }
            catch (Exception exception) {}
        }
    }
}

