/*
 * Decompiled with CFR 0.152.
 */
package com.ivistaportal.solibrary.utils;

public class RangeAddress {
    static final int WRONG_POS = -1;
    static final int MAX_HEIGHT = 66666;
    static final char SO_FORMNAME_ENCLOSURE = '\'';
    String m_sheetName;
    String m_cellFrom;
    String m_cellTo;

    public RangeAddress(String _url) {
        this.init(_url);
    }

    private String filter$(String _range) {
        String res = "";
        int i = 0;
        while (i < _range.length()) {
            char ch = _range.charAt(i);
            if (ch != '$') {
                res = String.valueOf(res) + ch;
            }
            ++i;
        }
        return res;
    }

    public int get26Sys(String _s) {
        int sum = 0;
        int multiplier = 1;
        if (_s != "") {
            int i = _s.length() - 1;
            while (i >= 0) {
                char ch = _s.charAt(i);
                int val = Character.getNumericValue(ch) - Character.getNumericValue('A') + 1;
                sum += val * multiplier;
                multiplier *= 26;
                --i;
            }
            return sum;
        }
        return -1;
    }

    public String getAddress() {
        String result = "";
        if (this.m_sheetName != null) {
            result = String.valueOf(result) + this.m_sheetName;
        }
        if (this.m_cellFrom != null) {
            result = String.valueOf(result) + this.m_cellFrom;
            if (this.m_cellTo != null) {
                result = String.valueOf(result) + ":" + this.m_cellTo;
            }
        }
        return result;
    }

    public String getCharPart(String _value) {
        String result = "";
        int digitpos = this.getFirstDigitPosition(_value);
        if (digitpos >= 0) {
            result = _value.substring(0, digitpos);
        }
        return result;
    }

    public String getDigitPart(String _value) {
        String result = "";
        int digitpos = this.getFirstDigitPosition(_value);
        if (digitpos >= 0) {
            result = _value.substring(digitpos);
        }
        return result;
    }

    private int getFirstDigitPosition(String _value) {
        int result = -1;
        if (_value != null && _value.trim().length() == 0) {
            return result;
        }
        _value = _value.trim();
        int length = _value.length();
        int i = 0;
        while (i < length) {
            if (Character.isDigit(_value.charAt(i))) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public String getFromCell() {
        return this.m_cellFrom;
    }

    public int getHeight() {
        if (this.m_cellFrom != null && this.m_cellTo != null) {
            int toY = this.getYPosition(this.m_cellTo);
            int fromY = this.getYPosition(this.m_cellFrom);
            if (toY == -1 || fromY == -1) {
                return 0;
            }
            return toY - fromY + 1;
        }
        return 0;
    }

    public String getRange() {
        String result = "";
        if (this.m_cellFrom != null) {
            result = String.valueOf(result) + this.m_cellFrom;
            if (this.m_cellTo != null) {
                result = String.valueOf(result) + ":" + this.m_cellTo;
            }
        }
        return result;
    }

    public String getSheetName() {
        return this.m_sheetName;
    }

    public String getToCell() {
        return this.m_cellTo;
    }

    public int getWidth() {
        if (this.m_cellFrom != null && this.m_cellTo != null) {
            int toX = this.getXPosition(this.m_cellTo);
            int fromX = this.getXPosition(this.m_cellFrom);
            if (toX == -1 || fromX == -1) {
                return 0;
            }
            return toX - fromX + 1;
        }
        return 0;
    }

    public int getXPosition(String _subrange) {
        int result = -1;
        String tmp = this.filter$(_subrange);
        tmp = this.getCharPart(_subrange);
        if (RangeAddress.isLetter(tmp) && (tmp.length() == 2 || tmp.length() == 1)) {
            result = this.get26Sys(tmp);
        }
        return result;
    }

    public int getYPosition(String _subrange) {
        int result;
        block3: {
            result = -1;
            if ((_subrange = _subrange.trim()).length() == 0) break block3;
            String digitstr = this.getDigitPart(_subrange);
            try {
                result = Integer.parseInt(digitstr);
                if (result > 66666) {
                    result = -1;
                }
            }
            catch (Exception exception) {
                result = -1;
            }
        }
        return result;
    }

    public boolean hasCell() {
        return this.m_cellFrom != null;
    }

    public boolean hasRange() {
        return this.m_cellFrom != null && this.m_cellTo != null;
    }

    public boolean hasSheetName() {
        return this.m_sheetName != null;
    }

    private void init(String _url) {
        String[] urls = this.parseURL(_url);
        this.m_sheetName = urls[0];
        this.m_cellFrom = urls[1];
        this.m_cellTo = urls[2];
    }

    private static boolean intern_isSheetNameOk(String _sheetName, boolean _canBeWaitSpace) {
        int i = 0;
        while (i < _sheetName.length()) {
            char ch = _sheetName.charAt(i);
            if (!(Character.isLetterOrDigit(ch) || ch == '_' || _canBeWaitSpace && ch == ' ')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isCellOk(String _cell) {
        return this.getYPosition(_cell) != -1 && this.getXPosition(_cell) != -1;
    }

    private static boolean isLetter(String _str) {
        boolean res = true;
        if (!_str.equals("")) {
            int i = 0;
            while (i < _str.length()) {
                char ch = _str.charAt(i);
                if (!Character.isLetter(ch)) {
                    res = false;
                    break;
                }
                ++i;
            }
        } else {
            res = false;
        }
        return res;
    }

    public boolean isSheetNameOk() {
        return RangeAddress.isSheetNameOk(this.m_sheetName);
    }

    public static boolean isSheetNameOk(String _sheetName) {
        boolean res = false;
        res = _sheetName != null && !_sheetName.equals("") ? RangeAddress.intern_isSheetNameOk(_sheetName, true) : true;
        return res;
    }

    public String numTo26Sys(int _num) {
        boolean sum = false;
        String s = "";
        while (_num > 0) {
            int reminder = _num % 26;
            int val = 64 + reminder;
            _num /= 26;
            s = String.valueOf((char)val) + s;
        }
        return s;
    }

    private String[] parseURL(String _url) {
        String[] result = new String[3];
        int index = _url.indexOf(46);
        if (index >= 0) {
            result[0] = _url.substring(0, index);
            _url = _url.substring(index + 1);
        }
        if ((index = _url.indexOf(58)) >= 0) {
            result[1] = _url.substring(0, index);
            result[2] = _url.substring(index + 1);
        } else {
            result[1] = _url;
        }
        return result;
    }

    public void setSize(int _width, int _height) {
        if (this.m_cellFrom == null) {
            this.m_cellFrom = "a1";
        }
        int tlX = this.getXPosition(this.m_cellFrom);
        int tlY = this.getYPosition(this.m_cellFrom);
        this.m_cellTo = this.numTo26Sys(tlX + _width - 1);
        this.m_cellTo = String.valueOf(this.m_cellTo) + String.valueOf(tlY + _height - 1);
    }
}

