/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.netbeans.modules.jarpackager.util.ProgressListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class JarInspector {
    private static MessageFormat progressInfo;
    private static final String META_INF_DIR = "META-INF";
    private HashSet listeners;
    private File archiveFile;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$util$JarInspector;

    public JarInspector(File file) {
        this.archiveFile = file;
    }

    public JarContent createContent() throws IOException, PropertyVetoException {
        JarFile jarFile = new JarFile(this.archiveFile);
        long l = jarFile.size();
        JarContent jarContent = new JarContent();
        JarInspector.initializeFromOptions(jarContent);
        this.fireProgressEvent(0, "MSG_ObtainingManifest");
        jarContent.setManifest(jarFile.getManifest());
        jarFile.close();
        jarFile = null;
        jarContent.setTargetFile(this.archiveFile);
        jarContent.setFilter(JarContent.ALL);
        this.fireProgressEvent(0, "MSG_AddingToRepository");
        FileSystem fileSystem = JarUtils.addJarFSToRepository(this.archiveFile, false);
        FileObject fileObject = null;
        long l2 = 0L;
        Enumeration enumeration = fileSystem.getRoot().getChildren(false);
        while (enumeration.hasMoreElements()) {
            block4: {
                fileObject = (FileObject)enumeration.nextElement();
                try {
                    if (!META_INF_DIR.equals(fileObject.getName())) {
                        jarContent.putFile(DataObject.find((FileObject)fileObject).getPrimaryFile());
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    if (System.getProperty("netbeans.debug.exceptions") == null) break block4;
                    dataObjectNotFoundException.printStackTrace();
                }
            }
            this.fireProgressEvent((int)(l2 * 100L / l), JarInspector.progressInfo().format(new Object[]{fileObject.getName()}));
            ++l2;
        }
        return jarContent;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(progressListener);
    }

    protected void fireProgressEvent(int n, String string) {
        HashSet hashSet;
        if (this.listeners == null) {
            return;
        }
        JarInspector jarInspector = this;
        synchronized (jarInspector) {
            hashSet = (HashSet)this.listeners.clone();
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).progress(n, string);
        }
    }

    private static void initializeFromOptions(JarContent jarContent) {
        JarPackagerOption jarPackagerOption = JarPackagerOption.singleton();
        jarContent.setCompressionLevel(jarPackagerOption.getCompressionLevel());
        jarContent.setManifestFileList(jarPackagerOption.isManifestFileList());
        jarContent.setMainAttributes(jarPackagerOption.isMainAttributes());
    }

    private static MessageFormat progressInfo() {
        if (progressInfo == null) {
            progressInfo = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$util$JarInspector == null ? (class$org$netbeans$modules$jarpackager$util$JarInspector = JarInspector.class$("org.netbeans.modules.jarpackager.util.JarInspector")) : class$org$netbeans$modules$jarpackager$util$JarInspector)).getString("FMT_ProgressInfo"));
        }
        return progressInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

