/*************************************************************************
 *
 *  $RCSfile: HitStore.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import java.util.Vector;

class HitStoreNode {
  private int           _free = 0;
  private int           _size;
  private QueryHit[]    _array;
  private int           _hitCount = 0;
  private double         _divider = 0.0;
  private double         _min = 10000000.0;
  private double         _max = 0.0;
  private HitStoreNode[] _children = new HitStoreNode[2]; // left & right
  private int           _index = 0;

  public HitStoreNode(int size) {
    _array = new QueryHit[_size = size];
  }
  
  public QueryHit getNextHit() {
    return _index < _free ? _array[_index++] : null;
  }
  
  private void fastAdd(QueryHit hit) {
    _hitCount++;
    _divider += hit.getScore();
    if (hit.getScore() > _max)
      _max = hit.getScore();
    else if (hit.getScore() < _min)
      _min = hit.getScore();
    _array[_free++] = hit;
  }

  public boolean add(QueryHit hit)
  {
    if (_array != null)
      {
	if (_free < _size)
	  {
	    fastAdd(hit);
	    return false;
	  }
	else if (_min != _max)
	  {
	    split();
	    _hitCount++;
	    _children[hit.getScore() > _divider ? 1 : 0].fastAdd(hit);
	    return true;
	  }
	else
	  {
	    QueryHit[] newArray = new QueryHit[_size *= 2];
	    System.arraycopy(_array, 0, newArray, 0, _free);
	    _array = newArray;
	    fastAdd(hit);
	    return true;
	  }
      }
    else
      {
	_hitCount++;
	return _children[hit.getScore() > _divider ? 1 : 0].add(hit);
      }
  }

  private void split()
  {
    _children[0] = new HitStoreNode(_size);
    _children[1] = new HitStoreNode(_size);
    _divider /= _hitCount;	// becomes average
    for (int i = 0; i < _free; i++)
      _children[_array[i].getScore() > _divider ? 1 : 0].fastAdd(_array[i]);
    _array = null;			// becomes internal
  }
  public int getCount() {
    return _hitCount;
  }
  public double getDivider() {
    return _divider;
  }
  public HitStoreNode getLChild() {
    return _children[0];
  }
  public HitStoreNode getRChild() {
    return _children[1];
  }
  public void setLChild(HitStoreNode node) {
    _children[0] = node;
  }
  public void setRChild(HitStoreNode node) {
    _children[1] = node;
  }
  public void decrementCount(int delta) {
    _hitCount -= delta;
  }
  public boolean isLeaf() {
    return _array != null;
  }
  
  public void sort() {
    quicksort(0, _free - 1);
  }

  public void gatherLeaves(Vector vector)
  {
    if (isLeaf())
      vector.addElement(this);
    else
      {
	getLChild().gatherLeaves(vector);
	getRChild().gatherLeaves(vector);
      }
  }
  
  // part of quicksearch
  private int partition(int p, int r)
  {
    QueryHit x = _array[(p + r)/2];
    int i = p - 1, j = r + 1;
    while (true)
      {
	while (x.betterThan(_array[--j]))
	  ;
	while (_array[++i].betterThan(x))
	  ;
	if (i < j)
	  {
	    QueryHit t = _array[i];
	    _array[i] = _array[j];
	    _array[j] = t;
	  }
	else
	  return j;
      }
  }

  private void quicksort(int p, int r)
  {
    while (p < r)
      {
	int q = partition(p, r);
	quicksort(p, q);
	p = q + 1;
      }
  }
}


class HitStore
{
  private static final int ArraySize = 128;
  private static final int DefaultLimit = 300;
  
  private HitStoreNode _root = new HitStoreNode(ArraySize);
  private int           _limit;
  private double        _standard;
  private Vector       _leaves = null;
  private HitStoreNode _current = null;

  public HitStore(double initialStandard) {
    this(initialStandard, DefaultLimit);
  }
  
  public HitStore(double initialStandard, int limit)
  {
    _limit = limit;
    _standard = initialStandard;
  }
  
  public void addQueryHit(QueryHit hit) {
    if(_root.add(hit))
      adapt();
  }
  
  private HitStoreNode getNextNode()
  {
    if (_leaves.size() > 0)
      {
	HitStoreNode node = (HitStoreNode)_leaves.firstElement();
	_leaves.removeElementAt(0);
	node.sort();
	return node;
      }
    else
      return null;
  }

  public QueryHit firstBestQueryHit()
  {
    _leaves = new Vector();
    _root.gatherLeaves(_leaves);
    _current = getNextNode();
    return _current.getNextHit();
  }
  
  public QueryHit nextBestQueryHit()
  {
    QueryHit result = _current.getNextHit();
    if (result != null)
      return result;
    else if ((_current = getNextNode()) != null)
      return _current.getNextHit();
    else
      return null;
  }
  
  double getCurrentStandard() {
    return _standard;
  }
  
  private void adapt()
  {
    if (_root.getCount() > _limit)
      if (!_root.isLeaf())
	{
	  HitStoreNode ptr = _root;
	  // find rightmost internal
	  while (!ptr.getRChild().isLeaf())
	    ptr = ptr.getRChild();
      
	  _standard = ptr.getDivider();
      
	  if (ptr == _root)
	    _root = ptr.getLChild();
	  else
	    {
	      int count = ptr.getRChild().getCount();
	      HitStoreNode ptr2 = _root;
	      while (ptr2.getRChild() != ptr)
		{
		  ptr2.decrementCount(count);
		  ptr2 = ptr2.getRChild();
		}
	      ptr2.setRChild(ptr.getLChild());
	    }
	  ptr.setLChild(null);
	}
  }
}
