/*************************************************************************
 *
 *  $RCSfile: Decompressor.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.util;

public abstract class Decompressor {
    private static final int BitsInByte = 8;
    private static final int NBits = 32;
  
    private int _readByte;
    private int _toRead = 0;
    private int _path = 0;

    abstract protected int getNextByte() throws Exception;

    protected void initReading() {
	_toRead = 0;
    }
    
    private final int countZeroes() throws Exception {
	for (int count = 0;; _readByte = getNextByte(), _toRead = BitsInByte)
	    while (_toRead-- > 0)
		if ((_readByte & (1 << _toRead)) != 0)
		    return count;
		else
		    ++count;
    }
  
    // reads 1 bit; returns non-0 for bit "1"
    private final int read() throws Exception {
	if (_toRead-- > 0)
	    return _readByte & (1 << _toRead);
	else {  // get next word
	    _toRead = BitsInByte - 1;
	    return (_readByte = getNextByte()) & 0x80;
	}
    }
  
    public final int read(int kBits) throws Exception {
	int shift = BitsInByte - _toRead;
	if (kBits <= _toRead)
	    return ((_readByte<<shift) & 0xFF) >>> (shift + (_toRead-=kBits));
	else {
	    int result = _toRead > 0
		? ((_readByte << shift) & 0xFF) >>> shift
		: 0;
	    for (kBits -= _toRead; kBits >= BitsInByte; kBits -= BitsInByte)
		result = (result << BitsInByte) | getNextByte();
	    if (kBits > 0)
		return (result << kBits)
		    | ((_readByte = getNextByte()) >>> (_toRead = BitsInByte - kBits));
	    else {
		_toRead = 0;
		return result;
	    }
	}
    }
  
    public final void beginIteration() {
	_path = 0;
    }

    public final boolean readNext(int k, CompressorIterator it) throws Exception {
	if (read() != 0) {
	    it.value(_path | read(k));
	    return true;
	}
	else {
	    for (int count = 1;; _readByte = getNextByte(), _toRead = BitsInByte) {
		while (_toRead-- > 0) {
		    if ((_readByte & (1 << _toRead)) != 0) {
			final int saved = _path;
			_path = ((_path >>> (k + count) << count) | read(count)) << k;
			if (_path != saved) {
			    it.value(_path | read(k));
			    return true;
			}
			else {
			    return false;
			}
		    }
		    else {
			++count;
		    }
		}
	    }
	}
    }
  
    public final void decode(int k, IntegerArray array) throws Exception {
	for (int path = 0;;)
	    if (read() != 0) {
		array.add(path | read(k));
	    }
	    else {
		final int count = countZeroes() + 1;
		final int saved = path;
		path = ((path >>> (k + count) << count) | read(count)) << k;
		if (path != saved)	// convention for end
		    array.add(path | read(k));
		else
		    break;
	    }
    }

    public final void decode(int k, int[] array) throws Exception {
	for (int path = 0, index = 0;;)
	    if (read() != 0) {
		array[index++] = path | read(k);
	    }
	    else {
		final int count = countZeroes() + 1;
		final int saved = path;
		path = ((path >>> (k + count) << count) | read(count)) << k;
		if (path != saved)	// convention for end
		    array[index++] = path | read(k);
		else
		    break;
	    }
    }

    public final void ascDecode(int k, IntegerArray array) throws Exception {
	for (int path = 0, start = 0;;) {
	    if (read() != 0) {
		array.add(start += path | read(k));
	    }
	    else {
		final int count = countZeroes() + 1;
		final int saved = path;
		path = ((path >>> (k + count) << count) | read(count)) << k;
		if (path != saved) {	// convention for end
		    array.add(start += path | read(k));
		}
		else {
		    break;
		}
	    }
	}
    }
  
    public final int ascendingDecode(int k, int start, int[] array) throws Exception {
	int path = 0, index = 0;
    LOOP:
	while (true) {
	    if (read() != 0) {
		array[index++] = (start += path | read(k));
	    }
	    else {
		for (int cnt = 0;; _readByte = getNextByte(), _toRead = BitsInByte) {
		    while (_toRead-- > 0) {
			if ((_readByte & (1 << _toRead)) != 0) {
			    ++cnt;
			    final int Path = ((path >>> (k + cnt) << cnt) | read(cnt)) << k;
			    if (Path != path) {
				array[index++] = (start += (path = Path) | read(k));
				continue LOOP;
			    }
			    else {
				return index;
			    }
			}
			else {
			    ++cnt;
			}
		    }
		}
	    }
	}
    }
}
