/*************************************************************************
 *
 *  $RCSfile: gcc2_freebsd_intel.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: svesik $ $Date: 2001/11/12 22:43:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif
#include <typeinfo>

typedef struct _uno_Any uno_Any;
typedef struct _uno_Mapping uno_Mapping;

// private egcs type info structs

// type_info for a simple class ( no base classes or an enum )
struct __user_type_info : public std::type_info {
	__user_type_info (const char *n) : type_info (n) {}
	
	//	 dynamic cast. built by gcc
	virtual void* dcast (const type_info &, int, void *,
						 const type_info * = 0, void * = 0) const;
};
// type_info for a class with one public, nonvirtual base class.

class __si_type_info : public __user_type_info {
	const __user_type_info &base;
	
public:
	__si_type_info (const char *n, const __user_type_info &b)
			: __user_type_info (n), base (b) { }
	
	//	 dynamic cast. built by gcc
	virtual void *dcast (const type_info &, int, void *,
						 const type_info * = 0, void * = 0) const;
};

// type_info for a general class.

typedef unsigned int USItype    __attribute__ ((mode (SI)));

struct __class_type_info : public __user_type_info {
	enum access { PUBLIC = 1, PROTECTED = 2, PRIVATE = 3 };
	
	struct base_info {
		const __user_type_info *base;
		USItype offset: 29;
		bool is_virtual: 1;
		access access1: 2;
	};
	
	const base_info *base_list;
	size_t n_bases;
	
	__class_type_info (const char *name, const base_info *bl, size_t bn)
			: __user_type_info (name), base_list (bl), n_bases (bn) {}
	
	//	 dynamic cast. built by gcc
	virtual void* dcast (const type_info &, int, void *,
						 const type_info * = 0, void * = 0) const;
};

struct cp_eh_info
{
	struct __eh_info 
	{
		void* match_function;
		short language;
		short version;
	};
	__eh_info eh_info;
	void *value;
	void *type;
	void (*cleanup)(void *, int);
	bool caught;
	cp_eh_info *next;
	long handlers;
	void *original_value;
};

extern "C" {
	void __cp_push_exception( void*, void*, void(*)(void*, int) );
	void __throw();
}

//##################################################################################################
//#### exceptions ##################################################################################
//##################################################################################################

namespace CPPU_CURRENT_NAMESPACE
{
	
void gcc291_freebsd_intel_raiseException( uno_Any * pUnoExc, uno_Mapping * pUno2Cpp );
void gcc291_freebsd_intel_fillUnoException( cp_eh_info*, uno_Any*, uno_Mapping * pCpp2Uno );

} 

