/*************************************************************************
 *
 *  $RCSfile: unmarshal.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/28 16:29:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <sal/alloca.h>

#include <osl/diagnose.h>

#include <rtl/memory.h>
#include <rtl/alloc.h>

#include <bridges/remote/unmarshal.hxx>
#include <bridges/remote/remote.hxx>

#include "conversion.h"

#ifdef major
#undef major
#undef minor
#endif

#include <com/sun/star/corba/TCKind.hpp>
#include <com/sun/star/corba/CorbaString8.hpp>
#include <com/sun/star/corba/CorbaUnion.hpp>
#include <com/sun/star/corba/ObjectKey.hpp>
#include <com/sun/star/corba/iop/IOR.hpp>
#include <com/sun/star/corba/iop/ProfileIdGroup.hpp>
#include <com/sun/star/corba/iiop/ProfileBody_1_1.hpp>

using namespace ::com::sun::star::uno;
using namespace ::rtl;

using namespace ::com::sun::star::corba;
using namespace ::com::sun::star::corba::iop;
using namespace ::com::sun::star::corba::iiop;



namespace bridges_remote {


static int g_nDetectLittleEndian = 1;	
static char g_bSystemIsLittleEndian = ((char*)&g_nDetectLittleEndian)[0];

Unmarshal::Unmarshal( const sal_Int8 *pMem ,
					  sal_Int32 nLength ,
					  sal_Bool bIsLittleEndian,
					  uno_Environment *pEnvRemote,
					  remote_createStubFunc callback ) :
	m_bIsLittleEndian( bIsLittleEndian ),
	m_pos( pMem ),
	m_base( pMem ),
	m_callback( callback ),
	m_pEnvRemote( pEnvRemote ),
	m_nLength( nLength )
{
	
}


inline void Unmarshal::align( sal_Int32 nToAlign )
{
	sal_Int32 n = ( (sal_uInt32)m_pos % nToAlign);
	if( n )
	{
		n = nToAlign -n;
	}
	m_pos += n;
}

sal_Bool Unmarshal::unpackAndDestruct( void *pDest, const ::com::sun::star::uno::Type &rType)
{
	typelib_TypeDescription * pDataTD = 0;
	TYPELIB_DANGER_GET( &pDataTD, rType.getTypeLibType() );
	uno_destructData( pDest , pDataTD , 0 );
	sal_Bool b = unpack( pDest, pDataTD );
	TYPELIB_DANGER_RELEASE( pDataTD );

	return b;
}

sal_Bool Unmarshal::unpackAndDestruct( void *pDest, typelib_TypeDescription *pType)
{
	uno_destructData( pDest , pType  , 0 );
	return unpack( pDest, pType );
}



/*****
 * unpacks a discrimnative union. (see corba specification)
 * The discriminative value ( byte or long ) and one value is unpacked,
 * the unused values are default constructed.
 *****/
sal_Bool unpackUnion( Unmarshal *pUnmarshal,
				  void *pVoidDest ,
				  typelib_CompoundTypeDescription *pCompType )
{
	sal_Int8 *pDest = ( sal_Int8 * ) pVoidDest;
	sal_Bool bReturn = sal_True;

	sal_Int32 nPosToMarshal = 0;
	typelib_TypeDescription *pType = 0;
	TYPELIB_DANGER_GET( &pType , pCompType->ppTypeRefs[0] );
	bReturn = pUnmarshal->unpack( pDest + pCompType->pMemberOffsets[0] , pType );

	if( typelib_TypeClass_BYTE == pType->eTypeClass ||
		typelib_TypeClass_BOOLEAN == pType->eTypeClass )
	{
		// retrieve the position to marshal
		nPosToMarshal =  (sal_Int32 ) *(sal_Int8 * ) (pDest + pCompType->pMemberOffsets[0]);
	}
	else if( typelib_TypeClass_SHORT    == pType->eTypeClass ||
			 typelib_TypeClass_UNSIGNED_SHORT    == pType->eTypeClass )
	{
		// retrieve the position to marshal
		nPosToMarshal =  (sal_Int32 ) *(sal_Int16 * ) (pDest + pCompType->pMemberOffsets[0]);
	}
	else if( typelib_TypeClass_LONG    == pType->eTypeClass ||
			 typelib_TypeClass_ENUM    == pType->eTypeClass )
	{
		// retrieve the position to marshal
		nPosToMarshal =  (sal_Int32 ) *(sal_Int32 * ) (pDest + pCompType->pMemberOffsets[0]);
	}
	else {
		OSL_ASSERT( 0 );
	}
	TYPELIB_DANGER_RELEASE( pType );

	sal_Int32 i;
	for( i = 1 ; i < pCompType->nMembers ; i ++ )
	{
		pType = 0;
		TYPELIB_DANGER_GET( &pType , pCompType->ppTypeRefs[i] );
		if( 1 + nPosToMarshal == i ) {
			bReturn = pUnmarshal->unpack( pDest + pCompType->pMemberOffsets[i], pType ) && bReturn;
		}
		else {
			uno_constructData( pDest + pCompType->pMemberOffsets[i] , pType );
		}
		TYPELIB_DANGER_RELEASE( pType );
	}

	return bReturn;
}


sal_Bool unpackTypecode( Unmarshal *pUnmarshal , typelib_TypeDescription **ppType )
{
	TCKind kind;
	sal_Bool bReturn = sal_True;
	if( ! ( (*pUnmarshal) >>= kind ) )
	{
		return sal_False;
	}

	switch( kind )
	{
	case TCKind_tk_null:
		bReturn = sal_False;
		break;

	case TCKind_tk_void:
		getCppuVoidType().getDescription( ppType );
		break;

	case TCKind_tk_short:
	{
		getCppuType( (sal_Int16 *) 0 ).getDescription( ppType );
		break;
	}
	case TCKind_tk_long:
	{
		getCppuType( (sal_Int32 *) 0 ).getDescription( ppType );
		break;
	}
	case TCKind_tk_wchar:
	{
		getCppuCharType( ).getDescription( ppType );
		break;
	}
	case TCKind_tk_ushort:
	{
		getCppuType( (sal_uInt16*) 0).getDescription( ppType );
		break;
	}
    case TCKind_tk_ulong:
	{
		getCppuType( (sal_uInt32*) 0).getDescription( ppType );
		break;
	}
	case TCKind_tk_float:
	{
		getCppuType( (float *) 0).getDescription( ppType  );
		break;
	}
	case TCKind_tk_double:
	{
		getCppuType( (double*) 0).getDescription( ppType );
		break;
	}
	case TCKind_tk_boolean:
	{
		getCppuBooleanType().getDescription( ppType );
		break;
	}
    case TCKind_tk_octet:
    case TCKind_tk_char:
	{
		getCppuType( (sal_Int8*)0).getDescription( ppType);
		break;
	}
	case TCKind_tk_any:
	{
		getCppuType( ( Any *)0).getDescription( ppType );
		break;
	}
    case TCKind_tk_longlong:
	{
		getCppuType( ( sal_Int64 * )0).getDescription( ppType );
		break;
	}
    case TCKind_tk_ulonglong:
	{
		getCppuType( ( sal_uInt64 * )0).getDescription( ppType );
		break;
	}

	case TCKind_tk_TypeCode:
	{
		getCppuType( ( Type * ) 0 ).getDescription( ppType );
		break;
	}
    case TCKind_tk_Principal:
	{
		OSL_ASSERT( 0 );
		bReturn = sal_False;
		break;
	}
    case TCKind_tk_objref:
	{
		CorbaString8 string8;
		(*pUnmarshal) >>= string8;

		typelib_typedescription_getByName( ppType , string8.theString.pData );

		CorbaString8 dummy;
		bReturn = ( (*pUnmarshal) >>= dummy );

		break;
	}
    case TCKind_tk_except:
	case TCKind_tk_struct:
	{
		CorbaString8 string8;
		(*pUnmarshal) >>= string8;

		typelib_typedescription_getByName( ppType , string8.theString.pData );

		// dummy
		(*pUnmarshal) >>= string8;

		sal_uInt32 nCount = 0;
		bReturn = ( (*pUnmarshal) >>= nCount );

		// extract the members.  These member-description are not used up to now,
		// they are read only to provide protocol-compatibility .
		for( sal_Int32 i = 0 ; i < nCount ; i ++ )
		{
			typelib_TypeDescription *pMemberType = 0;
			bReturn = ( (*pUnmarshal) >>= string8 ); 
			bReturn = unpackTypecode( pUnmarshal , &pMemberType );
			if( pMemberType )
			{
				typelib_typedescription_release( pMemberType );
			}
		}
		break;
	}
    case TCKind_tk_union:
	{
		CorbaString8 string8;
		(*pUnmarshal) >>= string8;

		typelib_typedescription_getByName( ppType , string8.theString.pData );

		// dummy
		(*pUnmarshal) >>= string8;

		typelib_CompoundTypeDescription *pCompType = ( typelib_CompoundTypeDescription*) *ppType;

		typelib_TypeDescription *pDiscriminativeType = 0;
		unpackTypecode( pUnmarshal , &pDiscriminativeType );

		sal_Int32 nDefault = 0;
		(*pUnmarshal) >>= nDefault;

		sal_uInt32 nCount = 0;
		bReturn = ( (*pUnmarshal) >>= nCount );
		
		// extract the members.  These member-description are not used up to now,
		// they are read only to provide protocol-compatibility .		
		for( sal_Int32 i = 0 ; i < nCount ; i ++ )
		{
			// sal_Int64 is largest discriminative type
			sal_Int64 dummyDiscriminativeValue;
			bReturn = pUnmarshal->unpack( &dummyDiscriminativeValue , pDiscriminativeType );

			// member name
			bReturn = ( (*pUnmarshal) >>= string8 );

			typelib_TypeDescription *pMemberType = 0;
			bReturn = unpackTypecode( pUnmarshal , &pMemberType );
			if( pMemberType )
			{
				typelib_typedescription_release( pMemberType );
			}
		}

		typelib_typedescription_release( pDiscriminativeType );
		break;
	}
    case TCKind_tk_enum:
	{
		CorbaString8 string8;
		(*pUnmarshal) >>= string8;

		typelib_typedescription_getByName( ppType , string8.theString.pData );

		CorbaString8 dummy;
		(*pUnmarshal) >>= dummy;

		sal_uInt32 nCount = 0;
		bReturn = ( (*pUnmarshal) >>= nCount );

		// extract the members.  These member-description are not used up to now,
		// they are read only to provide protocol-compatibility .		
		for( sal_Int32 i = 0 ; i < nCount ; i ++ )
		{
			bReturn = ( (*pUnmarshal) >>= string8 );
		}
		break;
	}
	case TCKind_tk_string:
	{
		sal_uInt32 nBound;
		bReturn = ( (*pUnmarshal) >>= nBound );
		getCppuType( (CorbaString8 * )0 ).getDescription( ppType );
		break;
	}
    case TCKind_tk_sequence:
	{
		typelib_TypeDescription * pElementType = 0;
		
		unpackTypecode( pUnmarshal , &pElementType );
		OUString s( RTL_CONSTASCII_USTRINGPARAM( "[]" ) );
		s += OUString( pElementType->pTypeName );

		typelib_typedescription_getByName( ppType, s.pData );
		OSL_ASSERT( *ppType );
		
		typelib_typedescription_release( pElementType );
		
		sal_uInt32 nBound;
		bReturn = ( (*pUnmarshal) >>= nBound );

		OSL_ASSERT( ! nBound );
		break;
	}
	case TCKind_tk_array:
    case TCKind_tk_alias:
	{
		OSL_ASSERT( 0 );
		break;
	}

    case TCKind_tk_longdouble:
	{
		OSL_ASSERT( 0 );
		break;
	}
    case TCKind_tk_wstring:
	{
		getCppuType( ( OUString * ) 0 ).getDescription( ppType );
		sal_uInt32 nBound;
		bReturn = ( (*pUnmarshal) >>= nBound );
		break;
	}
    case TCKind_tk_value:
    case TCKind_tk_value_box:
    case TCKind_tk_native:
    case TCKind_tk_abstract_interface:
    case TCKind_tk_fixed:
	{
		OSL_ASSERT(0);
		bReturn = sal_False;
		break;
	}
	}
	return bReturn;
}



sal_Bool Unmarshal::unpack( void *pDest , typelib_TypeDescription *pType )
{
	sal_Bool bReturn = sal_True;
	switch( pType->eTypeClass )
	{
	case typelib_TypeClass_VOID:
		// do nothing 
		break;
	case typelib_TypeClass_BYTE:
	{
		bReturn = checkAdditionalMem( 1 );
		if( bReturn )
		{
			*((sal_Int8*)pDest ) = *m_pos;
			m_pos++;
		}
		else
		{
			*((sal_Int8*)pDest ) = 0;
		}
		break;
	}
	case typelib_TypeClass_BOOLEAN:
	{
		bReturn = checkAdditionalMem( 1 );
		if( bReturn )
		{
			*((sal_Bool*)pDest) = (sal_Bool ) ( *m_pos);
			m_pos ++;
		}
		else
		{
			*((sal_Bool*)pDest) = 0;
		}
		break;
	}

	case typelib_TypeClass_CHAR:
	case typelib_TypeClass_SHORT:
	case typelib_TypeClass_UNSIGNED_SHORT:
	{		
		align( 2 );
		sal_uInt16 *p = ( sal_uInt16 * ) pDest;
		*p = 0;
		bReturn = checkAdditionalMem( 2 );
		if( bReturn )
		{
			if( m_bIsLittleEndian && g_bSystemIsLittleEndian ||
				! m_bIsLittleEndian && ! g_bSystemIsLittleEndian ) {

				*p = *(sal_uInt16 *) m_pos;
			}
			else
			{
				((sal_Int8*) p )[1] = m_pos[0];
				((sal_Int8*) p )[0] = m_pos[1];
			}
			m_pos ++;
			m_pos ++;
		}
		break;
	}
	case typelib_TypeClass_FLOAT:
	case typelib_TypeClass_LONG:
	case typelib_TypeClass_UNSIGNED_LONG:
	{
		align( 4 );

		bReturn = checkAdditionalMem(4);
		
		sal_uInt32 *p = ( sal_uInt32 * ) pDest;
		*p = 0;
		if( bReturn )
		{
			if( m_bIsLittleEndian && g_bSystemIsLittleEndian ||
				! m_bIsLittleEndian && ! g_bSystemIsLittleEndian )
			{
				*p = *( sal_uInt32 *) m_pos;
			}
			else
			{
				((sal_Int8*) p )[3] = m_pos[0];
				((sal_Int8*) p )[2] = m_pos[1];
				((sal_Int8*) p )[1] = m_pos[2];
				((sal_Int8*) p )[0] = m_pos[3];
			}
			m_pos += 4;
		}
		break;
	}
	case typelib_TypeClass_HYPER:
	case typelib_TypeClass_UNSIGNED_HYPER:
	case typelib_TypeClass_DOUBLE:
	{
		align( 8 );
		sal_uInt64 *p = ( sal_uInt64 * ) pDest;
		*p = 0;
		bReturn = checkAdditionalMem( 8 );
		if( bReturn )
		{
			
			if( m_bIsLittleEndian && g_bSystemIsLittleEndian ||
				! m_bIsLittleEndian && ! g_bSystemIsLittleEndian )
			{
				*p = *( sal_uInt64 *) m_pos;
			}
			else
			{
				((sal_Int8*) p )[7] = m_pos[0];
				((sal_Int8*) p )[6] = m_pos[1];
				((sal_Int8*) p )[5] = m_pos[2];
				((sal_Int8*) p )[4] = m_pos[3];
				((sal_Int8*) p )[3] = m_pos[4];
				((sal_Int8*) p )[2] = m_pos[5];
				((sal_Int8*) p )[1] = m_pos[6];
				((sal_Int8*) p )[0] = m_pos[7];
			}
			m_pos += 8;
		}
		break;
	}
	case typelib_TypeClass_STRING:
	{
		sal_Int32 nLenPlus;
		bReturn  = ( (*this) >>= nLenPlus );

		bReturn = bReturn && checkAdditionalMem( nLenPlus * sizeof( sal_Unicode ) );
		if( bReturn )
		{
			sal_Unicode *pMem = 0;

			if( m_bIsLittleEndian && g_bSystemIsLittleEndian ||
				! m_bIsLittleEndian && ! g_bSystemIsLittleEndian )
			{
				pMem = (sal_Unicode * ) m_pos;
				m_pos += ( nLenPlus * sizeof( sal_Unicode ) );
			}
			else
			{
				pMem = (sal_Unicode*) alloca( nLenPlus * sizeof( sal_Unicode )  );
				sal_Unicode *pPtr = pMem;
				for( sal_Int32 i = 0; i < nLenPlus ; i ++ )
				{
					((sal_Int8*) pPtr )[1] = m_pos[0];
					((sal_Int8*) pPtr )[0] = m_pos[1];
					m_pos ++;
					m_pos ++;
					pPtr ++;
				}
			}

			*(rtl_uString ** ) pDest = 0;
			rtl_uString_newFromStr_WithLength( (rtl_uString **)pDest ,
											   pMem,
											   nLenPlus -1);
		}
		else
		{
			*(rtl_uString ** ) pDest = 0;
			rtl_uString_new( (rtl_uString **) pDest );
		}
		
		break;
	}
	case typelib_TypeClass_ANY:
	{
		uno_Any *pAny = ( uno_Any * )pDest;

		typelib_TypeDescription *pValueType = 0;
		// Type is acquired with typelib_typedescription_acquire
		unpackTypecode( this , &pValueType );

		if( pValueType )
		{
			pAny->pType = pValueType->pWeakRef;
			typelib_typedescriptionreference_acquire( pAny->pType );
			
            switch (pAny->pType->eTypeClass)
            {
            case typelib_TypeClass_HYPER:
            case typelib_TypeClass_UNSIGNED_HYPER:
                if (sizeof(void *) < sizeof(sal_Int64))
                {
                    pAny->pData = rtl_allocateMemory( sizeof(sal_Int64) );
                }
                else
                {
                    pAny->pData = &pAny->pReserved;
                }
                break;
            case typelib_TypeClass_FLOAT:
                if (sizeof(void *) < sizeof(float))
                {
                    pAny->pData = rtl_allocateMemory( sizeof(float) );
                }
                else
                {
                    pAny->pData = &pAny->pReserved;
                }
                break;
            case typelib_TypeClass_DOUBLE:
                if (sizeof(void *) < sizeof(double))
                {
                    pAny->pData = rtl_allocateMemory( sizeof(double) );
                }
                else
                {
                    pAny->pData = &pAny->pReserved;
                }
                break;
            case typelib_TypeClass_STRUCT:
            case typelib_TypeClass_UNION:
            case typelib_TypeClass_EXCEPTION:
            case typelib_TypeClass_ARRAY:
                pAny->pData = rtl_allocateMemory( pType->nSize );
                break;
            default:
                pAny->pData = &pAny->pReserved;
            }
			bReturn = unpack( pAny->pData , pValueType );
		}
		else
		{
			Type type;
			pAny->pType = type.getTypeLibType();
			typelib_typedescriptionreference_acquire( pAny->pType );
			bReturn = sal_False;
		}
			
		break;
	}

	case typelib_TypeClass_ENUM:
	{
		sal_Int32 nIndex;
		bReturn = ( (*this) >>= nIndex );
		typelib_EnumTypeDescription *pEnumType = ((typelib_EnumTypeDescription * ) pType );

		// enum values are transported by value ( against IIOP-specification )
		// must be changed
		*(sal_Int32 *)pDest = nIndex;
		
//  		if( nIndex >= 0 && nIndex < pEnumType->nEnumValues )
//  		{
//  			*(sal_Int32 *)pDest = pEnumType->pEnumValues[nIndex];
//  		}
//  		else
//  		{
//  			// Unknown enum value ->
//  			*(sal_Int32 *)pDest = pEnumType->pEnumValues[0];
//  			// Protocol error or incompatible types !
//  			bReturn = sal_False;
//  		}
		
		break;
	}

	case typelib_TypeClass_STRUCT:
	case typelib_TypeClass_EXCEPTION:
	{
		typelib_CompoundTypeDescription * pCompType =
			(typelib_CompoundTypeDescription *)pType;

		if( my_str_equalsWithLength( CORBA_STRING8_NAME , CORBA_STRING8_NAME_LENGTH,
									  pType->pTypeName->buffer, pType->pTypeName->length ) )
		{
			sal_Int32 nLenPlus;
			
			if( ( (*this) >>= nLenPlus ) && checkAdditionalMem(nLenPlus ) )
			{
				
				*(rtl_uString **) pDest = 0;
				rtl_uString_newFromAscii( (rtl_uString **)pDest , (sal_Char*)m_pos);

				m_pos += nLenPlus;
			}
			else
			{
				bReturn = sal_False;
				*(rtl_uString **) pDest = 0;
				rtl_uString_new( (rtl_uString ** ) pDest );
			}
		}
		else
			if( pCompType->pBaseTypeDescription &&
				my_str_equalsWithLength(
					CORBA_UNION_NAME ,
					CORBA_UNION_NAME_LENGTH,
					pCompType->pBaseTypeDescription->aBase.pTypeName->buffer,
					pCompType->pBaseTypeDescription->aBase.pTypeName->length ) )
			{
				bReturn = unpackUnion( this , pDest , pCompType );
			}
		else
		{
			if (pCompType->pBaseTypeDescription)
			{
				bReturn =
					unpack( pDest , (typelib_TypeDescription * ) pCompType->pBaseTypeDescription );
			}

			// then construct members
			typelib_TypeDescriptionReference ** ppTypeRefs = pCompType->ppTypeRefs;
			sal_Int32 * pMemberOffsets = pCompType->pMemberOffsets;
			sal_Int32 nDescr = pCompType->nMembers;
			
			for ( sal_Int32 nPos = 0; nPos < nDescr; ++nPos )
			{
				typelib_TypeDescription * pMemberType = 0;
				TYPELIB_DANGER_GET( &pMemberType, ppTypeRefs[nPos] );
				// Even if bReturn is false, all values must be default constructed !
				bReturn = unpack( (char*)pDest + pMemberOffsets[nPos] , pMemberType ) && bReturn;
				TYPELIB_DANGER_RELEASE( pMemberType );
			}
		}
		break;
	}
	case typelib_TypeClass_SEQUENCE:
	{		
		sal_Int32 nLen;
		bReturn = ( (*this) >>= nLen );
		
		typelib_TypeDescription * pET = 0;
		typelib_typedescriptionreference_getDescription(
			&pET ,	 ((typelib_IndirectTypeDescription *)pType)->pType );
		uno_Sequence * pSequence = 0;

		if( pET )
		{
			sal_Int32 nElementSize = pET->nSize;
			
			pSequence = (uno_Sequence *)rtl_allocateMemory(
				SAL_SEQUENCE_HEADER_SIZE + nLen * nElementSize );
			pSequence->nRefCount = 1;
			pSequence->nElements = nLen;
			
			bReturn = bReturn &&  checkAdditionalMem( nElementSize * nLen );
			if( nLen && bReturn )
			{
				for( sal_Int32 i = 0 ; i < nLen ; i ++ )
				{
					bReturn = unpack( ((char*)pSequence->elements)+ i*nElementSize,pET ) && bReturn;
				}
			}
			typelib_typedescription_release( pET );
		}
		else
		{
			bReturn = sal_False;

			pSequence = (uno_Sequence*) rtl_allocateMemory( SAL_SEQUENCE_HEADER_SIZE );
			uno_constructData( pSequence , pType );
		}

		*((uno_Sequence **)pDest) = pSequence;
		break;
	}
	case typelib_TypeClass_INTERFACE:
	{
		*(remote_Interface**)pDest = 0;

		iop::IOR ior;
		bReturn = ( (*this) >>= ior );

		if( ior.profiles.getLength() && bReturn )
		{
			sal_Int32 nMax = ior.profiles.getLength();

			ObjectKey key;
			TaggedProfile *pProf = ior.profiles.getArray();
			for( sal_Int32 i = 0 ; i < nMax ; i ++ )
			{
				if( ProfileIdGroup::TAG_INTERNET_IOP == pProf[i].tag )
				{
					Unmarshal unm( pProf[i].profile_data.getConstArray(),
								   pProf[i].profile_data.getLength(),
								   m_bIsLittleEndian );

					ProfileBody_1_1 body;
					bReturn = ( unm >>= body );
					if( bReturn )
					{
						Unmarshal unm2( body.object_key.getConstArray(),
										body.object_key.getLength(),
										m_bIsLittleEndian );
						bReturn = unm2 >>= key;
					}
					break;
				}
			}
			if( bReturn )
			{
				// the requested type is already known. It is possible,
				// that a different type is in key.sOid.theString, but
				// it must be an interface, that is derived from the desired interface
				m_callback( (remote_Interface **) pDest,
							key.sOid.theString.pData,
							pType->pWeakRef,
							m_pEnvRemote,
							0 );
			}
							
			// leave the old code here, if the new variant causes any problems
//  			OSL_ASSERT( key.sType.theString == pType->pTypeName );
//  			typelib_TypeDescription *pInterfaceType = 0;
//  			typelib_typedescription_getByName( &pInterfaceType , key.sType.theString.pData );

//  			if( pInterfaceType )
//  			{
//  				m_callback( (remote_Interface**) pDest ,
//  							key.sOid.theString.pData,
//  							pInterfaceType->pWeakRef ,
//  							m_pEnvRemote );
			
//  				typelib_typedescription_release( pInterfaceType );
//  			}
//  			else
//  			{
//  				bReturn = sal_False;
//  			}
		}
		else
		{
			// null reference, nothing to do !
		}
		break;
	}
	case typelib_TypeClass_TYPE:
    {
		*(typelib_TypeDescriptionReference **) pDest = 0;
			
	    typelib_TypeDescription *pType = 0;
	    unpackTypecode( this, &pType );

		if( pType )
		{
			typelib_typedescriptionreference_new(
				(typelib_TypeDescriptionReference **) pDest ,
				pType->eTypeClass ,
				pType->pTypeName );
			
			typelib_typedescription_release( pType );
		}
		else
		{
			Type type;

			*(typelib_TypeDescriptionReference **) pDest  = type.getTypeLibType();
			typelib_typedescriptionreference_acquire( *(typelib_TypeDescriptionReference **) pDest );

			bReturn = sal_False;
		}
		break;
	}

	case typelib_TypeClass_TYPEDEF:
	case typelib_TypeClass_UNION:
	case typelib_TypeClass_ARRAY:
	case typelib_TypeClass_SERVICE:
	case typelib_TypeClass_MODULE:
	case typelib_TypeClass_INTERFACE_METHOD:
	case typelib_TypeClass_INTERFACE_ATTRIBUTE:
	case typelib_TypeClass_UNKNOWN:
	default:
		OSL_ASSERT( 0 );
	}
	return bReturn;
}

} // end namespace bridges
