/*************************************************************************
 *
 *  $RCSfile: export.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/22 15:42:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INETCOREMSG_HXX
#include "inetmsg.hxx"
#endif
#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _DATETIMEITEM_HXX
#include <svtools/dateitem.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef _SVTOOLS_STRCRYPT_HXX_
#include <svtools/strcrypt.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_EXPORT_HXX
#include <export.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CHAOS_MBXFORMT_HXX
#include <mbxformt.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  CntMIMEStreamSink
//
//============================================================================

// virtual
void CntMIMEStreamSink_Impl::writeSequence(sal_Char const * pBegin,
										   sal_Char const * pEnd)
{
	DBG_ASSERT(pBegin && pBegin <= pEnd,
			   "CntMIMEStreamSink_Impl::writeSequence(): Bad sequence");

	m_rStream.Write(pBegin, pEnd - pBegin);
}

//============================================================================
// virtual
ErrCode CntMIMEStreamSink_Impl::getError()
{
	return m_rStream.GetError();
}

//============================================================================
//
//  CntExport
//
//============================================================================

void CntExport::writeFrom(SfxItemSet const * pItems, bool bFromLine)
{
	if (bFromLine)
	{
		m_aSink << "From CHAOS 0";
		if (pItems)
			switch (static_cast< CntContentTypeItem const * >(
				            &pItems->Get(WID_CONTENT_TYPE))->
					    GetEnumValue())
			{
				case CONTENT_TYPE_X_CNT_MESSAGE:
					m_aSink << " message";
					break;

				case CONTENT_TYPE_X_CNT_POP3BOX:
					m_aSink << " messagebox";
					break;

				case CONTENT_TYPE_X_CNT_NEWSBOX:
					m_aSink << " newsbox";
					break;
			}
		m_aSink << INetMIMEOutputSink::endl;
	}
	m_aSink << "MIME-Version: 1.0" << INetMIMEOutputSink::endl;
}

//============================================================================
void CntExport::writeHeaderField(INetMIME::HeaderFieldType eType,
								 sal_Char const * pName,
								 ByteString const & rBody,
								 rtl_TextEncoding ePreferredEncoding)
{
	m_aSink << pName << ':';
	INetMIME::writeHeaderFieldBody(m_aSink, eType, rBody, ePreferredEncoding);
	m_aSink << INetMIMEOutputSink::endl;
}

//============================================================================
void CntExport::writeHeaderField(INetMIME::HeaderFieldType eType,
								 sal_Char const * pName,
								 UniString const & rBody,
								 rtl_TextEncoding ePreferredEncoding)
{
	m_aSink << pName << ':';
	INetMIME::writeHeaderFieldBody(m_aSink, eType, rBody, ePreferredEncoding);
	m_aSink << INetMIMEOutputSink::endl;
}

//============================================================================
void CntExport::writeQuotedPrintable(sal_uInt32 nChar, bool bForce,
									 bool bEndOfLine)
{
	bool bEscape = bForce
		           || !(INetMIME::isVisible(nChar)
						|| INetMIME::isWhiteSpace(nChar))
		           || nChar == '=';
	if (m_aSink.getColumn() + (bEscape ? 3 : 1)
		    > sal_uInt32(bEndOfLine ? INetMIME::SOFT_LINE_LENGTH_LIMIT :
						              INetMIME::SOFT_LINE_LENGTH_LIMIT - 1))
		m_aSink << '=' << INetMIMEOutputSink::endl;
	if (bEscape)
		INetMIME::writeEscapeSequence(m_aSink, nChar);
	else
		m_aSink << sal_Char(nChar);
}

//============================================================================
void CntExport::writeQuotedPrintable(SvStream & rData, sal_uInt32 nSize)
{
	enum State { STATE_LINE, STATE_F, STATE_R, STATE_O, STATE_HYPHUS,
				 STATE_CR };

	sal_uInt32 nNullCount = 0;
	sal_uInt8  aBuffer[5];
	int nBufferLen = 0;
	bool bForce = false;
	State eState = STATE_LINE;
	while (nSize-- > 0)
	{
		sal_uInt8 nChar;
		rData >> nChar;
		if (rData.GetError() || rData.IsEof())
			break;
		if (nChar != '\0')
			for (; nNullCount > 0; --nNullCount)
				writeQuotedPrintable(0);
		switch (eState)
		{
			state_line:
				eState = STATE_LINE;
			case STATE_LINE:
				if (nChar == 0x0D) // CR
				{
					aBuffer[nBufferLen++] = 0x0D; // CR
					eState = STATE_CR;
				}
				else
				{
					if (nBufferLen > 0)
					{
						for (; nNullCount > 0; --nNullCount)
							writeQuotedPrintable(0);
						for (int i = 0; i < nBufferLen; ++i)
						{
							writeQuotedPrintable(aBuffer[i], bForce);
							bForce = false;
						}
						nBufferLen = 0;
					}
					if (nChar == '\0')
						++nNullCount;
					else
					{
						aBuffer[nBufferLen++] = nChar;
						if (nChar == 'F' || nChar == 'f')
						{
							if (m_aSink.getColumn() == 0
								|| m_aSink.getColumn()
								    > INetMIME::SOFT_LINE_LENGTH_LIMIT - 2)
								eState = STATE_F;
						}
						else if (nChar == '-')
						{
							if (m_aSink.getColumn() == 0
								|| m_aSink.getColumn()
								    > INetMIME::SOFT_LINE_LENGTH_LIMIT - 2)
								eState = STATE_HYPHUS;
						}
					}
				}
				break;

			case STATE_F:
				if (nChar == 'R' || nChar == 'r')
				{
					aBuffer[nBufferLen++] = nChar;
					eState = STATE_R;
				}
				else
					goto state_line;
				break;

			case STATE_R:
				if (nChar == 'O' || nChar == 'o')
				{
					aBuffer[nBufferLen++] = nChar;
					eState = STATE_O;
				}
				else
					goto state_line;
				break;

			case STATE_O:
				bForce = nChar == 'M' || nChar == 'm';
				goto state_line;

			case STATE_HYPHUS:
				bForce = nChar == '-';
				goto state_line;

			case STATE_CR:
				if (nChar == 0x0A) // LF
				{
					for (; nNullCount > 0; --nNullCount)
						writeQuotedPrintable(0);
					if (nBufferLen > 1)
					{
						nBufferLen -= 2;
						for (int i = 0; i < nBufferLen; ++i)
						{
							writeQuotedPrintable(aBuffer[i], bForce);
							bForce = false;
						}
						writeQuotedPrintable(aBuffer[nBufferLen], bForce,
											 true);
						bForce = false;
					}
					nBufferLen = 0;
					m_aSink << INetMIMEOutputSink::endl;
					eState = STATE_LINE;
				}
				else
					goto state_line;
				break;
		}
	}
	if (nBufferLen > 0)
	{
		for (; nNullCount > 0; --nNullCount)
			writeQuotedPrintable(0);
		for (int i = 0; i < nBufferLen; ++i)
		{
			writeQuotedPrintable(aBuffer[i], bForce);
			bForce = false;
		}
	}
	m_aSink << INetMIMEOutputSink::endl;
}

//============================================================================
void CntExport::writeBase64(SvStream & rData, sal_uInt32 nSize)
{
	sal_uInt32 nValue = 0;
	int nPrecision = 16;
	while (nSize-- > 0)
	{
		sal_Char nChar;
		rData >> nChar;
		if (rData.GetError() || rData.IsEof())
			break;
		nValue |= sal_uInt32(sal_uChar(nChar)) << nPrecision;
		if (nPrecision > 0)
			nPrecision -= 8;
		else
		{
			if (m_aSink.getColumn() > INetMIME::SOFT_LINE_LENGTH_LIMIT - 4)
				m_aSink << INetMIMEOutputSink::endl;
			m_aSink << sal_Char(INetMIME::getBase64Digit(nValue >> 18))
					<< sal_Char(INetMIME::getBase64Digit(nValue >> 12 & 63))
					<< sal_Char(INetMIME::getBase64Digit(nValue >> 6 & 63))
					<< sal_Char(INetMIME::getBase64Digit(nValue & 63));
			nValue = 0;
			nPrecision = 16;
		}
	}
	if (nPrecision != 16)
	{
		if (m_aSink.getColumn() > INetMIME::SOFT_LINE_LENGTH_LIMIT - 4)
			m_aSink << INetMIMEOutputSink::endl;
		m_aSink << sal_Char(INetMIME::getBase64Digit(nValue >> 18))
				<< sal_Char(INetMIME::getBase64Digit(nValue >> 12 & 63))
				<< (nPrecision == 0 ?
					    sal_Char(INetMIME::getBase64Digit(nValue >> 6 & 63)) :
					    '=')
				<< '=';
	}
	if (m_aSink.getColumn() != 0)
		m_aSink << INetMIMEOutputSink::endl;
}

//============================================================================
ErrCode CntExport::writeMessage(SfxItemSet const * pItems,
								INetCoreMIMEMessage const * pMessage,
								bool bBody, UniString const & rNewsHost,
								rtl_TextEncoding ePreferredEncoding)
{
	bool bNewsMessage = false;
	if (pItems && !pMessage)
	{
		SfxPoolItem const * pItem;
		if (pItems->GetItemState(WID_MESSAGEBODY, true, &pItem)
			    == SFX_ITEM_SET)
		{
			pMessage
				= static_cast< CntMessageBodyItem const * >(pItem)->Get();
			bNewsMessage = true;
		}
	}

	SfxPoolItem const * pItem;
	if (pItems
		&& (pItems->GetItemState(WID_DATE_MODIFIED, true, &pItem)
			    == SFX_ITEM_SET
			|| pItems->GetItemState(WID_DATE_CREATED, true, &pItem)
			    == SFX_ITEM_SET))
	{
		INetMIMEStringOutputSink aSink;
		INetMIME::writeDateTime(aSink,
								static_cast< SfxDateTimeItem const * >(
									    pItem)->
								    GetDateTime());
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Date",
						 aSink.takeBuffer(), ePreferredEncoding);
	}
	else if (pMessage && pMessage->GetDate().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Date",
						 pMessage->GetDate(), ePreferredEncoding);

	if (pMessage && pMessage->GetReturnPath().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Return-path",
						 pMessage->GetReturnPath(), ePreferredEncoding);

	if (pMessage && pMessage->GetReceived().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Received",
						 pMessage->GetReceived(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_FROM, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "From",
						 ITEM_VALUE(CntNameItem, *pItem), ePreferredEncoding);
	else if (pMessage && pMessage->GetFrom().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "From",
						 pMessage->GetFrom(), ePreferredEncoding);

	if (pMessage && pMessage->GetSender().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "Sender",
						 pMessage->GetSender(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_REPLY_TO, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "Reply-To",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetReplyTo().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "Reply-To",
						 pMessage->GetReplyTo(), ePreferredEncoding);

	if (pItems && pItems->GetItemState(WID_TO, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "To",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetTo().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "To",
						 pMessage->GetTo(), ePreferredEncoding);

	if (pItems && pItems->GetItemState(WID_CC, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "cc",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetCC().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "cc",
						 pMessage->GetCC(), ePreferredEncoding);

	if (pItems && pItems->GetItemState(WID_BCC, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "bcc",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetBCC().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_ADDRESS, "bcc",
						 pMessage->GetBCC(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_MESSAGE_ID, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_MESSAGE_ID, "Message-ID",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetMessageID().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_MESSAGE_ID, "Message-ID",
						 pMessage->GetMessageID(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_IN_REPLY_TO, true, &pItem)
		    == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_MESSAGE_ID, "In-Reply-To",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetInReplyTo().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_MESSAGE_ID, "In-Reply-To",
						 pMessage->GetInReplyTo(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_REFERENCES, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_MESSAGE_ID, "References",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetReferences().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_MESSAGE_ID, "References",
						 pMessage->GetReferences(), ePreferredEncoding);

	if (pMessage && pMessage->GetKeywords().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_PHRASE, "Keywords",
						 pMessage->GetKeywords(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_SUBJECT, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_TEXT, "Subject",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetSubject().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_TEXT, "Subject",
						 pMessage->GetSubject(), ePreferredEncoding);

	if (pMessage && pMessage->GetComments().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_TEXT, "Comments",
						 pMessage->GetComments(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_NEWSGROUPS, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Newsgroups",
						 ITEM_VALUE(CntStringItem, *pItem),
						 ePreferredEncoding);
	else if (bNewsMessage && pMessage
			 && static_cast< INetCoreNewsMessage const * >(pMessage)->
			            GetNewsgroups().Len()
			        > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Newsgroups",
						 static_cast< INetCoreNewsMessage const * >(
							     pMessage)->
						     GetNewsgroups(),
						 ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_NEWS_XREFLIST, true, &pItem)
		       == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Xref",
						 CntMBXFormat::translateXref(
							 rNewsHost,
							 *static_cast< CntItemListItem const * >(pItem)),
						 ePreferredEncoding);
	else if (bNewsMessage && pMessage
			 && static_cast< INetCoreNewsMessage const * >(pMessage)->
			            GetXref().Len()
			        > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "Xref",
						 static_cast< INetCoreNewsMessage const * >(
							     pMessage)->
						     GetXref(),
						 ePreferredEncoding);

	if (pMessage && pMessage->GetXMailer().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_TEXT, "X-Mailer",
						 pMessage->GetXMailer(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_PRIORITY, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "X-Priority",
						 CntMBXFormat::translateXPriority(
							 CntPriority(ITEM_VALUE(CntPriorityItem,
													*pItem))),
						 ePreferredEncoding);
	else if (pMessage && pMessage->GetXPriority().Len() > 0)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "X-Priority",
						 pMessage->GetXPriority(), ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_IS_READ, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "X-CHAOS-Read",
						 CntMBXFormat::translateBoolean(
							 ITEM_VALUE(CntBoolItem, *pItem) != false),
						 ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_IS_MARKED, true, &pItem) == SFX_ITEM_SET)
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "X-CHAOS-Marked",
						 CntMBXFormat::translateBoolean(
							 ITEM_VALUE(CntBoolItem, *pItem) != false),
						 ePreferredEncoding);

	if (pItems
		&& pItems->GetItemState(WID_RECIPIENTLIST, true, &pItem)
		       == SFX_ITEM_SET)
	{
		ByteString aFieldBody;
		CntRecipientListItem const & rList
			= *static_cast< CntRecipientListItem const * >(pItem);
		for (USHORT i = 0; i < rList.Count(); ++i)
		{
			if (i != 0)
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(", "));
			CntRecipientInfo const * pInfo = rList[i];
			bool bOutput = false;
			if (pInfo->GetProtocol() >= CNT_OUTMSG_PROTOCOL_SMTP
				&& pInfo->GetProtocol() <= CNT_OUTMSG_PROTOCOL_COPY)
			{
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("<Protocol "));
				switch (pInfo->GetProtocol())
				{
					case CNT_OUTMSG_PROTOCOL_SMTP:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("SMTP"));
						break;

					case CNT_OUTMSG_PROTOCOL_VIM:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("VIM"));
						break;

					case CNT_OUTMSG_PROTOCOL_MAPI:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("MAPI"));
						break;

					case CNT_OUTMSG_PROTOCOL_MBOX:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("MBOX"));
						break;

					case CNT_OUTMSG_PROTOCOL_NNTP:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("NNTP"));
						break;

					case CNT_OUTMSG_PROTOCOL_COPY:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("COPY"));
						break;
				}
				aFieldBody += '>';
				bOutput = true;
			}
			if (pInfo->GetServer().Len() > 0)
			{
				if (bOutput)
					aFieldBody += ' ';
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("<Server "));
				aFieldBody += CntMBXFormat::translateWord(pInfo->GetServer());
				aFieldBody += '>';
				bOutput = true;
			}
			if (pInfo->GetUsername().Len() > 0)
			{
				if (bOutput)
					aFieldBody += ' ';
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("<User "));
				aFieldBody
					+= CntMBXFormat::translateWord(pInfo->GetUsername());
				aFieldBody += '>';
				bOutput = true;
			}
			if (pInfo->GetPassword().Len() > 0)
			{
				if (bOutput)
					aFieldBody += ' ';
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("<Message-ID "));
					// obscure key...
				aFieldBody
					+= CntMBXFormat::translateWord(
						   SvStringEncode(ByteString(pInfo->GetPassword(),
													 RTL_TEXTENCODING_UTF8)));
				aFieldBody += '>';
				bOutput = true;
			}
			if (pInfo->GetState() >= CNT_OUTMSG_INTERNALSTATE_WRITTEN
				&& pInfo->GetState() <= CNT_OUTMSG_INTERNALSTATE_CONFIRMED)
			{
				if (bOutput)
					aFieldBody += ' ';
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("<State "));
				switch (pInfo->GetState())
				{
					case CNT_OUTMSG_INTERNALSTATE_WRITTEN:
						aFieldBody.
							Append(RTL_CONSTASCII_STRINGPARAM("written"));
						break;

					case CNT_OUTMSG_INTERNALSTATE_PARTIALLY_LOCALLY_SENT:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(
							                  "partially-locally-sent"));
						break;

					case CNT_OUTMSG_INTERNALSTATE_COMPLETELY_LOCALLY_SENT:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(
							                  "completely-locally-sent"));
						break;

					case CNT_OUTMSG_INTERNALSTATE_RECOVERABLE_LOCAL_ERROR:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(
							                  "recoverable-local-error"));
						break;

					case CNT_OUTMSG_INTERNALSTATE_NONRECOVERABLE_LOCAL_ERROR:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(
							                  "nonrecoverable-local-error"));
						break;

					case CNT_OUTMSG_INTERNALSTATE_EXTERNAL_ERROR:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(
							                  "external-error"));
						break;

					case CNT_OUTMSG_INTERNALSTATE_WAITING_CONFIRMATION:
						aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(
							                  "waiting-confirmation"));
						break;

					case CNT_OUTMSG_INTERNALSTATE_CONFIRMED:
						aFieldBody.
							Append(RTL_CONSTASCII_STRINGPARAM("confirmed"));
						break;
				}
				aFieldBody += '>';
				bOutput = true;
			}
			if (bOutput)
				aFieldBody += ' ';
			aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM("<Reply-Code "));
/* @@@ */			aFieldBody += pInfo->GetProtocolError();
			aFieldBody += '>';
			if (pInfo->GetProtocolErrorStr().Len() > 0)
			{
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(" <Reply "));
				aFieldBody
					+= CntMBXFormat::translateWord(pInfo->
												       GetProtocolErrorStr());
				aFieldBody += '>';
			}
			aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(" <Tries "));
/* @@@ */			aFieldBody += pInfo->GetSendTries();
			aFieldBody += '>';
			if (pInfo->GetToRecipient().Len() > 0)
			{
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(" <To "));
				aFieldBody
					+= CntMBXFormat::translateWord(pInfo->GetToRecipient());
				aFieldBody += '>';
			}
			if (pInfo->GetCcRecipient().Len() > 0)
			{
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(" <cc "));
				aFieldBody
					+= CntMBXFormat::translateWord(pInfo->GetCcRecipient());
				aFieldBody += '>';
			}
			if (pInfo->GetBccRecipient().Len() > 0)
			{
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(" <bcc "));
				aFieldBody
					+= CntMBXFormat::translateWord(pInfo->GetBccRecipient());
				aFieldBody += '>';
			}
			if (pInfo->GetNewsRecipient().Len() > 0)
			{
				aFieldBody.Append(RTL_CONSTASCII_STRINGPARAM(" <News "));
				aFieldBody
					+= CntMBXFormat::translateWord(pInfo->GetNewsRecipient());
				aFieldBody += '>';
			}
		}
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED,
						 "X-CHAOS-Recipients", aFieldBody,
						 ePreferredEncoding);
	}

	if (pItems
		&& pItems->GetItemState(WID_DOCUMENT_SIZE, true, &pItem)
		       == SFX_ITEM_SET)
	{
		INetMIMEStringOutputSink aSink;
		INetMIME::writeUnsigned(aSink, ITEM_VALUE(CntUInt32Item, *pItem));
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED, "X-CHAOS-Size",
						 aSink.takeBuffer(), ePreferredEncoding);
	}

	if (bBody)
		if (pMessage)
		{
			UniString aType;
			UniString aSubType;
			INetContentTypeParameterList aParameters;
			INetContentTypes::parse(pMessage->GetContentType(), aType,
									aSubType, &aParameters);

			if (pMessage->GetContentType().Len() != 0)
				writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED,
								 "Content-Type", pMessage->GetContentType(),
								 ePreferredEncoding);

			writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED,
							 "Content-Transfer-Encoding",
							 aType.EqualsAscii("message")
							 || aType.EqualsAscii("multipart") ?
							     ByteString(RTL_CONSTASCII_STRINGPARAM(
									            "binary")) :
							 aType.EqualsAscii("text") ?
							     ByteString(RTL_CONSTASCII_STRINGPARAM(
									            "quoted-printable")) :
							     ByteString(RTL_CONSTASCII_STRINGPARAM(
									            "base64")),
							 ePreferredEncoding);

			if (pMessage->GetContentID().Len() > 0)
				writeHeaderField(INetMIME::HEADER_FIELD_MESSAGE_ID,
								 "Content-ID", pMessage->GetContentID(),
								 ePreferredEncoding);

			if (pMessage->GetContentDescription().Len() > 0)
				writeHeaderField(INetMIME::HEADER_FIELD_TEXT,
								 "Content-Description",
								 pMessage->GetContentDescription(),
								 ePreferredEncoding);

			if (pMessage->GetContentBase().Len() > 0)
				writeHeaderField(INetMIME::HEADER_FIELD_TEXT,
								 "Content-Base: ",
								 pMessage->GetContentBase(),
								 ePreferredEncoding);

			if (pMessage->GetContentDisposition().Len() > 0)
				writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED,
								 "Content-Disposition",
								 pMessage->GetContentDisposition(),
								 ePreferredEncoding);

			if (pMessage->GetContentLocation().Len() > 0)
				writeHeaderField(INetMIME::HEADER_FIELD_TEXT,
								 "Content-Location",
								 pMessage->GetContentLocation(),
								 ePreferredEncoding);

			m_aSink << INetMIMEOutputSink::endl;

			if (aType.EqualsAscii("message"))
			{
				ErrCode nError = writeMessage(0, pMessage->GetChild(0), true,
											  rNewsHost, ePreferredEncoding);
				if (nError != ERRCODE_NONE)
					return nError;
			}
			else if (aType.EqualsAscii("multipart"))
			{
				ByteString aBoundary;
				if (INetContentTypeParameter const * pParameter
					    = aParameters.
					          find(ByteString(RTL_CONSTASCII_STRINGPARAM(
								                  "boundary"))))
					aBoundary
						= ByteString(
							  pParameter->m_sValue,
							  RTL_TEXTENCODING_ISO_8859_1,
							  RTL_UNICODETOTEXT_FLAGS_UNDEFINED_IGNORE |
							      RTL_UNICODETOTEXT_FLAGS_INVALID_IGNORE |
							      RTL_UNICODETOTEXT_FLAGS_PRIVATE_IGNORE);
				for (ULONG i = 0; i < pMessage->GetChildCount(); ++i)
				{
					m_aSink << "--" << aBoundary.GetBuffer()
							<< INetMIMEOutputSink::endl;
					ErrCode nError
						= writeMessage(0, pMessage->GetChild(i), true,
									   rNewsHost, ePreferredEncoding);
					if (nError != ERRCODE_NONE)
						return nError;
				}
				m_aSink << "--" << aBoundary.GetBuffer() << "--"
						<< INetMIMEOutputSink::endl;
			}
			else if (aType.EqualsAscii("text"))
			{
				if (SvStream * pBodyStream = pMessage->GetDocumentStream())
				{
					pBodyStream->Seek(0);
					writeQuotedPrintable(*pBodyStream,
										 pMessage->GetDocumentSize());
					ErrCode nError = pBodyStream->GetError();
					if (nError != ERRCODE_NONE)
						return nError;
				}
			}
			else if (SvStream * pBodyStream = pMessage->GetDocumentStream())
			{
				pBodyStream->Seek(0);
				writeBase64(*pBodyStream, pMessage->GetDocumentSize());
				ErrCode nError = pBodyStream->GetError();
				if (nError != ERRCODE_NONE)
					return nError;
			}
		}
		else
			writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED,
							 "Content-Type", "X-CHAOS/none",
							 ePreferredEncoding);

	return m_aSink.getError();
}

//============================================================================
ErrCode CntExport::writeMessage(SfxItemSet const & rItems,
								UniString const * pNewsHost, bool bFromLine)
{
	writeFrom(&rItems, bFromLine);
	UniString aTheNewsHost;
	if (pNewsHost)
		aTheNewsHost = *pNewsHost;
	ErrCode nError = writeMessage(&rItems, 0, true, aTheNewsHost,
								  osl_getThreadTextEncoding());
	m_eState = STATE_FROM;
	return nError;
}

//============================================================================
ErrCode CntExport::writeMessage(INetCoreMIMEMessage const & rMessage,
								UniString const * pNewsHost)
{
	writeFrom(0, false);
	UniString aTheNewsHost;
	if (pNewsHost)
		aTheNewsHost = *pNewsHost;
	ErrCode nError = writeMessage(0, &rMessage, true, aTheNewsHost,
								  osl_getThreadTextEncoding());
	m_eState = STATE_FROM;
	return nError;
}

//============================================================================
ErrCode CntExport::writeHeader(SfxItemSet const & rItems,
							   UniString const * pNewsHost)
{
	writeFrom(&rItems, true);
	UniString aTheNewsHost;
	if (pNewsHost)
		aTheNewsHost = *pNewsHost;
	ErrCode nError = writeMessage(&rItems, 0, false, aTheNewsHost,
								  osl_getThreadTextEncoding());
	m_eState = STATE_HEADER;
	return nError;
}

//============================================================================
ErrCode CntExport::writeBody(ByteString const & rLine)
{
	if (m_eState == STATE_HEADER)
	{
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED,
						 "Content-Type", "text/plain; charset=US-ASCII",
						 osl_getThreadTextEncoding());
		writeHeaderField(INetMIME::HEADER_FIELD_STRUCTURED,
						 "Content-Transfer-Encoding", "7bit",
						 osl_getThreadTextEncoding());
		m_aSink << INetMIMEOutputSink::endl;
		m_eState = STATE_BODY;
	}
	if (m_eState == STATE_BODY)
		m_aSink << rLine.GetBuffer() << INetMIMEOutputSink::endl;
	return m_aSink.getError();
}

