/*************************************************************************
 *
 *  $RCSfile: mbx.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/14 16:59:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2001 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef INCLUDED_MBX_HXX
#define INCLUDED_MBX_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandProcessor.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif

namespace chaos
{

/*========================================================================
 *
 * MbxCommandInfo_Impl.
 *
 *======================================================================*/
class MbxCommandInfo_Impl :
	public cppu::OWeakObject,
	public com::sun::star::lang::XTypeProvider,
	public com::sun::star::ucb::XCommandInfo
{
public:
	/** Construction.
	 */
	MbxCommandInfo_Impl (void);

	/** XInterface.
	 */
	virtual com::sun::star::uno::Any
	SAL_CALL queryInterface (
		const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire (void) throw();
	virtual void SAL_CALL release (void) throw();

	/** XTypeProvider.
	 */
	virtual com::sun::star::uno::Sequence<com::sun::star::uno::Type>
	SAL_CALL getTypes (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual com::sun::star::uno::Sequence<sal_Int8>
	SAL_CALL getImplementationId (void)
		throw (com::sun::star::uno::RuntimeException);

	/** XCommandInfo.
	 */
	virtual com::sun::star::uno::Sequence<com::sun::star::ucb::CommandInfo>
	SAL_CALL getCommands (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual com::sun::star::ucb::CommandInfo
	SAL_CALL getCommandInfoByName (const rtl::OUString & rName)
		throw (
			com::sun::star::ucb::UnsupportedCommandException,
			com::sun::star::uno::RuntimeException);

	virtual com::sun::star::ucb::CommandInfo
	SAL_CALL getCommandInfoByHandle (sal_Int32 nHandle)
		throw (
			com::sun::star::ucb::UnsupportedCommandException,
			com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL hasCommandByName (const rtl::OUString & rName)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL hasCommandByHandle (sal_Int32 nHandle)
		throw (com::sun::star::uno::RuntimeException);

protected:
	/** Destruction.
	 */
	virtual ~MbxCommandInfo_Impl (void);

private:
	/** Representation.
	 */
	com::sun::star::uno::Sequence<
	    com::sun::star::ucb::CommandInfo> m_aCommands;

	/** Not implemented.
	 */
	MbxCommandInfo_Impl (const MbxCommandInfo_Impl&);
	MbxCommandInfo_Impl& operator= (const MbxCommandInfo_Impl&);
};

/*========================================================================
 *
 * MbxService_Impl.
 *
 *======================================================================*/
class MbxContext_Impl;

class MbxService_Impl :
	public cppu::OWeakObject,
	public com::sun::star::lang::XTypeProvider,
	public com::sun::star::lang::XServiceInfo,
	public com::sun::star::ucb::XCommandProcessor
{
public:
	/** Construction.
	 */
	MbxService_Impl (void);

	static com::sun::star::uno::Reference<
	    com::sun::star::lang::XSingleServiceFactory>
	createServiceFactory (
		const com::sun::star::uno::Reference<
		    com::sun::star::lang::XMultiServiceFactory> &);

	/** XInterface.
	 */
	virtual com::sun::star::uno::Any
	SAL_CALL queryInterface (
		const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire (void) throw();
	virtual void SAL_CALL release (void) throw();

	/** XTypeProvider.
	 */
	virtual com::sun::star::uno::Sequence<com::sun::star::uno::Type>
	SAL_CALL getTypes (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual com::sun::star::uno::Sequence<sal_Int8>
	SAL_CALL getImplementationId (void)
		throw (com::sun::star::uno::RuntimeException);

	/** XServiceInfo.
	 */
	static rtl::OUString SAL_CALL getImplementationName_Static (void)
		SAL_THROW(());

	virtual rtl::OUString SAL_CALL getImplementationName (void)
		throw (com::sun::star::uno::RuntimeException);

	static com::sun::star::uno::Sequence<rtl::OUString>
	SAL_CALL getSupportedServiceNames_Static (void)
		SAL_THROW(());

	virtual com::sun::star::uno::Sequence<rtl::OUString>
	SAL_CALL getSupportedServiceNames (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL supportsService (
		const rtl::OUString & rServiceName)
		throw (com::sun::star::uno::RuntimeException);

	/** XCommandProcessor.
	 */
	virtual sal_Int32 SAL_CALL createCommandIdentifier (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual com::sun::star::uno::Any
	SAL_CALL execute (
		const com::sun::star::ucb::Command & rCommand,
		sal_Int32                            nCommandId,
		const com::sun::star::uno::Reference<
		    com::sun::star::ucb::XCommandEnvironment>&)
		throw (
			com::sun::star::uno::Exception,
			com::sun::star::ucb::CommandAbortedException,
			com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL abort (sal_Int32 nCommandId)
		throw (com::sun::star::uno::RuntimeException);

protected:
	/** Destruction.
	 */
	virtual ~MbxService_Impl (void);

private:
	/** Representation.
	 */
	rtl::Reference<chaos::MbxCommandInfo_Impl> m_xCommands;
	rtl::Reference<chaos::MbxContext_Impl>     m_xContext;

	/** Not implemented.
	 */
	MbxService_Impl (const MbxService_Impl&);
	MbxService_Impl& operator= (const MbxService_Impl&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

} // namespace chaos

#endif /* INCLUDED_MBX_HXX */
