/*************************************************************************
 *
 *  $RCSfile: outitems.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OUTITEMS_HXX
#define _OUTITEMS_HXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif

namespace chaos {

/*========================================================================
 *
 * CntOutMsgInternalState.
 *
 * [Description]
 *
 * The internal state of a message as seen by the out tray.
 *
 *======================================================================*/
#define CNT_OUTMSG_INTERNALSTATE_WRITTEN \
    CNTOUT_ISTATE_WRITTEN

#define CNT_OUTMSG_INTERNALSTATE_PARTIALLY_LOCALLY_SENT \
	CNTOUT_ISTATE_PARTSENT

#define CNT_OUTMSG_INTERNALSTATE_COMPLETELY_LOCALLY_SENT \
	CNTOUT_ISTATE_SENT

#define CNT_OUTMSG_INTERNALSTATE_RECOVERABLE_LOCAL_ERROR \
    CNTOUT_ISTATE_ERROR

#define CNT_OUTMSG_INTERNALSTATE_NONRECOVERABLE_LOCAL_ERROR \
    CNTOUT_ISTATE_FATALERROR

#define CNT_OUTMSG_INTERNALSTATE_EXTERNAL_ERROR \
    CNTOUT_ISTATE_EXTERNALERROR

#define CNT_OUTMSG_INTERNALSTATE_WAITING_CONFIRMATION \
    CNTOUT_ISTATE_WAITCONFIRMED

#define CNT_OUTMSG_INTERNALSTATE_CONFIRMED \
    CNTOUT_ISTATE_CONFIRMED

enum CntOutMsgInternalState
{
	// message has just been placed into the out tray
	CNT_OUTMSG_INTERNALSTATE_WRITTEN,

	// message has been sent upstream to some recipients
	CNT_OUTMSG_INTERNALSTATE_PARTIALLY_LOCALLY_SENT,

	// message has been sent upstream to all recipients
	CNT_OUTMSG_INTERNALSTATE_COMPLETELY_LOCALLY_SENT,

	// local, non-fatal error (e.g. network temporarily not available)
	CNT_OUTMSG_INTERNALSTATE_RECOVERABLE_LOCAL_ERROR,

	// local fatal error (e.g. first SMTPD in chain did not accept the message)
	CNT_OUTMSG_INTERNALSTATE_NONRECOVERABLE_LOCAL_ERROR,

	// global fatal error (e.g. last SMTPD in chain could not deliver message)
	CNT_OUTMSG_INTERNALSTATE_EXTERNAL_ERROR,

	// messages was sent, we are waiting for confirmation
	CNT_OUTMSG_INTERNALSTATE_WAITING_CONFIRMATION,

	// recipient confirmed reading
	CNT_OUTMSG_INTERNALSTATE_CONFIRMED
};

#define CNTOUTMSGINTERNALSTATECOUNT 8

/*========================================================================
 *
 * CntOutMsgExternalState.
 *
 * [Description]
 *
 * The external state of a message as seen by the out tray user interface.
 *
 *======================================================================*/
enum CntOutMsgExternalState
{
	// message has just been placed into the out tray
	// or was temporarily not sent (non-fatal local error)
	CNT_OUTMSG_EXTERNALSTATE_WHITE,

	// message has been sent upstream to some recipients
	CNT_OUTMSG_EXTERNALSTATE_YELLOW,

	// manual user invention necessary (a fatal error has occurred)
	CNT_OUTMSG_EXTERNALSTATE_RED,

	// message has been sent upstream to all recipients
	CNT_OUTMSG_EXTERNALSTATE_GREEN,

	// message was confirmed by _all_ recipients
	CNT_OUTMSG_EXTERNALSTATE_GREEN_CHECKED
};

#define CNTOUTMSGEXTERNALSTATECOUNT 5

/*========================================================================
 *
 * CntOutMsgInternalStateItem.
 *
 * [Description]
 *
 * The internal state of a message as seen by the out tray.
 *
 *======================================================================*/
class CntOutMsgInternalStateItem : public CntEnumItem
{
public:
	TYPEINFO();

	CntOutMsgInternalStateItem (USHORT nWhich = 0);
	CntOutMsgInternalStateItem (USHORT nWhich, CntOutMsgInternalState eState);
	CntOutMsgInternalStateItem (USHORT nWhich, SvStream &);
	CntOutMsgInternalStateItem (const CntOutMsgInternalStateItem &);

	virtual USHORT       GetEnumValue() const;
	virtual void         SetEnumValue(USHORT nNewVal);

	virtual USHORT       GetValueCount() const;

	virtual SfxPoolItem* Clone  (SfxItemPool *pPool = 0) const;
	virtual SfxPoolItem* Create (SvStream &, USHORT nItemVersion) const;
	virtual SvStream&    Store  (SvStream &, USHORT nItemVersion) const;

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

/*========================================================================
 *
 * CntOutMsgExternalStateItem.
 *
 * [Description]
 *
 * The external state of a message as seen by the out tray user interface.
 *
 *======================================================================*/
class CntOutMsgExternalStateItem : public CntEnumItem
{
public:
	TYPEINFO();

	CntOutMsgExternalStateItem (USHORT nWhich = 0);
	CntOutMsgExternalStateItem (USHORT nWhich, SvStream& rStrm);
	CntOutMsgExternalStateItem (const CntOutMsgExternalStateItem& rOther);

	virtual USHORT       GetEnumValue() const;
	virtual void         SetEnumValue (USHORT nNewVal);

	virtual USHORT       GetValueCount() const;

	virtual SfxPoolItem* Clone  (SfxItemPool *pPool = 0) const;
	virtual SfxPoolItem* Create (SvStream &, USHORT nItemVersion) const;
	virtual SvStream&    Store  (SvStream &, USHORT nItemVersion) const;

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

}

#endif /* !_OUTITEMS_HXX */

