/*************************************************************************
 *
 *  $RCSfile: updateaccessor.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:17:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_UPDATEACCESSOR_HXX
#define CONFIGMGR_UPDATEACCESSOR_HXX

#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif
#ifndef CONFIGMGR_ACCESSOR_HXX
#include "accessor.hxx"
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------
    namespace memory
    {
    // -------------------------------------------------------------------------
        class Segment;
        class SegmentHeap;
    // -------------------------------------------------------------------------

        class Allocator
        {
            SegmentHeap *   m_heap;

        public:
            typedef sal_uInt32 Address;
            typedef sal_uInt32 Size;

            Address allocate(Size _sz) const;
            void deallocate(Address _addr) const;

            void *      access(Address _addr) const;
            Address     address(void const * _p) const;

        private:
            friend class UpdateAccessor;

            Allocator(SegmentHeap * _heap) : m_heap(_heap) {}
            char * heap_base() const;
        };
    // -------------------------------------------------------------------------
        class UpdateAccessor : Noncopyable
        {
            Segment *       m_segment;
            SegmentHeap *   m_heap;
        public:
            typedef Accessor::AddressType AddressType;

            /// constructs an accessor on the given Segment
            explicit UpdateAccessor(Segment * segment);
            ~UpdateAccessor();

            bool is() const { return m_segment != 0; }

        // Warning: The accessor and any addresses validated by it
        //          will be valid only until the next call on this->allocator()
            Accessor accessor() const;
            Accessor downgrade(); // return accessor and clear
            void clear();

            AddressType address(void const * _p) const
            { return (this->is()) ? reduce(_p) : Pointer();}

            void * access(AddressType _p) const
            { return (this->is()) ? resolve(_p) : Accessor::failNull();}

            void * validate(AddressType _p) const
            { return (this->is() && _p.is()) ? resolve(_p) : Accessor::failNull(); }

        // allocation support
            Allocator allocator() const { return Allocator(m_heap); }
        private:
            char * heap_base() const;
            void * resolve(AddressType _p) const;
            AddressType  reduce(void const * _p) const;
        };
    // -------------------------------------------------------------------------

  #if OSL_DEBUG_LEVEL == 0
        inline
        void * UpdateAccessor::resolve(AddressType _p) const
        { return _p.is() ? heap_base() + _p.value() : NULL; }

        inline
        Pointer  UpdateAccessor::reduce(void const * _p) const
        { return _p ? Pointer(static_cast<char const *>(_p) - heap_base()) : Pointer(); }
  #endif // OSL_DEBUG_LEVEL

  #if OSL_DEBUG_LEVEL == 0
        inline
        void * Allocator::access(Address _addr) const
        { return _addr ? heap_base() + _addr : NULL; }

        inline
        Allocator::Address  Allocator::address(void const * _p) const
        { return _p ? (static_cast<char const *>(_p) - heap_base()) : 0; }
  #endif // OSL_DEBUG_LEVEL

    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------
} // namespace configmgr

#endif // CONFIGMGR_UPDATEACCESSOR_HXX

