/*************************************************************************
 *
 *  $RCSfile: ADatabaseMetaDataResultSetMetaData.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: oj $ $Date: 2001/11/09 07:05:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_ADO_ADATABASEMETADATARESULTSETMETADATA_HXX_
#include "ado/ADatabaseMetaDataResultSetMetaData.hxx"
#endif

#ifndef _CONNECTIVITY_ADO_AWRAPADO_HXX_
#include "ado/Awrapado.hxx"
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include "connectivity/dbexception.hxx"
#endif


using namespace connectivity;
using namespace connectivity::ado;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::sdbc;

// -------------------------------------------------------------------------
ODatabaseMetaDataResultSetMetaData::~ODatabaseMetaDataResultSetMetaData()
{
	if(m_pRecordSet)
		m_pRecordSet->Release();
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL ODatabaseMetaDataResultSetMetaData::getColumnDisplaySize( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	sal_Int32 nSize = 0;
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		nSize = (*m_mColumnsIter).second.getColumnDisplaySize();
	else if(m_pRecordSet)
	{
		WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
		if(aField.IsValid())
			nSize = aField.GetActualSize();
	}
	return nSize;
}
// -------------------------------------------------------------------------

sal_Int32 SAL_CALL ODatabaseMetaDataResultSetMetaData::getColumnType( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	sal_Int32  nType = 0;
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		nType = (*m_mColumnsIter).second.getColumnType();
	else if(m_pRecordSet)
	{
		WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
		nType = ADOS::MapADOType2Jdbc(aField.GetADOType());
	}
	return nType;
}
// -------------------------------------------------------------------------

sal_Int32 SAL_CALL ODatabaseMetaDataResultSetMetaData::getColumnCount(  ) throw(SQLException, RuntimeException)
{
	if(!m_pRecordSet)
		return 0;
	if(m_nColCount != -1)
		return m_nColCount;

	if(m_vMapping.size())
		return m_mColumns.size();
	
	ADOFields* pFields	= NULL;
	m_pRecordSet->get_Fields(&pFields);
	WpOLEAppendCollection<ADOFields, ADOField, WpADOField>	aFields(pFields);
	m_nColCount = aFields.GetItemCount();
	return m_nColCount;
}
// -------------------------------------------------------------------------

::rtl::OUString SAL_CALL ODatabaseMetaDataResultSetMetaData::getColumnName( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.getColumnName();
	if(!m_pRecordSet)
		return ::rtl::OUString();
	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
		return aField.GetName();

	return ::rtl::OUString();
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL ODatabaseMetaDataResultSetMetaData::getColumnLabel( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.getColumnLabel();
	return getColumnName(column);
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL ODatabaseMetaDataResultSetMetaData::isCurrency( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.isCurrency();
	if(!m_pRecordSet)
		return 0;
	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
	{
		return (aField.GetAttributes() & adFldFixed) == adFldFixed;
	}
	return sal_False;
}
// -------------------------------------------------------------------------


sal_Bool SAL_CALL ODatabaseMetaDataResultSetMetaData::isSigned( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.isSigned();
	if(!m_pRecordSet)
		return 0;
	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
	{
		return (aField.GetAttributes() & adFldNegativeScale) == adFldNegativeScale;
	}
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL ODatabaseMetaDataResultSetMetaData::getPrecision( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.getPrecision();
	if(!m_pRecordSet)
		return 0;
	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
		return aField.GetPrecision();
	return 0;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL ODatabaseMetaDataResultSetMetaData::getScale( sal_Int32 column ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.getScale();

	if(!m_pRecordSet)
		return 0;

	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
		return aField.GetNumericScale();
	return 0;
}
// -------------------------------------------------------------------------

sal_Int32 SAL_CALL ODatabaseMetaDataResultSetMetaData::isNullable( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.isNullable();
	
	if(!m_pRecordSet)
		return 0;

	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
	{
		return (aField.GetAttributes() & adFldIsNullable) == adFldIsNullable;
	}
	return sal_False;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL ODatabaseMetaDataResultSetMetaData::isReadOnly( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.isReadOnly();

	if(!m_pRecordSet)
		return 0;

	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
	{
		//	return (aField.GetStatus() & adFieldReadOnly) == adFieldReadOnly;
	}
	return sal_False;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL ODatabaseMetaDataResultSetMetaData::isDefinitelyWritable( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.isDefinitelyWritable();

	if(!m_pRecordSet)
		return 0;

	WpADOField aField = ADOS::getField(m_pRecordSet,m_vMapping[column]);
	if(aField.IsValid())
	{
		return (aField.GetAttributes() & adFldUpdatable) == adFldUpdatable;
	}
	return sal_False;
;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL ODatabaseMetaDataResultSetMetaData::isWritable( sal_Int32 column ) throw(SQLException, RuntimeException)
{
	if(m_mColumns.size() && (m_mColumnsIter = m_mColumns.find(column)) != m_mColumns.end())
		return (*m_mColumnsIter).second.isWritable();
	return isDefinitelyWritable(column);
}
// -----------------------------------------------------------------------------


