/*************************************************************************
 *
 *  $RCSfile: pkgchk.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 13:50:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#if ! defined INCLUDED_DESKTOP_PKGCHK_HXX
#define INCLUDED_DESKTOP_PKGCHK_HXX

#include "rtl/bootstrap.hxx"

#include "com/sun/star/uno/Any.hxx"


namespace pkgchk
{

class pkgchk_env;

/** Checks/ patches the unorc/uno.ini.

    @param p_unorc
           [inout] handle of unorc/uno.ini; opens unorc/uno.ini if handle is 0
    @param patch
           whether to patch the unorc/uno.ini or just check it
    @param vebose
           whether to verbosely write to stdout/stderr
*/
void check_unorc(
    rtlBootstrapHandle * p_unorc, bool patch,
    bool verbose = false /* no writing to stdout, stderr */ );


/** Class for managing options, arguments.
*/
class OptionsContainer
{
public:
    virtual ~OptionsContainer();
    
    /** Gets an option, e.g.
        
        shared --
            whether shared packages (user path) are scanned or user packages (share path)
        verbose_on_ignored_errors --
            whether ignored errors go to stderr, too
        verbose --
            whether logs go to stdout, too (includes verbose_on_ignored_errors)
        strict_error_handling --
            whether strict error handling is effective, i.e. _every_ error is notified
            by a RuntimeException.  If strict_error_handling is off, then these errors
            are only logged into the log file.
        
        @param name
               option name
        @param shortcut
               shortcut for option
        @return
                whether option is set
    */
    virtual bool get_option(
        ::rtl::OUString const & name, sal_Unicode shortcut = '\0' ) const;
    
    /** Gets an option argument, e.g.
        
        log_file_path [string] --
            path to log file
        
        @param value
               option value
        @param name
               option name
        @param shortcut
               shortcut for option
        @return
                whether argument option is set
    */
    virtual bool get_argument(
        ::com::sun::star::uno::Any * value,
        ::rtl::OUString const & name, sal_Unicode shortcut = '\0' ) const;
};


/** Class for managing uno packages, i.e. checking for packages to be installed/ removed from
    installation.
*/
class UNO_PackagesManager
{
    /** @internal */
    pkgchk_env * m_env;
    
public:
    /** ctor.
        
        @param unorc
               bootstrap for unorc/uno.ini
        @param options
               options container to retrieve options, arguments
    */
    UNO_PackagesManager(
        ::rtl::Bootstrap const & unorc, OptionsContainer const & options = OptionsContainer() );
    /** dtor.
    */
    ~UNO_PackagesManager();
    
    // packages management
    
    /** Checks for packages to be (re-)installed.
        
        @return
                true, if balance() is needed
    */
    bool check();
    
    /** Balances all packages to be removed and installed.
    */
    void balance();
    
    /** De-installs all installed packages.
    */  
    void remove_all();
    
    /** Copies package into packages directory.
        
        @param package_path package file url
    */
    void copy( ::rtl::OUString const & package_path );
};

}

#endif

