/*************************************************************************
 *
 *  $RCSfile: pkgchk_env.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/28 13:26:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_env.h"
#include "pkgchk_unorc.h"
#include "pkgchk.hxx"
#include "rtl/uri.hxx"
#include "osl/thread.h"
#include "cppuhelper/servicefactory.hxx"
#include "unotools/processfactory.hxx"
#include "ucbhelper/contentbroker.hxx"
#include "ucbhelper/configurationkeys.hxx"

#include "com/sun/star/lang/XComponent.hpp"
#include "com/sun/star/beans/XPropertySet.hpp"


using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;
// because of conflicting ::com::sun::star::ucb with ::ucb
using namespace ::com::sun::star::ucb;

namespace pkgchk
{

//______________________________________________________________________________
pkgchk_env::pkgchk_env(
    Bootstrap const & unorc, OptionsContainer const & options )
    : m_ucb_inited( false ),
      m_classpath_inited( false ),
      m_log_file( 0 )
{
#if defined DIAG
    OSL_VERIFY( osl_getSystemTime( &m_start_time ) );
#endif
    // read out some options
    bool shared_packages =
        options.get_option( OUSTR("shared"), 's' );
    m_force_overwrite =
        options.get_option( OUSTR("force_overwrite"), 'f' );
    m_verbose =
        options.get_option( OUSTR("verbose"), 'v' );
    m_verbose_on_ignored_errors =
        options.get_option( OUSTR("verbose_on_ignored_errors") );
    m_strict_error_handling =
        options.get_option( OUSTR("strict_error_handling") );
    m_supersede_basic_libs =
        options.get_option( OUSTR("supersede_basic_libs") );
    Any val;
    if (options.get_argument( &val, OUSTR("log"), 'l' ))
    {
        if (val >>= m_log_file_path)
        {
            m_log_file_path = path_make_absolute( m_log_file_path );
        }
    }

    OUString config_path;
    if (shared_packages)
    {
        m_packages_path = path_make_absolute(
            get_from_bootstrap( OUSTR(UNO_SHARED_PACKAGES), unorc ) );
        m_cache_path = path_make_absolute(
            get_from_bootstrap( OUSTR(UNO_SHARED_PACKAGES_CACHE), unorc ) );
        m_reg_cache_path =
            OUSTR(EXPAND_PROTOCOL ":$" UNO_SHARED_PACKAGES_CACHE); // expand url
        config_path = OUSTR(RC_SHARED_INSTPATH_MACRO "/share");
    }
    else
    {
        m_packages_path = path_make_absolute(
            get_from_bootstrap( OUSTR(UNO_USER_PACKAGES), unorc ) );
        m_cache_path = path_make_absolute(
            get_from_bootstrap( OUSTR(UNO_USER_PACKAGES_CACHE), unorc ) );
        m_reg_cache_path =
            OUSTR(EXPAND_PROTOCOL ":$" UNO_USER_PACKAGES_CACHE); // expand url
        config_path = OUSTR(RC_USER_INSTPATH_MACRO "/user");
    }
    
    // basic pathes
    unorc.expandMacrosFrom( config_path );
    config_path = path_make_absolute( config_path );
    m_basic_script_libs.m_container_path =
        path_concat(
            config_path,
            RTL_CONSTASCII_STRINGPARAM("basic/script.xlc") );
    m_basic_dialog_libs.m_container_path =
        path_concat(
            config_path,
            RTL_CONSTASCII_STRINGPARAM("basic/dialog.xlc") );
    
    // ensure packages path
    dir_ensure( m_packages_path );
    // ensure cache path
    dir_ensure( m_cache_path );
    // ensure exact cache path
    FileStatus status( FileStatusMask_FileURL );
    path_get_status( &status, m_cache_path, FileStatusMask_FileURL );
    m_cache_path = status.getFileURL();
    
    // log file
    if (! m_log_file_path.getLength())
    {
        // set default log file
        m_log_file_path =
            path_concat( m_cache_path, RTL_CONSTASCII_STRINGPARAM("log.txt") );
    }
}

//______________________________________________________________________________
pkgchk_env::~pkgchk_env()
{
    try
    {
        try
        {
            // close services.rdb
            if (m_xServices_rdb.is())
            {
                m_xServices_rdb->close();
                m_xServices_rdb.clear();
            }
            // close types.rdb
            if (m_xTypes_rdb.is())
            {
                m_xTypes_rdb->close();
                m_xTypes_rdb.clear();
            }
            // flush classpath
            classpath_flush();
            // flush basic scripts, dialogs
            basic_flush();
            // flush configuration
            configuration_flush();
        }
        catch (Exception & exc)
        {
            warn( exc.Message );
#if OSL_DEBUG_LEVEL > 0
            OString str(
                OUStringToOString(
                    OUSTR("# ~pkgchk_env() UNO exception occured: ") +
                      exc.Message,
                    osl_getThreadTextEncoding() ) );
            OSL_ENSURE( 0, str.getStr() );
#endif
        }

        // close log file
        if (m_log_file)
        {
            OSL_VERIFY( osl_File_E_None == osl_closeFile( m_log_file ) );
            m_log_file = 0;
        }
        // cleanup ucbhelper ucb
        if (m_ucb_inited)
        {
            m_ucb_inited = false;
            ::ucb::ContentBroker::deinitialize();
        }
        // cleanup component context
        if (m_xComponentContext.is())
        {
            Reference< lang::XComponent > xComp(
                m_xComponentContext, UNO_QUERY );
            if (xComp.is())
            {
                m_xComponentContext.clear();
                xComp->dispose();
            }
            ::utl::setProcessServiceFactory( m_xOldProcessServiceFactory );
        }
    }
    // no exc here
#if OSL_DEBUG_LEVEL > 0
    catch (Exception & exc)
    {
        OString str(
            OUStringToOString(
                OUSTR("# ~pkgchk_env() UNO exception occured: ") + exc.Message,
                osl_getThreadTextEncoding() ) );
        OSL_ENSURE( 0, str.getStr() );
    }
#endif
    catch (...)
    {
        OSL_ENSURE( 0, "# ~pkgchk_env() unexpected exception occured!" );
    }
}

//______________________________________________________________________________
Reference< XComponentContext > const & pkgchk_env::get_component_context() const
{
    if (! m_xComponentContext.is())
    {
        try
        {
            // bootstrap uno from types.rdb and services.rdb
            // directly avoiding any rc entries
            Reference< lang::XMultiServiceFactory > xMgr(
                ::cppu::createRegistryServiceFactory(
                    path_concat(
                        path_get_executable(),
                        RTL_CONSTASCII_STRINGPARAM("types.rdb") ),
                    path_concat(
                        path_get_executable(),
                        RTL_CONSTASCII_STRINGPARAM("services.rdb") ),
                    sal_True /* read-only */ ) );
            Reference< beans::XPropertySet > xProps( xMgr, UNO_QUERY );
            OSL_ASSERT( xProps.is() );
            xProps->getPropertyValue( OUSTR("DefaultContext") ) >>=
                m_xComponentContext;
            OSL_ASSERT( m_xComponentContext.is() );
            // set global process service factory used by
            // unotools config helpers
            m_xOldProcessServiceFactory = ::utl::getProcessServiceFactory();
            ::utl::setProcessServiceFactory( xMgr );
        }
        catch (Exception & exc)
        {
            throw RuntimeException( exc.Message, exc.Context );
        }
    }
    return m_xComponentContext;
}

//______________________________________________________________________________
Reference< registry::XImplementationRegistration > const &
pkgchk_env::get_impreg() const
{
    if (! m_xImpReg.is())
    {
        try
        {
            // raise impreg
            Reference< XComponentContext > const & xContext =
                get_component_context();
            m_xImpReg.set(
                xContext->getServiceManager()->createInstanceWithContext(
                    OUSTR("com.sun.star.registry.ImplementationRegistration"),
                    xContext ),
                UNO_QUERY );
        }
        catch (Exception & exc)
        {
            throw RuntimeException( exc.Message, exc.Context );
        }
        if (! m_xImpReg.is())
        {
            throw DeploymentException(
                OUSTR("no implementation registration available!"),
                Reference< XInterface >() );
        }
    }
    return m_xImpReg;
}

//______________________________________________________________________________
Reference< XCommandProcessor > pkgchk_env::get_ucb_cmdproc() const
{
    if (! m_ucb_inited)
    {
        sal_Bool succ;
        try
        {
            // we have to initialize the ucbhelper ucb,
            // because the package implementation uses it
            Reference< lang::XMultiServiceFactory > xFac(
                get_component_context()->getServiceManager(), UNO_QUERY );
            OSL_ASSERT( xFac.is() );
            // init ucb
            Sequence< Any > args( 2 );
            args[ 0 ] <<= OUSTR(UCB_CONFIGURATION_KEY1_LOCAL);
            args[ 1 ] <<= OUSTR(UCB_CONFIGURATION_KEY2_OFFICE);
            succ = ::ucb::ContentBroker::initialize( xFac, args );
        }
        catch (Exception & exc)
        {
            throw RuntimeException( exc.Message, exc.Context );
        }
        if (! succ)
        {
            throw RuntimeException(
                OUSTR("cannot initialize ucb!"), Reference< XInterface >() );
        }
        m_ucb_inited = true;
    }
    return ::ucb::ContentBroker::get()->getCommandProcessorInterface();
}

//______________________________________________________________________________
Reference< XSimpleFileAccess > const &
pkgchk_env::get_simple_file_access() const
{
    if (! m_xSimpleFileAccess.is())
    {
        try
        {
            // raise simple file access
            Reference< XComponentContext > const & xContext =
                get_component_context();
            get_ucb_cmdproc(); // hack: ensure UCB is initialized
            m_xSimpleFileAccess.set(
                xContext->getServiceManager()->createInstanceWithContext(
                    OUSTR("com.sun.star.ucb.SimpleFileAccess"), xContext ),
                UNO_QUERY );
        }
        catch (Exception & exc)
        {
            throw RuntimeException( exc.Message, exc.Context );
        }
        if (! m_xSimpleFileAccess.is())
        {
            throw DeploymentException(
                OUSTR("no simple file access available!"),
                Reference< XInterface >() );
        }
    }
    return m_xSimpleFileAccess;
}

//______________________________________________________________________________
void pkgchk_env::xml_parse(
    OUString const & path,
    Reference< xml::sax::XDocumentHandler > const & xDocHandler ) const
{
    if (! m_xParser.is())
    {
        // raise sax parser
        Reference< XComponentContext > const & xContext =
            get_component_context();
        m_xParser.set(
            xContext->getServiceManager()->createInstanceWithContext(
                OUSTR("com.sun.star.xml.sax.Parser"), xContext ),
            UNO_QUERY );
        if (! m_xParser.is())
        {
            throw DeploymentException(
                OUSTR("no sax parser available!"),
                Reference< XInterface >() );
        }
    }
    
    // error handler, entity resolver omitted
    m_xParser->setDocumentHandler( xDocHandler );
    xml::sax::InputSource source;
    source.aInputStream = get_simple_file_access()->openFileRead( path );
    source.sSystemId = path;
    m_xParser->parseStream( source );  
}

//______________________________________________________________________________
Reference< registry::XSimpleRegistry > pkgchk_env::rdb_open(
	OUString const & url, bool readOnly, bool create ) const
{
    Reference< registry::XSimpleRegistry > xNewReg;
    try
    {
        Reference< XComponentContext > const & xContext =
            get_component_context();
        xNewReg.set(
            xContext->getServiceManager()->createInstanceWithContext(
                OUSTR("com.sun.star.registry.SimpleRegistry"), xContext ),
            UNO_QUERY );
        if (! xNewReg.is())
        {
            throw DeploymentException(
                OUSTR("no simple registry available!"),
                Reference< XInterface >() );
        }

		xNewReg->open(
            url,
            readOnly ? sal_True : sal_False,
            create ? sal_True : sal_False );
		if (! xNewReg->isValid())
        {
            xNewReg->close();
            throw RuntimeException(
                OUSTR("invalid registry ") + url,
                Reference< XInterface >() );
        }
	}
	catch (RuntimeException &)
	{
        throw;
	}
	catch (Exception & exc)
	{
        throw RuntimeException( exc.Message, exc.Context );
	}

    return xNewReg;
}

//______________________________________________________________________________
OUString pkgchk_env::make_reg_url(
    OUString const & base_path, OUString const & path ) const
{
    if (0 == base_path.getLength())
        return path;
    
    if (0 == base_path.compareToAscii(
            RTL_CONSTASCII_STRINGPARAM(EXPAND_PROTOCOL ":") ))
    {
        // make bootstrap macro url
        OUStringBuffer buf( 128 );
        buf.append( base_path );
        buf.append( (sal_Unicode) '/' );
        // escape path url $, \, {} (rtl bootstrap macro)
        sal_Int32 nPos = 0;
        sal_Int32 nLen = path.getLength();
        while (nPos < nLen)
        {
            sal_Unicode c = path[ nPos ];
            switch (c)
            {
            case '$':
            case '\\':
            case '{':
            case '}':
                buf.append( (sal_Unicode)'\\' );
                break;
            }
            buf.append( c );
            ++nPos;
        }
        OUString macro( buf.makeStringAndClear() );
        OUString uri(
            Uri::encode(
                macro, rtl_getUriCharClass( rtl_UriCharClassUric ),
                rtl_UriEncodeIgnoreEscapes, RTL_TEXTENCODING_UTF8 ) );
        // macro string starts with "vnd.sun.star.expand:$UNO_..."
        // uric char class allows characters '.' and ':'
        // so encoding the whole string (including protocol) is ok
        OSL_ASSERT( 0 == uri.compareToAscii(
                        RTL_CONSTASCII_STRINGPARAM(EXPAND_PROTOCOL ":") ) );
#if defined DIAG
        OString cstr_base_path(
            OUStringToOString( base_path, osl_getThreadTextEncoding() ) );
        OString cstr_path(
            OUStringToOString( path, osl_getThreadTextEncoding() ) );
        OString cstr_macro(
            OUStringToOString( macro, osl_getThreadTextEncoding() ) );
        OString cstr_uri(
            OUStringToOString( uri, osl_getThreadTextEncoding() ) );
        printf(
            "[diag] make_reg_url(): base_path=%s + path=%s => "
            "%s => %s\n",
            cstr_base_path.getStr(), cstr_path.getStr(),
            cstr_macro.getStr(), cstr_uri.getStr() );
#endif
        return uri;
    }
    else // no expand path
    {
        return path_concat( base_path, path );
    }
}

//______________________________________________________________________________
OUString pkgchk_env::expand_reg_url( OUString const & url ) const
{
    if (0 == url.compareToAscii(
            RTL_CONSTASCII_STRINGPARAM(EXPAND_PROTOCOL ":") ))
    {
        if (! m_xMacroExpander.is())
        {
            m_xMacroExpander = Reference< util::XMacroExpander >(
                get_component_context()->getValueByName(
                    OUSTR("/singletons/com.sun.star.util.theMacroExpander") ),
                UNO_QUERY );
            if (! m_xMacroExpander.is())
            {
                throw DeploymentException(
                    OUSTR("no macro expander singleton available!"),
                    Reference< XInterface >() );
            }
        }
        
        // cut protocol
        OUString macro( url.copy( sizeof (EXPAND_PROTOCOL ":") -1 ) );
        // decode uric class chars
        macro = Uri::decode(
            macro, rtl_UriDecodeWithCharset, RTL_TEXTENCODING_UTF8 );
        // expand macro string
        OUString ret( m_xMacroExpander->expandMacros( macro ) );
#if defined DIAG
        OUStringBuffer buf( 128 );
        buf.appendAscii(
            RTL_CONSTASCII_STRINGPARAM("[diag] expand_reg_url(): ") );
        buf.append( url );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" => ") );
        buf.append( macro );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" => ") );
        buf.append( ret );
        OString str(
            OUStringToOString(
                buf.makeStringAndClear(), osl_getThreadTextEncoding() ) );
        OSL_TRACE( str.getStr() );
#endif
        return ret;
    }
    else
    {
        return url;
    }
}

//______________________________________________________________________________
Reference< registry::XSimpleRegistry > const &
pkgchk_env::get_services_rdb() const
{
    if (! m_xServices_rdb.is())
    {
        m_xServices_rdb = rdb_open(
            path_concat(
                m_cache_path,
                RTL_CONSTASCII_STRINGPARAM("services.rdb") ),
            false /* ! read-only */, true /* create */ );
    }
    return m_xServices_rdb;
}

//______________________________________________________________________________
Reference< registry::XSimpleRegistry > const &
pkgchk_env::get_types_rdb() const
{
    if (! m_xTypes_rdb.is())
    {
        m_xTypes_rdb = rdb_open(
            path_concat(
                m_cache_path,
                RTL_CONSTASCII_STRINGPARAM("types.rdb") ),
            false /* ! read-only */, true /* create */ );
    }
    return m_xTypes_rdb;
}

}
