/*************************************************************************
 *
 *  $RCSfile: pkgchk_env.h,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/02 15:28:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if ! defined INCLUDED_PKGCHK_ENV_H
#define INCLUDED_PKGCHK_ENV_H

#include <hash_set>
#include <hash_map>

#include "pkgchk_misc.h"
#if defined DIAG
#include "osl/time.h"
#endif
#include "xmlscript/xmllib_imexp.hxx"

#include "com/sun/star/uno/DeploymentException.hpp"
#include "com/sun/star/uno/XComponentContext.hpp"
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#include "com/sun/star/util/XMacroExpander.hpp"
#include "com/sun/star/registry/XSimpleRegistry.hpp"
#include "com/sun/star/registry/XImplementationRegistration.hpp"
#include "com/sun/star/ucb/XCommandProcessor.hpp"
#include "com/sun/star/ucb/XSimpleFileAccess.hpp"
#include "com/sun/star/xml/sax/XParser.hpp"
#include "com/sun/star/configuration/backend/XLayerImporter.hpp"

#define EXPAND_PROTOCOL "vnd.sun.star.expand"


namespace pkgchk
{

class OptionsContainer;

typedef ::std::hash_set<
    ::rtl::OUString, ::rtl::OUStringHash > t_string_set;

typedef ::std::hash_map<
    ::rtl::OUString,
     ::xmlscript::LibDescriptor, ::rtl::OUStringHash > t_libs_map;

//==============================================================================
class pkgchk_env
{
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::lang::XMultiServiceFactory >
    m_xOldProcessServiceFactory;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext > m_xComponentContext;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > m_xServices_rdb;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > m_xTypes_rdb;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XImplementationRegistration > m_xImpReg;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::ucb::XSimpleFileAccess > m_xSimpleFileAccess;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::configuration::backend::XLayerImporter >
    m_xMergeImporter;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::xml::sax::XParser > m_xParser;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::util::XMacroExpander > m_xMacroExpander;
    mutable bool m_ucb_inited;
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > rdb_open(
        ::rtl::OUString const & url, bool readOnly, bool create ) const;
    
    // logging, errors
    mutable ::rtl::OUString m_log_file_path;
    mutable oslFileHandle m_log_file;
#if defined DIAG
    ::TimeValue m_start_time;
#endif
    void log_write( ::rtl::OString const & text ) const;
    
    // java classpath
    t_string_set m_classpathes;
    bool m_classpath_inited;
    mutable bool m_classpath_modified;
    void classpath_verify_init();
    
    // basic scripts, dialog libs
    struct basic_libs
    {
        ::rtl::OUString m_container_path;
        t_libs_map m_map;
        bool m_inited, m_modified;
        inline basic_libs()
            : m_inited( false )
            {}
    };
    bool m_supersede_basic_libs;
    mutable basic_libs m_basic_script_libs, m_basic_dialog_libs;
    void basic_verify_init( basic_libs * libs );
    void basic_flush( basic_libs * libs ) const;
    ::rtl::OUString basic_get_libname( ::rtl::OUString const & path ) const;
    bool basic_remove(
        basic_libs * libs, ::rtl::OUString const & path, bool exact );
    
    // configuration
    void xcu_merge_in( ::rtl::OUString const & url ) const;
    void xcs_merge_in( ::rtl::OUString const & url ) const;
    t_string_set m_xcu_to_be_installed, m_xcu_to_be_removed;
    t_string_set m_xcs_to_be_installed, m_xcs_to_be_removed;
    
    // packages balancing
    t_string_set m_packages_to_be_installed, m_packages_to_be_removed;
    
public:
    pkgchk_env(
        ::rtl::Bootstrap const & unorc, OptionsContainer const & options );
    ~pkgchk_env();
    
    // misc: uno services, rdbs, ucb
    ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext > const &
    get_component_context() const;
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > const &
    get_services_rdb() const;
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > const &
    get_types_rdb() const;
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XImplementationRegistration > const &
    get_impreg() const;
    
    ::com::sun::star::uno::Reference< ::com::sun::star::ucb::XCommandProcessor >
    get_ucb_cmdproc() const;
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::ucb::XSimpleFileAccess > const &
    get_simple_file_access() const;
    
    void xml_parse(
        ::rtl::OUString const & path,
        ::com::sun::star::uno::Reference<
          ::com::sun::star::xml::sax::XDocumentHandler > const & xDocHandler )
        const;
    
    ::rtl::OUString make_reg_url(
        ::rtl::OUString const & base_path,
        ::rtl::OUString const & path ) const;
    ::rtl::OUString expand_reg_url(
        ::rtl::OUString const & url ) const;
    
    // flags
    bool m_force_overwrite;
    bool m_strict_error_handling;
    bool m_verbose;
    bool m_verbose_on_ignored_errors;
    
    // pathes
    ::rtl::OUString m_packages_path;
    ::rtl::OUString m_cache_path;
    ::rtl::OUString m_reg_cache_path;
    
    // java classpath
    void classpath_flush() const;
    void classpath_insert( ::rtl::OUString const & path );
    void classpath_remove( ::rtl::OUString const & path );
    
    // basic
    inline void basic_flush() const;
    bool basic_remove_cache_entries();
    bool basic_insert( ::rtl::OUString const & path );
    bool basic_remove( ::rtl::OUString const & path );
    
    // configuration
    void configuration_flush() const;
    inline void xcu_insert( ::rtl::OUString const & path )
        { m_xcu_to_be_installed.insert( path ); }
    inline void xcu_remove( ::rtl::OUString const & path )
        { m_xcu_to_be_removed.insert( path ); }
    inline void xcs_insert( ::rtl::OUString const & path )
        { m_xcs_to_be_installed.insert( path ); }
    inline void xcs_remove( ::rtl::OUString const & path )
        { m_xcs_to_be_removed.insert( path ); }
    
    // logging, errors
    void log( ::rtl::OUString const & text, bool allow_verbose = true) const;
    void warn( ::rtl::OUString const & text, bool allow_verbose = true ) const;
    void err( ::rtl::OUString const & text, bool allow_verbose = true ) const;
    
    // packages management
    void packages_remove_all();
    bool packages_check();
    inline bool packages_to_be_balanced() const;
    void packages_balance();
};

//______________________________________________________________________________
inline bool pkgchk_env::packages_to_be_balanced() const
{
    return (!m_packages_to_be_installed.empty() ||
            !m_packages_to_be_removed.empty());
}

//______________________________________________________________________________
inline void pkgchk_env::basic_flush() const
{
    basic_flush( &m_basic_script_libs );
    basic_flush( &m_basic_dialog_libs );
}

}

#endif
