/*************************************************************************
 *
 *  $RCSfile: address.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <address.hxx>
#include <usr/services.hxx>
#include <usr/reflserv.hxx>

#ifndef _SMART_COM_SUN_STAR_CHAOS_XCOMMANDEXECUTOR_HXX_
#include <smart/com/sun/star/chaos/XCommandExecutor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_XSTATUSCALLBACK_HXX_
#include <smart/com/sun/star/chaos/XStatusCallback.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_UNKNOWNCOMMANDEXCEPTION_HXX_
#include <smart/com/sun/star/chaos/UnknownCommandException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CHAOS_STATUSCALLBACKEVENT_HXX_
#include <smart/com/sun/star/chaos/StatusCallbackEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKXMLIMPORT_HXX_
#include <smart/com/sun/star/address/XAddressBookXMLImport.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEPARTICIPANTROLE_HXX_
#include <smart/com/sun/star/schedule/ScheduleParticipantRole.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEACCESSRIGHT_HXX_
#include <smart/com/sun/star/schedule/ScheduleAccessRight.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEREMINDERTYPE_HXX_
#include <smart/com/sun/star/schedule/ScheduleReminderType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEWEEKDAY_HXX_
#include <smart/com/sun/star/schedule/ScheduleWeekDay.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEBUSYSTATE_HXX_
#include <smart/com/sun/star/schedule/ScheduleBusyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULETASKSTATE_HXX_
#include <smart/com/sun/star/schedule/ScheduleTaskState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEPARTICIPANTSTATE_HXX_
#include <smart/com/sun/star/schedule/ScheduleParticipantState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULERECURRENCETYPE_HXX_
#include <smart/com/sun/star/schedule/ScheduleRecurrenceType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEQUERYOPERATOR_HXX_
#include <smart/com/sun/star/schedule/ScheduleQueryOperator.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEITEMMETHOD_HXX_
#include <smart/com/sun/star/schedule/ScheduleItemMethod.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XERRORHANDLER_HXX_
#include <smart/com/sun/star/xml/sax/XErrorHandler.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XENTITYRESOLVER_HXX_
#include <smart/com/sun/star/xml/sax/XEntityResolver.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_INPUTSOURCE_HXX_
#include <smart/com/sun/star/xml/sax/InputSource.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XDTDHANDLER_HXX_
#include <smart/com/sun/star/xml/sax/XDTDHandler.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XPARSER_HXX_
#include <smart/com/sun/star/xml/sax/XParser.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICENAME_HXX_
#include <smart/com/sun/star/lang/XServiceName.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_DATE_HXX_
#include <smart/com/sun/star/util/Date.hxx>
#endif

#if STLPORT_VERSION<321
#include <rope.h>
#else
//#include <rope>
#endif



#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif

#ifndef _FSYS_HXX //autogen wg. DirEntry
#include <tools/fsys.hxx>
#endif





#include <services.hxx>




OPersistentPropertySet::OPersistentPropertySet(
	IMutex& rMutex, const XMultiServiceFactoryRef& xMgr,
	const UString& rName )
	: m_rMutex( rMutex ), m_xMgr( xMgr ), m_aName( rName )
{
}

void OPersistentPropertySet::queryTermination(
	const EventObject& aEvent) 
	THROWS( (TerminationVetoException, UsrSystemException) )
{
}

void OPersistentPropertySet::notifyTermination(
	const EventObject& aEvent) THROWS( (UsrSystemException) )
{
	flush();
}

void OPersistentPropertySet::flush()
{
	XRegistryKeyRef xRoot = m_xRegistry->getRootKey();
	XPropertySetRef xProp( this, USR_QUERY );
	OPropertySet::savePropertySet( xProp, xRoot );
}

void OPersistentPropertySet::load()
{
	XNameAccessRef xSettings( m_xMgr->createInstance(
		L"com.sun.star.frame.Settings" ), USR_QUERY );
	if( xSettings.is() )
	{
		XPropertySetRef xProps;
		extractInterface( xSettings->getByName( L"PathSettings" ), xProps );
		UString aPath;
		if( xProps.is() && (
			xProps->getPropertyValue( USERCONFIGPROPNAME )  >>= aPath ) )
		{
			m_xRegistry = XSimpleRegistryRef(
				m_xMgr->createInstance(
					L"com.sun.star.registry.SimpleRegistry" ), USR_QUERY );
			if( !m_xRegistry.is() ) return;
			DirEntry aEntry( SHOULDTAKEUNICODE( aPath ));
			aEntry += DirEntry( SHOULDTAKEUNICODE( m_aName ) );
			aEntry.SetExtension( "rdb" );
			m_xRegistry->open( 
				SHOULDBEUNICODE( aEntry.GetFull() ), FALSE, TRUE );
			XRegistryKeyRef xKey = m_xRegistry->getRootKey();
			XPropertySetRef xThisProp( this, USR_QUERY );
			OPropertySet::loadPropertySet( xThisProp, xKey );
		}
	}
	XDesktopRef xDesktop( m_xMgr->createInstance(
		L"com.sun.star.frame.Desktop" ), USR_QUERY );
	xDesktop->addTerminateListener( this );
}

///////////////////////////////////////////////////////////////


void throwException( const UsrAny& rAny )
{
	if( rAny.getReflection()->getTypeClass() == TypeClass_EXCEPTION )
	{
		ExceptionBaseReflection* pRefl = (ExceptionBaseReflection*) rAny.getReflection();
		pRefl->throwException( *(const UsrException*)rAny.get() );
	}
	THROW( UsrException() );
}

UsrAny exceptionToAny( const UsrException& rExp )
{
	return ExceptionBaseReflection::wrapException( rExp );
//  	//! use dynamic type
//  	UsrAny aRet;
//  	aRet <<= rExp;
//  	return aRet;
}

XIdlClassRef OEnumeration::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OEnumeration", 
		UsrObject::getUsrObjectIdlClass(), 3,
		XEnumeration_getReflection(), 
		XCancellable_getReflection(), 
		XJobListener_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OEnumeration::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OEnumeration::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XEnumeration );
	QUERYIFACE( XCancellable );
	QUERYIFACE( XJobListener );
	QUERYIFACE( XEventListener );
	return UsrObject::queryInterface( aUik, rOut );
}

BOOL OEnumeration::hasMoreElements()
{
	waitCondition( m_aDataAvailable );
	OGuard aGuard( m_aMutex );
	if( m_aException.get() )
		throwException( m_aException );
	return m_aData.size() != 0;
}

UsrAny OEnumeration::nextElement()
{
	waitCondition( m_aDataAvailable );
	OGuard aGuard( m_aMutex );
	if( m_aException.get() )
		throwException( m_aException );
	if( !m_aData.size() ) THROW( NoSuchElementException() );
	UsrAny aAny = m_aData.front();
	m_aData.pop_front();
	if( !m_aData.size() && !m_bDone)
		m_aDataAvailable.reset();
	return aAny;
}

void OEnumeration::updateJobState( const JobEvent& rEvent )
{
	switch( rEvent.Type )
	{
		case JobEventType_ERROR:
		{
			// throw exception in arguments
			m_aException = rEvent.Data;
			m_bDone = TRUE;
			m_aDataAvailable.set();
			break;
		}
		case JobEventType_DATA:
		{
			OGuard aGuard( m_aMutex );
			m_aData.push_back( rEvent.Data );
			m_aDataAvailable.set();
			break;
		}
		case JobEventType_DONE:
		{
			m_bDone = TRUE;
			m_aDataAvailable.set();
		};
	}
}

class OThreadPool;
class OGeneralJobThread : public OThread
{
public:
	OGeneralJobThread( OThreadPool& rPool ) : 
		m_bWaitForRelease( FALSE ), m_rPool( rPool ){}
	virtual void run();

	OThreadPool&    m_rPool;
	XSynchronJobRef    m_xSync;
	XAsynchronJobRef   m_xAsync;
	XJobListenerRef m_xCallback;
	UsrAny          m_aResult;
	UsrAny          m_aException;

	OCondition      m_aStartJob;
	OCondition      m_aJobDone;
	BOOL            m_bWaitForRelease;
};

class OThreadPool
{
public:
	static OThreadPool& getInstance();
	UsrAny executeSynchron( const XSynchronJobRef& xJob );
	void executeAsynchron( const XAsynchronJobRef& xJob, const XJobListenerRef& xCallback );
	void cancel( const XJobRef& xJob );

	void releaseThread( OGeneralJobThread& );
	OGeneralJobThread& acquireThread();
	
private:
	OGeneralJobThread* getThread( const XJobRef& xJob );
	
	vector<OGeneralJobThread*> m_aWaitingThreads;
	vector<OGeneralJobThread*> m_aRunningThreads;
	OMutex m_aMutex;
};

OThreadPool& OThreadPool::getInstance()
{
	static OThreadPool* pPool = 0;
	if( !pPool ) 
		pPool = new OThreadPool;
	return *pPool;
}

void OGeneralJobThread::run()
{
	while( schedule() )
	{
		waitCondition( m_aStartJob );
		m_aStartJob.reset();
		if( m_xSync.is() ) 
		{
			TRY
			{
				m_aResult = m_xSync->executeSynchron();
			}
			CATCH( UsrException, rException )
			{
				m_aException = exceptionToAny( rException );
			}
			END_CATCH;
			m_aJobDone.set();
		}
		else m_xAsync->executeAsynchron( m_xCallback );
		if( !m_bWaitForRelease ) m_rPool.releaseThread( *this );
	}
}

void OThreadPool::releaseThread( OGeneralJobThread& rThread )
{
	rThread.m_xCallback = XJobListenerRef();
	rThread.m_xAsync = XAsynchronJobRef();
	rThread.m_xSync = XSynchronJobRef();
	rThread.m_aResult = rThread.m_aException = UsrAny();
	rThread.m_aJobDone.reset();

	OGuard aGuard( m_aMutex );
	vector<OGeneralJobThread*>::iterator aIter = 
		find( m_aRunningThreads.begin(), m_aRunningThreads.end(), &rThread );
	m_aWaitingThreads.push_back( *aIter );
	m_aRunningThreads.erase( aIter );
}

OGeneralJobThread* OThreadPool::getThread( const XJobRef& xJob )
{
	for( vector<OGeneralJobThread*>::iterator aIter = 
			 m_aRunningThreads.begin(); aIter != m_aRunningThreads.end(); aIter++ )
		if( xJob == (*aIter)->m_xAsync || xJob == (*aIter)->m_xSync )
			return *aIter;
	return 0;
}

OGeneralJobThread& OThreadPool::acquireThread()
{
	OGuard aGuard( m_aMutex );
	if( !m_aWaitingThreads.size() )
	{
		OGeneralJobThread* pNew = new OGeneralJobThread( *this );
		m_aRunningThreads.push_back( pNew );
		pNew->create();
		return *pNew;
	}
	else 
	{
		OGeneralJobThread* pBack = m_aWaitingThreads.back();
		m_aWaitingThreads.pop_back();
		m_aRunningThreads.push_back( pBack );
		return *pBack;
	}
}

void OThreadPool::executeAsynchron( 
	const XAsynchronJobRef& xJob, const XJobListenerRef& xCallback )
{
	OGeneralJobThread& rThread = acquireThread();
	rThread.m_xAsync = xJob;
	rThread.m_bWaitForRelease = FALSE;
	rThread.m_xCallback = xCallback;
	rThread.m_aStartJob.set();
}

UsrAny OThreadPool::executeSynchron( const XSynchronJobRef& xJob )
{
	OGeneralJobThread& rThread = acquireThread();
	rThread.m_xSync = xJob;
	rThread.m_bWaitForRelease = TRUE;
	rThread.m_aStartJob.set();
	waitCondition( rThread.m_aJobDone );
	UsrAny aException = rThread.m_aException;
	UsrAny aResult = rThread.m_aResult;
	releaseThread( rThread );
	if( aException.get() )
		throwException( aException );
	return aResult;
}

void OThreadPool::cancel( const XJobRef& xJob )
{
	OGuard aGuard( m_aMutex );
	OGeneralJobThread* pThread = getThread( xJob );
	if( !pThread ) 
	{
		THROW( IllegalArgumentException() );
	}
	else
	{
		if( pThread->m_xCallback.is() )
		{
			JobEvent aEvent;
			aEvent.Type = JobEventType_ERROR;
			aEvent.Source = xJob;
			aEvent.Data <<= CancelledException();
			pThread->m_xCallback = XJobListenerRef();
		}
		else pThread->m_aException <<= CancelledException();
		pThread->m_aJobDone.set();
	}
}

XIdlClassRef OGeneralJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OGeneralJob", 
		UsrObject::getUsrObjectIdlClass(), 3,
		XAsynchronJob_getReflection(), 
		XSynchronJob_getReflection(),
		XJobListener_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OGeneralJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OGeneralJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	// only this annoying construct will satisfy egcs
	if( aUik == ((XAsynchronJob*)this)->XCancellable::getSmartUik() )
	{
		rOut = (XCancellable*)(XAsynchronJob*)this;
		return TRUE;
	}
	QUERYIFACE( XAsynchronJob );
	QUERYIFACE( XSynchronJob );
	QUERYIFACE( XJobListener );
	QUERYIFACE( XEventListener );
	if( aUik == ((XAsynchronJob*)this)->XJob::getSmartUik() )
	{
		rOut = (XJob*)(XAsynchronJob*)this;
		return TRUE;
	}
	return UsrObject::queryInterface( aUik, rOut );
}

void OGeneralJob::cancel()
{
	OClearableGuard aGuard( m_aMutex );
	if( !m_aException.get() ) 
	{
		m_aException <<= CancelledException();
		m_xCallback = (XJobListener*)0;
		m_aDone.set();
		aGuard.clear();
		if( m_xSync.is() ) m_xSync->cancel();
		else m_xAsync->cancel();
	}
}

void OGeneralJob::suspend()
{
	if( m_xSync.is() ) m_xSync->suspend();
	else m_xAsync->cancel();
}

void OGeneralJob::resume()
{
	if( m_xSync.is() ) m_xSync->resume();
	else m_xAsync->resume();
}

void OGeneralJob::updateJobState( const JobEvent& rEvent )
{
	OClearableGuard aGuard( m_aMutex );
	// route asynchron calls thru
	if( m_xAsync.is() )
	{
		if( m_xCallback.is() ) 
		{
			XJobListenerRef xCall = m_xCallback;
			if( rEvent.Type == JobEventType_DONE ||
				rEvent.Type == JobEventType_ERROR )
				m_xCallback = (XJobListener*)0;
			aGuard.clear();
			JobEvent aEvent( rEvent );
			aEvent.Source = *this;
			xCall->updateJobState( aEvent );
			return;
		}
	}
	switch( rEvent.Type )
	{
		case JobEventType_ERROR:
			// throw exception in arguments
			m_aException = rEvent.Data;
			m_aDone.set();
			break;
		case JobEventType_DATA:
		{
			OEnumeration* pEnum;
			XEnumerationRef xEnum = pEnum = new OEnumeration(
				XCancellableRef( m_xAsync ) );
			m_xCallback = pEnum;
			m_aResult <<= xEnum;
			m_aDone.set();
			updateJobState( rEvent );
			break;
		}
		case JobEventType_DONE:
			m_aResult = rEvent.Data;
			m_aDone.set();
			break;
	}
}

UsrAny OGeneralJob::executeSynchron()
{
	BOOL bUseThisThread = FALSE;
	if( m_xSync.is() ) 
		return bUseThisThread ? m_xSync->executeSynchron(  ) : 
		OThreadPool::getInstance().executeSynchron( m_xSync );
	else
	{
		if( bUseThisThread ) m_xAsync->executeAsynchron( this );
		else OThreadPool::getInstance().executeAsynchron( m_xAsync, this );
		waitCondition( m_aDone );
		if( m_aException.get() )
			throwException( m_aException );
		return m_aResult;
	}
}

void OGeneralJob::executeAsynchron( const XJobListenerRef& xCallback )
{
	m_xCallback = xCallback;
	BOOL bUseThisThread = FALSE;
	if( m_xAsync.is() ) 
	{
		if( bUseThisThread )
			m_xAsync->executeAsynchron( this );
		else OThreadPool::getInstance().executeAsynchron( m_xAsync, this );
	}
	else
	{
		JobEvent aEvent;
		aEvent.Source = *this;
		TRY
		{
			aEvent.Data = 
				bUseThisThread ? m_xSync->executeSynchron() : 
				OThreadPool::getInstance().executeSynchron( m_xSync );
			XEnumerationRef xEnum;
			if( extractInterface( aEvent.Data, xEnum ) )
			{
				aEvent.Type = JobEventType_DATA;
				while( xEnum->hasMoreElements() )
				{
					aEvent.Data = xEnum->nextElement();
					xCallback->updateJobState( aEvent );
				}
				aEvent.Data = UsrAny();
				aEvent.Type = JobEventType_DONE;
				xCallback->updateJobState( aEvent );
			}
		}
		CATCH( UsrException, e )
			{
				aEvent.Type = JobEventType_ERROR;
			aEvent.Data = exceptionToAny( e );
			xCallback->updateJobState( aEvent );
			}
		END_CATCH;
	}
}

XIdlClassRef OGeneralJobFactory::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.SynchronAndAsynchronJobFactory", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XInitialization_getReflection(), 
		XJobFactory_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OGeneralJobFactory::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OGeneralJobFactory::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XInitialization );
	QUERYIFACE( XJobFactory );
	return UsrObject::queryInterface( aUik, rOut );
}

XInterfaceRef OGeneralJobFactory::createJob(
	const UString& rType, const Sequence<UsrAny>& rArgs )
{
	return *new OGeneralJob( m_xFactory->createJob( rType, rArgs ) );
}

void OGeneralJobFactory::initialize( const Sequence<UsrAny>& rArgs )
{
	if( rArgs.getLen() != 1 || !(extractInterface( 
		rArgs.getConstArray()[ 0 ], m_xFactory ) ) )
		THROW( IllegalArgumentException() );
}


OResultSetDescriptor::OResultSetDescriptor() : 
	OPropertySet( 
		m_aMutex, this, OObjectClass<OResultSetDescriptor>::getInstance(), false ) 
{
}

SMART_REFLECTION_IMPLEMENTATION( 
	OResultSetDescriptor, OPropertySet, L"OResultSetDescriptor" )

void OResultSetDescriptorData::fillClassInfo(
	OObjectClassBase*& rpParentClass, Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OResultSetDescriptorData, RequestedProperties, PropertyAttribute_BOUND ),
			ADR_PROPERTY( 
				OResultSetDescriptorData, Query, PropertyAttribute_BOUND ),
			ADR_PROPERTY( 
				OResultSetDescriptorData, Sorting, PropertyAttribute_BOUND ),
			ADR_PROPERTY( 
				OResultSetDescriptorData, Schemata, PropertyAttribute_BOUND ),
			};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

void OAddressBookSchemaData::fillClassInfo(
	OObjectClassBase*& rpParentClass, Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSchemaData, Name, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSchemaData, Properties, 
			PropertyAttribute_READONLY | PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSchemaData, IsInsertable, 
			PropertyAttribute_BOUND )
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

OAddressBookSimpleSchema::OAddressBookSimpleSchema(
	const Sequence<PropertyValue>& rValues )
	: OPropertySet( 
		m_aMutex, this, 
		OObjectClass<OAddressBookSimpleSchema>::getInstance(), FALSE )
{
	OObjectClass<OAddressBookSimpleSchema>::getInstance().setPropertyValues(
		this, rValues );
}

/////////////////////////////////////////////////////////////

void OAddressBookSourceData::fillClassInfo(
	OObjectClassBase*& rpParentClass, Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSourceData, ServiceName, PropertyAttribute_BOUND ),
			ADR_PROPERTY( 
				OAddressBookSourceData, Name, PropertyAttribute_BOUND ),
			ADR_PROPERTY( 
				OAddressBookSourceData, Types, PropertyAttribute_BOUND ),
			ADR_PROPERTY( 
				OAddressBookSourceData, ReadOnly, PropertyAttribute_BOUND ),
			ADR_PROPERTY( 
				OAddressBookSourceData, Uid, PropertyAttribute_BOUND ),
			};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

//////////////////////////////////////////////////////////////////////

XIdlClassRef OAddressBookSimpleSchemata::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSimpleSchemata", 
		OComponentHelper::getStaticIdlClass(), 1,
		XNameAccess_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSimpleSchemata::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSimpleSchemata::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XElementAccess );
	QUERYIFACE( XNameAccess );
	return OComponentHelper::queryInterface( aUik, rOut );
}

OAddressBookSimpleSchemata::OAddressBookSimpleSchemata( 
	const Sequence<Sequence<PropertyValue> >& rSchemata ) :
	ONameContainerHelper<XPropertySetRef>( m_aMutex, m_aHashMap ) ,
	OComponentHelper( m_aMutex )
{
	for( const Sequence<PropertyValue >* pCur = 
			 rSchemata.getConstArray(); 
		 pCur < rSchemata.getConstArray() + rSchemata.getLen(); pCur++ )
	{
		OAddressBookSimpleSchema* pSchema = new OAddressBookSimpleSchema(
			*pCur );
		m_aHashMap[ pSchema->getName() ] = XPropertySetRef( pSchema );
	}
}

///////////////////////////////////////////////////////////////////


struct AddressBookParameteredPropertyValueLower
{
	inline BOOL operator()(
		const AddressBookParameteredPropertyValue & s1, 
		const AddressBookParameteredPropertyValue & s2) const
	{
		return s1.Name < s2.Name;
	}
};


const AddressBookParameteredPropertyValue* ORecord::getProperty(
	const UString& rName ) const
{
	AddressBookParameteredPropertyValue aValue;
	aValue.Name = rName;
	const AddressBookParameteredPropertyValue* pFirst = 
		m_Values.getConstArray();
	const AddressBookParameteredPropertyValue* pLast = 
		pFirst + m_Values.getLen();

	pair<const AddressBookParameteredPropertyValue*,
		const AddressBookParameteredPropertyValue*> aPair = 
		equal_range( 
			m_Values.getConstArray(), 
			m_Values.getConstArray() + m_Values.getLen(),
			aValue, AddressBookParameteredPropertyValueLower() );
	if( aPair.first != aPair.second )
		return aPair.first;
	else return 0;
}

void ORecord::fillClassInfo( 
	OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			ORecord, Values, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			ORecord, Properties, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			ORecord, Uid, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			ORecord, SchemaName, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			ORecord, IsRemovable, PropertyAttribute_BOUND ),
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

BOOL ORecord::operator<( const ORecord& rArg ) const
{
	const AddressBookSortInfo* pCur = 
		m_pSorting->getConstArray();
	const AddressBookSortInfo* pLast = 
		pCur + m_pSorting->getLen();
	
	for( ; pCur < pLast; pCur++ )
	{

		const AddressBookParameteredPropertyValue* pFirst = 
			getProperty( pCur->Property );
		const AddressBookParameteredPropertyValue* pSecond = 
			rArg.getProperty( pCur->Property );
		
		BOOL bSet = FALSE;
		BOOL bComp;
		if( !pFirst || !pSecond ) 
		{
			bComp = !pFirst > !pSecond;
			bSet = TRUE;
		}
		else
		{
			const Sequence<AddressBookParameteredValue>& rValues1 = 
				pFirst->Values;
			const Sequence<AddressBookParameteredValue>& rValues2 = 
				pSecond->Values;
			if( rValues1.getLen() == 0 || rValues2.getLen() == 0 )
				return rValues1.getLen() < rValues2.getLen();
			
			const AddressBookParameteredValue& rValue1 = *rValues1.getConstArray();
			const AddressBookParameteredValue& rValue2 = *rValues2.getConstArray();
			
			static Reflection* pUString = OUString_getReflection();
			static Reflection* pBOOL = BOOL_getReflection();
			// nothing is smaller than anything
			if( !rValue1.Value.get() != !rValue2.Value.get() )
			{
				bComp = !rValue1.Value.get() > !rValue2.Value.get();
				bSet = TRUE;
			}
			else if( pUString->equals( *rValue1.Value.getReflection() ) &&
					 pUString->equals( *rValue2.Value.getReflection() ) )
			{
				bComp = *(UString*)rValue1.Value.get() < 
					*(UString*)rValue2.Value.get();
				bSet = TRUE;
			}
			else if( pBOOL->equals( *rValue1.Value.getReflection() ) &&
					 pBOOL->equals( *rValue2.Value.getReflection() ) )
			{
				bComp = *(BOOL*)rValue1.Value.get() < 
					*(BOOL*)rValue2.Value.get();
				bSet = TRUE;
			}
		}
		if( bSet && bComp == pCur->Ascending )
			return TRUE;
	}
	return FALSE;
}

//////////////////////////////////////////////////////////////

void OResultSet::appendRecord( const ORecord& rRecord ) 
{
	m_aRecords.push_back( rRecord );
	m_aRecords.back().setSorting( &m_aSorting );
}

OResultSet::OResultSet( const Sequence<AddressBookSortInfo>& rSorting )
	: m_aSorting( rSorting )
{
}


///////////////////////////////////////////////////////////////

void OAddressBookSourceAccess::fillClassInfo(
	OObjectClassBase*& rpParentClass, Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSourceAccess, IsInsertable, PropertyAttribute_BOUND ),
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

XIdlClassRef OAddressBookSourceAccess::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.AddressBookSourceAccess", 
		OPropertySet::getStaticIdlClass(), 5,
		XAddressBookSchemataSupplier_getReflection(), 
		XAddressBookResultSetDescriptorFactory_getReflection(), 
		XAddressBookRecordContainer_getReflection(), 
		XCancellable_getReflection(),
		XInitialization_getReflection()	);
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceAccess::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceAccess::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAddressBookSchemataSupplier );
	QUERYIFACE( XAddressBookResultSetDescriptorFactory );
	QUERYIFACE( XAddressBookRecordContainer );
	QUERYIFACE( XCancellable );
	QUERYIFACE( XInitialization );
	return OPropertySet::queryInterface( aUik, rOut );
}

void OAddressBookSourceAccess::cancel()
{
	vector<XCancellableRef> aJobs;
	{
		OGuard aGuard( m_aMutex );
		aJobs = m_aRunningJobs;
	}
	for( vector<XCancellableRef>::const_iterator aIter = aJobs.begin();
		 aIter != aJobs.end(); aIter++ )
		(*aIter)->cancel();
}

void OAddressBookSourceAccess::getFastPropertyValue(
	UsrAny& rValue, INT32 nHandle ) const
{
	if( !m_bPropertiesGot )
	{
		UsrAny aRet;
		XSynchronJobRef xJob( 
			m_xJobFactory->createJob( L"getProperties", Sequence<UsrAny>() ), 
			USR_QUERY );
		{
			OJobContext aCtx( this, xJob );
			aRet = xJob->executeSynchron();
		}
		if( aRet.getReflection() != Sequence<PropertyValue>::getReflection() )
			THROW( RuntimeException() );
		OGuard aGuard( getMutex() );
		OAddressBookSourceAccess* pThis= (OAddressBookSourceAccess*)this;
		pThis->m_bPropertiesGot = TRUE;
		OObjectClass<OAddressBookSourceAccess>::getInstance().
			setPropertyValues( pThis, *(const Sequence<PropertyValue>*)
							   aRet.get() );
	}
	OPropertySet::getFastPropertyValue( rValue, nHandle );
}

void OAddressBookSourceAccess::initialize( const Sequence<UsrAny>& rArgs )
{
	XAddressBookJobFactorySupplierRef xSup;
	if( rArgs.getLen() != 1 || 
		!extractInterface( rArgs.getConstArray()[ 0 ], xSup ) )
		THROW( IllegalArgumentException() );
	m_xJobFactory = xSup->getJobFactory();
}

XInterfaceRef OAddressBookSourceAccess::createResultSetDescriptor()
{
	return *new OResultSetDescriptor();
}

void OAddressBookSourceAccess::registerJob( const XSynchronJobRef& xJob )
{
	XCancellableRef xCancel( xJob, USR_QUERY );
	{
		OGuard aGuard( m_aMutex );
		m_aRunningJobs.push_back( xCancel );
	}
}

void OAddressBookSourceAccess::unregisterJob( const XSynchronJobRef& xJob )
{
	XCancellableRef xCancel( xJob, USR_QUERY );
	OGuard aGuard( m_aMutex );
	for( vector<XCancellableRef>::iterator aIter = m_aRunningJobs.begin();
		 aIter != m_aRunningJobs.end(); aIter++ )
		if( (*aIter ) == xCancel ) 
		{
			m_aRunningJobs.erase( aIter );
			return;
		}
}

Sequence< UString > OAddressBookSourceAccess::createUids(
	const UString& schema, INT16 count) THROWS( (UsrSystemException) )
{
	UsrAny aRet;
	Sequence<UsrAny> aArgs( 2 );
	UsrAny* pArgs = aArgs.getArray();
	pArgs[ 0 ] <<= schema;
	pArgs[ 1 ] <<= count;
	XSynchronJobRef xJob( 
		m_xJobFactory->createJob( L"createUids", aArgs ), USR_QUERY );
	{
		OJobContext aCtx( this, xJob );
		aRet = xJob->executeSynchron();
	}
	Sequence<UString> aUids;
	if( !(aRet >>= aUids ) ) THROW( RuntimeException() );
	return aUids;
}

XEnumerationRef OAddressBookSourceAccess::query(
	const XPropertySetRef& queryDescriptor) 
	THROWS( (UsrSystemException) )
{
	Sequence<UsrAny> aArgs( 4 );
	UsrAny* pArgs = aArgs.getArray();
	pArgs[ 0 ] = queryDescriptor->getPropertyValue( L"RequestedProperties" );
	pArgs[ 1 ] = queryDescriptor->getPropertyValue( L"Query" );
	pArgs[ 2 ] = queryDescriptor->getPropertyValue( L"Sorting" );
	pArgs[ 3 ] = queryDescriptor->getPropertyValue( L"Schemata" );
	
	UsrAny aRet;
	XSynchronJobRef xJob( 
		m_xJobFactory->createJob( L"query", aArgs ), USR_QUERY );
	{
		OJobContext aCtx( this, xJob );
		aRet = xJob->executeSynchron();
	}
	XEnumerationRef xEnum;
	extractInterface(aRet, xEnum );
	return new OAddressBookResultSet( xEnum );
}

void OAddressBookSourceAccess::insertRecord(
	const UString& schema, 
	const Sequence< AddressBookParameteredPropertyValue >& values) 
	THROWS( (UsrSystemException) )
{
	Sequence<UsrAny> aArgs( 2 );
	UsrAny* pArgs = aArgs.getArray();
	pArgs[ 0 ] <<= schema;
	pArgs[ 1 ] <<= values;
	XSynchronJobRef xJob( 
		m_xJobFactory->createJob( L"insertRecord", aArgs ), USR_QUERY );
	{
		OJobContext aCtx( this, xJob );
		xJob->executeSynchron();
	}
}

void OAddressBookSourceAccess::updateRecord(
	const UString& uid, 
	const Sequence< AddressBookParameteredPropertyValue >& values) 
	THROWS( (UsrSystemException) )
{
	Sequence<UsrAny> aArgs( 2 );
	UsrAny* pArgs = aArgs.getArray();
	pArgs[ 0 ] <<= uid;
	pArgs[ 1 ] <<= values;
	XSynchronJobRef xJob( 
		m_xJobFactory->createJob( L"updateRecord", aArgs ), USR_QUERY );
	{
		OJobContext aCtx( this, xJob );
		xJob->executeSynchron();
	}
}

void OAddressBookSourceAccess::removeRecord(
	const UString& uid) THROWS( (UsrSystemException) )
{
	Sequence<UsrAny> aArgs( 1 );
	UsrAny* pArgs = aArgs.getArray();
	pArgs[ 0 ] <<= uid;
	XSynchronJobRef xJob( 
		m_xJobFactory->createJob( L"removeRecord", aArgs ), USR_QUERY );
	{
		OJobContext aCtx( this, xJob );
		xJob->executeSynchron();
	}
}

XNameAccessRef OAddressBookSourceAccess::getSchemata(void)
	THROWS( (UsrSystemException) )
{
	if( !m_xSchemata.is())
	{
		UsrAny aRet;
		XSynchronJobRef xJob( 
			m_xJobFactory->createJob( L"getSchemata", Sequence<UsrAny>() ), USR_QUERY );
		{
			OJobContext aCtx( this, xJob );
			aRet = xJob->executeSynchron();
		}
		if( aRet.getReflection() != 
			Sequence<Sequence<PropertyValue> >::getReflection() )
			THROW( RuntimeException() );
		m_xSchemata = new OAddressBookSimpleSchemata(
			*(const Sequence<Sequence<PropertyValue> >*)aRet.get() );
	}
	return m_xSchemata;
}

XIdlClassRef OAddressBookResultSet::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookResultSet", 
		OComponentHelper::getStaticIdlClass(), 2,
		XEnumeration_getReflection(),
		XCancellable_getReflection()
		);
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookResultSet::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookResultSet::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XCancellable );
	QUERYIFACE( XEnumeration );
	return OComponentHelper::queryInterface( aUik, rOut );
}

void OAddressBookResultSet::cancel()
{
	if( m_xEnum.is() ) 
	{
		XCancellableRef xCancel( m_xEnum, USR_QUERY );
		if( xCancel.is() ) xCancel->cancel();
	}
}

BOOL OAddressBookResultSet::hasMoreElements()
{
	return m_xEnum.is() && m_xEnum->hasMoreElements();
}

UsrAny OAddressBookResultSet::nextElement()
{
	UsrAny aAny = m_xEnum->nextElement();
	if( aAny.getReflection() != Sequence<PropertyValue>::getReflection() )
		THROW( RuntimeException() );
	ORecord* pRec = new ORecord;
	OObjectClass<ORecord>::getInstance().setPropertyValues( 
		pRec, *(const Sequence<PropertyValue>*)aAny.get() );
	XPropertySetRef xProp = new OStandalonePropertySet(
		pRec, OObjectClass<ORecord>::getInstance() );
	aAny <<= xProp;
	return aAny;
}

XIdlClassRef OAddressBookSourceScheduleAsynchronJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceScheduleAsynchronJob", 
		OComponentHelper::getStaticIdlClass(), 1,
		XAsynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceScheduleAsynchronJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceScheduleAsynchronJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XCancellable );
	QUERYIFACE( XAsynchronJob );
	QUERYIFACE( XJob );
	return OComponentHelper::queryInterface( aUik, rOut );
}

void OAddressBookSourceScheduleAsynchronJob::executeAsynchron( 
	const XJobListenerRef& xCallback )
{
	if( m_aType == L"query" )
	{
		OGuard aGuard( m_xSource->getMutex() );
		
		ORecord aRecord;
		aRecord.m_IsRemovable = FALSE;
		aRecord.m_SchemaName = L"Person";

		XScheduleCursorRef xCursor = m_xSource->getScheduleCursor();
		XScheduleBookmarkCursorRef xBmk( xCursor, USR_QUERY );
		if( !xBmk.is() ) THROW( RuntimeException( ));

	
		XPropertySetRef xProp = xCursor->getRecord();
		
		Sequence<UString>             aRequestedProps;
		UString                       aQuery;
		Sequence<AddressBookSortInfo> aSorting;
		Sequence<UString>             aSchemata;
		const UsrAny* pArgs = m_aArgs.getConstArray();
		if( m_aArgs.getLen() != 4 ||
			!( pArgs[ 0 ] >>= aRequestedProps ) ||
			!( pArgs[ 1 ] >>= aQuery ) ||
			!( pArgs[ 2 ] >>= aSorting ) ||
			!( pArgs[ 3 ] >>= aSchemata ) )
			THROW( IllegalArgumentException() );

		OResultSet* pSet = 0;
		if( aSorting.getLen() ) pSet = new OResultSet( aSorting );
		AddressBookQueryTerm* pTerm = 0;
		OAddressBookEvaluator* pEval = 0;
		if( aQuery.len() )
		{
			XAddressBookQueryParserRef xParser(
				m_xMgr->createInstance( 
					L"com.sun.star.address.AddressBookQueryParser" ), USR_QUERY );
			if( !xParser.is() ) THROW( IllegalArgumentException() );
			pTerm = new AddressBookQueryTerm;
			*pTerm = xParser->parseTerm( aQuery );
			pEval = new OAddressBookEvaluator( *pTerm);
		}
		
		UsrAny aAny;
		aAny <<= XAddressBookJobFactorySupplierRef( 
			(XJobFactory*)(OAddressBookSourceSchedule*)m_xSource, USR_QUERY );
		XAddressBookSchemataSupplierRef xContainr(
			m_xMgr->createInstanceWithArguments( 
				L"stardiv.one.address.AddressBookSourceAccess",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
		XPropertySetRef xSchema;
		extractInterface( xContainr->getSchemata()->getByName( 
			L"Person" ), xSchema );
		Sequence<AddressBookParameteredProperty> aProps;
		xSchema->getPropertyValue( L"Properties" ) >>= aProps;

		AddressBookParameteredPropertyValue aProperties[ 5 ];
		AddressBookParameteredValue aValue;
		xCursor->moveToFirst();
		while( xCursor->isValid() )
		{
			xProp->getPropertyValue( L"Uid" ) >>= aRecord.m_Uid;
			aValue.Value <<= aRecord.m_Uid;
			aProperties[ 4 ].Values = Sequence<AddressBookParameteredValue>( &aValue, 1 );
			aProperties[ 4 ].Name = L"Uid";
			aValue.Value = xProp->getPropertyValue( L"Name" );
			aProperties[ 3 ].Values = Sequence<AddressBookParameteredValue>( &aValue, 1 );
			aProperties[ 3 ].Name = L"Shownname";
			aValue.Value = xProp->getPropertyValue( L"Login" );
			aProperties[ 2 ].Values = Sequence<AddressBookParameteredValue>( &aValue, 1 );
			aProperties[ 2 ].Name = L"Initials";
			aValue.Value = xProp->getPropertyValue( L"EMail" );
			aProperties[ 1 ].Values = Sequence<AddressBookParameteredValue>( &aValue, 1 );
			aProperties[ 1 ].Name = L"EMail";
			aValue.Value = xProp->getPropertyValue( L"CalendarURL" );
			aProperties[ 0 ].Values = Sequence<AddressBookParameteredValue>( &aValue, 1 );
			aProperties[ 0 ].Name = L"Calendarurl";
			aRecord.m_Properties = aProps;
			aRecord.m_Values = Sequence< AddressBookParameteredPropertyValue>( 
				aProperties, sizeof( aProperties ) / 
				sizeof( AddressBookParameteredPropertyValue ) );

			// does this record fit?
			if( !pEval || pEval->evaluateTerm( &aRecord ) )
			{
				// do we have to sort?
				if( pSet ) pSet->appendRecord( aRecord );
				// else notify record
				else
				{
					JobEvent aEvent;
					aEvent.Source = *this;
					aEvent.Type = JobEventType_DATA;
					aEvent.Data <<= 
						OObjectClass<ORecord>::getInstance().getPropertyValues(
							&aRecord );
					xCallback->updateJobState( aEvent );
				}
			}
			xCursor->moveRelative( 1 );
		}

		JobEvent aEvent;
		aEvent.Source =*this;
		if( pSet )
		{
			pSet->getRecords().sort();

			aEvent.Type = JobEventType_DATA;
			for( list<ORecord>::iterator aRec = pSet->getRecords().begin(); 
				 aRec != pSet->getRecords().end(); aRec++ )
			{
				aEvent.Data <<= 
					OObjectClass<ORecord>::getInstance().getPropertyValues( 
						&*aRec );
				xCallback->updateJobState( aEvent );
			}
		}
		aEvent.Data = UsrAny();
		aEvent.Type = JobEventType_DONE;
		xCallback->updateJobState( aEvent );
		delete pSet;
		delete pTerm;
		delete pEval;
		return;
	}
	THROW( IllegalArgumentException() );
}

XIdlClassRef OAddressBookSourceScheduleSynchronJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceScheduleAsynchronJob", 
		OComponentHelper::getStaticIdlClass(), 1,
		XAsynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceScheduleSynchronJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceScheduleSynchronJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XCancellable );
	QUERYIFACE( XSynchronJob );
	QUERYIFACE( XJob );
	return OComponentHelper::queryInterface( aUik, rOut );
}

UsrAny OAddressBookSourceScheduleSynchronJob::executeSynchron()
{
	if( m_aType == L"getProperties" )
	{
		UsrAny aAny;
		aAny <<= Sequence<PropertyValue>();
		return aAny;
	}
	else if( m_aType == L"getSchemata" )
	{
		AddressBookParameteredProperty aFields[ 5 ];
		AddressBookParameteredProperty aProp;
		Reflection* pRefl = OUString_getReflection();
		aProp.Type = pRefl->getIdlClass();
		aProp.MinCount = 1;
		aProp.MaxCount = 1;
		aProp.IsWritable = FALSE;
		aFields[ 4 ] = aProp;
		aFields[ 4 ].Name = L"Uid";
		aFields[ 3 ] = aProp;
		aFields[ 3 ].Name = L"Shownname";
		aFields[ 2 ] = aProp;
		aFields[ 2 ].Name = L"Initials";
		aFields[ 1 ] = aProp;
		aFields[ 1 ].Name = L"EMail";
		aFields[ 0 ] = aProp;
		aFields[ 0 ].Name = L"Calendarurl";
		
		OAddressBookSchemaData aData;
		aData.m_IsInsertable = FALSE;
		aData.m_Name = L"Person";
		sort( aFields, aFields + 5, isLessProperty );
		aData.m_Properties = Sequence<AddressBookParameteredProperty>(
			aFields, 5 );
		Sequence<PropertyValue> aSeq = 
			OObjectClass<OAddressBookSchemaData>::getInstance().getPropertyValues(
				&aData );
		UsrAny aAny;
		aAny <<= Sequence<Sequence<PropertyValue> >(&aSeq, 1 );
		return aAny;
	}
	THROW( IllegalArgumentException() );
	return UsrAny();
}

XIdlClassRef OAddressBookSourceSchedule::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceSchedule", 
		OPropertySet::getStaticIdlClass(), 2,
		XAddressBookJobFactorySupplier_getReflection(),
		XJobFactory_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceSchedule::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceSchedule::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAddressBookJobFactorySupplier );
	QUERYIFACE( XJobFactory );
	return OPropertySet::queryInterface( aUik, rOut );
}

void OAddressBookSourceSchedule::fillClassInfo(
	OObjectClassBase*& rpParentClass, 
	Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSourceSchedule, ServerName,
			PropertyAttribute_BOUND )
			};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
	rpParentClass = &OObjectClass<OAddressBookSourceData>::getInstance();
}

XScheduleCursorRef OAddressBookSourceSchedule::getScheduleCursor()
{
	OGuard aGuard( m_aMutex );
	if( !m_xCursor.is() )
	{
		XScheduleSessionManagerRef xMgr( m_xMgr->createInstance(
			L"com.sun.star.schedule.ScheduleManager" ), USR_QUERY );
		XScheduleServersSupplierRef xSup( xMgr, USR_QUERY );
		XNameAccessRef xNames( xSup->getServers(), USR_QUERY );
		XPropertySetRef xProp;
		UsrAny aAny = xNames->getByName( m_ServerName );
		if( extractInterface( aAny, xProp ) )
		{
			XScheduleSessionRef xSession = 
				xMgr->getSessionByConfiguration( xProp );
			if( xSession.is() ) 
			{
				XScheduleCursorDescriptorFactoryRef xFact( xSession, USR_QUERY );
				XPropertySetRef xProp = xFact->createCursorDescriptor();
				xProp->setPropertyValue( 
					L"ContainerType", UsrAny( L"Rights.Resources") );
				xProp->setPropertyValue( L"ContainerUid", UsrAny( UString() ) );
				XIndexFactoryContainerRef xFilter;
				xProp->getPropertyValue( L"Filter" ) >>= xFilter;
				XPropertySetRef xCond;
				xFilter->insertNewByIndex( 0 ) >>= xCond;
				xCond->setPropertyValue( 
					L"PropertyName", UsrAny( L"IsScheduleableResource" ) );
				xCond->setPropertyValue(
					L"Operator", UsrAny( INT16( 
						ScheduleQueryOperator_EQUAL ) ) );
				xCond->setPropertyValue(
					L"Value", UsrAny( BOOL( TRUE ) ) );
				
				UString aFields[] = { L"Login", L"Name", L"CalendarURL", L"EMail", L"Uid" };
				UsrAny aFieldsAny;
				aFieldsAny <<= Sequence<UString>( 
					aFields, sizeof( aFields )/ sizeof( UString ) );
				xProp->setPropertyValue( L"PropertyNames", aFieldsAny );
				XScheduleCursorFactoryRef xCurFact( xSession, USR_QUERY );
				m_xCursor = xCurFact->createCursor(
					xProp, ScheduleCursorType_UPDATED );
			}
		}
	}
	return m_xCursor;
}


XJobFactoryRef OAddressBookSourceSchedule::getJobFactory()
{
	if( !m_xJobFactory.is() )
	{
		UsrAny aAny;
		aAny <<= XJobFactoryRef( this );
		m_xJobFactory = XJobFactoryRef(
			m_xMgr->createInstanceWithArguments( 
				L"com.sun.star.address.SynchronAndAsynchronJobFactory",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xJobFactory;
}

XInterfaceRef OAddressBookSourceSchedule::createJob(
	const UString& rType, const Sequence<UsrAny>& rArgs )
{
	if( rType != L"query" )
		return *new OAddressBookSourceScheduleSynchronJob(
			rType, this, rArgs );
	else return *new OAddressBookSourceScheduleAsynchronJob(
		m_xMgr, rType, this, rArgs );
}

XIdlClassRef OAddressBookQueryParser::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookQueryParser", 
		OWeakObject::getStaticIdlClass(), 2,
		XAddressBookQueryParser_getReflection(),
		XAddressBookQueryWriter_getReflection()
		);
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookQueryParser::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookQueryParser::queryInterface( 
	Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAddressBookQueryParser );
	QUERYIFACE( XAddressBookQueryWriter );
	return OWeakObject::queryInterface( aUik, rOut );
}

UString OAddressBookQueryParser::writeOpTerm(
	const UString& rOp, const Sequence<UsrAny>& rArgs, BOOL bWithStars )
{
	UString aRet;
	const UsrAny* pArgs = rArgs.getConstArray();
	const UsrAny* pEnd = pArgs + rArgs.getLen();
	UString aField;
	if( *pArgs++ >>= aField )
		aRet += aField;
	aRet += rOp;

	while( pArgs != pEnd )
	{
		if( *pArgs >>= aField )
		{
			UniString aTmp( aField );
			aTmp.SearchAndReplaceAll( UniString( "*" ), UniString("\\*" ) );
			aTmp.SearchAndReplaceAll( UniString( "(" ), UniString( "\\(" ) );
			aTmp.SearchAndReplaceAll( UniString("(" ), UniString( "\\)" ) );
			aRet += UString( aTmp );
			if( aTmp.Len() && bWithStars ) aRet += UString::createFromAscii( "*" );
		}
		pArgs++;
	}
	return aRet;
}

UString OAddressBookQueryParser::writeTerm(const AddressBookQueryTerm& term) 
	THROWS( (UsrSystemException) )
{
	UString aTerm( UString::createFromAscii( "(" ) );
	switch( term.Function )
	{
		case AddressBookQueryFunction_OR:
		case AddressBookQueryFunction_AND:
		{
			aTerm += UString::createFromAscii( 
				term.Function == 
				AddressBookQueryFunction_OR ? "|" : "&" );
			const UsrAny* pFirst = term.Arguments.getConstArray();
			const UsrAny* pLast =  pFirst + term.Arguments.getLen();
			for( ; pFirst != pLast; pFirst++ )
			{
				if( pFirst->getReflection() != AddressBookQueryTerm_getReflection() )
					THROW( IllegalArgumentException() );
				aTerm += writeTerm( *(const AddressBookQueryTerm*) pFirst->get() );
			}
			break;
		}
		case AddressBookQueryFunction_NOT:
		{
			aTerm += UString::createFromAscii( "!" );
			const UsrAny* pFirst = term.Arguments.getConstArray();
			if( !term.Arguments.getLen() || 
				pFirst->getReflection() != AddressBookQueryTerm_getReflection() )
				THROW( IllegalArgumentException() );
			aTerm += writeTerm( *(const AddressBookQueryTerm*) pFirst->get() );
			break;
		}
		case AddressBookQueryFunction_EQUALITYMATCH:
			aTerm += writeOpTerm( L"=", term.Arguments, FALSE );
			break;
		case AddressBookQueryFunction_SUBSTRINGS:
			aTerm += writeOpTerm( L"=", term.Arguments, TRUE );
			break;
		case AddressBookQueryFunction_APPROXMATCH:
			aTerm += writeOpTerm( L"~=", term.Arguments, FALSE );
			break;
		case AddressBookQueryFunction_LESSOREQUAL:
			aTerm += writeOpTerm( L"<=", term.Arguments, FALSE );
			break;
		case AddressBookQueryFunction_GREATEROREQUAL:
			aTerm += writeOpTerm( L">=", term.Arguments, FALSE );
			break;
		case AddressBookQueryFunction_PRESENT:
			aTerm += writeOpTerm( L"=*", term.Arguments, FALSE );
			break;
	}
	aTerm += L")";
	return UString( aTerm );
}


AddressBookQueryTerm OAddressBookQueryParser::parseTerm(const UString& query) 
	THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_aMutex );
	AddressBookQueryTerm aReturn;
	AddressBookQueryTerm* parseQuery( const UString& rQuery );
	AddressBookQueryTerm* pTerm = parseQuery( query );
	if( !pTerm ) THROW( IllegalArgumentException() );
	aReturn = *pTerm;
	delete pTerm;
	return aReturn;
}

OAddressBookEvaluator::OAddressBookEvaluator( 
	const AddressBookQueryTerm& rTerm )
	: m_aTerm( rTerm )
{
	compileTerm( m_aTerm );
}

void OAddressBookEvaluator::compileTerm( 
	AddressBookQueryTerm& rTerm )
{
	switch( rTerm.Function )
	{
		case AddressBookQueryFunction_OR:
		case AddressBookQueryFunction_AND:
		case AddressBookQueryFunction_NOT:
		{
			UsrAny* pArgs = rTerm.Arguments.getArray();
			INT32 nPos = rTerm.Arguments.getLen();
			while( nPos-- ) 
			{
				UsrAny& rAny = pArgs[ nPos ];
				if( rAny.getReflection() != 
					AddressBookQueryTerm_getReflection() )
					THROW( IllegalArgumentException() );
				compileTerm( *(AddressBookQueryTerm*)rAny.get() );
			}
			break;
		}
		case AddressBookQueryFunction_EQUALITYMATCH:
		case AddressBookQueryFunction_PRESENT:
		case AddressBookQueryFunction_SUBSTRINGS:
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_LESSOREQUAL:
		case AddressBookQueryFunction_GREATEROREQUAL:
			UString aField;
			if( !rTerm.Arguments.getLen() || 
				!(rTerm.Arguments.getConstArray()[ 0 ] >>= aField) )
				THROW( IllegalArgumentException() );
			rTerm.Arguments.getArray()[ 0 ] <<= aField;
			break;
	}
}


vector<UString> OAddressBookEvaluator::getFields( 
	const AddressBookQueryTerm& rTerm )
{
	vector<UString> aResult;
	const UsrAny* pAny = rTerm.Arguments.getConstArray();
	UString aField;
	for( INT32 nPos = rTerm.Arguments.getLen(); nPos--; )
	{
		if( pAny[ nPos ].getReflection() == 
			AddressBookQueryTerm_getReflection() )
		{
			vector<UString> aTmp = 
				getFields( *(const AddressBookQueryTerm*)pAny[ nPos ].get() );
			sort( aTmp.begin(), aTmp.end(), isLess );
			INT32 nOldSize = aResult.size();
			aResult.reserve( nOldSize + aTmp.size() );
			copy( aTmp.begin(), aTmp.end(),
				  back_insert_iterator<vector<UString> >( aResult ) );
			inplace_merge( aResult.begin(), aResult.begin() + nOldSize,
						   aResult.end(), isLess );
		}
		else
		{
			if( pAny[ nPos ] >>= aField )
			{
				aResult.push_back( aField );
				return aResult;
			}
		}
	}
	return aResult;
}


void OAddressBookEvaluator::normalize(
	AddressBookQueryTerm& rTerm )
{
	// first remove and/or terms with one argument
	switch( rTerm.Function )
	{
		case AddressBookQueryFunction_OR:
		case AddressBookQueryFunction_AND:
		{
			UsrAny* pArgs = rTerm.Arguments.getArray();
			INT32 nPos = rTerm.Arguments.getLen();
			if( nPos == 1 )
			{
				AddressBookQueryTerm aSubTerm = 
					*(AddressBookQueryTerm*)rTerm.Arguments.
					getArray()[ 0 ].get();
				normalize( aSubTerm );
				rTerm = aSubTerm;
			}
			else while( nPos-- ) 
			{
				UsrAny& rAny = pArgs[ nPos ];
				if( rAny.getReflection() != 
					AddressBookQueryTerm_getReflection() )
					THROW( IllegalArgumentException() );
				normalize( *(AddressBookQueryTerm*)rAny.get() );
			}
			break;
		}
		case AddressBookQueryFunction_NOT:
		{
			normalize( *(AddressBookQueryTerm*)
					   rTerm.Arguments.getArray()[ 0 ].get() );
			break;
		}
		case AddressBookQueryFunction_EQUALITYMATCH:
		case AddressBookQueryFunction_PRESENT:
		case AddressBookQueryFunction_SUBSTRINGS:
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_LESSOREQUAL:
		case AddressBookQueryFunction_GREATEROREQUAL:
			break;
	}
	// if we have two following nots, eliminate them
	if( rTerm.Function == AddressBookQueryFunction_NOT )
	{
		AddressBookQueryTerm& rSubTerm = *(AddressBookQueryTerm*)
			rTerm.Arguments.getArray()[ 0 ].get();
		if( rSubTerm.Function == AddressBookQueryFunction_NOT )
		{
			AddressBookQueryTerm aSubTerm = rSubTerm;
			rTerm = aSubTerm;
		}
	}
}

BOOL OAddressBookEvaluator::evaluateTerm( 
	 const AddressBookQueryTerm& rTerm, const ORecord* pObject )
{
	AddressBookQueryFunction eFunc = rTerm.Function;
	switch( eFunc )
	{
		case AddressBookQueryFunction_OR:
		case AddressBookQueryFunction_AND:
		case AddressBookQueryFunction_NOT:
		{
			// evaluate arguments
			const UsrAny* pArgs = 
				rTerm.Arguments.getConstArray();
			INT32 nCount = rTerm.Arguments.getLen();
			for( INT32 nPos = 0; nPos < nCount; nPos++ )
			{
				const UsrAny& rAny = pArgs[ nPos ];
				if( rAny.getReflection() != 
					AddressBookQueryTerm_getReflection() )
					THROW( IllegalArgumentException() );
				BOOL bResult = evaluateTerm( 
					*(const AddressBookQueryTerm*)rAny.get(), pObject );
				switch( eFunc )
				{
					case AddressBookQueryFunction_OR:
						if( bResult ) return TRUE;
						break;
					case AddressBookQueryFunction_AND:
						if( !bResult ) return FALSE;
						break;
					case AddressBookQueryFunction_NOT:
						return !bResult;
						break;
				}
			}
			return eFunc == AddressBookQueryFunction_AND;
		}
		case AddressBookQueryFunction_PRESENT:
		case AddressBookQueryFunction_EQUALITYMATCH:
		case AddressBookQueryFunction_SUBSTRINGS:
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_LESSOREQUAL:
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			UString aField;
			if( !(rTerm.Arguments.getConstArray()[ 0 ] >>= aField ))
				THROW( IllegalArgumentException() );
			const AddressBookParameteredPropertyValue* pValue = 
				pObject->getProperty( aField );
			if( !pValue ) THROW( IllegalArgumentException() );
			const Sequence<AddressBookParameteredValue>& rValues = 
				pValue->Values;
			
			INT32 nLen = rValues.getLen();
			if( !nLen ) switch( eFunc )
			{
				case AddressBookQueryFunction_LESSOREQUAL:
					return TRUE;
				case AddressBookQueryFunction_APPROXMATCH:
				case AddressBookQueryFunction_EQUALITYMATCH:
				case AddressBookQueryFunction_SUBSTRINGS:
				case AddressBookQueryFunction_GREATEROREQUAL:
				case AddressBookQueryFunction_PRESENT:
					return FALSE;
			}
			
			UString aValue;
			for( const AddressBookParameteredValue* pAny = 
					 rValues.getConstArray(); 
				 nLen--; )
			{
				const UsrAny& rAny = pAny[ nLen ].Value;
				Reflection* pRefl = rAny.getReflection();
				BOOL bValue;
				if( rAny >>= bValue )
					aValue = bValue ? L"TRUE" : L"FALSE";
				else
				{
					Date aDate( 0 );
					if( rAny >>= aDate )
					{
						UString aDateRope;
						UString aStr( SHOULDBEUNICODE(
							String( aDate.GetYear() ) ) );
						UString aZeros( UString::createFromAscii( "0000" ) );

						aDateRope += aZeros.copy( 0, 4 - aStr.len() );
						aDateRope += aStr;
						aStr = SHOULDBEUNICODE( 
							String( aDate.GetMonth() ) );
						aDateRope += aZeros.copy( 0, 2 - aStr.len() );
						aDateRope += aStr;
						aStr = SHOULDBEUNICODE( 
							String( aDate.GetDay() ) );
						aDateRope += aZeros.copy( 0, 2 - aStr.len() );
						aDateRope += aStr;
						aValue = aDateRope;
					}
					else if( !(rAny >>= aValue ) )
						THROW( IllegalArgumentException() );
				}
				
				UString aValue2;
				if( eFunc != AddressBookQueryFunction_PRESENT &&
					( rTerm.Arguments.getLen() < 2 ||
					  !(rTerm.Arguments.getConstArray()[ 1 ] >>= 
						aValue2 )))
					THROW( IllegalArgumentException() );

				switch( eFunc )
				{
					//! alles case insensitive machen
  					case AddressBookQueryFunction_EQUALITYMATCH:
  						if( aValue.equalsIgnoreCase( aValue2 ) ) return TRUE;
						break;
  					case AddressBookQueryFunction_SUBSTRINGS:
  						if( aValue.equalsIgnoreCase( aValue2 ) ) return TRUE;
						break;
  					case AddressBookQueryFunction_APPROXMATCH:
  						if( aValue.equalsIgnoreCase( aValue2 ) ) return TRUE;
						break;
  					case AddressBookQueryFunction_LESSOREQUAL:
  						return aValue.compareTo( aValue2 ) <= 0;
						break;
  					case AddressBookQueryFunction_GREATEROREQUAL:
  						return aValue.compareTo( aValue2 ) >= 0;
						break;
					case AddressBookQueryFunction_PRESENT:
					{
						UString aValue;
						Reflection* pRefl= rAny.getReflection();
						// if it is a string only consider it 
						// present if len != 0
						if( pRefl != OUString_getReflection() &&
							pRefl != Sequence<BYTE>::getReflection() )
							return TRUE;
						if( (rAny >>= aValue ) && aValue.len() )
							return TRUE;
						else if( pRefl == 
								 Sequence<BYTE>::getReflection() &&
								 (*(Sequence<BYTE>*)pAny[ nLen ].Value.get()).
								 getLen() ) return TRUE;
						break;
					}
				}
			}
			return FALSE;
		}
		default: THROW( IllegalArgumentException() );
	}
	return FALSE;
}


OAddressBookSources::OAddressBookSources( 
	const XMultiServiceFactoryRef& xMgr ) : 
	m_xMgr(xMgr), OComponentHelper( m_aMutex ), m_aListeners( m_aMutex )
{
	XScheduleServersSupplierRef xServers(
		xMgr->createInstance( L"com.sun.star.schedule.ScheduleManager" ), 
		USR_QUERY );
	if( xServers.is() )
	{
		XNameAccessRef xNames( xServers->getServers(), USR_QUERY );
		Sequence<UString> aNames = xNames->getElementNames();
		const UString* pNames = aNames.getConstArray();
		UsrAny aAny;
		UString aType( L"userSource" );
		Sequence<UString> aSeq( &aType, 1 );
		UsrAny aSeqAny;
		aSeqAny <<= aSeq;
		for( INT32 nPos = aNames.getLen(); nPos--; )
		{
			XPropertySetRef xProp( xMgr->createInstance(
				L"com.sun.star.address.AddressBookSourceSchedule" ), USR_QUERY );
			xProp->setPropertyValue( L"ServerName", pNames[ nPos ] );
			xProp->setPropertyValue( L"Name", pNames[ nPos ] );
			xProp->setPropertyValue( L"ReadOnly", UsrAny( BOOL( TRUE ) ) );
			xProp->setPropertyValue( L"Types", aSeqAny );
			aAny <<= xProp;
			// insert via API to get UniqueID
			insert( aAny );
		}
	}
	XNameAccessRef xSettings( xMgr->createInstance(
		L"com.sun.star.frame.Settings" ), USR_QUERY );
	if( xSettings.is() )
	{
		XPropertySetRef xProps;
		extractInterface( xSettings->getByName( L"PathSettings" ), xProps );
		UString aPath;
		if( xProps.is() && (
			xProps->getPropertyValue( USERCONFIGPROPNAME )  >>= aPath ) )
		{
			m_xRegistry = XSimpleRegistryRef(
				xMgr->createInstance(
					L"com.sun.star.registry.SimpleRegistry" ), USR_QUERY );
			if( !m_xRegistry.is() ) return;
			DirEntry aEntry( SHOULDTAKEUNICODE( aPath ));
			aEntry += DirEntry( "adrbook.rdb" );
			m_xRegistry->open( 
				SHOULDBEUNICODE( aEntry.GetFull() ), FALSE, TRUE );
			XRegistryKeyRef xKey = m_xRegistry->getRootKey();
			Sequence<XRegistryKeyRef> aKeys = xKey->openKeys();
			const XRegistryKeyRef* pKeys = aKeys.getConstArray();
			INT32 nPos;
			for( nPos = aKeys.getLen(); nPos--; )
				loadSection( pKeys[ nPos ] );
		}
	}
	XDesktopRef xDesktop( xMgr->createInstance(
		L"com.sun.star.frame.Desktop" ), USR_QUERY );
	xDesktop->addTerminateListener( this );
}

void OAddressBookSources::addContainerListener(
	const XContainerListenerRef& xListener) 
	THROWS( (UsrSystemException) )
{
	m_aListeners.addInterface( (XContainerListener*) xListener );
}

void OAddressBookSources::removeContainerListener(
	const XContainerListenerRef& xListener) 
	THROWS( (UsrSystemException) )
{
	m_aListeners.removeInterface( (XContainerListener*) xListener );
}

void OAddressBookSources::flush()
{
	XRegistryKeyRef xRoot = m_xRegistry->getRootKey();
	vector<UString> aNames;
	for( vector<XPropertySetRef>::const_iterator aIter = m_aSources.begin();
		 aIter != m_aSources.end(); aIter++ )
	{
		const XPropertySetRef xProp( *aIter );
		UString aService;
		// save all sources but automatically generated schedule sources
		if( xProp->getPropertySetInfo()->hasPropertyByName( L"ServiceName" ) &&
			(xProp->getPropertyValue( L"ServiceName" ) >>= aService ))
			if( aService != L"com.sun.star.address.AddressBookSourceSchedule" )
			{
				UString aName;
				if( xProp->getPropertySetInfo()->hasPropertyByName( 
					L"Name" ) &&
					(xProp->getPropertyValue( L"Name" ) >>= aName ) )
				{
					aNames.push_back( aName );
					XRegistryKeyRef xKey;
					xKey = xRoot->openKey( aName );
					if( !xKey.is() ) xKey = xRoot->createKey( aName );
					OPropertySet::savePropertySet( xProp, xKey );
				}
			}
	}
	
	Sequence<UString> aKeys = xRoot->getKeyNames();
	UString* pKeys = aKeys.getArray();
	INT32 nPos = aKeys.getLen();
	while( nPos-- )
	{
		UString& rName = pKeys[ nPos ];
		INT32 nPos = rName.len( ) - 1;
		while( nPos && rName[ nPos ] != L'/' ) nPos--;
		if( nPos >= 0 ) rName = rName.copy( nPos + 1 );
	}
	
	// remove all keys that don't correspond to sources anymore
	sort( pKeys, pKeys + aKeys.getLen(), isLess );
	sort( aNames.begin(), aNames.end(), isLess );
	vector<UString> aLeftOver;
	set_difference( 
		pKeys, pKeys + aKeys.getLen(),
		aNames.begin(), aNames.end(), 
		insert_iterator< vector< UString > >( aLeftOver, aLeftOver.begin() ),
		isLess );
	{
		for( vector<UString>::const_iterator aIter = aLeftOver.begin();
			 aIter != aLeftOver.end(); aIter++ )
			xRoot->deleteKey( *aIter );
	}
}

void OAddressBookSources::loadSection( const XRegistryKeyRef& xKey )
{
	XRegistryKeyRef xServiceName = xKey->openKey( L"ServiceName" );
	if( !xServiceName.is() ) return;
	XPropertySetRef xProp( m_xMgr->createInstance(
		xServiceName->getStringValue() ), USR_QUERY );
	if( !xProp.is() ) return;
	OPropertySet::loadPropertySet( xProp, xKey );
	m_aSources.push_back( xProp );
}



void OAddressBookSources::disposing()
{
	XDesktopRef xDesktop( m_xMgr->createInstance(
		L"com.sun.star.frame.Desktop" ), USR_QUERY );
	if( xDesktop.is() ) xDesktop->removeTerminateListener( this );
	m_xRegistry->close();
	// dispose sources
	vector<XPropertySetRef> aSources;
	{
		OGuard aGuard( m_aMutex );
		aSources = m_aSources;
		m_aSources.erase( m_aSources.begin(), m_aSources.end() );
	}
	for( vector<XPropertySetRef>::const_iterator aIter = aSources.begin();
		 aIter != aSources.end(); aIter++ )
	{
		XComponentRef xComp( *aIter, USR_QUERY );
		if( xComp.is() ) xComp->dispose();
	}
//	flush();
}

// XIdlClassProvider
XIdlClassRef OAddressBookSources::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSources", 
		OComponentHelper::getStaticIdlClass(), 4,
		XUniqueIDAccess_getReflection(),
		XNameAccess_getReflection(),
		XContainer_getReflection(),
		XSet_getReflection(),
		XTerminateListener_getReflection()
		);
	return xClass;
}

Sequence<XIdlClassRef> OAddressBookSources::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSources::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XUniqueIDAccess );
	QUERYIFACE( XNameAccess );
	QUERYIFACE( XContainer );
	QUERYIFACE( XEnumerationAccess );
	QUERYIFACE( XSet );
	// egcs again!
	if( aUik == ((XIndexAccess*)this)->XElementAccess::getSmartUik() )
	{
		rOut = (XElementAccess*)(XIndexAccess*)this;
		return TRUE;
	}
	QUERYIFACE( XTerminateListener );
	QUERYIFACE( XEventListener );
	return OComponentHelper::queryInterface( aUik, rOut );
}

void OAddressBookSources::queryTermination(const EventObject& aEvent) 
	THROWS( (TerminationVetoException, UsrSystemException) )
{
}

void OAddressBookSources::notifyTermination(const EventObject& aEvent) 
	THROWS( (UsrSystemException) )
{
	flush();
}

XIdlClassRef OAddressBookSources::getElementType(void) const THROWS( (UsrSystemException) )
{
	return XSingleServiceFactory_getReflection()->getIdlClass();
}

BOOL OAddressBookSources::hasElements(void) const THROWS( (UsrSystemException) )
{
	OGuard aGuard( getMutex() );
	return m_aSources.size() != 0;
}


UsrAny OAddressBookSources::getByUniqueID(const UString& aUid) 
	THROWS( (NoSuchElementException, UsrSystemException) )
{
	UString aName;
	OGuard aGuard( getMutex() );
	for( vector<XPropertySetRef>::const_iterator aIter = m_aSources.begin();
		 aIter != m_aSources.end(); aIter++ )
	{
		TRY
		{
			if( ((*aIter)->getPropertyValue( L"Uid" ) >>= aName) &&
				aName == aUid )
			{
				UsrAny aAny;
				aAny <<= *aIter;
				return aAny;
			}
		}
		CATCH( UnknownPropertyException, e )
		{
		}
		END_CATCH;
	}
	THROW( NoSuchElementException() );
	return UsrAny();
}

void OAddressBookSources::removeByUniqueID(const UString& aUid) 
	THROWS( (NoSuchElementException, UsrSystemException) )
{
	UString aName;
	OGuard aGuard( getMutex() );
	INT32 nIndex = 0;
	for( vector<XPropertySetRef>::const_iterator aIter = m_aSources.begin();
		 aIter != m_aSources.end(); aIter++, nIndex++ )
	{
		TRY
		{
			if( ((*aIter)->getPropertyValue( L"Uid" ) >>= aName) &&
				aName == aUid )
			{
				remove( makeAny( *aIter ) );
				return;
			}
		}
		CATCH( UnknownPropertyException, e )
		{
		}
		END_CATCH;
	}
	THROW( NoSuchElementException() );
}

OSourceEnumeration::OSourceEnumeration(
	vector<XPropertySetRef>::iterator aFirst, 
	vector<XPropertySetRef>::iterator aLast  )
	: OEnumerationHelper<vector<XPropertySetRef>::iterator>( m_aMutex )
{
	copy( aFirst, aLast, back_insert_iterator<vector<XPropertySetRef> >( m_aSources ) );
	setIterators( m_aSources.begin(), m_aSources.end() );
}

XIdlClassRef OSourceEnumeration::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OSourceEnumeration", 
		UsrObject::getUsrObjectIdlClass(), 1,
		XEnumeration_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef> OSourceEnumeration::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OSourceEnumeration::queryInterface( 
	Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XEnumeration );
	return UsrObject::queryInterface( aUik, rOut );
}

XEnumerationRef OAddressBookSources::createEnumeration(void) THROWS( (UsrSystemException) )
{
	OGuard aGuard( getMutex() );
	return new OSourceEnumeration( m_aSources.begin(), m_aSources.end() );
}


BOOL OAddressBookSources::has(const UsrAny& Element) const THROWS( (UsrSystemException) )
{
	XPropertySetRef xProp;
	extractInterface( Element, xProp );
	OGuard aGuard( getMutex() );
	for( INT32 nPos = 0; nPos < m_aSources.size(); nPos++ )
	{
		if( m_aSources[ nPos ] == xProp )
			return TRUE;
	}
	return FALSE;
}

void OAddressBookSources::insert(const UsrAny& aElement) THROWS( (IllegalArgumentException, ElementExistException, UsrSystemException) )
{
	OClearableGuard aGuard( getMutex() );
	if( has( aElement ) )
	{
		THROW( ElementExistException() );
	}
	else
	{
		XPropertySetRef xProp;
		extractInterface( aElement, xProp );

		UString aUid;
		xProp->getPropertyValue( L"Uid" ) >>= aUid;
		if( !aUid.len() )
		{
		XUniqueIDFactoryRef xFac( m_xMgr->createInstance(
			L"com.sun.star.util.UniqueIDFactory" ), USR_QUERY );
		xProp->setPropertyValue( L"Uid", UsrAny( xFac->createUniqueID() ) );
		}

		m_aSources.push_back( xProp );
		OInterfaceIteratorHelper aIter( m_aListeners );
		if( aIter.hasMoreElements() )
		{
			aGuard.clear();
			ContainerEvent aEvent;
			aEvent.Source = *this;
			aEvent.Element <<= xProp;
			while( aIter.hasMoreElements() )
			{
				XContainerListenerRef xListener( aIter.next(), USR_QUERY );
				if( xListener.is() )
					xListener->elementInserted( aEvent );
			}
		}
	}
}

void OAddressBookSources::remove(const UsrAny& aElement) THROWS( (IllegalArgumentException, NoSuchElementException, UsrSystemException) )
{
	OClearableGuard aGuard( getMutex() );
	XPropertySetRef xProp;
	extractInterface( aElement, xProp );
	for( INT32 nPos = 0; nPos < m_aSources.size(); nPos++ )
	{
		if( m_aSources[ nPos ] == xProp )
		{
			vector<XPropertySetRef>::iterator aPos = m_aSources.begin();
			advance( aPos, nPos );
			m_aSources.erase( aPos );
			aGuard.clear();
			OInterfaceIteratorHelper aIter( m_aListeners );
			aGuard.clear();
			ContainerEvent aEvent;
			aEvent.Source = *this;
			aEvent.Element <<= xProp;
			while( aIter.hasMoreElements() )
			{
				XContainerListenerRef xListener( aIter.next(), USR_QUERY );
				if( xListener.is() )
					xListener->elementRemoved( aEvent );
			}
			return;
		}
	}
	THROW( NoSuchElementException() );
}

	
UsrAny OAddressBookSources::getByName(const UString& rName) const THROWS( (NoSuchElementException, WrappedTargetException, UsrSystemException) )
{
	UString aName;
	OGuard aGuard( getMutex() );
	for( vector<XPropertySetRef>::const_iterator aIter = m_aSources.begin();
		 aIter != m_aSources.end(); aIter++ )
	{
		TRY
		{
			if( ((*aIter)->getPropertyValue( L"Name" ) >>= aName) &&
				aName == rName )
			{
				UsrAny aAny;
				aAny <<= *aIter;
				return aAny;
			}
		}
		CATCH( UnknownPropertyException, e )
		{
		}
		END_CATCH;
	}
	THROW( NoSuchElementException() );
	return UsrAny();
}

Sequence<UString > OAddressBookSources:: getElementNames(void) const THROWS( (UsrSystemException) )
{
	UString aName;
	vector<UString> aNames;
	OGuard aGuard( getMutex() );
	for( vector<XPropertySetRef>::const_iterator aIter = m_aSources.begin();
		 aIter != m_aSources.end(); aIter++ )
	{
		TRY
		{
			if((*aIter)->getPropertyValue( L"Name" ) >>= aName)
				aNames.push_back( aName );
		}
		CATCH( UnknownPropertyException, e )
		{
		}
		END_CATCH;
	}
	Sequence<UString> aReturn;
	copyContainerToSequence( aNames, aReturn );
	return aReturn;
}

BOOL OAddressBookSources::hasByName(const UString& rName) const THROWS( (UsrSystemException) )
{
	Sequence<UString> aNames = getElementNames();
	const UString* pFirst = aNames.getConstArray();
	const UString* pEnd = pFirst + aNames.getLen();
	return find_if( 
		pFirst, pEnd, bind2nd( equal_to<UString>(), rName ) ) != pEnd;
}


BOOL OAddressBookSources::uidToSchemaAndBasisUid( 
	const UString& rUid, UString& rSchema, UString& rBasisUid )
{
	rSchema = rUid.getToken( 0, L'/' );
	rBasisUid = (const sal_Unicode*)rUid + rSchema.len() + 1;
	return TRUE;
}

UString OAddressBookSources::schemaAndBasisUidToUid(
	const UString& rSchema, const UString& rBasisUid )
{
	UString aRet( rSchema );
	( aRet += UString::createFromAscii( "/" )) += rBasisUid;
	return UString( aRet );
}


void OAddressBookCursorResultSet::removeRecord(
	list<ORecord>::iterator& rIter )
{
	OGuard aGuard( m_aMutex );
	for( vector<IAddressBookCursorIterator*>::iterator aIter = 
			 m_aIterators.begin(); aIter != m_aIterators.end(); aIter++ )
		(*aIter)->removingRecord( rIter );
	m_aRecords.erase( rIter );
}

OAddressBookCursor::OAddressBookCursor( ) : 
	OPropertySet( 
		m_aMutex, this, OObjectClass<ORecord>::getInstance(), 
		false )
{
	m_xRecords = new OAddressBookCursorResultSet;
	m_aCurRecord = m_xRecords->getRecords().end();
	m_xRecords->registerIterator( this );
}

OAddressBookCursor::OAddressBookCursor( 
	const ORef<OAddressBookCursorResultSet>& xResult ) : 
	OPropertySet( 
		m_aMutex, this, OObjectClass<ORecord>::getInstance(), 
		false ), m_xRecords( xResult )
{
	acquire();
	m_aCurRecord = m_xRecords->getRecords().end();
	m_xRecords->registerIterator( this );
	moveToFirst();
}

OAddressBookCursor::~OAddressBookCursor() 
{
	m_xRecords->unregisterIterator( this );
	cancel(); 
}

BOOL OAddressBookCursor::isValid(void) const THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_xRecords->getMutex() );
	return m_aCurRecord != m_xRecords->getRecords().end();
}

BOOL OAddressBookCursor::isBeforeFirst(void) const THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_xRecords->getMutex() );
	return m_aCurRecord == m_xRecords->getRecords().end();
}

BOOL OAddressBookCursor::isBehindLast(void) const THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_xRecords->getMutex() );
	return m_aCurRecord == m_xRecords->getRecords().end();
}

BOOL OAddressBookCursor::isAtFirst(void) const THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_xRecords->getMutex() );
	return m_aCurRecord == m_xRecords->getRecords().begin();
}

BOOL OAddressBookCursor::isAtLast(void) const THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_xRecords->getMutex() );
	list<ORecord>::iterator aCur = m_aCurRecord;
	aCur++;
	return aCur == m_xRecords->getRecords().end();
}

BOOL OAddressBookCursor::moveToFirst(void) THROWS( ( UsrSystemException) )
{
	OClearableGuard aGuard( m_xRecords->getMutex() );
	BOOL bFetched = m_xRecords->m_aRecords.size() != 0 || fetchRecord();
	if( bFetched )
	{
		m_aCurRecord = m_xRecords->getRecords().begin();
		aGuard.clear();
		getCurrentValues();
	}
	m_xRecords->m_bNew = FALSE;
	return bFetched;
}

BOOL OAddressBookCursor::moveRelative(INT32 nCount) THROWS( (UsrSystemException) )
{
	OClearableGuard aGuard( m_xRecords->getMutex() );
	list<ORecord>::iterator aCur = m_aCurRecord;
	while( nCount < 0 && aCur != m_xRecords->getRecords().end() )
	{
		nCount++;
		if( aCur == m_xRecords->getRecords().begin() ) 
			aCur = m_xRecords->getRecords().end();
		else aCur--;
	}
	if( nCount < 0 ) return FALSE;
	while( nCount > 0 && ++aCur != m_xRecords->getRecords().end() )
		nCount--;
	if( nCount )
	{
		while( nCount-- )
			if( !fetchRecord() ) 
			{
		m_aCurRecord = m_xRecords->getRecords().end();
				return FALSE;
			}
		
		m_aCurRecord = m_xRecords->getRecords().end();
		m_aCurRecord--;
	}
	else m_aCurRecord = aCur;
	m_xRecords->m_bNew = FALSE;
	aGuard.clear();
	getCurrentValues();
	return TRUE;
}

BOOL OAddressBookCursor::moveToLast(void) THROWS( (UsrSystemException) )
{
	OClearableGuard aGuard( m_xRecords->getMutex() );
	while( fetchRecord() );
	m_aCurRecord = m_xRecords->getRecords().end();
	if( m_aCurRecord != m_xRecords->getRecords().begin() )
		m_aCurRecord--;
	if( isValid() )
	{
		m_xRecords->m_bNew = FALSE;
		aGuard.clear();
		getCurrentValues();
		return TRUE;
	}
	return FALSE;
}


void OAddressBookCursor::addRecord(void) THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_xRecords->getMutex() );
	moveToLast();
	ORecord aRecord;
	m_xRecords->getRecords().push_back( aRecord );
	m_aCurRecord = m_xRecords->getRecords().end();
	m_aCurRecord--;
	m_xRecords->m_bNew = TRUE;
}

void OAddressBookCursor::editRecord(void) THROWS( (UsrSystemException) )
{
}

INT32 OAddressBookCursor::updateRecord(void) THROWS( (UsrSystemException) )
{
	OGuard aGuard( m_xRecords->getMutex() );
	if( !m_xRecords->m_bNew )
	{
		m_xRecords->m_xCont->updateRecord( m_Uid, m_Values );
		*m_aCurRecord = *this;
	}
	else 
	{
		AddressBookParameteredPropertyValue* pValuesStart = m_Values.getArray();
		AddressBookParameteredPropertyValue* pValuesEnd = pValuesStart + m_Values.getLen();
		for( ; pValuesStart != pValuesEnd; pValuesStart++ )
			if( pValuesStart->Name == L"Uid" )
				break;
		if( pValuesStart == pValuesEnd )
		{
			INT32 nLen = m_Values.getLen();
			m_Values.realloc( nLen + 1);
			pValuesStart = m_Values.getArray() + nLen;
			pValuesStart->Name = L"Uid";
		}
		
		AddressBookParameteredValue* pUid = 0;
		if( !pValuesStart->Values.getLen() )
			pValuesStart->Values.realloc( 1 );
		pUid = pValuesStart->Values.getArray();

		UString aUid;
		pUid->Value >>= aUid;
		if( !aUid.len() )
		{
		Sequence<UString> aUids = m_xRecords->m_xCont->createUids( m_SchemaName, 1 );
			pUid->Value <<= aUids.getConstArray()[ 0 ];
		}
		m_xRecords->m_xCont->insertRecord( m_SchemaName, m_Values );
		pUid->Value >>= m_Uid;
		*m_aCurRecord = *this;
		m_xRecords->m_bNew = FALSE;
	}
	return 1;
}

INT32 OAddressBookCursor::deleteRecord(void) THROWS( (UsrSystemException) )
{
	OClearableGuard aGuard( m_xRecords->getMutex() );
	if( isValid() )
	{
		m_xRecords->m_xCont->removeRecord( m_Uid );
		m_xRecords->removeRecord( m_aCurRecord );
		aGuard.clear();
		getCurrentValues();
		return 1;
	}
	return 0;
}

void OAddressBookCursor::restoreRecord(void) THROWS( (UsrSystemException) )
{
	getCurrentValues();
}

UsrAny OAddressBookCursor::getBookmark(void) const THROWS( (UsrSystemException) )
{
	OClearableGuard aGuard( m_xRecords->getMutex() );
	return UsrAny( m_Uid );
}

BOOL OAddressBookCursor::moveToBookmark(const UsrAny& aBookmark) THROWS( (IllegalArgumentException, UsrSystemException) )
{
	OClearableGuard aGuard( m_xRecords->getMutex() );
	UString aUid;
	aBookmark >>= aUid;
	for( list<ORecord>::iterator aCur = m_xRecords->getRecords().begin(); 
		 aCur != m_xRecords->getRecords().end();
		 aCur++ )
		if( (*aCur).m_Uid == aUid )
		{
			m_aCurRecord = aCur;
			aGuard.clear();
			getCurrentValues();
			return TRUE;
		}
	while( fetchRecord() )
	{
		if( m_xRecords->m_aRecords.back().m_Uid == aUid )
		{
			m_aCurRecord = m_xRecords->getRecords().end();
			m_aCurRecord--;
			aGuard.clear();
			getCurrentValues();
			return TRUE;
		}
	}
	return FALSE;
}
 
void OAddressBookCursor::getCurrentValues()
{
	if( isValid() )
	{
		Sequence<PropertyValue> aValues;
		{
			OGuard aGuard( m_aMutex );
			ORecord::operator=( ORecord() );
		}
		{
			OClearableGuard aGuard( m_xRecords->getMutex() );
			if( isValid() ) 
				aValues = OObjectClass<ORecord>::getInstance().
					getPropertyValues( &*m_aCurRecord );
		}
		setPropertyValues( aValues );
	}
}


BOOL OAddressBookCursor::fetchRecord()
{
	OGuard aGuard( m_xRecords->m_aMutex );
	if( m_xRecords->m_bDone ) return FALSE;
	if( m_xRecords->m_xEnum->hasMoreElements() )
	{
		XPropertyAccessRef xProp;
		extractInterface( m_xRecords->m_xEnum->nextElement(), xProp );
		ORecord aRecord;
		OObjectClass<ORecord>::getInstance().setPropertyValues(
			&aRecord, xProp->getPropertyValues() );
		m_xRecords->m_aRecords.push_back( aRecord );
		return TRUE;
	}
	else
	{
		m_xRecords->m_bDone = TRUE;
		return FALSE;
	}
}

void OAddressBookCursor::removingRecord( list<ORecord>::iterator& rIter )
{
	if( rIter == m_aCurRecord )	 m_aCurRecord++;
}

XCloneableRef OAddressBookCursor::createClone()
{
	XCloneableRef xRet = new OAddressBookCursor( m_xRecords );
	xRet->release();
	return xRet;
}

void OAddressBookCursor::cancel()
{
	XCancellableRef xCancel( m_xRecords->m_xEnum, USR_QUERY );
	if( xCancel.is() ) xCancel->cancel();
}

void OAddressBookCursor::initialize( const Sequence<UsrAny>& rArgs )
{
	XPropertySetRef                xDesc;
	const UsrAny* pArgs = rArgs.getConstArray();
	if( rArgs.getLen() != 2 || !extractInterface( 
		pArgs[ 0 ], m_xRecords->m_xCont ) || !extractInterface(pArgs[ 1 ], xDesc ) )
		THROW( IllegalArgumentException() );
	m_xRecords->m_xEnum = m_xRecords->m_xCont->query( xDesc );
	moveToFirst();
}

XIdlClassRef OAddressBookCursor::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookCursor", 
		OPropertySet::getStaticIdlClass(), 5,
		XScheduleUpdateCursor_getReflection(), 
		XScheduleBookmarkCursor_getReflection(), 
		XCancellable_getReflection(), 
		XCloneable_getReflection(), 
		XInitialization_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookCursor::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookCursor::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XCloneable );
	QUERYIFACE( XCancellable );
	QUERYIFACE( XScheduleBookmarkCursor );
	QUERYIFACE( XScheduleUpdateCursor );
	QUERYIFACE( XScheduleCursor );
	QUERYIFACE( XScheduleRecordSupplier );
	QUERYIFACE( XInitialization );
	return OPropertySet::queryInterface( aUik, rOut );
}


BOOL isLessSequenceUString( const Sequence<UString>& r1, 
							const Sequence<UString>& r2 )
{
	INT32 nCur = r2.getLen();
	if( r1.getLen() < nCur ) return TRUE;
	if( r1.getLen() > nCur ) return FALSE;
	const UString* pCur1 = r1.getConstArray();
	const UString* pCur2 = r2.getConstArray();
	for( ; nCur--; )
	{
		if( pCur1[ nCur ] > pCur2[ nCur ] ) return FALSE;
		if( pCur1[ nCur ] < pCur2[ nCur ] ) return TRUE;
	}
	return FALSE;
}

OAddressBookDatabaseDriverSettings::OAddressBookDatabaseDriverSettings( 
	const XMultiServiceFactoryRef& xMgr )
	: 
	OPropertySet( 
		m_aMutex, this, 
		OObjectClass<OAddressBookDatabaseDriverSettings>::getInstance(), 
		false ), 
	m_xMgr( xMgr ), OPersistentPropertySet( m_aMutex, xMgr, L"dbadr" )
{
	acquire();
	load();
	// if we have no settings import default settings
	if( !m_Sources.getLen() )
	{
		XNameAccessRef xSettings( m_xMgr->createInstance(
			L"com.sun.star.frame.Settings" ), USR_QUERY );
		if( xSettings.is() )
		{
			XPropertySetRef xProps;
			extractInterface( xSettings->getByName( L"PathSettings" ), xProps );
			UString aPath;
			if( xProps.is() && (
				xProps->getPropertyValue( L"Config" )  >>= aPath ) )
			{
				aPath = SHOULDBEUNICODE( 
					( DirEntry( SHOULDTAKEUNICODE( aPath ) ) + 
					  DirEntry( "dbsettings.act" ) ).GetFull());
				UsrAny aFileNameAny( aPath );
				// fill source with standard data
				XAddressBookXMLImportRef xImport(
					m_xMgr->createInstance( 
						L"com.sun.star.address.XMLImport" ), USR_QUERY );
				UsrAny aSrc;
				aSrc <<= XPropertySetRef( this );
				xImport->setTarget( aSrc );
				
				XParserRef xParser(
					m_xMgr->createInstance( 
						L"com.sun.star.xml.sax.Parser" ), USR_QUERY );
				xParser->setDocumentHandler(
					XDocumentHandlerRef( xImport, USR_QUERY ) );
				InputSource aSource;
				aSource.aInputStream = XInputStreamRef(
					m_xMgr->createInstanceWithArguments(
						L"com.sun.star.address.InputStream", 
						Sequence<UsrAny>( &aFileNameAny, 1 ) ), USR_QUERY );
				TRY
					{
						xParser->parseStream( aSource );
					}
				CATCH( SAXException, e )
					{
					}
				END_CATCH;
			}
		}
	}
}


XIdlClassRef OAddressBookDatabaseDriverSettings::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.AddressBookDatabaseDriverSettings", 
		OPropertySet::getStaticIdlClass(), 1,
		XTerminateListener_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookDatabaseDriverSettings::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookDatabaseDriverSettings::queryInterface( 
	Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XTerminateListener );
	return OPropertySet::queryInterface( aUik, rOut );
}

inline BOOL isEqual( const DatabaseDriverAddressBookTableField& r1, 
					 const DatabaseDriverAddressBookTableField& r2 )
{
	return r1.Name == r2.Name && r1.AddressBookName == r2.AddressBookName &&
		isEqual( r1.Parameters, r2.Parameters ) && r1.Count == r2.Count;
}

DECLARE_SEQEQUAL( DatabaseDriverAddressBookTableField )

inline BOOL isEqual( const DatabaseDriverAddressBookTableDefinition& r1, 
					 const DatabaseDriverAddressBookTableDefinition& r2 )
{
	return r1.Name == r2.Name && r1.SchemataPattern == r2.SchemataPattern &&
		isEqual( r1.FieldMappings, r2.FieldMappings );
}

DECLARE_SEQEQUAL( DatabaseDriverAddressBookTableDefinition )

inline BOOL isEqual( const DatabaseDriverAddressBookSourceDefinition& r1, 
					 const DatabaseDriverAddressBookSourceDefinition& r2 )
{
	return r1.SourcePattern == r2.SourcePattern && isEqual( r1.Tables, r2.Tables );
}

DECLARE_SEQEQUAL( DatabaseDriverAddressBookSourceDefinition )

void OAddressBookDatabaseDriverSettings::fillClassInfo(
	OObjectClassBase*& rpParentClass, Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookDatabaseDriverSettings, Sources, PropertyAttribute_BOUND )
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

XInterfaceRef OAddressBookDatabaseDriverSettings::create( 
	const XMultiServiceFactoryRef& xMgr ) 
{ 
	XInterfaceRef xRef = *new OAddressBookDatabaseDriverSettings( xMgr ); 
	xRef->release();
	return xRef;
}



#ifndef _SV_SVAPP_HXX //autogen wg. Application
#include <vcl/svapp.hxx>
#endif

BOOL isSolarThread()
{
	return Application::GetMainThreadIdentifier() == 
		OThread::getCurrentIdentifier();
}

struct OUnguard
{
	INT32 nCount;
	OUnguard();
	~OUnguard();
};

OUnguard::OUnguard()
	: nCount( Application::ReleaseSolarMutex() )
{
}

OUnguard::~OUnguard()
{
	Application::AcquireSolarMutex( nCount );
}

void waitCondition( OCondition& rCond )
{
		OUnguard aGuard;
		rCond.wait();
	}

XIdlClassRef OUniqueIDFactory::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OUniqueIDFactory", 
		UsrObject::getUsrObjectIdlClass(), 1,
		XUniqueIDFactory_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OUniqueIDFactory::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OUniqueIDFactory::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XUniqueIDFactory );
	return UsrObject::queryInterface( aUik, rOut );
}

UString OUniqueIDFactory::createUniqueID() THROWS( ( UsrSystemException))
{
	static long nNr = 0;
	String aSubUid = Time::GetSystemTicks();
	((( aSubUid += '-' ) += rand() ) += '-' ) += nNr++;
	return SHOULDBEUNICODE( aSubUid );
}



