/*************************************************************************
 *
 *  $RCSfile: address.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_ADDRESS_HXX
#define _ADR_ADDRESS_HXX

#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANCELLEDEXCEPTION_HXX_
#include <smart/com/sun/star/address/CancelledException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKSOURCEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookSourceDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTYVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredPropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPROPERTYPARAMETERINFO_HXX_
#include <smart/com/sun/star/address/AddressBookPropertyParameterInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XSYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XSynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENTTYPE_HXX_
#include <smart/com/sun/star/address/JobEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYFUNCTION_HXX_
#include <smart/com/sun/star/address/AddressBookQueryFunction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKSCHEMATASUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookSchemataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOB_HXX_
#include <smart/com/sun/star/address/XJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYPARSER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryParser.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASEFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKJOBFACTORYSUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookJobFactorySupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBLISTENER_HXX_
#include <smart/com/sun/star/address/XJobListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRECORDCONTAINER_HXX_
#include <smart/com/sun/star/address/XAddressBookRecordContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEFIELD_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableField.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYWRITER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryWriter.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENT_HXX_
#include <smart/com/sun/star/address/JobEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XASYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XAsynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTY_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredProperty.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASESCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYTERM_HXX_
#include <smart/com/sun/star/address/AddressBookQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSORTINFO_HXX_
#include <smart/com/sun/star/address/AddressBookSortInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANTCONNECTEXCEPTION_HXX_
#include <smart/com/sun/star/address/CantConnectException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCOPE_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPScope.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRESULTSETDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/address/XAddressBookResultSetDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBFACTORY_HXX_
#include <smart/com/sun/star/address/XJobFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XTASKSSUPPLIER_HXX_
#include <smart/com/sun/star/frame/XTasksSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XDESKTOPTASK_HXX_
#include <smart/com/sun/star/frame/XDesktopTask.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_WINDOWARRANGE_HXX_
#include <smart/com/sun/star/frame/WindowArrange.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_TERMINATIONVETOEXCEPTION_HXX_
#include <smart/com/sun/star/frame/TerminationVetoException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XTERMINATELISTENER_HXX_
#include <smart/com/sun/star/frame/XTerminateListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XWINDOWARRANGER_HXX_
#include <smart/com/sun/star/frame/XWindowArranger.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XTASK_HXX_
#include <smart/com/sun/star/frame/XTask.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XDESKTOP_HXX_
#include <smart/com/sun/star/frame/XDesktop.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XASSIGNABLE_HXX_
#include <smart/com/sun/star/schedule/XAssignable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEQUERYTERM_HXX_
#include <smart/com/sun/star/schedule/ScheduleQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEBUSYTIME_HXX_
#include <smart/com/sun/star/schedule/XScheduleBusyTime.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULERESULTSETCHANGEDBROADCASTER_HXX_
#include <smart/com/sun/star/schedule/XScheduleResultSetChangedBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULERESULTSETCHANGEDEVENT_HXX_
#include <smart/com/sun/star/schedule/ScheduleResultSetChangedEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEPRINTCONTEXTSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XSchedulePrintContextSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULECURSORTYPE_HXX_
#include <smart/com/sun/star/schedule/ScheduleCursorType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECONFIGURATIONSSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleConfigurationsSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSTRINGPROPERTYACCESS_HXX_
#include <smart/com/sun/star/schedule/XStringPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XINDEXFACTORYCONTAINER_HXX_
#include <smart/com/sun/star/schedule/XIndexFactoryContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEPROTOCOLPROVIDER_HXX_
#include <smart/com/sun/star/schedule/XScheduleProtocolProvider.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULERESULTSETCHANGEDLISTENER_HXX_
#include <smart/com/sun/star/schedule/XScheduleResultSetChangedListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECURSORFACTORY_HXX_
#include <smart/com/sun/star/schedule/XScheduleCursorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEWRITECONTAINER_HXX_
#include <smart/com/sun/star/schedule/XScheduleWriteContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEGROUPING_HXX_
#include <smart/com/sun/star/schedule/XScheduleGrouping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEDEFAULTCONFIGURATIONUIDSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleDefaultConfigurationUidSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEUIDACCESS_HXX_
#include <smart/com/sun/star/schedule/XScheduleUidAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSION_HXX_
#include <smart/com/sun/star/schedule/XScheduleSession.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSIONMANAGER_HXX_
#include <smart/com/sun/star/schedule/XScheduleSessionManager.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_DURATION_HXX_
#include <smart/com/sun/star/schedule/Duration.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULERESULTSETCHANGEDEVENTTYPE_HXX_
#include <smart/com/sun/star/schedule/ScheduleResultSetChangedEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XNAMETRANSLATOR_HXX_
#include <smart/com/sun/star/schedule/XNameTranslator.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESERVERSSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleServersSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECONFIGURATIONSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleConfigurationSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSIONFACTORY_HXX_
#include <smart/com/sun/star/schedule/XScheduleSessionFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECURSORDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/schedule/XScheduleCursorDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSIONSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleSessionSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XCLONEABLE_HXX_
#include <smart/com/sun/star/util/XCloneable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XINITIALIZATION_HXX_
#include <smart/com/sun/star/lang/XInitialization.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XUNIQUEIDACCESS_HXX_
#include <smart/com/sun/star/container/XUniqueIDAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEUPDATECURSOR_HXX_
#include <smart/com/sun/star/schedule/XScheduleUpdateCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEBOOKMARKCURSOR_HXX_
#include <smart/com/sun/star/schedule/XScheduleBookmarkCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEUPDATECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseUpdateCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEBOOKMARKCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseBookmarkCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XUNIQUEIDFACTORY_HXX_
#include <smart/com/sun/star/util/XUniqueIDFactory.hxx>
#endif


#ifndef _VOS_CONDITN_HXX_ //autogen wg. OCondition
#include <vos/conditn.hxx>
#endif


#include <propset.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif



// for our special friend, the solaris cc:
inline BOOL operator<( const UsrAny& r1, const UsrAny& r2 ) 
{
	return FALSE;
}

inline BOOL operator==( const UsrAny& r1, const UsrAny& r2 ) 
{
	return FALSE;
}

class OEnumeration : 
	public UsrObject, public XCancellable, public XJobListener, 
	public XEnumeration
{
public:
	SMART_UNO_DECLARATION( OEnumeration, UsrObject );
	OEnumeration( const XCancellableRef& rCancel ): 
		m_xCancel( rCancel ), m_bDone( FALSE ) {}
	
	virtual void cancel() { m_xCancel->cancel(); }
	
	virtual void   updateJobState( const JobEvent& rEvent );

	virtual BOOL hasMoreElements();
	virtual UsrAny nextElement();
			
	virtual void   disposing( const EventObject& rObj ){}

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

private:
	list<UsrAny > m_aData;
	XCancellableRef        m_xCancel;
	OMutex                 m_aMutex;
	OCondition             m_aDataAvailable;
	UsrAny                 m_aException;
	BOOL                   m_bDone;
};


class OGeneralJob : 
	public UsrObject, 
	public XAsynchronJob, 
	public XSynchronJob,
	public XJobListener
{
public:
	SMART_UNO_DECLARATION( OGeneralJob, UsrObject );
	OGeneralJob( const XInterfaceRef& xJob )
		: m_xAsync( xJob, USR_QUERY ),
		  m_xSync( xJob, USR_QUERY ){}

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	virtual void cancel();
	virtual void resume();
	virtual void suspend();
	virtual UsrAny executeSynchron();
	virtual void   executeAsynchron( const XJobListenerRef& xCallback );

	virtual void   updateJobState( const JobEvent& rEvent );
	virtual void   disposing( const EventObject& rObj ){}
	
private:
	XAsynchronJobRef m_xAsync;
	XSynchronJobRef  m_xSync;
	OMutex           m_aMutex;
	OCondition       m_aDone;
	UsrAny           m_aResult;
	UsrAny           m_aException;
	XJobListenerRef  m_xCallback;
};

class OGeneralJobFactory : 
	public UsrObject, public XJobFactory, public XInitialization
{
public:
	SMART_UNO_DECLARATION( OGeneralJobFactory, UsrObject );

	static XInterfaceRef create( const XMultiServiceFactoryRef& ) { return *new OGeneralJobFactory(); }

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	virtual void initialize( const Sequence<UsrAny>& rArgs );
	virtual XInterfaceRef createJob( 
		const UString& rType, const Sequence<UsrAny>& rArgs );
private:
	XJobFactoryRef m_xFactory;
};


inline BOOL isEqual( 
	const AddressBookSortInfo& rFirst, const AddressBookSortInfo& rSecond )
{
	return rFirst.Property == rSecond.Property &&
		rFirst.Ascending == rSecond.Ascending;
}

inline BOOL isEqual( 
	const AddressBookPropertyParameterInfo& rFirst, 
	const AddressBookPropertyParameterInfo& rSecond )
{
	return rFirst.MinCount == rSecond.MinCount &&
		rFirst.MaxCount == rSecond.MaxCount && 
		isEqual( rFirst.Parameters, rSecond.Parameters ) &&
		rFirst.IsWritable == rSecond.IsWritable;
}

DECLARE_SEQEQUAL( AddressBookPropertyParameterInfo )
DECLARE_SEQEQUAL( AddressBookSortInfo )

inline BOOL isEqual( 
	const AddressBookParameteredProperty& rFirst, 
	const AddressBookParameteredProperty& rSecond )
{
	return rFirst.MinCount == rSecond.MinCount &&
		rFirst.MaxCount == rSecond.MaxCount && 
		isEqual( rFirst.Parameters, rSecond.Parameters )&&
				 rFirst.Type->equals( rSecond.Type ) &&
		isEqual( rFirst.AllowedParameterCombinations,
				 rSecond.AllowedParameterCombinations ) &&
		rFirst.IsWritable == rSecond.IsWritable;
}


inline BOOL isEqual( 
	const AddressBookParameteredValue& rFirst, 
	const AddressBookParameteredValue& rSecond )
{
	if( !isEqual( rFirst.Parameters, rSecond.Parameters ) )
		return FALSE;
	return isEqual( rFirst.Value, rSecond.Value );
}

DECLARE_SEQEQUAL( AddressBookParameteredProperty )
DECLARE_SEQEQUAL( AddressBookParameteredValue )

inline BOOL isEqual( 
	const AddressBookParameteredPropertyValue& rFirst, 
	const AddressBookParameteredPropertyValue& rSecond )
{
	if( !isEqual( (const AddressBookParameteredProperty&)rFirst, 
				  (const AddressBookParameteredProperty&)rSecond ) )
		return FALSE;
	return isEqual( rFirst.Values, rSecond.Values );
}

DECLARE_SEQEQUAL( AddressBookParameteredPropertyValue )

class OResultSetDescriptorData : public OPropertyObject
{
public:
	static void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	Sequence<UString>             m_RequestedProperties;
	UString                       m_Query;
	Sequence<AddressBookSortInfo> m_Sorting;
	Sequence<UString>             m_Schemata;
};

class OResultSetDescriptor : public OPropertySet, public OResultSetDescriptorData
{
public:
	SMART_REFLECTION_DECLARATION( OResultSetDescriptor, OPropertySet );
	OResultSetDescriptor();

	static XInterfaceRef createInstance( const XMultiServiceFactoryRef& xMgr ){
		return *new OResultSetDescriptor( ); }		
private:
	NAMESPACE_VOS( OMutex )       m_aMutex;
};

class OAddressBookSchemaData : public OPropertyObject
{
public:
	static void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	const UString& getName() const { return m_Name; }
	UString                                  m_Name;
	Sequence<AddressBookParameteredProperty> m_Properties;
	BOOL                                     m_IsInsertable;
protected:
};

class OAddressBookSimpleSchema : 
	public OAddressBookSchemaData, public OPropertySet
{
public:
	OAddressBookSimpleSchema( const Sequence<PropertyValue>& rValues );
private:
	OMutex                         m_aMutex;
};

class OAddressBookSimpleSchemata : 
	public ONameContainerHelper<XPropertySetRef>, public NAMESPACE_USR(OComponentHelper)
{
public:
	SMART_UNO_DECLARATION( OAddressBookSimpleSchemata, OComponentHelper );
	OAddressBookSimpleSchemata( 
		const Sequence<Sequence<PropertyValue> >& rSchemata );
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
private:
	hashmap m_aHashMap;
	NAMESPACE_VOS( OMutex ) m_aMutex;
};

class OStandalonePropertySet : public OPropertySet
{
public:
	OStandalonePropertySet( OPropertyObject* pObj, const OObjectClassBase& rClass )
		: OPropertySet( m_aMutex, pObj, rClass, true )
		{
		}
protected:
	NAMESPACE_VOS( OMutex ) m_aMutex;
};

// since we don't have member function templates on all compilers yet,
// we have to rely on ORecord::operator< to provide the ordering for
// the sorting of the ResultSet. thus the sorting criterion can be set
// on ORecord


class ORecord;
// Fuer unsere aelteren Compiler und die stl:
inline BOOL operator==( const ORecord&, const ORecord& ) { return FALSE; }

class ORecordSortInfo;
class ORecord : public OPropertyObject
{
public:
	ORecord() : m_IsRemovable( FALSE ){}
	void setSorting( const Sequence<AddressBookSortInfo>* pSorting ) {
		m_pSorting = pSorting; }

	BOOL operator<( const ORecord& rArg ) const;
	const AddressBookParameteredPropertyValue* getProperty( 
		const UString& rName ) const;

	Sequence<AddressBookParameteredPropertyValue> m_Values;
	Sequence<AddressBookParameteredProperty>      m_Properties;
	UString                                       m_Uid;
	UString                                       m_SchemaName;
	BOOL                                          m_IsRemovable;

	static void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );
private:
	
	const Sequence<AddressBookSortInfo>*    m_pSorting;
	
	friend class OAddressRecordClass;
	friend class OAddressResultSet;
};


class OResultSet
{
public:
	OResultSet( const Sequence<AddressBookSortInfo>& rSorting );
	void              appendRecord( const ORecord& rRecord  );
	list<ORecord>&    getRecords() { return m_aRecords; }
	const Sequence<AddressBookSortInfo>& getSorting() const;
			
private:
	Sequence<AddressBookSortInfo> m_aSorting;
	list<ORecord>                 m_aRecords;
};

// wg. msvc4.1 bug (siehe intradoku/entwicklung/schedule/stl.txt Punkt 1)
// 

#ifdef WNT

__BEGIN_STL_NAMESPACE

 inline list<ORecord>::iterator* value_type(
 	const vector<list<ORecord>::iterator>::iterator& ) { 
 	return (list<ORecord>::iterator*)(0); }

__END_STL_NAMESPACE

#endif


class OAddressBookResultSet : 
	public NAMESPACE_USR( OComponentHelper ),
	public XEnumeration,
	public XCancellable
{
public:
	SMART_UNO_DECLARATION( OAddressBookResultSet, OComponentHelper );

	OAddressBookResultSet( 
		const XEnumerationRef xEnum  ) : OComponentHelper( m_aMutex ), m_xEnum( xEnum ) {}

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	// XEnumeration
	BOOL hasMoreElements();
	UsrAny nextElement();

	// XCancellable
	void cancel();

	NAMESPACE_VOS( IMutex )& getMutex() const { 
		return (NAMESPACE_VOS(IMutex )&) m_aMutex; }
private:

	NAMESPACE_VOS( OMutex )     m_aMutex;
	XEnumerationRef             m_xEnum;
};


struct OAddressBookSourceData : public OPropertyObject
{
	UString  m_ServiceName;
	UString  m_Name;
	UString  m_Uid;
	Sequence<UString>  m_Types;
	BOOL     m_ReadOnly;

	OAddressBookSourceData() : m_ReadOnly( FALSE )
		{
		}
	
	static void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );
};


class OAddressBookSourceAccess : 
	public OPropertySet,
	public XAddressBookSchemataSupplier,
	public XAddressBookResultSetDescriptorFactory,
	public XAddressBookRecordContainer,
	public XCancellable,
	public XInitialization,
	public OPropertyObject
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceAccess, OPropertySet );
	static XInterfaceRef create( const XMultiServiceFactoryRef& ) { 
		return *new OAddressBookSourceAccess(); }
	

	static void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	OAddressBookSourceAccess() 
		: OPropertySet( 
			m_aMutex, this, 
			OObjectClass<OAddressBookSourceAccess>::getInstance(), false ),
		m_IsInsertable( FALSE ), m_bPropertiesGot( FALSE ){}

	virtual void cancel();
	virtual void initialize( const Sequence<UsrAny>& rArgs );
	virtual XInterfaceRef createResultSetDescriptor();
	
    virtual XNameAccessRef getSchemata(void) THROWS( (UsrSystemException) );

    virtual Sequence< UString > createUids(const UString& schema, INT16 count) THROWS( (UsrSystemException) );
    virtual XEnumerationRef query(const XPropertySetRef& queryDescriptor) THROWS( (UsrSystemException) );
    virtual void insertRecord(const UString& schema, const Sequence< AddressBookParameteredPropertyValue >& values) THROWS( (UsrSystemException) );
    virtual void updateRecord(const UString& uid, const Sequence< AddressBookParameteredPropertyValue >& values) THROWS( (UsrSystemException) );
    virtual void removeRecord(const UString& uid) THROWS( (UsrSystemException) );
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	void registerJob( const XSynchronJobRef& xJob );
	void unregisterJob( const XSynchronJobRef& xJob );

	OMutex& getMutex() const { return (OMutex&)m_aMutex;}
protected:
	virtual void getFastPropertyValue( 
		UsrAny& rValue, INT32 nHandle ) const;

private:
	BOOL m_IsInsertable;

	BOOL m_bPropertiesGot;

	class OJobContext
	{
	public:
		OJobContext( const OAddressBookSourceAccess* pAccess, 
					 const XSynchronJobRef& xJob )
			: m_xJob( xJob ), m_pAccess( (OAddressBookSourceAccess*)pAccess ){ 
			m_pAccess->registerJob( xJob ); }
		~OJobContext() { m_pAccess->unregisterJob( m_xJob ); }
	private:
		OAddressBookSourceAccess* m_pAccess;
		XSynchronJobRef           m_xJob;
	};

	XJobFactoryRef          m_xJobFactory;
	vector<XCancellableRef> m_aRunningJobs;
	XNameAccessRef          m_xSchemata;
	OMutex                  m_aMutex;
};


//////////////////////////////////////////////////////////


class OAddressBookSourceSchedule : 
	public OAddressBookSourceData, 
	public OPropertySet,
	public XAddressBookJobFactorySupplier,
	public XJobFactory
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceSchedule, OPropertySet );
	OAddressBookSourceSchedule( const XMultiServiceFactoryRef& xMgr )
		: OPropertySet( 			
			m_aMutex, this, 
			OObjectClass<OAddressBookSourceSchedule>::getInstance(), false ),
						   m_xMgr( xMgr )
		{ m_ServiceName = L"com.sun.star.address.AddressBookSourceSchedule"; }
	
	static void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual XJobFactoryRef getJobFactory();
	virtual XInterfaceRef createJob( 
		const UString& rType, const Sequence<UsrAny>& rArgs );

	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr ) { 
		return *new OAddressBookSourceSchedule( xMgr ); }

	OMutex&                getMutex() const { return (OMutex&)m_aMutex; }
	XScheduleCursorRef     getScheduleCursor();

private:
	friend class OAddressBookSourceProtocolSchedule;

	OMutex                   m_aMutex;
	XMultiServiceFactoryRef  m_xMgr;

	UString                  m_ServerName;
	XJobFactoryRef           m_xJobFactory;
	XScheduleCursorRef       m_xCursor;
};

USR_DECLIMPL_OBJECT_REF( OAddressBookSourceSchedule )

class OAddressBookSourceScheduleSynchronJob : 
	public OComponentHelper,
	public XSynchronJob
{
public:
	SMART_UNO_DECLARATION( 
		OAddressBookSourceScheduleSynchronJob, OComponentHelper );

	OAddressBookSourceScheduleSynchronJob( 
		const UString& rType,
		const OAddressBookSourceScheduleRef& rSource,
		const Sequence<UsrAny>& rArgs ) :
		m_aArgs( rArgs ), m_xSource( rSource ),	m_aType( rType ),
		OComponentHelper( m_aMutex )
		{
		}
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void cancel() {}
	virtual void resume() {}
	virtual void suspend() {}
	virtual UsrAny executeSynchron();

private:

	NAMESPACE_VOS( OMutex )        m_aMutex;
	UString                        m_aType;
	OAddressBookSourceScheduleRef  m_xSource;
	Sequence<UsrAny>               m_aArgs;
};

class OAddressBookSourceScheduleAsynchronJob : 
	public OComponentHelper,
	public XAsynchronJob
{
public:
	SMART_UNO_DECLARATION( 
		OAddressBookSourceScheduleAsynchronJob, OComponentHelper );

	OAddressBookSourceScheduleAsynchronJob( 
		const XMultiServiceFactoryRef& xMgr, 
		const UString& rType,
		const OAddressBookSourceScheduleRef& rSource,
		const Sequence<UsrAny>& rArgs ) :
		m_aArgs( rArgs ), m_xSource( rSource ), m_bCanceled( FALSE ),
		m_aType( rType ), OComponentHelper( m_aMutex ), m_xMgr( xMgr )
		{
		}
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void cancel() {}
	virtual void resume() {}
	virtual void suspend() {}
	virtual void executeAsynchron( const XJobListenerRef& xCallback );

private:

	NAMESPACE_VOS( OMutex )        m_aMutex;
	BOOL                           m_bCanceled;
	UString                        m_aType;
	OAddressBookSourceScheduleRef  m_xSource;
	Sequence<UsrAny>               m_aArgs;
	XMultiServiceFactoryRef        m_xMgr;
};

class OAddressBookQueryParser : 
	public NAMESPACE_USR( OWeakObject ), 
	public XAddressBookQueryParser,
	public XAddressBookQueryWriter
{
 public:
	OAddressBookQueryParser(){}
	SMART_UNO_DECLARATION( OAddressBookQueryParser, OWeakObject );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	virtual AddressBookQueryTerm parseTerm(const UString& query) 
		THROWS( (UsrSystemException) );
	virtual UString writeTerm(const AddressBookQueryTerm& term) 
		THROWS( (UsrSystemException) );

	static XInterfaceRef createInstance( const XMultiServiceFactoryRef& ) { 
		return *new OAddressBookQueryParser(); }
 private:
	UString writeOpTerm(
		const UString& rOp, const Sequence<UsrAny>& rArgs, BOOL bWithStars );

	NAMESPACE_VOS( OMutex ) m_aMutex;
};


class OAddressBookEvaluator
{
public:
	OAddressBookEvaluator(const  AddressBookQueryTerm& rTerm );
	BOOL evaluateTerm( 
		const ORecord* pObject ) {
		return evaluateTerm( m_aTerm, pObject ); }

	static vector<UString> getFields( const AddressBookQueryTerm& rTerm );
	static void normalize( AddressBookQueryTerm& rTerm );

private:	

	BOOL evaluateTerm( 
		const AddressBookQueryTerm& rTerm, const ORecord* pObject );
	void compileTerm( AddressBookQueryTerm& rTerm );
	AddressBookQueryTerm    m_aTerm;
};


class OPersistentPropertySet : 
	public XTerminateListener
{
 public:
	OPersistentPropertySet( 
		IMutex& rMutex, const XMultiServiceFactoryRef& xMgr,
		const UString& rName );
	
	// XTerminateListener
    virtual void queryTermination(const EventObject& aEvent) THROWS( (TerminationVetoException, UsrSystemException) );
    virtual void notifyTermination(const EventObject& aEvent) THROWS( (UsrSystemException) );
	
	virtual void disposing( const EventObject& rObj ) {}
	
	void load();
	void flush();

private:

	XSimpleRegistryRef                 m_xRegistry;
	UString                            m_aName;
	NAMESPACE_VOS( IMutex )&           m_rMutex;
	XMultiServiceFactoryRef            m_xMgr;
};

class OSourceEnumeration : 
	public OEnumerationHelper< vector< XPropertySetRef >::iterator >,
	public UsrObject
{
public:
	SMART_UNO_DECLARATION( OSourceEnumeration, UsrObject );
	OSourceEnumeration( 
		vector<XPropertySetRef>::iterator aFirst, 
		vector<XPropertySetRef>::iterator aLast  );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
private:
	NAMESPACE_VOS( OMutex ) m_aMutex;
	vector< XPropertySetRef > m_aSources;
};

class OAddressBookSources : 
	public NAMESPACE_USR(OComponentHelper),
	public XSet, public XNameAccess, public XTerminateListener,
	public XContainer, public XUniqueIDAccess
{
 public:
	OAddressBookSources( const XMultiServiceFactoryRef& xMgr );
	SMART_UNO_DECLARATION( OAddressBookQueryParser, OComponentHelper );
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	static XInterfaceRef createInstance( const XMultiServiceFactoryRef& xMgr) { 
		return *new OAddressBookSources( xMgr ); }

	virtual void disposing();
	
	// XTerminateListener
    virtual void queryTermination(const EventObject& aEvent) THROWS( (TerminationVetoException, UsrSystemException) );
    virtual void notifyTermination(const EventObject& aEvent) THROWS( (UsrSystemException) );
	
	virtual void disposing( const EventObject& rObj ) {}
	
	
    virtual XIdlClassRef getElementType(void) const THROWS( (UsrSystemException) );
    virtual BOOL hasElements(void) const THROWS( (UsrSystemException) );

	
	virtual BOOL has(const UsrAny& Element) const THROWS( (UsrSystemException) );
    virtual void insert(const UsrAny& aElement) THROWS( (IllegalArgumentException, ElementExistException, UsrSystemException) );
    virtual void remove(const UsrAny& aElement) THROWS( (IllegalArgumentException, NoSuchElementException, UsrSystemException) );
    virtual XEnumerationRef createEnumeration(void) THROWS( (UsrSystemException) );

	virtual UsrAny getByName(const UString& aName) const THROWS( (NoSuchElementException, WrappedTargetException, UsrSystemException) );
    virtual Sequence< UString > getElementNames(void) const THROWS( (UsrSystemException) );
    virtual BOOL hasByName(const UString& aName) const THROWS( (UsrSystemException) );
	
	virtual UsrAny getByUniqueID(const UString& aUid) THROWS( (NoSuchElementException, UsrSystemException) );
	virtual void removeByUniqueID(const UString& aUid) THROWS( (NoSuchElementException, UsrSystemException) );

	
	virtual void addContainerListener(const XContainerListenerRef& xListener) THROWS( (UsrSystemException) );
    virtual void removeContainerListener(const XContainerListenerRef& xListener) THROWS( (UsrSystemException) );
	

	void flush();
	OMutex& getMutex() const { return (OMutex&)m_aMutex; }

	static BOOL uidToSchemaAndBasisUid( 
		const UString& rUid, UString& rSchema, UString& rBasisUid );
	static UString schemaAndBasisUidToUid(
		const UString& rSchema, const UString& rBasisUid );

private:
	void loadSection( const XRegistryKeyRef& xKey );

	OInterfaceContainerHelper          m_aListeners;
	XSimpleRegistryRef                 m_xRegistry;
	NAMESPACE_VOS( OMutex )            m_aMutex;
	XMultiServiceFactoryRef            m_xMgr;
	
	vector<XPropertySetRef>          m_aSources;
};

class IAddressBookCursorIterator
{
public:
	virtual void removingRecord( list<ORecord>::iterator& rIter ) = 0;
};

struct OAddressBookCursorResultSet : public OReference
{
	OAddressBookCursorResultSet() : m_bDone( FALSE ), m_bNew( FALSE ) {}
	IMutex& getMutex() { return m_aMutex; }
	void removeRecord( list<ORecord>::iterator& rIter );
	list<ORecord>& getRecords() { return m_aRecords; }
	void registerIterator( IAddressBookCursorIterator* pIter ) {
		m_aIterators.push_back( pIter ); }
	void unregisterIterator( IAddressBookCursorIterator* pIter ) {
		remove( m_aIterators.begin(), m_aIterators.end(), pIter ); }

	XEnumerationRef                    m_xEnum;
	XAddressBookRecordContainerRef     m_xCont;
	BOOL                               m_bDone;
	BOOL                               m_bNew;
	OMutex                             m_aMutex;
	list<ORecord>                      m_aRecords;
	vector<IAddressBookCursorIterator*> m_aIterators;
};

class OAddressBookCursor : 
	public ORecord,
	public OPropertySet, 
	public XScheduleUpdateCursor,
	public XCancellable,
	public XScheduleBookmarkCursor,
	public XInitialization, 
	public XCloneable,
	public IAddressBookCursorIterator
{
public:
	SMART_UNO_DECLARATION( OAddressBookCursor, OPropertySet );
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr ) { 
		return *new OAddressBookCursor(); }
	OAddressBookCursor( );
	OAddressBookCursor( const ORef<OAddressBookCursorResultSet>& xResult );
	~OAddressBookCursor();
	
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	virtual BOOL isValid(void) const THROWS( (UsrSystemException) );
    virtual BOOL isBeforeFirst(void) const THROWS( (UsrSystemException) );
    virtual BOOL isBehindLast(void) const THROWS( (UsrSystemException) );
    virtual BOOL isAtFirst(void) const THROWS( (UsrSystemException) );
    virtual BOOL isAtLast(void) const THROWS( (UsrSystemException) );
    virtual BOOL moveToFirst(void) THROWS( (UsrSystemException) );
    virtual BOOL moveRelative(INT32 nCount) THROWS( (UsrSystemException) );
    virtual BOOL moveToLast(void) THROWS( (UsrSystemException) );

	virtual XPropertySetRef getRecord(void) const THROWS( (UsrSystemException) ) { 
		return (XPropertySet*) this; }

	virtual void addRecord(void) THROWS( (UsrSystemException) );
    virtual void editRecord(void) THROWS( (UsrSystemException) );
    virtual INT32 updateRecord(void) THROWS( (UsrSystemException) );
    virtual INT32 deleteRecord(void) THROWS( (UsrSystemException) );
    virtual void restoreRecord(void) THROWS( (UsrSystemException) );

    virtual UsrAny getBookmark(void) const THROWS( (UsrSystemException) );
    virtual BOOL moveToBookmark(const UsrAny& aBookmark) THROWS( (IllegalArgumentException, UsrSystemException) );

	virtual void cancel();
	virtual void initialize( const Sequence<UsrAny>& rArgs );

	XCloneableRef createClone();

	virtual void removingRecord( list<ORecord>::iterator& rIter );



private:
	void getCurrentValues();
	BOOL fetchRecord();

	ORef<OAddressBookCursorResultSet> m_xRecords;
	list<ORecord>::iterator        m_aCurRecord;
	OMutex                         m_aMutex;
};

void waitCondition( OCondition& rCond );
BOOL isSolarThread();


BOOL isLessSequenceUString( const Sequence<UString>& r1, 
							const Sequence<UString> &r2 );

inline BOOL isLessProperty( 
	const AddressBookParameteredProperty& rFirst, const AddressBookParameteredProperty& rSecond )
{
	return rFirst.Name < rSecond.Name;
}

inline BOOL isLessPropertyValue( 
	const AddressBookParameteredPropertyValue& rFirst, const AddressBookParameteredPropertyValue& rSecond )
{
	return rFirst.Name < rSecond.Name;
}

inline BOOL isLess( const UString& r1, const UString& r2 ) 
{
	return r1 < r2;
}

class OAddressBookDatabaseDriverSettings : 
	public OPropertySet, public OPropertyObject, 
	public OPersistentPropertySet
{
public:
	SMART_UNO_DECLARATION( OAddressBookDatabaseDriverSettings, OPropertySet );
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr );
	OAddressBookDatabaseDriverSettings(
		const XMultiServiceFactoryRef& rMgr );
	Sequence<DatabaseDriverAddressBookSourceDefinition> m_Sources;
	
	static void fillClassInfo( 
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

private:
	OMutex m_aMutex;
	XMultiServiceFactoryRef m_xMgr;
};


class OUniqueIDFactory : public UsrObject, public XUniqueIDFactory
{
public:
	SMART_UNO_DECLARATION( OUniqueIDFactory, UsrObject );
	static XInterfaceRef createInstance( const XMultiServiceFactoryRef& xMgr ){
		return *new OUniqueIDFactory( ); }		


	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	UString createUniqueID() THROWS( ( UsrSystemException));
};


#endif

