/*************************************************************************
 *
 *  $RCSfile: fielddsc.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "basepage.hxx"
#include "datman.hxx"
#include "adrmod.hxx"

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

SV_IMPL_PTRARR( AdrFieldDescList, AdrFieldDescriptionPtr );

AdrFieldDescription::AdrFieldDescription():
			pField(NULL),
			pTitle(NULL),
			ppDatMan(NULL),
			bRefreshed(FALSE),
			bModified(FALSE),
			nNo(0)
{
	//
}

AdrFieldDescription::AdrFieldDescription(Edit* pF,AdrDataManagerHdl pDM, 
							const UString& aCName,const Sequence<UString>& seqPa)
{
	Initilize(pF,pDM, aCName, seqPa);
}

AdrFieldDescription::AdrFieldDescription(AdrDataManagerHdl pDM, 
							const UString& aCName,const Sequence<UString>& seqPa)
{
	Initilize(pDM, aCName, seqPa);
}

void AdrFieldDescription::Initilize(Edit* pF,AdrDataManagerHdl ppDM, 
							const UString& aCName,const Sequence<UString>&	seqPa)
{
	SetField(pF);
	ppDatMan=ppDM;
	aClassName=aCName;
	seqParas=seqPa;
	bRefreshed=FALSE;
	bModified=FALSE;
	nNo=0; //???
}

void AdrFieldDescription::Initilize(AdrDataManagerHdl pDM, 
							const UString& aCName,const Sequence<UString>&	seqPa)
{
	Initilize(NULL,pDM, aCName, seqPa);
}

void AdrFieldDescription::UpdateData()
{
	BOOL bFlag = FALSE;
	bRefreshed=FALSE;
		
	TRY
	{
		if(ppDatMan !=NULL && *ppDatMan !=NULL && pField !=NULL)
		{
			BOOL bReadOnly=TRUE;
			UsrAny aAny = (*ppDatMan)->getFieldValue(aClassName,seqParas,&bReadOnly);

			pField->SetReadOnly( bReadOnly);
			
			if(pTitle!=NULL)
			{
				const StyleSettings& rSettings = pTitle->GetSettings().GetStyleSettings();
				
				if(bReadOnly)
					pTitle->SetTextColor(rSettings.GetHighlightColor());
				else
					pTitle->SetTextColor(rSettings.GetFieldTextColor());
				pTitle->Invalidate();
			}

			if( aAny.getReflection()->equals(*AddressBookParameteredValue_getReflection()))
			{
				aValue= *(AddressBookParameteredValue*) aAny.get();

				if(aValue.Value.getReflection()->equals(*UString_getReflection()))
				{
					UString aUStr = aValue.Value.getString();
					pField->SetText(U2S(aUStr));
					bFlag =TRUE;
					bRefreshed=TRUE;
				}

			}
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrFieldDescription::UpdateData")
	}
	END_CATCH

	if(!bFlag)
	{
		pField->SetText(String());		
	}
}

void AdrFieldDescription::RefreshField()
{
	BOOL bFlag = FALSE;
	
	if(!bRefreshed)
	{
		bRefreshed=TRUE;
		
		TRY
		{
			if(ppDatMan !=NULL && *ppDatMan !=NULL && pField !=NULL)
			{
				BOOL bReadOnly=TRUE;
				UsrAny aAny = (*ppDatMan)->getFieldValue(aClassName,seqParas,&bReadOnly);

				if( aAny.getReflection()->equals(*AddressBookParameteredValue_getReflection()))
				{
					aValue= *(AddressBookParameteredValue*) aAny.get();
					pField->SetReadOnly(bReadOnly);

					if(pTitle!=NULL)
					{
						const StyleSettings& rSettings = pTitle->GetSettings().GetStyleSettings();
				
						if(bReadOnly)
							pTitle->SetTextColor(rSettings.GetHighlightColor());
						else
							pTitle->SetTextColor(rSettings.GetFieldTextColor());
						pTitle->Invalidate();
					}
				}
			}
		}
		CATCH_ALL()
		{
			DBG_ERROR("Exception in AdrFieldDescription::RefreshField")
		}
		END_CATCH

		if(!bFlag)
		{
			pField->SetText(String());		
		}
	}
}

void AdrFieldDescription::SaveField()
{
	if(ppDatMan !=NULL && *ppDatMan !=NULL)
	{
		(*ppDatMan)->saveFieldValue(aClassName,aValue);
		bModified=FALSE;
	}
}

void AdrFieldDescription::SetField(Edit* pF)
{
	pField=pF;
	if(pField!=NULL)
	{
		pField->SetModifyHdl(LINK( this, AdrFieldDescription, ModifyHdl));
	}
}

Window*	AdrFieldDescription::GetField()
{
	return pField;
}

BOOL AdrFieldDescription::IsConnected()
{
	return (pField != NULL);
}

IMPL_LINK( AdrFieldDescription, ModifyHdl, Edit*, pEd )
{
	bModified=TRUE;

	TRY
	{
		if(pField !=NULL)
		{
			UString aUStr = S2U(pField->GetText());
			aValue.Value.setString(aUStr);

			if(ppDatMan !=NULL && *ppDatMan !=NULL)
			{
				(*ppDatMan)->setRecordModified();
			}
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrFieldDescription::ModifyHdl")
	}
	END_CATCH
	
	return 0;
}

//=============================================================================

AdrFieldList::AdrFieldList(AdrDataManagerHdl ppDM):
		ppDatMan(ppDM)
{
	GenerateFieldList();
}

AdrFieldList::~AdrFieldList()
{
	Clear();
}

void AdrFieldList::Clear()
{
	if(Count()>0)
		DeleteAndDestroy(0,Count());
}

void AdrFieldList::GenerateFieldList()
{
	if(ppDatMan!=NULL && *ppDatMan!=NULL)
	{
		XNameAccessRef xAdrSourceSchemata = (*ppDatMan)->GetSourceSchemata();

		Sequence<UString> aSchemataList(xAdrSourceSchemata->getElementNames());
		
		INT32 nCount=aSchemataList.getLen();
		
		if(nCount > 0)
		{
			const UString* pSchemata = aSchemataList.getConstArray();

			UString aSchemataName = pSchemata[0];

			UsrAny aElement = xAdrSourceSchemata->getByName(aSchemataName);

			XPropertySetRef xFields = *(XPropertySetRef*)aElement.get();

			UsrAny theFields=xFields->getPropertyValue(L"Properties");
			Sequence<AddressBookParameteredProperty> aParaSeq;
			aParaSeq = *(Sequence<AddressBookParameteredProperty> *)theFields.get();

			INT32 nFieldCount =aParaSeq.getLen();
			
			const AddressBookParameteredProperty* pProp= aParaSeq.getConstArray();

			for(INT32 i=0;i < nFieldCount; i++)
			{
				CreateFieldDescriptions(pProp);
				pProp++;
			}
		}
	}
}

void AdrFieldList::CreateFieldDescriptions(const AddressBookParameteredProperty* pProp)
{
	/*
	if(pProp != NULL)
	{
		Sequence<AddressBookPropertyParameterInfo> aValues = pProp->AllowedParameterCombinations;

		const AddressBookPropertyParameterInfo* pVal = aValues.getConstArray();
		INT32 nCount = aValues.getLen();
		
		if(nCount >0)
		{
			for(INT32 j=0; j < nCount; j++)
			{
				if(	EqualSeq(pVal->Parameters, seqParas))
				{	
					nMax = pVal->MaxCount;
					break;
				}
				pVal++;
			}
		}
		else
		{
		   nMax = pResProp->MaxCount;
		}
	}
	*/
}

void AdrFieldList::CreateFieldDescription(const AddressBookPropertyParameterInfo* pProp)
{
	
}

void AdrFieldList::UpdateData()
{
TRY
{
	USHORT nCount=Count();
	for(USHORT i=0; i<nCount; i++)
	{
		AdrFieldDescriptionPtr pFieldDescription = GetObject(i);

		pFieldDescription->UpdateData();
	}
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrFieldList::UpdateData")
}
END_CATCH

}

void AdrFieldList::SaveFields()
{
TRY
{
	USHORT nCount=Count();
	for(USHORT i=0; i<nCount; i++)
	{
		AdrFieldDescriptionPtr pFieldDescription = GetObject(i);

		pFieldDescription->SaveField();
	}
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrFieldList::SaveFields")
}
END_CATCH

}


void AdrFieldList::RefreshFields()
{
TRY
{
	USHORT nCount=Count();
	for(USHORT i=0; i<nCount; i++)
	{
		AdrFieldDescriptionPtr pFieldDescription = GetObject(i);

		pFieldDescription->RefreshField();
	}
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrFieldList::UpdateData")
}
END_CATCH


}

short AdrFieldList::ConnectField(Edit* pF, const UString& aCName,const Sequence<UString>& seqPa)
{
	short nNo = -1;
	AdrFieldDescriptionPtr pFieldDescription = Search(aCName, seqPa, -1);

	if(pFieldDescription != NULL)
	{
		pFieldDescription->SetField(pF);
		nNo = pFieldDescription->GetNumber();
	}

	return nNo;
}

BOOL AdrFieldList::IsConnected(const UString& aCName,const Sequence<UString>& seqPa, short nNo)
{
	BOOL bFlag=FALSE;
	AdrFieldDescriptionPtr pFieldDescription = Search(aCName, seqPa, nNo);

	if(pFieldDescription != NULL)
	{
		bFlag=TRUE;
	}

	return bFlag;
}

INT32 AdrFieldList::GetFieldCount(const UString& aCName,const Sequence<UString>& seqPa)
{
	INT32 nCount = 0;
	if(ppDatMan!=NULL && *ppDatMan!=NULL)
		   nCount = (*ppDatMan)->GetMaxFieldCount(aCName,seqPa);

	return nCount;
}

INT32 AdrFieldList::GetFieldCount()
{
	return Count();
}


AdrFieldDescriptionPtr AdrFieldList::Search(const UString& aCName,const Sequence<UString>& seqPa, short nNo)
{
	short nPos = -1;
	short nFieldCount = 0;

	AdrFieldDescriptionPtr pResult = NULL;
	USHORT nCount = Count();
	
	for(USHORT i=0; i < nCount; i++)
	{
		AdrFieldDescriptionPtr pFieldDescription = GetObject(i);

		if(pFieldDescription->ClassName() == aCName)
		{
			if(EqualSeq(*pFieldDescription->GetParaList(),seqPa))
			{
				if(nNo != -1)
				{
					if(nFieldCount == nNo)
					{
						pResult = pFieldDescription;
						break;
					}
				}
				else if(!pFieldDescription->IsConnected())
				{
					pResult = pFieldDescription;
					break;
				}

				nFieldCount++;
			}
		}
	}

	return pResult;
}

BOOL AdrFieldList::EqualSeq(const Sequence<UString>& seqParas,const Sequence<UString>& aSubSet)
{
	UINT32 nCount1 = seqParas.getLen();
	UINT32 nCount2 = aSubSet.getLen();

	if(nCount1!=nCount2)
		return FALSE;

	const UString* pStr2 = aSubSet.getConstArray();

	UINT32 nCounter = 0;

	for(UINT32 i=0; i < nCount2; i++)
	{
		const UString* pStr1 = seqParas.getConstArray();
		
		for(UINT32 j=0; j < nCount1; j++)
		{
			if(	*pStr1 == *pStr2)
			{	
				nCounter++;
				break;
			}

			pStr1++;
		}

		pStr2++;
	}

	if(nCounter == nCount2)
		return TRUE;

	return FALSE;
}

AdrFieldDescriptionPtr AdrFieldList::InsertField(Edit* pField, const UString& aClassName, 
												 const Sequence<UString>& seqParas,Window* pTitle)
{
	AdrFieldDescriptionPtr pResult=NULL;

	if(!IsAllowedField(aClassName,seqParas))
	{
		USHORT nCount=Count();
		
		USHORT i;
		for(i=0; i<nCount; i++)
		{
			AdrFieldDescriptionPtr pFieldDescription = GetObject(i);

			if(pFieldDescription->GetTitleWin() == pTitle) break;
		}

		if(pTitle!=NULL && i==nCount) 
			pTitle->Disable();

		pField->Disable();

	}
	else
	{
		pResult = new AdrFieldDescription(pField,ppDatMan, aClassName,seqParas);
		if(ppDatMan !=NULL && *ppDatMan !=NULL)
			(*ppDatMan)->RemoveAvailableField(aClassName,seqParas);
		pResult->SetTitleWin(pTitle);
		if(pTitle!=NULL) pTitle->Enable();

		Insert(pResult,Count());
	}
	return pResult;
}

void AdrFieldList::RemoveField(AdrFieldDescriptionPtr* ppDesc)
{
	if(ppDesc !=NULL)
	{
		USHORT nCount=Count();
		AdrFieldDescriptionPtr pDesc=*ppDesc;
		for(USHORT i=0; i<nCount; i++)
		{
			AdrFieldDescriptionPtr pFieldDescription = GetObject(i);

			if(pFieldDescription == pDesc)
			{
				Remove(i);
				delete pDesc;
				*ppDesc	=NULL;
				break;
			}
		}
	}	
}

BOOL AdrFieldList::IsAllowedField(const UString& aClassName, const Sequence<UString>& seqParas)
{
	BOOL bFlag = FALSE;
		
	if(ppDatMan !=NULL && *ppDatMan !=NULL)
		bFlag =((*ppDatMan)->GetMaxFieldCount(aClassName,seqParas) > 0);

	return bFlag;
}



