/*************************************************************************
 *
 *  $RCSfile: sdbimporter.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_SDBIMPORTER_HXX_
#include "sdbimporter.hxx"
#endif
#ifndef _EXTENSIONS_DBI_SDBFILEACCESS_HXX_
#include "sdbfileaccess.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_UTIL_XFLUSHABLE_HPP_ 
#include <com/sun/star/util/XFlushable.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XBOOKMARKSSUPPLIER_HPP_ 
#include <com/sun/star/sdb/XBookmarksSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XFORMSSUPPLIER_HPP_
#include <com/sun/star/form/XFormsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGESSUPPLIER_HPP_
#include <com/sun/star/drawing/XDrawPagesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGESUPPLIER_HPP_
#include <com/sun/star/drawing/XDrawPageSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XTASK_HPP_
#include <com/sun/star/frame/XTask.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATE_HPP_
#include <com/sun/star/beans/PropertyState.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XQUERYDEFINITIONSSUPPLIER_HPP_
#include <com/sun/star/sdb/XQueryDefinitionsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _EXTENSIONS_DBI_DSNTYPES_HXX_
#include "dsntypes.hxx"
#endif
#ifndef _DBHELPER_DBCHARSET_HXX_
#include <connectivity/dbcharset.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef _STRING_HXX 
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_TEMPFILE_HXX
#include <tools/tempfile.hxx>
#endif
#include <ctype.h>
#ifndef _VCL_STDTEXT_HXX 
#include <vcl/stdtext.hxx>
#endif
#ifndef _EXTENSIONS_DBI_DOCFILTER_HXX_
#include "docfilter.hxx"
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX 
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _EXTENSIONS_DBI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif
#ifndef _URLOBJ_HXX 
#include <tools/urlobj.hxx>
#endif
#ifndef _UCBHELPER_CONTENT_HXX
#include <ucbhelper/content.hxx>
#endif
#ifndef _EXTENSIONS_DBI_DBIDIALOGS_HXX_
#include "dbidialogs.hxx"
#endif
#ifndef _SV_MSGBOX_HXX 
#include <vcl/msgbox.hxx>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XFORM_HPP_ 
#include <com/sun/star/form/XForm.hpp>
#endif
#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <cppuhelper/extract.hxx>
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif

#include <algorithm>

//.........................................................................
namespace dbi
{
//.........................................................................

	using namespace ::dbtools;
	using namespace ::utl;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::sdb;
	using namespace ::com::sun::star::io;
	using namespace ::com::sun::star::ucb;
	using namespace ::com::sun::star::form;
	using namespace ::com::sun::star::container;
	using namespace ::com::sun::star::document;
	using namespace ::com::sun::star::frame;
	using namespace ::com::sun::star::drawing;
	using namespace ::com::sun::star::form;
	using namespace ::com::sun::star::util;

	//=====================================================================
	//= tools
	//=====================================================================
	//---------------------------------------------------------------------
	Any& append(Sequence< PropertyValue >& _rSeq, const ::rtl::OUString& _rPropertyName)
	{
		sal_Int32 nLen = _rSeq.getLength();
		_rSeq.realloc(nLen + 1);

		PropertyValue& rNewElement = _rSeq[nLen];
		rNewElement = PropertyValue(
			_rPropertyName,
			0,
			Any(),
			PropertyState_DIRECT_VALUE
		);

		return rNewElement.Value;
	}

	//---------------------------------------------------------------------
	Any& append(Sequence< PropertyValue >& _rSeq, const sal_Char* _pPropertyName)
	{
		return append(_rSeq, ::rtl::OUString::createFromAscii(_pPropertyName));
	}

	//=====================================================================
	//= OSdbImporter
	//=====================================================================
	//---------------------------------------------------------------------
	OSdbImporter::OSdbImporter(const Reference< XMultiServiceFactory >& _rxORB, const OImportSettings& _rSettings, const ::vos::ORef< OSdbFileAccess >& _rSdbArchive, Window* _pMessageParent)
		:m_xORB(_rxORB)
		,m_aSettings(_rSettings)
		,m_pSdbArchive(_rSdbArchive)
		,m_pMessageParent(_pMessageParent)
	{
	}

	//---------------------------------------------------------------------
	Reference< XNamingService > OSdbImporter::implGetDSContext()
	{
		Reference< XNamingService > xDSContainer;
		try
		{
			Reference< XInterface > xContext;
			if (m_xORB.is())
				xContext = m_xORB->createInstance(::rtl::OUString::createFromAscii("com.sun.star.sdb.DatabaseContext"));
			DBG_ASSERT(xContext.is(), "OImportSdbDialog::implGetDSContext: got no database context!");
			xDSContainer = Reference< XNamingService >(xContext, UNO_QUERY);
			DBG_ASSERT(xDSContainer.is() || !xContext.is(), "OImportSdbDialog::implGetDSContext: missing the XNamingService interface!");
		}
		catch(Exception&)
		{
			DBG_ERROR("OSdbImporter::implGetDSContext: could not create the database context (caught an exception)!");
		}

		return xDSContainer;
	}

	//---------------------------------------------------------------------
	void OSdbImporter::createDatasource()
	{
		DBG_ASSERT(m_xORB.is(), "OSdbImporter::createDatasource: no service factory!");
		DBG_ASSERT(!m_xNewDatasource.is(), "OSdbImporter::createDatasource: already have a data source!");
		m_xNewDatasource.clear();

		ODSNTypeInfo aDSNType(m_pSdbArchive->getTypeLogical());

		// never to be called if we don't support this type anymore ...
		if (!aDSNType.isAvailable())
		{
			DBG_ERROR("OSdbImporter::createDatasource: can't create data sources of that type!");
			return;
		}

		// get the DatabaseContext as NameContainer
		Reference< XNamingService > xDSContainer = implGetDSContext();
		if (!xDSContainer.is())
			// can't do anything, should have asserted in all cases which lead us here ...
			return;

		// create a new data source
		try
		{
			Reference< XInterface > xDS;
			if (m_xORB.is())
				xDS = m_xORB->createInstance(::rtl::OUString::createFromAscii("com.sun.star.sdb.DataSource"));
			DBG_ASSERT(xDS.is(), "OImportSdbDialog::implCollectDatasources: got no new data source!");
			m_xNewDatasource = Reference< XPropertySet >(xDS, UNO_QUERY);
			DBG_ASSERT(m_xNewDatasource.is() || !xDS.is(), "OImportSdbDialog::implCollectDatasources: missing the XPropertySet interface!");
		}
		catch(Exception&)
		{
			DBG_ERROR("OSdbImporter::createDatasource: could not create the data source!");
		}

		if (!m_xNewDatasource.is())
			// can't do anything, should have asserted in all cases which lead us here ...
			return;

		// translate the old sdb file settings into properties ....
		try
		{
			// the user name
			implTrasferStringProperty("UID", "User");

			// the URL
			String sURL;
			if (TYPE_JDBC == aDSNType.getId())
			{
				sURL = m_pSdbArchive->getDSNStringToken("URL");
			}
			else
			{	// need to prepend the context
				String sOldDSN = m_pSdbArchive->getDSNStringToken(String::CreateFromAscii("DSN"));
				aDSNType.filterDSN(sOldDSN);
				sURL = aDSNType.getURLPrefix();
				sURL += sOldDSN;
			}
			m_xNewDatasource->setPropertyValue(::rtl::OUString::createFromAscii("URL"), makeAny(::rtl::OUString(sURL)));

			// password usage
			sal_Bool bPasswordRequired = implTrasferBooleanProperty("ASKWHENEMPTYPWD", "IsPasswordRequired");

			// the password
			if (implTrasferStringProperty("PWD", "Password").getLength() && !bPasswordRequired)
			{
				m_xNewDatasource->setPropertyValue(
					::rtl::OUString::createFromAscii("IsPasswordRequired"),
					::cppu::bool2any(sal_True)
				);
			}

			// TableFilter
			Sequence< ::rtl::OUString > aTableFilter;
			if (m_pSdbArchive->hasDSNToken("TBL_FILTER"))
			{
				// saving the filter is somewhat strange in 5.2:
				// In the DSN is stated _if_ the tables are filtered, and the enumeration of visible
				// tables (i.e. tables passing the filter) is the enumeration of storages in the table
				// sub-storage.
				StringArray aTables;
				m_pSdbArchive->getTableNames(aTables);

				sal_Int32 nFilterEntries = aTables.size();
				// copy it (somewhat ugly, because the source are strings and the destination ::rtl::OUStrings
				aTableFilter.realloc(nFilterEntries);
				::rtl::OUString* pFilterEntries = aTableFilter.getArray();
				ConstStringArrayIterator aLoop = aTables.begin();
				for (; nFilterEntries; --nFilterEntries, ++pFilterEntries, ++aLoop)
					*pFilterEntries = *aLoop;
			}
			else
			{	// no filter
				aTableFilter.realloc(1);
				aTableFilter[0] = ::rtl::OUString::createFromAscii("%");
			}
			m_xNewDatasource->setPropertyValue(::rtl::OUString::createFromAscii("TableFilter"), makeAny(aTableFilter));

			// PropertyInfo
			Sequence< PropertyValue > aAdditionalInfo;
			// the charset
			static const sal_Char* s_pCharsetToken = "CharSet";
			if (m_pSdbArchive->hasDSNToken(s_pCharsetToken))
			{
				// it's logical (i.e. persistent) name
				::rtl::OUString sCharsetLogical = m_pSdbArchive->getDSNStringToken(s_pCharsetToken);
				sCharsetLogical = sCharsetLogical.toAsciiUpperCase();

				// translate it into an encoding
				rtl_TextEncoding eEncoding = RTL_TEXTENCODING_DONTKNOW;
				const sal_Char* aLogicalAsciiNames[] = {
					"ANSI",
					"MAC",
					"IBMPC_437",
					"IBMPC_850",
					"IBMPC",
					"DOS",
					"IBMPC_860",
					"IBMPC_861",
					"IBMPC_863",
					"IBMPC_865",
					"IBMPC_866",
					"SYSTEM"
				};
				const rtl_TextEncoding aEncodings[] = {
					RTL_TEXTENCODING_MS_1252,		// ANSI
					RTL_TEXTENCODING_APPLE_ROMAN,	// MAC
					RTL_TEXTENCODING_IBM_437,		// IBMPC_437
					RTL_TEXTENCODING_IBM_850,		// IBMPC_850
					RTL_TEXTENCODING_IBM_850,		// IBMPC
					RTL_TEXTENCODING_IBM_850,		// DOS
					RTL_TEXTENCODING_IBM_860,		// IBMPC_860
					RTL_TEXTENCODING_IBM_861,		// IBMPC_861
					RTL_TEXTENCODING_IBM_863,		// IBMPC_863
					RTL_TEXTENCODING_IBM_865,		// IBMPC_865
					RTL_TEXTENCODING_IBM_866,		// IBMPC_866 (cyrillic)
					RTL_TEXTENCODING_DONTKNOW		// SYSTEM
				};
				DBG_ASSERT( ( sizeof( aLogicalAsciiNames ) / sizeof( aLogicalAsciiNames[0] ) )
						==	( sizeof( aEncodings ) / sizeof( aEncodings[0] ) ),
						"OSdbImporter::createDatasource: inconsistent map!" );

				const sal_Char** ppLogical = aLogicalAsciiNames;
				const rtl_TextEncoding* pEncoding = aEncodings;
				sal_Int32 i = 0;
				for ( ; i < sizeof( aEncodings ) / sizeof( aEncodings[0] ); ++i, ++ppLogical, ++pEncoding )
				{
					if ( 0 == sCharsetLogical.compareToAscii( *ppLogical ) )
					{
						eEncoding = *pEncoding;
						break;
					}
				}
				DBG_ASSERT( i < sizeof( aEncodings ) / sizeof( aEncodings[0] ), "OSdbImporter::createDatasource: invalid logical charset name!" );

				OCharsetMap aCharsets;
				OCharsetMap::CharsetIterator aPos = aCharsets.find( eEncoding );
				DBG_ASSERT( aCharsets.end() != aPos, "OSdbImporter::createDatasource: invalid encoding in map!" );
				if ( aCharsets.end() != aPos )
					append(aAdditionalInfo, ::rtl::OUString::createFromAscii(s_pCharsetToken)) <<= (*aPos).getIanaName();
			}


			// items for the text format
			switch (aDSNType.getId())
			{
				case TYPE_ADABAS:
				{
					append(aAdditionalInfo, "ControlUser") <<= ::rtl::OUString( m_pSdbArchive->getDSNStringToken( "ctrluser" ) );
					append(aAdditionalInfo, "ControlPassword") <<= ::rtl::OUString( m_pSdbArchive->getDSNStringToken( "ctrlpwd" ) );

					if ( m_pSdbArchive->hasDSNToken( "SHUTSERVICE" ) )
						append( aAdditionalInfo, "ShutdownDatabase" ) <<= (sal_Bool)sal_True;

					append( aAdditionalInfo, "DataCacheSizeIncrement" ) <<= m_pSdbArchive->getDSNIntToken( "DATAINC" );
					append( aAdditionalInfo, "DataCacheSize" ) <<= m_pSdbArchive->getDSNIntToken( "CACHESIZE" );
						// sounds strange (DataCacheSizeIncrement=CACHESIZE and DataCacheSize=DATAINC), but there's a bug
						// in 5.2 ...
				}
				break;

				case TYPE_TEXT:
				{
					// the string properties
					static const sal_Char* pInfoNames[] = 
					{
						"FieldDelimiter", "StringDelimiter", "DecimalDelimiter", "ThousandDelimiter", "Extension"
					};
					static const sal_Char* pDsnTokenNames[] = 
					{
						"del", "str", "decdel", "thodel", "ext"
					};
					DBG_ASSERT(sizeof(pInfoNames) / sizeof(pInfoNames[0]) == sizeof(pDsnTokenNames) / sizeof(pDsnTokenNames[0]),
						"OSdbImporter::createDatasource: inconsistence!");
					String sToken;
					sal_Int32 nStringItems = sizeof(pInfoNames) / sizeof(pInfoNames[0]);
					for (sal_Int32 i=0; i<nStringItems; ++i)
					{
						// the token value in the SDB file
						sToken = m_pSdbArchive->getDSNStringToken(pDsnTokenNames[i]);
						if (i < nStringItems - 1)
						{	// it's one of the delimiter strings, they need special handling
							if (sToken.Len())
							{
								if (!isdigit(sToken.GetBuffer()[0]))
									// remove everything but the first character
									sToken = sToken.Copy(0, 1);
								else
								{
									sal_Unicode cCharcter = (sal_Unicode)m_pSdbArchive->getDSNIntToken(pDsnTokenNames[i]);
									sToken = String(&cCharcter, 1);
								}
							}
						}
						// append a property value for this
						append(aAdditionalInfo, pInfoNames[i]) <<= ::rtl::OUString(sToken);
					}
					// the boolean property
					append(aAdditionalInfo, "HeaderLine") = makeAny(m_pSdbArchive->getDSNBoolToken("hdr"));

					// the only missing setting is the charset, which has been handled above ...
				}
				break;
				case TYPE_DBASE:
				{
					append(aAdditionalInfo, "ShowDeleted") = makeAny(m_pSdbArchive->getDSNBoolToken("deleted"));
				}
				break;
				case TYPE_JDBC:
				{
					append(aAdditionalInfo, "JavaDriverClass") <<= ::rtl::OUString(m_pSdbArchive->getDSNStringToken("jdbcdrv"));
				}
				break;
			}

			m_xNewDatasource->setPropertyValue(::rtl::OUString::createFromAscii("Info"), makeAny(aAdditionalInfo));
		}
		catch(Exception&)
		{
			DBG_ERROR("OSdbImporter::createDatasource: could not initialize the data source with some property values!");
		}

		// insert the new data source into the database context
		sal_Bool bSuccess = sal_False;
		try
		{
			xDSContainer->registerObject(m_aSettings.sDatasourceName, m_xNewDatasource.get());
			bSuccess = sal_True;
		}
		catch(Exception&)
		{
		}

		if (!bSuccess)
		{
			DBG_ERROR("OSdbImporter::createDatasource: could not insert the data source!");
			// TODO: real error handling
		}
	}

	//---------------------------------------------------------------------
	sal_Bool OSdbImporter::implCopyFormDocumentToTemporary(const SvStorageStreamRef& _rSourceStream, ::rtl::OUString& _rDestURL)
	{
		String sTemporaryFile = TempFile::CreateTempName();
		INetURLObject aTemporaryFile(sTemporaryFile);
		_rDestURL = sTemporaryFile;

		return implCopy(_rSourceStream, aTemporaryFile);
	}

	//---------------------------------------------------------------------
	sal_Bool OSdbImporter::implCopy(SvStream* _pSource, const INetURLObject& _rTargetURL)
	{
		// create a new target stream
		SvStream* _pDestStream = ::utl::UcbStreamHelper::CreateStream(_rTargetURL.GetMainURL(INetURLObject::NO_DECODE), STREAM_READWRITE | STREAM_SHARE_DENYWRITE);
		if (!_pDestStream)
			// TODO: how to get an error message?
			return sal_False;

		_pSource->Seek(STREAM_SEEK_TO_BEGIN);
		_pSource->ResetError();

		static const sal_uInt32 nBufferSize = 32768;
		char cBuffer[nBufferSize];
		sal_uInt32 nDone = 0;
		sal_uInt32 nThisRound;
		while	(	(ERRCODE_NONE == _pSource->GetErrorCode())
				&&	!_pSource->IsEof()
				&&	(ERRCODE_NONE == _pDestStream->GetErrorCode())
				)
		{
			nThisRound = _pSource->Read(cBuffer, sizeof(cBuffer));
			_pDestStream->Write(cBuffer, nThisRound);
			nDone += nThisRound;
		}

		delete _pDestStream;

		if (!_pSource->IsEof())
		{	// something went wrong ...
			// TODO: real error handling
			return sal_False;
		}

		return sal_True;
	}

	//---------------------------------------------------------------------
	void OSdbImporter::importForms()
	{
		ODocumentFilterInfo aFilterInfo(m_xORB, m_pMessageParent);

		sal_Bool nFlushBookmarks = sal_False;

		// loop through the to-be-imported forms
		for	(	ConstStringArrayIterator aLoop = m_aSettings.aImportForms.begin();
				aLoop != m_aSettings.aImportForms.end();
				++aLoop
			)
		{
			SvStorageStreamRef aFormStream = m_pSdbArchive->getFormStream(*aLoop);
			if (!aFormStream.Is())
			{
				// TODO: real error handling
				DBG_ERROR(
						(ByteString("OSdbImporter::importForms: could not open the stream for form ")
					+=	ByteString(aLoop->GetBuffer(), aLoop->Len(), gsl_getSystemTextEncoding())).GetBuffer());
				continue;
			}

			// the name of the file as we really want to name it finally
			OFileNotation aTransformer(m_aSettings.sFormImportPath, OFileNotation::N_SYSTEM);
			INetURLObject aFinalURL(aTransformer.get(OFileNotation::N_URL));
			aFinalURL.Append(*aLoop);

			// -------------------------
			FilterDescriptor aFilter;
			FilterDescriptor aPreferredFilter;
			if (aFilterInfo.isValid())
			{
				// try to detect the content of the document and it's default extension, plus the preferred filter
				// to save this content type with.
				try
				{
					Reference< XInputStream > xFormDocument = new OSeekableInputStreamWrapper(&aFormStream);
					aFilter = aFilterInfo.getFilter( xFormDocument );
					aPreferredFilter = aFilterInfo.getPreferedFilter( aFilter );
					xFormDocument->closeInput();	// this ensures that the wrapper won't access aFormStream anymore
				}
				catch(const Exception&)
				{
					DBG_ERROR("OSdbImporter::importForms: caught an exception while determining the document type!");
					// TODO: an error message for the user (saying that we ignore this file) would be nice
					continue;
				}

				if (!aFinalURL.hasExtension())
				{
					// the original document name itself does not have an extension
					::rtl::OUString sExtension = aPreferredFilter.sExtension;
					if (0 == sExtension.getLength())
						sExtension = aFilter.sExtension;

					if (0 != sExtension.getLength())
						// but we have an extension either from the preferred or from the current filter
						aFinalURL.setExtension(sExtension);
				}
			}

			// -------------------------
			// check for name collisions
			sal_Bool bFileExists = existsFile(aFinalURL);
			sal_Bool bSkipForm = sal_False;
			while (bFileExists)
			{
				// translate the URL into a (more) user-readable system string
				OFileNotation aTransformer(aFinalURL.GetMainURL(INetURLObject::NO_DECODE), OFileNotation::N_URL);
				OFormExistsDialog aAsk(m_pMessageParent, aTransformer.get(OFileNotation::N_SYSTEM));
				if ((RET_OK != aAsk.Execute()) || aAsk.isSkipForm())
				{	// interpret as skip
					bSkipForm = sal_True;
					break;
				}

				if (aAsk.isOverwrite())
					break;

				aFinalURL.setName(aAsk.getNewLocalName());
				bFileExists = existsFile(aFinalURL);
			}

			if (bSkipForm)
				// skip
				continue;


			Reference< XModel > xDocModel;

			sal_Bool bNeedChangeFileType = (aFilter.sFilterName != aPreferredFilter.sFilterName );
			// -------------------------
			if (bNeedChangeFileType)
			{	// the current document type is not the preferred document type
				// -> open it directly from the storage stream, and later on we will do a SaveAs

				INetURLObject aLoadFromStreamURL;
				aLoadFromStreamURL.SetSmartProtocol(INET_PROT_PRIVATE);
				aLoadFromStreamURL.SetSmartURL(String::CreateFromAscii("private:stream/"));

				Reference< XInputStream > xFormDocument = new OSeekableInputStreamWrapper(&aFormStream);
				xDocModel = openDocumentHiddenTask(aLoadFromStreamURL, xFormDocument);
				xFormDocument->closeInput();
			}
			else
			{
				implCopy(&aFormStream, aFinalURL);
			}

			// --------------------------
			// reset the forms in the doc
			if (m_aSettings.bCreateDatasource)
			{
				if (!xDocModel.is())
					// not already opened (which means the filter and the preferred filter matched
					xDocModel = openDocumentHiddenTask(aFinalURL, Reference< XInputStream >());

				resetFormDatasource(xDocModel, m_aSettings.sDatasourceName);
			}

			// --------------------------
			// store the document
			if (xDocModel.is())
			{	// only if it has been opened for any reason
				if (bNeedChangeFileType)
					storeDocumentTo(xDocModel, aFinalURL, aPreferredFilter);
				else
					storeDocument(xDocModel);
			}

			// --------------------------
			// close the document
			closeDocument(xDocModel);

			// --------------------------
			// create a link to this document under the data source
			if (m_aSettings.bCreateDatasource)
			{
				nFlushBookmarks = sal_True;
				bookmarkDocument(aFinalURL);
			}
		}

		if (nFlushBookmarks)
		{
			Reference< XBookmarksSupplier > xSuppBookmarks(m_xNewDatasource, UNO_QUERY);
			Reference< XFlushable > xBookmarksFlush;
			if (xSuppBookmarks.is())
				xBookmarksFlush = Reference< XFlushable >(xSuppBookmarks->getBookmarks(), UNO_QUERY);
			DBG_ASSERT(xBookmarksFlush.is(), "OSdbImporter::importForms: can't flush the bookmarks collection!");
			try
			{
				if (xBookmarksFlush.is())
					xBookmarksFlush->flush();
			}
			catch(const Exception&)
			{
				DBG_ERROR("OSdbImporter::importForms: caught an exception while flushing the bookmarks!");
			}
		}
	}

	//---------------------------------------------------------------------
	void OSdbImporter::bookmarkDocument(const INetURLObject& _rURL)
	{
		try
		{
			DBG_ASSERT(m_xNewDatasource.is(), "OSdbImporter::bookmarkDocument: have no data source!");
			if (!m_xNewDatasource.is())
				return;

			Reference< XBookmarksSupplier > xSuppBookmarks(m_xNewDatasource, UNO_QUERY);
			Reference< XNameContainer > xBookmarks;
			if (xSuppBookmarks.is())
				xBookmarks = Reference< XNameContainer >(xSuppBookmarks->getBookmarks(), UNO_QUERY);

			DBG_ASSERT(xBookmarks.is(), "OSdbImporter::bookmarkDocument: could not retrieve the bookmarks container!");
			if (!xBookmarks.is())
				return;

			::rtl::OUString sNewElementName = ::dbtools::createUniqueName(xBookmarks.get(), _rURL.getBase());
			xBookmarks->insertByName(sNewElementName, makeAny(::rtl::OUString(_rURL.GetMainURL(INetURLObject::NO_DECODE))));
		}
		catch(const Exception& e)
		{
			e;
			DBG_ERROR("OSdbImporter::bookmarkDocument: caught an exception!");
		}
	}

	//---------------------------------------------------------------------
	Reference< XModel > OSdbImporter::openDocumentHiddenTask(const INetURLObject& _rFormDoc, const Reference< XInputStream >& _rxStream)
	{
		Reference< XModel > xDocModel;

		// create the desktop
		Reference< XComponentLoader > xDesktop;
		try
		{
			xDesktop = Reference< XComponentLoader >(m_xORB->createInstance(::rtl::OUString::createFromAscii("com.sun.star.frame.Desktop")), UNO_QUERY);
			DBG_ASSERT(xDesktop.is(), "OSdbImporter::openDocumentHiddenTask: no desktop service!");
		}
		catch(Exception&)
		{
			DBG_ERROR("OSdbImporter::openDocumentHiddenTask: caught an exception while creating the desktop!");
		}

		if (xDesktop.is())
		{
			INetURLObject aURLToLoad = _rFormDoc;

			// arguments to load the component: we want it to be hidden
			sal_Bool bHaveInputStream = _rxStream.is();
			Sequence<PropertyValue> aArgs(bHaveInputStream ? 2 : 1);
			aArgs[0].Name = ::rtl::OUString::createFromAscii("Hidden");
			aArgs[0].Value <<= (sal_Bool) sal_True;
				// want to open this document hidden

			if (bHaveInputStream)
			{
				aArgs[1].Name = ::rtl::OUString::createFromAscii("InputStream");
				aArgs[1].Value <<= _rxStream;
			}

			static const ::rtl::OUString s_sFrameName = ::rtl::OUString::createFromAscii("_blank");

			Reference< XComponent > xComponent;
			try
			{
				// load the component
				xComponent = xDesktop->loadComponentFromURL(
						aURLToLoad.GetMainURL(INetURLObject::NO_DECODE),
						s_sFrameName,
						FrameSearchFlag::AUTO | FrameSearchFlag::CREATE,
						aArgs);
			}
			catch(Exception&)
			{
			}

			// the model of the component
			xDocModel = Reference< XModel >(xComponent, UNO_QUERY);

			if (!xDocModel.is())
			{	// show an error message
				String sMessage(ModuleRes(RID_STR_COULDNOTLOADFORM));
				sMessage.SearchAndReplaceAscii("$name$", OFileNotation(aURLToLoad.GetMainURL(INetURLObject::NO_DECODE), OFileNotation::N_URL).get(OFileNotation::N_SYSTEM));
					// TODO: in case we loaded via an input stream, we need a name other than the URL

				ErrorBox aError(m_pMessageParent, WB_OK, sMessage);
				aError.Execute();
			}
		}

		return xDocModel;
	}

	//---------------------------------------------------------------------
	struct PropagateProperty : public ::std::unary_function< ::rtl::OUString, void >
	{
	protected:
		const Reference< XNameAccess >&	m_xContainer;
		const Any&						m_rPropertyValue;

	public:
		PropagateProperty( const Reference< XNameAccess >& _rxContainer, const Any& _rValue )
			:m_xContainer( _rxContainer )
			,m_rPropertyValue( _rValue )
		{
		}

		void operator() ( const ::rtl::OUString& _rName )
		{
			Reference< XForm > xForm;
			m_xContainer->getByName( _rName ) >>= xForm;
			Reference< XPropertySet > xFormProps( xForm, UNO_QUERY );
			if ( xFormProps.is() )
			{	// it's really a form
				xFormProps->setPropertyValue( ::rtl::OUString::createFromAscii( "DataSourceName" ), m_rPropertyValue );

				// step down the hierarchy, if possible
				Reference< XNameAccess > xContainer( xFormProps, UNO_QUERY );
				PropagateProperty aStepDown( xContainer, m_rPropertyValue );
				aStepDown.apply( );
			}
		}

		void apply( )
		{
			if ( m_xContainer.is() )
			{
				Sequence< ::rtl::OUString > aElementNames = m_xContainer->getElementNames();
				::std::for_each(
					aElementNames.getConstArray(),
					aElementNames.getConstArray() + aElementNames.getLength(),
					*this
				);
			}
		}
	};
	//---------------------------------------------------------------------
	void OSdbImporter::resetFormDatasource(const Reference< XModel >& _rxDocModel, const ::rtl::OUString _rNewDataSourceName)
	{
		if (!_rxDocModel.is())
		{
			DBG_ERROR("OSdbImporter::resetFormDatasource: could not connect to the document model of the loaded document!");
			return;
		}

		// now iterate through the pages
		try
		{
			DECLARE_STL_VECTOR( Reference< XDrawPage >, PageArray);
			PageArray aPages;
			Reference< XDrawPageSupplier > xPageSupp(_rxDocModel, UNO_QUERY);
			if (xPageSupp.is())
			{	// document with only one page -> Writer
				aPages.push_back(xPageSupp->getDrawPage());
			}
			else
			{
				// it's a multi-page document
				// get the pages
				Reference< XDrawPagesSupplier > xPagesSupp(_rxDocModel, UNO_QUERY);
				Reference< XDrawPages > xPages;
				if (xPagesSupp.is())
					xPages = xPagesSupp->getDrawPages();

				Reference< XIndexAccess > xPagesIndexed = xPages.get();
				DBG_ASSERT(xPagesIndexed.is(), "OSdbImporter::resetFormDatasource: could not retrieve the index access for the draw pages!");

				// loop through the pages and remember them (for the moment)
				if (xPagesIndexed.is())
				{
					sal_Int32 nCount = xPagesIndexed->getCount();
					for (sal_Int32 i=0; i<nCount; ++i)
					{
						Reference< XDrawPage > xCurrent;
						xPagesIndexed->getByIndex(i) >>= xCurrent;
						if (xCurrent.is())
							aPages.push_back(xCurrent);
					}
				}
			}

			// loop through all the pages
			const Any aDataSourceNameValue = makeAny(::rtl::OUString(_rNewDataSourceName));
			for (ConstPageArrayIterator aLoop = aPages.begin(); aLoop != aPages.end(); ++aLoop)
			{
				Reference< XFormsSupplier > xFormsSupp(*aLoop, UNO_QUERY);
				DBG_ASSERT(xFormsSupp.is(), "OSdbImporter::resetFormDatasource: a page which is no forms supplier!");
				Reference< XNameContainer > xForms;
				if (xFormsSupp.is())
					xForms = xFormsSupp->getForms();
				if (xForms.is())
				{
					try
					{
						PropagateProperty aSetProps( xForms.get(), aDataSourceNameValue );
						aSetProps.apply();
					}
					catch(Exception&)
					{
						DBG_ERROR("OSdbImporter::resetFormDatasource: could not set the data source name on the page!");
					}
				}
			}
		}
		catch(Exception&)
		{
			DBG_ERROR("OSdbImporter::resetFormDatasource: caught an exception while looping through the pages!");
		}
	}

	//---------------------------------------------------------------------
	void OSdbImporter::storeDocument(const Reference< XModel >& _rxDocModel)
	{
		try
		{
			// save the document
			Reference< XStorable > xStoreDoc(_rxDocModel, UNO_QUERY);
			DBG_ASSERT(xStoreDoc.is() || !_rxDocModel.is(), "OSdbImporter::storeDocument: invalid doc model!");
			if (xStoreDoc.is())
				xStoreDoc->store();
		}
		catch(Exception&)
		{
			DBG_ERROR("OSdbImporter::storeDocument: caught an exception while saving the document!");
			// TODO: an error message
		}
	}

	//---------------------------------------------------------------------
	void OSdbImporter::storeDocumentTo(const Reference< XModel >& _rxDocModel, const INetURLObject& _rTargetURL, const FilterDescriptor& _rNonDefaultFilter)
	{
		try
		{
			// save the document
			Reference< XStorable > xStoreDoc(_rxDocModel, UNO_QUERY);
			DBG_ASSERT(xStoreDoc.is() || !_rxDocModel.is(), "OSdbImporter::storeDocument: invalid doc model!");
			if (xStoreDoc.is())
			{
				Sequence< PropertyValue > aAdditionalArgs(1);
				aAdditionalArgs[0].Name = ::rtl::OUString::createFromAscii("FilterName");
				aAdditionalArgs[0].Value <<= _rNonDefaultFilter.sFilterName;

				xStoreDoc->storeAsURL(_rTargetURL.GetMainURL(INetURLObject::NO_DECODE), aAdditionalArgs);
			}
		}
		catch(Exception&)
		{
			DBG_ERROR("OSdbImporter::storeDocumentTo: caught an exception while saving the document!");
			// TODO: an error message
		}
	}

	//---------------------------------------------------------------------
	void OSdbImporter::closeDocument(const Reference< XModel >& _rxDocModel)
	{
		if (_rxDocModel.is())
		{
			try
			{
				// we need the frame of the doc
				Reference< XController > xController = _rxDocModel->getCurrentController();
				Reference< XFrame > xDocFrame;
				if (xController.is())
					xDocFrame = xController->getFrame();
				DBG_ASSERT(xDocFrame.is(), "OSdbImporter::closeDocument: no frame for the document!");
				Reference< XTask > xDocTask(xDocFrame, UNO_QUERY);
				if (xDocTask.is())
					xDocTask->close();
			}
			catch(Exception&)
			{
				DBG_ERROR("OSdbImporter::closeDocument: caught an exception while closing the task!");
			}
		}
	}

	//---------------------------------------------------------------------
	sal_Bool OSdbImporter::existsFile(const INetURLObject& _rTargetURL)
	{
		try
		{
			::ucb::Content aFile(_rTargetURL.GetMainURL(INetURLObject::NO_DECODE), Reference< XCommandEnvironment >());
			if (aFile.isDocument())
				return sal_True;
			if (aFile.isFolder())
				return sal_True;
		}
		catch(Exception&)
		{
		}
		return sal_False;
	}

	//---------------------------------------------------------------------
	void OSdbImporter::importQueries()
	{
		// determine the target data source
		Reference< XInterface > xTargetDS = m_xNewDatasource.get();
		if (m_aSettings.sQueryDestinationDS.Len())
		{	// it's not the data source which has been created (if any)
			Reference< XNamingService > xDSContainer = implGetDSContext();
			if (!xDSContainer.is())
				// already asserted this
				return;

			try
			{
				xTargetDS = xDSContainer->getRegisteredObject(m_aSettings.sQueryDestinationDS);
			}
			catch(Exception&)
			{
				DBG_ERROR("OSdbImporter::importQueries: could not obtain the target data souce for the query import!");
			}
		}
		else
			DBG_ASSERT(xTargetDS.is(), "OSdbImporter::importQueries: no target specified and no DS created, yet!");

		if (!xTargetDS.is())
			// already asserted this
			return;

		Reference< XQueryDefinitionsSupplier > xSupp(xTargetDS, UNO_QUERY);
		Reference< XNameAccess > xQueries;
		if (xSupp.is())
			xQueries = xSupp->getQueryDefinitions();
		if (!xQueries.is())
		{
			DBG_ERROR("OSdbImporter::importQueries: could not retrive the queries container!");
			return;
		}

		// some heavily needed interfaces
		Reference< XSingleServiceFactory > xDefinitionFactory(xQueries, UNO_QUERY);
		if (!xDefinitionFactory.is())
		{
			DBG_ERROR("OSdbImporter::importQueries: missing the XSingleServiceFactory interface! Can't import the queries!");
			return;
		}
		Reference< XNameContainer > xDefinitionContainer(xQueries, UNO_QUERY);
		if (!xDefinitionContainer.is())
		{
			DBG_ERROR("OSdbImporter::importQueries: missing the XNameContainer interface! Can't import the queries!");
			return;
		}


		static ::rtl::OUString s_sCommand = ::rtl::OUString::createFromAscii("Command");
		static ::rtl::OUString s_sEscapeProcessing = ::rtl::OUString::createFromAscii("EscapeProcessing");

		// loop through the to-be-imported queries
		for	(	ConstStringArrayIterator aLoop = m_aSettings.aImportQueries.begin();
				aLoop != m_aSettings.aImportQueries.end();
				++aLoop
			)
		{
			try
			{
				Reference< XPropertySet > xNewObject(xDefinitionFactory->createInstance(), UNO_QUERY);
				DBG_ASSERT(xNewObject.is(), "OSdbImporter::importQueries: could not create an empty query!");
				if (!xNewObject.is())
					break;

				// read the data from the SDB file
				OQueryDescriptor aDescriptor;
				if (!m_pSdbArchive->getQuery(*aLoop, aDescriptor))
				{
					// TODO: real error handling
					DBG_ERROR(
							(ByteString("OSdbImporter::importQueries: could not open the stream for query ")
						+=	ByteString(aLoop->GetBuffer(), aLoop->Len(), gsl_getSystemTextEncoding())).GetBuffer());
					continue;
				}

				// set the property values
				xNewObject->setPropertyValue(s_sCommand, makeAny(::rtl::OUString(aDescriptor.sStatement)));
				xNewObject->setPropertyValue(s_sEscapeProcessing, makeAny(aDescriptor.bEscapeProcessing));

				::rtl::OUString sRealInsertName = *aLoop;
				if (xDefinitionContainer->hasByName(sRealInsertName))
				{
					OQueryNameConflictDialog aEnterNewName(m_pMessageParent, xDefinitionContainer.get(), sRealInsertName);
					if (RET_OK != aEnterNewName.Execute())
						// skip
						continue;

					sRealInsertName = aEnterNewName.getNewName();
				}

				// insert the object into the container
				xDefinitionContainer->insertByName(sRealInsertName, makeAny(xNewObject));
			}
			catch(Exception&)
			{
				DBG_ERROR("OSdbImporter::importQueries: error importing a query (caught a generic exception)!");
			}
		}
	}

	//---------------------------------------------------------------------
	sal_Bool OSdbImporter::implTrasferBooleanProperty(const sal_Char* _pDSNTokenName, const sal_Char* _pDSPropertyName)
	{
		// if the token is not present assume false
		sal_Bool bValue = sal_False;

		// get the token value
		String sDSNToken = String::CreateFromAscii(_pDSNTokenName);
		if (m_pSdbArchive->hasDSNToken(sDSNToken))
			bValue = m_pSdbArchive->getDSNBoolToken(sDSNToken);

		// set the property
		m_xNewDatasource->setPropertyValue(
			::rtl::OUString::createFromAscii(_pDSPropertyName),
			makeAny(bValue)
		);
		return bValue;
	}

	//---------------------------------------------------------------------
	::rtl::OUString OSdbImporter::implTrasferStringProperty(const sal_Char* _pDSNTokenName, const sal_Char* _pDSPropertyName)
	{
		::rtl::OUString sValue = m_pSdbArchive->getDSNStringToken(String::CreateFromAscii(_pDSNTokenName));
		m_xNewDatasource->setPropertyValue(
			::rtl::OUString::createFromAscii(_pDSPropertyName),
			makeAny(sValue)
		);
		return sValue;
	}

	//---------------------------------------------------------------------
	void OSdbImporter::import()
	{
		// create the data source
		if (m_aSettings.bCreateDatasource)
			createDatasource();

		// import the queries
		if (m_aSettings.bImportQueries && m_aSettings.aImportQueries.size())
			importQueries();

		// import the forms
		if (m_aSettings.bImportForms && m_aSettings.aImportForms.size())
			importForms();
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

