/*************************************************************************
 *
 *  $RCSfile: sdbimporter.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_SDBIMPORTER_HXX_
#define _EXTENSIONS_DBI_SDBIMPORTER_HXX_

#ifndef _EXTENSIONS_DBI_IMPORTSETTINGS_HXX_
#include "importsettings.hxx"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XNAMINGSERVICE_HPP_
#include <com/sun/star/uno/XNamingService.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _EXTENSIONS_DBI_SDBFILEACCESS_HXX_
#include "sdbfileaccess.hxx"
#endif

class INetURLObject;
//.........................................................................
namespace dbi
{
//.........................................................................

	struct FilterDescriptor;
	//=====================================================================
	//= OSdbImporter
	//=====================================================================
	class OSdbImporter
	{
	protected:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
										m_xORB;
		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >	
										m_xNewDatasource;
			// valid after createDatasource has been called

		Window*							m_pMessageParent;

		OImportSettings					m_aSettings;
		::vos::ORef< OSdbFileAccess >	m_pSdbArchive;


	public:
		OSdbImporter(
			const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
			const OImportSettings& _rSettings,
			const ::vos::ORef< OSdbFileAccess >& _rSdbArchive,
			Window* _pMessageParent);

		// for one-time usage only. No efforts were taken to allow multiple calls
		void import();

	protected:
		void createDatasource();
		void importQueries();
		void importForms();

		// no error handling, i.e. no catch etc
		::rtl::OUString implTrasferStringProperty(
			const sal_Char* _pDSNTokenName,
			const sal_Char* _pDSPropertyName
			);
		sal_Bool implTrasferBooleanProperty(
			const sal_Char* _pDSNTokenName,
			const sal_Char* _pDSPropertyName
			);

		::com::sun::star::uno::Reference< ::com::sun::star::uno::XNamingService >
			implGetDSContext();

		// copy a form document to the target directory
		// _rSourceStream has to be the already openend source stream of the document refered to by _rName
		sal_Bool implCopyFormDocumentToTemporary(
			const SvStorageStreamRef& _rSourceStream,
			::rtl::OUString& _rDestURL);

		sal_Bool implCopy(SvStream* _pSource, const INetURLObject& _rTargetURL);

		sal_Bool existsFile(const INetURLObject& _rTargetURL);

		/// opens the given document in a hidden task frame
		::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >
				openDocumentHiddenTask(
					const INetURLObject& _rFormDoc,
					const ::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStream >& _rxStream);

		/// resets the forms in the given document model to the data source given
		void	resetFormDatasource(
			const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >& _rxDocModel,
			const ::rtl::OUString _rNewDataSourceName);

		/// stores the document given
		void	storeDocument(
			const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >& _rxDocModel);

		/// stores the document given to a new URL, using a specific filter
		void	storeDocumentTo(
			const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >& _rxDocModel,
			const INetURLObject& _rTargetURL,
			const FilterDescriptor& _rNonDefaultFilter);

		/// closes the given document
		void	closeDocument(
			const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >& _rxDocModel);

		/// adds a bookmark for the given document under the newly created data source
		void	bookmarkDocument(const INetURLObject& _rURL);
	};

//.........................................................................
}	// namespace dbi
//.........................................................................

#endif // _EXTENSIONS_DBI_SDBIMPORTER_HXX_

