/*************************************************************************
 *
 *  $RCSfile: ie_ol.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include <regtools.hxx>
#include "inetset.hxx"

using namespace ::rtl;

OString sOutlookExpress = "Outlook Express";
// UString usOutlookExpress = L"Outlook Express";
OString sNetscape = "Netscape";

/* --- Outlook Express lesen ---------------------------------------------- */
void readMailAccount(HKEY account, const BOOL isDefaultAccount,
                     Directory *parent)
{
    typedef struct
    {
        __int32 pos;
        __int32 len;
        __int32 prev;
        __int32 next;
        __int32 num;
        char dispName[259];
        char fileName[259];
        char unknown[86];
    } dataRec;

    OString c;
    if (getRegSTRING(account, "SMTP Display Name", c))
    {
        OString dirName(isDefaultAccount ? "*" : "");
        dirName += c;
        Directory *user = new Directory(FALSE);

        OString smtpServer;
        if (getRegSTRING(account, "SMTP Server", smtpServer))
        { // read SMTP Server
            DWORD smtpPort;
            if (getRegDWORD(account, "SMTP Port", smtpPort))
            {
                if (smtpPort != 25)
                { // wenn ungleich dem default-port
                    char portNum[32];
                    sprintf(portNum, "%i", smtpPort);
                    smtpServer += ":";
                    smtpServer += portNum;
                }
            }
            user->insert(createData("SMTPServer", smtpServer));
        }

        OString popServer;
        if (getRegSTRING(account, "POP3 Server", popServer))
        { // read POP Server
            DWORD popPort;
            if (getRegDWORD(account, "POP3 Port", popPort))
            {
                if (popPort != 110)
                { // wenn ungleich dem default-port
                    char portNum[32];
                    sprintf(portNum, "%i", popPort);
                    popServer += ":";
                    popServer += portNum;
                }
            }
            user->insert(createData("POPServer", popServer));
        }

        OString popUserName;
        if (getRegSTRING(account, "POP3 User Name", popUserName))
            user->insert(createData("UserMailName", popUserName));

        HKEY outlook;
        if (getRegKey(HKEY_CURRENT_USER,
                      "Software\\Microsoft\\Outlook Express", outlook))
        {
            OString storeRoot;
            if (getRegSTRING(outlook, "Store Root", storeRoot))
            {
                OString sMailRoot = storeRoot;
                sMailRoot += "\\mail\\";
                OString sFoldersNCH = sMailRoot;
                sFoldersNCH += "folders.nch";
                Directory *box = new Directory(FALSE);
                char *buf = readFile(sFoldersNCH.getStr(), "rb");
                if (buf)
                {
                    dataRec *rec;
                    __int32 p;
                    memcpy(&p, buf+20, sizeof(p));
                    while (p)
                    {
                        rec = (dataRec *) (buf + p);
                        if (rec->num == 1)
                        { // inbox
                            Directory *inbox = new Directory(FALSE);
                            OString sFileName = sMailRoot;
                            sFileName += rec->fileName;
                            sFileName += ".mbx";
                            inbox->insert(createData("pfad", sFileName));
                            inbox->insert(createNum("typ", mtOutlook));
                            inbox->insert(createNum("ServerTyp", stPOP));
                            inbox->insert(createData("ServerName",
                                                     OString(popServer)));
                            inbox->insert(createData("MailUserName",
                                                     OString(popUserName)));
                            if (!inbox->hasElements()) delete inbox;
                            box->insert(createSub(rec->dispName, inbox));
                        }
                        else if (rec->num == 2)
                        { // outbox
                            Directory *outbox = new Directory(FALSE);
                            OString sFileName = sMailRoot;
                            sFileName += rec->fileName;
                            sFileName += ".mbx";
                            outbox->insert(createData("pfad", sFileName));
                            outbox->insert(createNum("typ", mtOutlook));
                            outbox->insert(createNum("ServerTyp", stUNSENT));
                            outbox->insert(createData("ServerName",
                                                      OString(smtpServer)));
                            if (!outbox->hasElements()) delete outbox;
                            box->insert(createSub(rec->dispName, outbox));
                        }
                        else if (rec->num == 3)
                        { // sent items
                            Directory *sent = new Directory(FALSE);
                            OString sFileName = sMailRoot;
                            sFileName += rec->fileName;
                            sFileName += ".mbx";
                            sent->insert(createData("pfad", sFileName));
                            sent->insert(createNum("typ", mtOutlook));
                            sent->insert(createNum("ServerTyp", stSMTP));
                            sent->insert(createData("ServerName",
                                                    OString(smtpServer)));
                            if (!sent->hasElements()) delete sent;
                            box->insert(createSub(rec->dispName, sent));
                        }
                        p = rec->next;
                    }
                    delete buf;
                    if (!box->hasElements()) delete box;
                    else user->insert(createSub("box", box));
                }
            }
            RegCloseKey(outlook);
        }
        if (!user->hasElements()) delete user;
        else parent->insert(createSub(dirName, user));
    }
}

void readNewsAccount(HKEY account, const BOOL isDefaultAccount,
                     Directory *parent)
{
    OString userName;
    if (getRegSTRING(account, "NNTP Display Name", userName))
    {
        BOOL exists = TRUE;
        Entry *userEntry;
        if (isDefaultAccount)
        {
            OString s = "*"; s += userName;
            userEntry = createSub(s, new Directory(FALSE));
            exists = FALSE;
        }
        else
        { // --- suche nach vorhandenen userEntry
            userEntry = parent->get(OUString::createFromAscii(userName));
            if (!userEntry)
            {
                OString s = "*"; s += userName;
                userEntry = parent->get(OUString::createFromAscii(s));
                if (!userEntry)
                {
                    userEntry = createSub(userName, new Directory(FALSE));
                    exists = FALSE;
                }
            }
        }
        Directory *userDir = userEntry->dir;

        OString accountName;
        if (getRegSTRING(account, "Account Name", accountName))
        {
            Directory *d = new Directory(FALSE);
            OString nntpServer;
            if (getRegSTRING(account, "NNTP Server", nntpServer))
            { // read NNTP Server
                DWORD nntpPort;
                if (getRegDWORD(account, "NNTP Port", nntpPort))
                {
                    if (nntpPort != 119)
                    { // if not the default-port
                        char portNum[32];
                        sprintf(portNum, "%i", nntpPort);
                        nntpServer += ":";
                        nntpServer += portNum;
                    }
                }
                d->insert(createData("NNTPServer", nntpServer));
                // .... import newsgroups
            }
            if (!d->hasElements()) delete d;
            else userDir->insert(createSub(accountName, d));
        }

        if (!exists)
        {
            if (!userDir->hasElements())
            {
                delete userDir;
                delete userEntry;
            }
            else parent->insert(userEntry);
        }
    }
}

void readOutlook(Directory *root)
{
    if (!root) return;
    HKEY Outlook5;
    if (getRegKey(HKEY_CURRENT_USER,
                  "Software\\Microsoft\\Outlook Express\\5.0", Outlook5))
    { // Outlook Express 5.0 not supported
        RegCloseKey(Outlook5);
        return;
    }

    HKEY internetAccountManager;
    if (getRegKey(HKEY_CURRENT_USER,
                  "Software\\Microsoft\\Internet Account Manager",
                  internetAccountManager))
    {
        HKEY accounts;
        if (getRegKey(internetAccountManager, "Accounts", accounts))
        {
            DWORD len = 1024;
            char *name = new char[len];

            // --- read mail -------------------------------------------------
            OString defaultMailAccount;
            if (getRegSTRING(internetAccountManager, "Default Mail Account",
                             defaultMailAccount))
            {
                Directory *outlook = new Directory(FALSE);
                LONG res = ERROR_SUCCESS;
                for (DWORD index = 0; res == ERROR_SUCCESS; index++)
                {
                    DWORD resLen = len;
                    res = RegEnumKeyEx(accounts, index, name, &resLen, 0, 0,
                                       0, 0);
                    if (res == ERROR_SUCCESS)
                    {
                        HKEY account;
                        if (getRegKey(accounts, name, account))
                        {
                            readMailAccount(account, (strcmp(name,
                              defaultMailAccount.getStr()) == 0), outlook);
                            RegCloseKey(account);
                        }
                    }
                }
                if (!outlook->hasElements()) delete outlook;
                else root->insert(createSub(sOutlookExpress, outlook),
                                  OString("mail"));
            }

            // --- read news -------------------------------------------------
            OString defaultNewsAccountName;
            if (getRegSTRING(internetAccountManager, "Default News Account",
                             defaultNewsAccountName))
            {
                Directory *outlook = new Directory(FALSE);
                HKEY defaultNewsAccountHandle;
                OString defaultNewsUser;
                if (getRegKey(accounts, defaultNewsAccountName,
                              defaultNewsAccountHandle))
                {
                    readNewsAccount(defaultNewsAccountHandle, TRUE, outlook);
                }
                LONG res = ERROR_SUCCESS;
                for (DWORD index = 0; res == ERROR_SUCCESS; index++)
                {
                    DWORD resLen = len;
                    res = RegEnumKeyEx(accounts, index, name, &resLen, 0, 0,
                                       0, 0);
                    if (res == ERROR_SUCCESS)
                    {
                        HKEY account;
                        if (getRegKey(accounts, name, account))
                        {
                            if (account != defaultNewsAccountHandle)
                                readNewsAccount(account, FALSE, outlook);
                            RegCloseKey(account);
                        }
                    }
                }
                if (defaultNewsAccountHandle)
                    RegCloseKey(defaultNewsAccountHandle);
                if (!outlook->hasElements()) delete outlook;
                else root->insert(createSub(sOutlookExpress,
                  outlook), OString("news"));
            }

            // --- cleanup ---------------------------------------------------
            delete name;
            RegCloseKey(accounts);
        }
        RegCloseKey(internetAccountManager);
    }
}

/* --- tools fuer Internet Explorer RegistryEntries ------------------------ */
int section(char *src)
{
    register char *tmp;
    for (tmp = src; (*tmp); tmp++) if (*tmp == ';') break;
    return (tmp - src);
}

/* --- Internet Explorer lesen --------------------------------------------- */
char *getProxyLine(char *name)
{
    char *reg = getRegValue(HKEY_CURRENT_USER,
      "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings",
      "ProxyServer");
    if (!reg) return 0;
    if ((find(reg, ";") < 0) && (find(reg, "=") < 0)) return reg;
    // neither ";" nor "=" in string --> return whole string
    int off = find(reg, name);
    if (off < 0) return 0;
    char *tmp = reg + off + strlen(name);
    off = section(tmp);
    char *res = new char[off + 1];
    strncpy(res, tmp, off);
    res[off] = 0;
    return res;
}

OString getProxyName(char *name)
{
    char *line = getProxyLine(name);
    if (!line) return "";
    int off = find(line, ":");
    if (off < 0) return "";
    char *res = new char[off + 1];
    strncpy(res, line, off);
    res[off] = 0;
    OString resString(res);
    delete res;
    return resString;
}

OString getProxyPort(char *name)
{
    char *line = getProxyLine(name);
    if (!line) return "";
    int off = find(line, ":");
    if (off < 0) return "";
    int l = strlen(line) - off;
    char *res = new char[l];
    strcpy(res, line + off + 1);
    res[l - 1] = 0;
    OString resString(res);
    delete res;
    return resString;
}

Entry *getIEProxyName(char *name, const OString &iniName)
{
    OString value = getProxyName(name);
    if (value.getLength() == 0) return 0;
    return createData(iniName, value);
}

Entry *getIEProxyPort(char *name, const OString &iniName)
{
    OString value = getProxyPort(name);
    if (value.getLength() == 0) return 0;
    return createNumData(iniName, value);
}

void readIExplorer(Directory *root)
{
    HKEY versionRoot;
    if (getRegKey(HKEY_LOCAL_MACHINE,
                  "Software\\Microsoft\\Internet Explorer", versionRoot))
    {
        OString ieVersion;
        if (getRegSTRING(versionRoot, "Version", ieVersion))
        {
            if (ieVersion.getStr()[0] >= '4') // ie4.0 or higher
            {
                OUString ie =
                    OUString::createFromAscii("browser/Internet Explorer");
                Entry *e;
                e = getIEProxyName("http=",  "HTTPProxyName");
                if (e) root->insert(e, ie);
                e = getIEProxyPort("http=",  "HTTPProxyPort");
                if (e) root->insert(e, ie);
                e = getIEProxyName("ftp=",   "FTPProxyName");
                if (e) root->insert(e, ie);
                e = getIEProxyPort("ftp=",   "FTPProxyPort");
                if (e) root->insert(e, ie);
                e = getIEProxyName("https=", "SecurityProxyName");
                if (e) root->insert(e, ie);
                e = getIEProxyPort("https=", "SecurityProxyPort");
                if (e) root->insert(e, ie);
                e = getIEProxyName("socks=", "SocksProxyName");
                if (e) root->insert(e, ie);
                e = getIEProxyPort("socks=", "SocksProxyPort");
                if (e) root->insert(e, ie);
            
                HKEY internetSettings;
                if (getRegKey(HKEY_CURRENT_USER,
          "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings",
                    internetSettings))
                {
                    DWORD proxyEnable;
                    if (getRegDWORD(internetSettings, "ProxyEnable",
                                    proxyEnable))
                    {
                        root->insert(createNum16Data("ProxyType",
                          proxyEnable ? "2" : "0"), ie);
                    }
                    OString proxyOverride;
                    if (getRegSTRING(internetSettings, "ProxyOverride",
                                     proxyOverride))
                    {
                        int i = find((char *) proxyOverride.getStr(),
                                     ";<local>");
                        if (i >= 0) proxyOverride = proxyOverride.copy(0, i);
                        root->insert(createData("NoProxy",
                                                proxyOverride), ie);
                    }
                    RegCloseKey(internetSettings);
                }
            
                HKEY explorerSettings;
                if (getRegKey(HKEY_CURRENT_USER,
                              "Software\\Microsoft\\Internet Explorer\\Main",
                              explorerSettings))
                {
                    OString startPage;
                    if (getRegSTRING(explorerSettings, "Start Page",                                     startPage))
                    {
                        root->insert(createData("HomePage", startPage), ie);
                    }
                    RegCloseKey(explorerSettings);
                }
            }
        }
        RegCloseKey(versionRoot);
    }
}
