/*************************************************************************
 *
 *  $RCSfile: oleclassw.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jl $ $Date: 2000/10/12 12:51:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "ole2uno.hxx"

#include <tools/presys.h>
#include <vector>
#include <hash_map>
#include <tools/postsys.h>


#include <vos/mutex.hxx>
#include <vos/diagnose.hxx>
#include <vos/refernce.hxx>


#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HXX_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

#include "oleobjw.hxx"

using namespace vos;
using namespace cppu;
using namespace std;
using namespace rtl;
using namespace cppu;


//using namespace ole_adapter;
namespace ole_adapter
{
class IdlClassAdapter_Impl;
/*****************************************************************************

	class declaration IdlFieldAdapter_Impl
	
*****************************************************************************/

class IdlFieldAdapter_Impl : public WeakImplHelper1< XIdlField>
{
public:
//IdlFieldAdapter_Impl::IdlFieldAdapter_Impl(IdlClassAdapter_Impl& rClass, const OUString& name)
	IdlFieldAdapter_Impl( IdlClassAdapter_Impl& rClass, const OUString& name);

	virtual	~IdlFieldAdapter_Impl();

	void addFuncDesc(ITypeInfo* pTypeInfo, FUNCDESC* pFuncDesc);
	void addVarDesc(ITypeInfo* pTypeInfo, VARDESC* pVarDesc);


	// XIdlField
    virtual Reference<XIdlClass > SAL_CALL getType(  ) throw(RuntimeException);
    virtual FieldAccessMode SAL_CALL getAccessMode(  ) throw(RuntimeException);
    virtual Any SAL_CALL get( const Any& obj ) throw(IllegalArgumentException, RuntimeException);
    virtual void SAL_CALL set( const Any& obj, const Any& value ) throw(IllegalArgumentException, IllegalAccessException, RuntimeException);

	// XIdlMember
	virtual Reference< XIdlClass > SAL_CALL getDeclaringClass(  ) throw(RuntimeException);
    virtual OUString SAL_CALL getName(  ) throw(RuntimeException) ;
	
protected:

	IdlClassAdapter_Impl&	m_rClass;
	FieldAccessMode			m_access;
	OUString					m_name;
	Reference<XIdlClass>			m_type;
	DISPID					m_dispIdPropertyGet;
	DISPID					m_dispIdPropertyPut;
	DISPID					m_dispIdPropertyPutRef;
};

/*****************************************************************************

	class declaration IdlMethodAdapter_Impl
	
*****************************************************************************/


class IdlMethodAdapter_Impl : public WeakImplHelper1<XIdlMethod>
{
public:
	IdlMethodAdapter_Impl(IdlClassAdapter_Impl& rClass, const OUString& name);

	virtual	~IdlMethodAdapter_Impl();

	void addFuncDesc(ITypeInfo* pTypeInfo, FUNCDESC* pFuncDesc);

	// XIdlMethod
    virtual Reference<XIdlClass > SAL_CALL getReturnType(  ) throw(RuntimeException);
    virtual Sequence<Reference<XIdlClass > > SAL_CALL getParameterTypes(  ) throw(RuntimeException);
    virtual Sequence<ParamInfo > SAL_CALL getParameterInfos(  ) throw(RuntimeException);
    virtual Sequence<Reference<XIdlClass > > SAL_CALL getExceptionTypes(  ) throw(RuntimeException);
    virtual MethodMode SAL_CALL getMode(  ) throw(RuntimeException);
    virtual Any SAL_CALL invoke( const Any& obj, Sequence< Any >& args ) throw(IllegalArgumentException, InvocationTargetException, RuntimeException);

	// XIdlMember ( inherited by XIdlMethod)
    virtual Reference<XIdlClass > SAL_CALL getDeclaringClass(  ) throw(RuntimeException);
    virtual OUString SAL_CALL getName(  ) throw(RuntimeException);

//    OUString 				getName(void);
//    XIdlClassRef 			getDeclaringClass(void);
//    XIdlClassRef 			getReturnType(void);
//    Sequence< ParamInfo > 	getParameterInfos(void);
//    MethodMode 				getMode(void);//    Sequence<XIdlClassRef> 	getParameterTypes(void);
//    Sequence<XIdlClassRef> 	getExceptionTypes(void);
//    UsrAny 					invoke(const UsrAny& obj, Sequence<UsrAny>& args)
//    	THROWS( (IllegalArgumentException, InvocationTargetException, UsrSystemException) );

protected:

	IdlClassAdapter_Impl&		m_rClass;
	OUString						m_name;
	Reference<XIdlClass> m_returnType;
	Sequence< ParamInfo >m_paramInfos;
	DISPID						m_dispId;
};

/*****************************************************************************

	class declaration IdlClassAdapter_Impl
	
*****************************************************************************/

struct hashUik_Impl
{
	size_t operator()(const Uik & rUik) const
	{
		//return rUik.getValue();
		// the first 4 bytes are the time
		return rUik.m_Data1;
	}
};

struct equalToUik_Impl
{
  bool operator()(const Uik & s1, const Uik & s2) const
  {
    return s1 == s2;
  }
};

typedef hash_map
<
	Uik,
	Reference<XIdlClass>,
	hashUik_Impl,
	equalToUik_Impl	
> ClassTable;



typedef hash_map
<
	OUString,
	IdlMethodAdapter_Impl*,
	hashOUString_Impl,
	equalOUString_Impl
> MethodList;

typedef hash_map
<
	OUString,
	IdlFieldAdapter_Impl*,
	hashOUString_Impl,
	equalOUString_Impl
> FieldList;



class IdlClassAdapter_Impl : public WeakImplHelper1< XIdlClass>
{
public:
	IdlClassAdapter_Impl(ITypeInfo* pTypeInfo, TYPEATTR* pTypeAttr);
	~IdlClassAdapter_Impl();

	// Methoden von XIdlClass
    virtual Sequence< Reference<XIdlClass > > SAL_CALL getClasses(  ) throw(RuntimeException);
    virtual Reference<XIdlClass > SAL_CALL getClass( const OUString& aName ) throw(RuntimeException);
    virtual sal_Bool SAL_CALL equals( const Reference<XIdlClass >& Type ) throw(RuntimeException);
    virtual sal_Bool SAL_CALL isAssignableFrom( const Reference<XIdlClass >& xType ) throw(RuntimeException);
    virtual TypeClass SAL_CALL getTypeClass(  ) throw(RuntimeException);
    virtual OUString SAL_CALL getName(  ) throw(RuntimeException);
    virtual Uik SAL_CALL getUik(  ) throw(RuntimeException);
    virtual Sequence<Reference<XIdlClass > > SAL_CALL getSuperclasses(  ) throw(RuntimeException);
    virtual Sequence<Reference<XIdlClass > > SAL_CALL getInterfaces(  ) throw(RuntimeException);
    virtual Reference<XIdlClass > SAL_CALL getComponentType(  ) throw(RuntimeException);
    virtual Reference<XIdlField > SAL_CALL getField( const OUString& aName ) throw(RuntimeException);
    virtual Sequence<Reference<XIdlField > > SAL_CALL getFields(  ) throw(RuntimeException);
    virtual Reference<XIdlMethod > SAL_CALL getMethod( const OUString& aName ) throw(RuntimeException);
    virtual Sequence<Reference<XIdlMethod > > SAL_CALL getMethods(  ) throw(RuntimeException);
    virtual Reference<XIdlArray > SAL_CALL getArray(  ) throw(RuntimeException);
    virtual void SAL_CALL createObject(Any& obj ) throw(RuntimeException);

	
protected:

	void addVarDesc(ITypeInfo* pTypeInfo, VARDESC* pVarDesc);
	void addFuncDesc(ITypeInfo* pTypeInfo, FUNCDESC* pFuncDesc);

	OUString 		m_name;
	Uik				m_uik;
	MethodList 		m_methods;
	FieldList 		m_fields;	
};

 
static ClassTable 	globalClassTable;
static OMutex		classTableMutex;

/*****************************************************************************

	class implementation IdlFieldAdapter_Impl
	
*****************************************************************************/

IdlFieldAdapter_Impl::IdlFieldAdapter_Impl(IdlClassAdapter_Impl& rClass, const OUString& name)
	: m_rClass(rClass)
	, m_name(name)
	, m_dispIdPropertyGet(0)
	, m_dispIdPropertyPut(0)
	, m_dispIdPropertyPutRef(0)
{
	// type of field	
	m_access = FieldAccessMode_READONLY;
}

IdlFieldAdapter_Impl::~IdlFieldAdapter_Impl()
{
	
}	

void IdlFieldAdapter_Impl::addFuncDesc(ITypeInfo* pTypeInfo, FUNCDESC* pFuncDesc)
{
	m_access = FieldAccessMode_READWRITE;
	
	m_dispIdPropertyGet = pFuncDesc->memid;
	m_dispIdPropertyPut = pFuncDesc->memid;
	m_dispIdPropertyPutRef = pFuncDesc->memid;
	
}	

void IdlFieldAdapter_Impl::addVarDesc(ITypeInfo* pTypeInfo, VARDESC* pVarDesc)
{
	m_dispIdPropertyGet = pVarDesc->memid;
	
	if (pVarDesc->varkind == VAR_CONST)
	{
		m_access = FieldAccessMode_CONST;
	}
	else
	{
		if (pVarDesc->wVarFlags != VARFLAG_FREADONLY)
		{
			m_dispIdPropertyGet = pVarDesc->memid;
			m_dispIdPropertyPut = pVarDesc->memid;
			m_dispIdPropertyPutRef = pVarDesc->memid;
			m_access = FieldAccessMode_READWRITE;
		}
	}
}	



OUString SAL_CALL IdlFieldAdapter_Impl::getName(void)
	throw( RuntimeException)
{
	return m_name;	
}	

FieldAccessMode	SAL_CALL IdlFieldAdapter_Impl::getAccessMode(void)
	throw( RuntimeException)
{
	return m_access;	
}	

Reference<XIdlClass> SAL_CALL IdlFieldAdapter_Impl::getDeclaringClass(void)
	throw( RuntimeException)
{
	return Reference<XIdlClass>( &m_rClass);
}	

Reference<XIdlClass> SAL_CALL IdlFieldAdapter_Impl::getType(void)
	throw( RuntimeException)
{
	return m_type;
}	

// Needs a association to the IUnknownWrapper, cause it delegates
// to getValueWithDispId
Any SAL_CALL IdlFieldAdapter_Impl::get(const Any& obj)
	throw(IllegalArgumentException, RuntimeException) 
{
	Any ret;

	if( obj.getValueTypeClass() == TypeClass_INTERFACE)
	{
		Reference<XInterface> xInt(*(XInterface**)obj.getValue());
		
		if (xInt.is())
		{
//			Reference< XUnoTunnel> spXUnoTunnel( xInt, UNO_QUERY);
//			IUnknownWrapper_Impl *pUnkWrapper= NULL;
//			if( spXUnoTunnel.is())
//				pUnkWrapper=(IUnknownWrapper_Impl*) spXUnoTunnel->getSomething(
//					IUnknownWrapper_Impl::getUnoTunnelId());
//			if( pUnkWrapper)
//				ret= pUnkWrapper->getValueWithDispId( m_dispIdPropertyGet);
//			else
//				throw IllegalArgumentException();
			
		}
		else
			throw IllegalArgumentException();
	}
	else
		throw IllegalArgumentException();

	return ret;	
}	

void SAL_CALL IdlFieldAdapter_Impl::set(const Any& obj, const Any& value)
	throw (IllegalArgumentException, IllegalAccessException, RuntimeException) 
{
	if( obj.getValueTypeClass() == TypeClass_INTERFACE)
	{
		Reference<XInterface> xInt( *(XInterface**)obj.getValue());
		
		if (xInt.is())
		{
//			Reference<XUnoTunnel> spXUnoWrapper( xInt, UNO_QUERY);
//			IUnknownWrapper_Impl *pUnkWrapper= NULL;
//			if( spXUnoWrapper.is)
//				pUnkWrapper= (IUnknownWrapper_Impl*)spXUnoWrapper->getSomething(
//					IUnknownWrapper_Impl::getUnoTunnelId());
//			if( pUnkWrapper)
//				pUnkWrapper->setValueWithDispId( m_dispIdPropertyPut, value);
//			else
//				throw IllegalArgumentException();
				
		}
		else
			throw IllegalArgumentException();
	}
	else
		throw IllegalArgumentException();
}	

/*****************************************************************************

	class implementation IdlMethodAdapter_Impl
	
*****************************************************************************/

IdlMethodAdapter_Impl::IdlMethodAdapter_Impl(IdlClassAdapter_Impl& 	rClass, const OUString& name)
	: m_rClass(rClass)
	, m_name(name)
	, m_dispId(0)
{
}	

IdlMethodAdapter_Impl::~IdlMethodAdapter_Impl()
{
	
}	

void IdlMethodAdapter_Impl::addFuncDesc(ITypeInfo* pTypeInfo, FUNCDESC* pFuncDesc)
{
	HRESULT result;

	m_dispId = pFuncDesc->memid;
	
	// parameters of method
	BSTR *oleNames = new BSTR[pFuncDesc->cParams + 1];
  	unsigned int cNames;
		
	result = pTypeInfo->GetNames(pFuncDesc->memid, oleNames, pFuncDesc->cParams + 1, &cNames);
	
	if (result == NOERROR)
	{
		// parameters of method
		m_paramInfos.realloc(pFuncDesc->cParams);

		for (sal_uInt32 i = 0; i < pFuncDesc->cParams; i++)
		{
			// parameter type
			// yet a hack !!!
			// !!!!!!!!!!!!!!!!!!!!!!!!!!
//			m_paramInfos.getArray()[i].aType = Any_getReflection()->getIdlClass();

			// parameter mode 
			m_paramInfos.getArray()[i].aMode = ParamMode_INOUT;

			// parameter name
			if ((i + 1) < cNames)
			{
				m_paramInfos.getArray()[i].aName = oleNames[i + 1];
				SysFreeString(oleNames[i + 1]);		
			}
		}

		SysFreeString(oleNames[0]);		
	}

	delete[] oleNames;

	// return type of method
	// yet a hack !!!

	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//m_returnType = Any_getReflection()->getIdlClass();
}	
	

OUString SAL_CALL IdlMethodAdapter_Impl::getName(void)
	throw (RuntimeException)
{
	return m_name;	
}	

Reference<XIdlClass> SAL_CALL IdlMethodAdapter_Impl::getDeclaringClass(void)
	throw (RuntimeException)
{
	return Reference<XIdlClass>( &m_rClass);
}	
Reference<XIdlClass > SAL_CALL IdlMethodAdapter_Impl::getReturnType(  )
	throw(RuntimeException)
{
	return m_returnType;	
}	
Sequence<ParamInfo > SAL_CALL IdlMethodAdapter_Impl::getParameterInfos(  )
	throw(RuntimeException)
{
	return m_paramInfos;		
}	

MethodMode SAL_CALL  IdlMethodAdapter_Impl::getMode(  )
	throw(RuntimeException)
{
	return MethodMode_TWOWAY;	
}	

Sequence<Reference<XIdlClass > > SAL_CALL IdlMethodAdapter_Impl::getParameterTypes(  )
	throw(RuntimeException)
{
	Sequence<Reference<XIdlClass> > ret(m_paramInfos.getLength());
	
	for (sal_uInt32 i = 0; i < m_paramInfos.getLength(); i++)
	{
		ret.getArray()[i] = m_paramInfos.getConstArray()[i].aType;
	}	
	
	return ret;	
}

Sequence<Reference<XIdlClass > > SAL_CALL IdlMethodAdapter_Impl::getExceptionTypes(  )
	throw(RuntimeException)
{
	return Sequence<Reference<XIdlClass> >();	
}	
Any SAL_CALL IdlMethodAdapter_Impl::invoke( const Any& obj, Sequence< Any >& args )
	throw(IllegalArgumentException, InvocationTargetException, RuntimeException)
{
	Any ret;

	if( obj.getValueTypeClass() == TypeClass_INTERFACE)
	{
		Reference<XInterface> xInt(*(XInterface**)obj.getValue());
		
		if (xInt.is())
		{
			Reference<XUnoTunnel> spXUnoWrapper( xInt, UNO_QUERY);
			IUnknownWrapper_Impl *pUnkWrapper= NULL;
			if( spXUnoWrapper.is)
//				pUnkWrapper= (IUnknownWrapper_Impl*)spXUnoWrapper->getSomething(
//					IUnknownWrapper_Impl::getUnoTunnelId());
			if( pUnkWrapper)
			{
				Sequence<sal_Int16> outParamIndex;
				Sequence<Any> outParams;

				ret = pUnkWrapper->invokeWithDispIdUnoTlb(m_dispId, args, outParamIndex, outParams);

				for (sal_uInt32 i = 0; i < outParamIndex.getLength(); i++)
				{
					(Any&)args.getConstArray()[outParamIndex.getConstArray()[i]] = 
						outParams.getConstArray()[i];				
				}
			}			
			else
				throw IllegalArgumentException();
		}
		else
			throw IllegalArgumentException();
	}
	else
		throw IllegalArgumentException();

	return ret;	
}	

/*****************************************************************************

	class implementation IdlClassAdapter_Impl
	
*****************************************************************************/

IdlClassAdapter_Impl::IdlClassAdapter_Impl(ITypeInfo* pTypeInfo, TYPEATTR* pTypeAttr)
{
	sal_uInt32 					i;
	HRESULT					result;
	VARDESC* 				pVarDesc = NULL;
	FUNCDESC* 				pFuncDesc = NULL;	
	BSTR 					oleName = NULL;
	IdlMethodAdapter_Impl* 	pNewMethod = NULL;
	IdlFieldAdapter_Impl* 	pNewField = NULL;

	m_uik = o2u_uikFromGUID(&(pTypeAttr->guid));
	
	result = pTypeInfo->GetDocumentation(MEMBERID_NIL, &oleName, NULL, NULL, NULL);

	if (result == NOERROR)
	{
		m_name = OUString(oleName);
		SysFreeString(oleName);
	}
	else
	{
		m_name= OUString::createFromAscii("OleObject");
	}

	for (i = 0; i < pTypeAttr->cVars; i++)
	{
		result = pTypeInfo->GetVarDesc(i, &pVarDesc);
		
		if (result == NOERROR)
		{
			addVarDesc(pTypeInfo, pVarDesc);
			pTypeInfo->ReleaseVarDesc(pVarDesc);
		}
	}		

	for (i = 0; i < pTypeAttr->cFuncs; i++)
	{
		result = pTypeInfo->GetFuncDesc(i, &pFuncDesc);
		
		if (result == NOERROR)
		{
			addFuncDesc(pTypeInfo, pFuncDesc);
			pTypeInfo->ReleaseFuncDesc(pFuncDesc);
		}
	}		
}	

IdlClassAdapter_Impl::~IdlClassAdapter_Impl()
{
	MethodList::iterator methodIter = m_methods.begin();

	while (methodIter != m_methods.end())
	{
		delete (*methodIter).second;
		methodIter++;
	}

	FieldList::iterator fieldIter = m_fields.begin();	

	while (fieldIter != m_fields.end())
	{
		delete (*fieldIter).second;
		fieldIter++;
	}
}	


Sequence< Reference<XIdlClass > > SAL_CALL IdlClassAdapter_Impl::getClasses(  )
	throw(RuntimeException)
{
	return Sequence<Reference<XIdlClass> >();	
}	
Reference<XIdlClass > SAL_CALL IdlClassAdapter_Impl::getClass( const OUString& aName )
	throw(RuntimeException)
{
	return Reference<XIdlClass>();	
}	
sal_Bool SAL_CALL IdlClassAdapter_Impl::equals( const Reference<XIdlClass >& aType )
	throw(RuntimeException)
{
	return (aType == Reference<XIdlClass>(this));	
}	

TypeClass SAL_CALL IdlClassAdapter_Impl::getTypeClass(void)
	throw(RuntimeException)
{
	return TypeClass_UNKNOWN;	
}	

OUString SAL_CALL IdlClassAdapter_Impl::getName(void)
	throw( RuntimeException)
{
	return m_name;
}	

Uik SAL_CALL IdlClassAdapter_Impl::getUik(void)
	throw( RuntimeException)
{
	return m_uik;
}	

Sequence< Reference< XIdlClass > > SAL_CALL IdlClassAdapter_Impl::getSuperclasses(void)
	throw (RuntimeException)
{
	return Sequence<Reference<XIdlClass> >();	
}	

Sequence<Reference<XIdlClass> > SAL_CALL IdlClassAdapter_Impl::getInterfaces(void)
	throw (RuntimeException)
{
	return Sequence<Reference<XIdlClass> >();	
}	

Reference<XIdlClass> SAL_CALL IdlClassAdapter_Impl::getComponentType(void)
	throw (RuntimeException)
{
	return Reference<XIdlClass>();	
}	

Reference<XIdlField> SAL_CALL IdlClassAdapter_Impl::getField(const OUString& aName)
	throw ( RuntimeException)
{
	Reference<XIdlField> ret;

	FieldList::iterator iter = m_fields.find(aName);
	
	if (iter != m_fields.end())
	{
		ret = (*iter).second;		
	}		

	return ret;	
}	

Sequence<Reference<XIdlField> > SAL_CALL IdlClassAdapter_Impl::getFields(void)
	throw (RuntimeException)
{
	Sequence<Reference<XIdlField> > ret(m_fields.size());
	sal_uInt32 i = 0;
	
	FieldList::iterator iter = m_fields.begin();
	
	while (iter != m_fields.end())
	{
		ret.getArray()[i++] = (*iter).second;
		iter++;
	}
	
	return ret;	
}	

Reference<XIdlMethod> SAL_CALL IdlClassAdapter_Impl::getMethod(const OUString& aName)
	throw ( RuntimeException)
{
	Reference<XIdlMethod> ret;

	MethodList::iterator iter = m_methods.find(aName);
	
	if (iter != m_methods.end())
	{
		ret = (*iter).second;		
	}		
	
	return ret;	
}	

Sequence<Reference<XIdlMethod> > SAL_CALL IdlClassAdapter_Impl::getMethods(void)
	throw( RuntimeException)
{
	Sequence<Reference<XIdlMethod> > ret(m_methods.size());
	sal_uInt32 i = 0;
	
	MethodList::iterator iter = m_methods.begin();
	
	while (iter != m_methods.end())
	{
		ret.getArray()[i++] = (*iter).second;
		iter++;
	}
	
	return ret;	
}	

Reference<XIdlArray> SAL_CALL IdlClassAdapter_Impl::getArray(void)
	throw( RuntimeException)
{
	return Reference<XIdlArray>();	
}	

void SAL_CALL IdlClassAdapter_Impl::createObject(Any& obj)
	throw ( RuntimeException)
{
	
}	

sal_Bool SAL_CALL IdlClassAdapter_Impl::isAssignableFrom(const Reference<XIdlClass>& xClass)
	throw (RuntimeException)
{
	return equals(xClass);	
}	

void IdlClassAdapter_Impl::addVarDesc(ITypeInfo* pTypeInfo, VARDESC* pVarDesc)
{
	OUString 		name;
	BSTR*			oleNames = new BSTR[1];
  	unsigned int 	cNames;
		
	HRESULT result = pTypeInfo->GetNames(pVarDesc->memid, oleNames, 1, &cNames);
	
	if (result == NOERROR)
	{
		name = oleNames[0];
		SysFreeString(oleNames[0]);		
		
		FieldList::iterator iter = m_fields.find(name);

		if (iter == m_fields.end())
		{
			IdlFieldAdapter_Impl* pNewField = new IdlFieldAdapter_Impl(*this, name);

			iter = m_fields.insert(FieldList::value_type(name, pNewField)).first;
		}

		(*iter).second->addVarDesc(pTypeInfo, pVarDesc);
	}

	delete[] oleNames;
}

void IdlClassAdapter_Impl::addFuncDesc(ITypeInfo* pTypeInfo, FUNCDESC* pFuncDesc)
{
	OUString 		name;
	BSTR*			oleNames = new BSTR[1];
  	unsigned int 	cNames;
		
	HRESULT result = pTypeInfo->GetNames(pFuncDesc->memid, oleNames, 1, &cNames);
	
	if (result == NOERROR)
	{
		name = oleNames[0];
		SysFreeString(oleNames[0]);		
		
		if (pFuncDesc->invkind == INVOKE_FUNC)
		{
			MethodList::iterator iter = m_methods.find(name);

			if (iter == m_methods.end())
			{
				IdlMethodAdapter_Impl* pNewMethod = new IdlMethodAdapter_Impl(*this, name);
				
				iter = m_methods.insert(MethodList::value_type(name, pNewMethod)).first;
			}

			(*iter).second->addFuncDesc(pTypeInfo, pFuncDesc);
		}
		else
		{
			FieldList::iterator iter = m_fields.find(name);

			if (iter == m_fields.end())
			{
				IdlFieldAdapter_Impl* pNewField = new IdlFieldAdapter_Impl(*this, name);

				iter = m_fields.insert(FieldList::value_type(name, pNewField)).first;
			}

			(*iter).second->addFuncDesc(pTypeInfo, pFuncDesc);
		}	
	}

	delete[] oleNames;
}

/*****************************************************************************

	function o2u_uikFromGUID()
	
*****************************************************************************/

Uik o2u_uikFromGUID(GUID* pGuid)
{
	Uik ret;
	memcpy( &ret, pGuid, 16);
	return ret;	
}	

/*****************************************************************************

	function o2u_createOleClassWrapper()
	
*****************************************************************************/

	
Reference<XIdlClass> o2u_createOleObjectWrapper(ITypeInfo* pTypeInfo)
{
	Reference<XIdlClass> ret;
	
	TYPEATTR* pTypeAttr = NULL;

	HRESULT result = pTypeInfo->GetTypeAttr(&pTypeAttr);
	
	if (result == NOERROR)
	{
		{
			OGuard guard(classTableMutex);
			
			Uik uik = o2u_uikFromGUID(&(pTypeAttr->guid));

			ClassTable::iterator iter = globalClassTable.find(uik);
			
			if (iter == globalClassTable.end())
			{
				Reference<XIdlClass> xNewClass = new IdlClassAdapter_Impl(pTypeInfo, pTypeAttr);
				
				iter = globalClassTable.insert(ClassTable::value_type(uik, xNewClass)).first;
			}
			
			ret = (*iter).second;
		}
		
		pTypeInfo->ReleaseTypeAttr(pTypeAttr);			
	}
	
	return ret;
}	

} // end namespace
