<?xml version="1.0" encoding="UTF-8"?>
<!-- #  The Contents of this file are made available subject to the terms of
 #  either of the following licenses
 #
 #         - GNU Lesser General Public License Version 2.1
 #         - Sun Industry Standards Source License Version 1.1
 #
 #  Sun Microsystems Inc., October, 2000
 #
 #  GNU Lesser General Public License Version 2.1
 #  =============================================
 #  Copyright 2000 by Sun Microsystems, Inc.
 #  901 San Antonio Road, Palo Alto, CA 94303, USA
 #
 #  This library is free software; you can redistribute it and/or
 #  modify it under the terms of the GNU Lesser General Public
 #  License version 2.1, as published by the Free Software Foundation.
 #
 #  This library is distributed in the hope that it will be useful,
 #  but WITHOUT ANY WARRANTY; without even the implied warranty of
 #  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 #  Lesser General Public License for more details.
 #
 #  You should have received a copy of the GNU Lesser General Public
 #  License along with this library; if not, write to the Free Software
 #  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 #  MA  02111-1307  USA
 #
 #
 #  Sun Industry Standards Source License Version 1.1
 #  =================================================
 #  The contents of this file are subject to the Sun Industry Standards
 #  Source License Version 1.1 (the "License"); You may not use this file
 #  except in compliance with the License. You may obtain a copy of the
 #  License at http://www.openoffice.org/license.html.
 #
 #  Software provided under this License is provided on an "AS IS" basis,
 #  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 #  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 #  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 #  See the License for the specific provisions governing your rights and
 #  obligations concerning the Software.
 #
 #  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 #
 #  Copyright: 2000 by Sun Microsystems, Inc.
 #
 #  All Rights Reserved.
 #
 #  Contributor(s): _______________________________________
 #
 #-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:SL="http://schemas.microsoft.com/schemaLibrary/2003/core" xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882" xmlns:office="http://openoffice.org/2000/office" xmlns:table="http://openoffice.org/2000/table" xmlns:style="http://openoffice.org/2000/style" xmlns:text="http://openoffice.org/2000/text" xmlns:draw="http://openoffice.org/2000/drawing" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:number="http://openoffice.org/2000/datastyle" xmlns:svg="http://www.w3.org/2000/svg" xmlns:chart="http://openoffice.org/2000/chart" xmlns:dr3d="http://openoffice.org/2000/dr3d" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="http://openoffice.org/2000/form" xmlns:script="http://openoffice.org/2000/script" office:class="text" office:version="1.0">
	<xsl:output method="xml" indent="yes" omit-xml-declaration="no" encoding="UTF-8" version="1.0"/>
	<!--<xsl:include href="mstables.xsl"/>
<xsl:include href="mslists.xsl"/>
<xsl:include href="styles.xsl"/>
<xsl:include href="graphics.xsl"/>
<xsl:include href="fields.xsl"/>-->
	<xsl:template match="w:wordDocument">
		<office:document xmlns:office="http://openoffice.org/2000/office" xmlns:style="http://openoffice.org/2000/style" xmlns:text="http://openoffice.org/2000/text" xmlns:table="http://openoffice.org/2000/table" xmlns:draw="http://openoffice.org/2000/drawing" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:number="http://openoffice.org/2000/datastyle" xmlns:svg="http://www.w3.org/2000/svg" xmlns:chart="http://openoffice.org/2000/chart" xmlns:dr3d="http://openoffice.org/2000/dr3d" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="http://openoffice.org/2000/form" xmlns:script="http://openoffice.org/2000/script" office:class="text" office:version="1.0">
			<xsl:apply-templates/>
		</office:document>
	</xsl:template>
	<xsl:template match="w:body">
		<xsl:element name="office:body">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="o:DocumentProperties"/>
	<xsl:template match="w:p[child::w:pPr/w:listPr]">
		<xsl:call-template name="genlist"/>
	</xsl:template>
	<xsl:template match="w:hlink">
		<xsl:element name="text:a">
			<xsl:attribute name="xlink:type">simple</xsl:attribute>
			<xsl:attribute name="xlink:href"><xsl:value-of select="@w:dest"/></xsl:attribute>
			<xsl:value-of select="descendant::w:t"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:p">
		<xsl:choose>
			<!-- because word treats page breaks as separate tags, we must split some paragraphs up so that we can 
			give the sub para a fo:break-before ="page" attribute
		-->
			<xsl:when test="child::w:r[child::w:br/@w:type='page']  ">
				<xsl:call-template name="processPageBreaks"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="commonPara"/>
			</xsl:otherwise>
		</xsl:choose>
		<!--<xsl:apply-templates/>-->
	</xsl:template>
	<xsl:template name="processPageBreaks">
		<xsl:variable name="pageBreak" select="child::w:r[child::w:br/@w:type='page']"/>
		<xsl:call-template name="createSubPara">
			<xsl:with-param name="list" select="$pageBreak[1]/preceding-sibling::w:r"/>
			<xsl:with-param name="pageBreak"/>
			<xsl:with-param name="needsPageBreak">false</xsl:with-param>
		</xsl:call-template>
		<xsl:for-each select="$pageBreak">
			<xsl:call-template name="createSubPara">
				<xsl:with-param name="list" select="./following-sibling::w:r[preceding::w:r/child::w:br = '.']"/>
				<xsl:with-param name="pageBreak" select="."/>
				<xsl:with-param name="needsPageBreak">true</xsl:with-param>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="createSubPara">
		<xsl:param name="list"/>
		<xsl:param name="pageBreak"/>
		<xsl:param name="needsPageBreak"/>
		<xsl:if test="(count($list) &gt; 0) or ($needsPageBreak ='true') ">
			<xsl:element name="text:p">
				<xsl:choose>
					<xsl:when test="$needsPageBreak = 'true'">
						<xsl:choose>
							<xsl:when test="ancestor::w:p/w:pPr">
								<xsl:attribute name="text:style-name">P<xsl:value-of select="count(ancestor::w:p/w:pPr/preceding::w:pPr)"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="text:style-name">PageBreak</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="text:style-name">Normal</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="$pageBreak">
					<xsl:apply-templates select="$pageBreak"/>
				</xsl:if>
				<xsl:apply-templates select="$list"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template name="commonPara">
		<!-- Heading or normal para-->
		<xsl:choose>
			<xsl:when test="(child::w:pPr/w:pStyle/@w:val='Heading1') or (child::w:pPr/w:pStyle/@w:val='Heading2') or 
						(child::w:pPr/w:pStyle/@w:val='Heading3') or  (child::w:pPr/w:pStyle/@w:val='Heading4') or 
						(child::w:pPr/w:pStyle/@w:val='Heading5') or  (child::w:pPr/w:pStyle/@w:val='Heading6') or  
						(child::w:pPr/w:pStyle/@w:val='Heading7') or  (child::w:pPr/w:pStyle/@w:val='Heading8') or  
						(child::w:pPr/w:pStyle/@w:val='Heading9')">
				<xsl:variable name="styleid" select="child::w:pPr/w:pStyle/@w:val"/>
				<xsl:element name="text:h">
					<xsl:variable name="outlinelevel" select="number(/descendant::w:style[@w:styleId = $styleid]/w:pPr/w:outlineLvl/@w:val)+1"/>
					<xsl:if test="$outlinelevel">
						<xsl:attribute name="text:level"><xsl:value-of select="$outlinelevel"/></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="commonParaAttribs"/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="text:p">
					<xsl:call-template name="commonParaAttribs"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="commonParaAttribs">
		<!-- Common  paragraph attributes-->
		<xsl:choose>
			<xsl:when test="child::w:pPr">
				<!--<xsl:choose>
					<xsl:when test="child::w:pPr/w:pStyle">
						<xsl:attribute name="text:style-name"><xsl:value-of select="child::w:pPr/w:pStyle/@w:val"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="text:style-name">P<xsl:value-of select="count(preceding::w:pPr)"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>-->
				<xsl:attribute name="text:style-name">P<xsl:value-of select="count(preceding::w:pPr)"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="not(child::w:pPr) and (descendant::w:br[@w:type = 'column'] or ancestor::wx:sect/descendant::w:sectPr[w:cols/@w:num &gt; 1])">
				<xsl:attribute name="text:style-name">ColumnBreakPara</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="text:style-name">Normal</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="child::*"/>
	</xsl:template>
	<xsl:template match="w:pPr"/>
	<xsl:template match="w:rPr"/>
	<xsl:template match="wx:sect">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="wx:sub-section">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:t">
		<xsl:choose>
			<xsl:when test="string(.) = ' ' ">
				<xsl:element name="text:s"/>
			</xsl:when>
			<xsl:when test="contains(.,'  ')">
				<xsl:call-template name="replace-spaces">
					<xsl:with-param name="curr-string" select="."/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="replace-spaces">
		<xsl:param name="curr-string"/>
		<xsl:if test="contains($curr-string,'  ')">
			<xsl:value-of select="substring-before($curr-string,' ')"/>
			<xsl:element name="text:s">
				<xsl:attribute name="text:c">2</xsl:attribute>
			</xsl:element>
			<xsl:variable name="next-string" select="substring-after($curr-string,'  ')"/>
			<xsl:choose>
				<xsl:when test="contains($next-string, '  ')">
					<xsl:call-template name="replace-spaces">
						<xsl:with-param name="curr-string" select="$next-string"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$next-string"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:tab">
		<xsl:element name="text:tab-stop"/>
	</xsl:template>
	<xsl:template match="w:hdr">
		<!-- empty template to ignore inline processing of header
		These are handled as part of the master style in styles.xsl
	-->
	</xsl:template>
	<xsl:template match="w:ftr">
		<!-- empty template to ignore inline processing of header
		These are handled as part of the master style in styles.xsl
	-->
	</xsl:template>
	<xsl:template match="w:docPr"/>
	<xsl:template match="w:r">
		<xsl:variable name="body" select="ancestor::w:body"/>
		<xsl:if test="child::w:br[@w:type='text-wrapping'] or child::w:br[not(@w:type)]">
			<xsl:element name="text:line-break"/>
		</xsl:if>
		<xsl:choose>
			<!--<xsl:when test="child::w:br[@w:type='text-wrapping'] and not(child::w:t)">
			<xsl:element name="text:p"> 
			</xsl:element>
		</xsl:when>-->
			<xsl:when test="child::w:rPr/w:vanish">
				<xsl:element name="text:hidden-text">
					<xsl:attribute name="text:is-hidden">false</xsl:attribute>
					<xsl:attribute name="text:condition">hide==1</xsl:attribute>
					<xsl:attribute name="text:string-value"><xsl:value-of select="."/></xsl:attribute>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="(preceding-sibling::w:r) or (child::w:rPr)">
				<xsl:element name="text:span">
					<!--<xsl:if test="child::w:rPr">
							<xsl:attribute name="text:style-name">T<xsl:value-of select="count(preceding::w:rPr)"/></xsl:attribute>
					</xsl:if>		-->
					<xsl:choose>
						<xsl:when test="child::w:rPr/w:rStyle">
							<xsl:attribute name="text:style-name"><xsl:value-of select="child::w:rPr/w:rStyle/@w:val"/></xsl:attribute>
						</xsl:when>
						<xsl:when test="child::w:rPr">
							<xsl:attribute name="text:style-name">T<xsl:value-of select="count(preceding::w:rPr)"/></xsl:attribute>
						</xsl:when>
						<!--<xsl:when test="child::w:br/@w:type='page'">
								<xsl:attribute name="text:style-name">PageBreak</xsl:attribute>
						</xsl:when>-->
					</xsl:choose>
					<!--<xsl:if test="not(child::w:rPr) and ((count($body/preceding::w:rPr) - count($body/descendant::w:rPr))&gt; 0)">
							<xsl:attribute name="text:style-name">T<xsl:value-of select="count(preceding::w:rPr)"/></xsl:attribute>
					</xsl:if>-->
					<!--<xsl:apply-templates select="w:t"/>-->
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="wx:sect">
		<xsl:apply-templates/>
	</xsl:template>
	<!-- Paragraph properties-->
	<!--<xsl:template match="w:rPr[ancestor::w:body]">
		<xsl:attribute name="text:style-name">T<xsl:value-of select="count(preceding::w:rPr)+count(preceding::w:pPr)+1"/></xsl:attribute>
		<xsl:apply-templates select="descendant::*"/>
</xsl:template>

<xsl:template match="w:pPr[ancestor::w:body]">
		<xsl:attribute name="text:style-name">T<xsl:value-of select="count(preceding::w:rPr)+count(preceding::w:pPr)+1"/></xsl:attribute>
		<xsl:apply-templates select="w:rPr"/>
</xsl:template>-->
	<xsl:template match="wx:font[ancestor::w:fonts]">
		<xsl:if test="not(ancestor::w:p)">
			<xsl:attribute name="style:font-name"><xsl:value-of select="@wx:val"/></xsl:attribute>
			<xsl:apply-templates/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:pStyle">
		<xsl:if test="not(ancestor-or-self::w:styles)">
			<xsl:choose>
				<xsl:when test="not(@w:val = '')">
					<xsl:attribute name="text:style-name"><xsl:value-of select="@w:val"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="text:style-name">Normal</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:sz">
		<xsl:attribute name="fo:font-size"><xsl:value-of select="number(@w:val) div 2 "/>pt</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:i">
		<xsl:attribute name="fo:font-style">italic</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:b">
		<xsl:attribute name="fo:font-weight">bold</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:u">
		<xsl:attribute name="style:text-underline"><xsl:value-of select="@w:val"/></xsl:attribute>
		<xsl:if test="@w:color">
			<xsl:attribute name="style:text-underline-color">#<xsl:value-of select="@w:color"/></xsl:attribute>
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:vertAlign">
		<xsl:attribute name="style:text-position"><xsl:choose><xsl:when test="@w:val = 'superscript'">super 58%</xsl:when><xsl:when test="@w:val = 'subscript'">sub 58%</xsl:when></xsl:choose></xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:shadow">
		<xsl:attribute name="style:text-shadow">1pt 1pt</xsl:attribute>
		<xsl:attribute name="fo:text-shadow">1pt 1pt</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:strike">
		<xsl:attribute name="style:text-crossing-out">single-line</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:dstrike">
		<xsl:attribute name="style:text-crossing-out">double-line</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:color">
		<xsl:attribute name="fo:color">#<xsl:value-of select="@w:val"/></xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:smallCaps">
		<xsl:attribute name="fo:font-variant">small-caps</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:caps">
		<xsl:attribute name="fo:text-transform">uppercase</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:imprint">
		<xsl:attribute name="style:font-relief">engraved</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:emboss">
		<xsl:attribute name="style:font-relief">embossed</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:outline">
		<xsl:attribute name="style:text-outline">true</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:listPr/wx:font"/>
	<xsl:template match="wx:font">
		<xsl:attribute name="style:font-name"><xsl:value-of select="@wx:val"/></xsl:attribute>
		<xsl:apply-templates/>
	</xsl:template>
	<!-- <style:style style:name="P1" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties style:text-underline="single" style:text-underline-color="font-color"/>
		</style:style>
		<style:style style:name="P2" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties fo:font-weight="bold"/>
		</style:style>
		<style:style style:name="P3" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties fo:font-style="italic"/>
		</style:style>
		<style:style style:name="P4" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties style:text-crossing-out="single-line"/> <w:strike/> <w:strike>
		</style:style>
		<style:style style:name="P5" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties style:text-position="super 58%"/> 	<w:vertAlign w:val="superscript"/>
		</style:style>
		<style:style style:name="P6" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties style:text-position="sub 58%"/>         <w:vertAlign w:val="subscript"/>
		</style:style>
		<style:style style:name="P7" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties fo:text-shadow="1pt 1pt"/> <w:shadow>
		</style:style>
		<style:style style:name="P8" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties style:text-outline="true"/>
		</style:style>
		<style:style style:name="P9" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties fo:font-style="italic" fo:font-weight="bold"/>
		</style:style>
		<style:style style:name="P10" style:family="paragraph" style:parent-style-name="Normal">
			<style:properties style:text-underline="double" style:text-underline-color="font-color"/>
		</style:style>
-->
	<!-- <style:style style:name="Heading 2" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text body" style:class="text">
			<style:properties fo:font-size="14pt" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="14pt" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="14pt" style:font-style-complex="italic" style:font-weight-complex="bold"  style:font-name-complex="Tahoma1"/>
		</style:style>


		
		<w:style w:type="paragraph" w:default="on" w:styleId="Normal">
			<w:name w:val="Normal"/>
			<w:rsid w:val="CA2749"/>
			<w:rPr>
				<wx:font wx:val="Times New Roman"/>
				<w:sz w:val="24"/>
				<w:sz-cs w:val="24"/>
				<w:lang w:val="EN-US" w:fareast="EN-US" w:bidi="AR-SA"/>
			</w:rPr>
		</w:style>

		
		-->
	<xsl:template match="w:fonts">
		<xsl:element name="office:font-decls">
			<style:font-decl style:name="Arial" fo:font-family="Arial" style:font-family-generic="roman" style:font-pitch="variable"/>
			<style:font-decl style:name="Times New Roman" fo:font-family="'Times New Roman'" style:font-family-generic="roman" style:font-pitch="variable"/>
			<!-- <style:font-decl style:name="Microsoft Sans Serif" fo:font-family="&apos;Microsoft Sans Serif&apos;" style:font-family-generic="swiss" style:font-pitch="variable"/>-->
			<style:font-decl style:name="Symbol" fo:font-family="Symbol" style:font-family-generic="roman" style:font-pitch="variable" style:font-charset="x-symbol"/>
			<xsl:if test="not(/w:wordDocument/w:fonts/w:font[@w:name='StarSymbol'])">
				<style:font-decl style:name="StarSymbol" fo:font-family="StarSymbol" style:font-charset="x-symbol"/>
			</xsl:if>
			<style:font-decl style:name="Courier New" fo:font-family="'Courier New'" style:font-family-generic="modern" style:font-pitch="fixed"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:font">
		<xsl:element name="style:font-decl">
			<xsl:attribute name="style:name"><xsl:value-of select="@w:name"/></xsl:attribute>
			<xsl:attribute name="fo:font-family"><xsl:value-of select="@w:name"/></xsl:attribute>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:family">
		<xsl:attribute name="style:font-family-generic"><xsl:choose><xsl:when test="@w:val = 'Swiss'">swiss</xsl:when><xsl:when test="@w:val='Modern'">modern</xsl:when><xsl:when test="@w:val='Roman'">roman</xsl:when><xsl:when test="@w:val='Script'">script</xsl:when><xsl:when test="@w:val='Decorative'">decorative</xsl:when><xsl:when test="@w:val='System'">system</xsl:when></xsl:choose></xsl:attribute>
	</xsl:template>
	<xsl:template match="w:pitch">
		<xsl:attribute name="style:font-pitch"><xsl:value-of select="@w:val"/></xsl:attribute>
	</xsl:template>
	<!-- 
<w:fonts>
		<w:defaultFonts w:ascii="Times New Roman" w:fareast="Times New Roman" w:h-ansi="Times New Roman" w:cs="Times New Roman"/>
		<w:font w:name="Tahoma">
			<w:panose-1 w:val="020B0604030504040204"/>
			<w:charset w:val="00"/>
			<w:family w:val="Swiss"/>
			<w:pitch w:val="variable"/>
			<w:sig w:usb-0="61007A87" w:usb-1="80000000" w:usb-2="00000008" w:usb-3="00000000" w:csb-0="000101FF" w:csb-1="00000000"/>
		</w:font>
		<w:font w:name="Palatino">
			<w:panose-1 w:val="00000000000000000000"/>
			<w:charset w:val="00"/>
			<w:family w:val="Roman"/>
			<w:notTrueType/>
			<w:pitch w:val="variable"/>
			<w:sig w:usb-0="00000003" w:usb-1="00000000" w:usb-2="00000000" w:usb-3="00000000" w:csb-0="00000001" w:csb-1="00000000"/>
		</w:font>
	</w:fonts>
	
		<style:font-decl style:name="Andale Sans UI" fo:font-family="&apos;Andale Sans UI&apos;" style:font-pitch="variable"/>
		<style:font-decl style:name="Thorndale" fo:font-family="Thorndale" style:font-family-generic="roman" style:font-pitch="variable"/>

	
-->
	<xsl:template match="wx:sect">
		<!-- We handle Columns as seperate Sections to allow for different numbers of columns on the same page-->
		<xsl:choose>
			<xsl:when test="descendant::w:sectPr[w:cols/@w:num &gt; 1]">
				<xsl:element name="text:section">
					<xsl:attribute name="text:style-name">sect<xsl:value-of select="count(preceding::w:sectPr[child::w:cols/@w:num &gt;1])"/></xsl:attribute>
					<xsl:attribute name="text:name">sect<xsl:value-of select="count(preceding::w:sectPr[child::w:cols/@w:num &gt;1])"/></xsl:attribute>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*">
		<xsl:apply-templates/>
	</xsl:template>
	<!-- 
	Style Handling 

-->
	<!--Styles-->
	<xsl:template match="w:styles">
		<xsl:element name="office:styles">
			<style:style style:name="Numbering Symbols" style:family="text"/>
			<style:style style:name="ColumnBreakPara" style:family="paragraph">
				<style:properties fo:break-after="column"/>
			</style:style>
			<xsl:element name="style:default-style">
				<xsl:attribute name="style:family">paragraph</xsl:attribute>
				<xsl:element name="style:properties">
					<xsl:attribute name="style:font-name"><xsl:choose><!--	<w:defaultFonts w:ascii="Times New Roman" w:fareast="Times New Roman" w:h-ansi="Times New Roman" w:cs="Times New Roman"/>
 --><xsl:when test="preceding::w:fonts/w:defaultFonts"><xsl:value-of select="preceding::w:fonts/w:defaultFonts/@w:ascii"/></xsl:when><xsl:otherwise><xsl:text>Times New Roman</xsl:text></xsl:otherwise></xsl:choose></xsl:attribute>
					<xsl:attribute name="style:tab-stop-distance"><xsl:value-of select="(number(/descendant::w:docPr/w:defaultTabStop/@w:val)div 1440)*2.54"/>cm</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:apply-templates/>
			<style:style style:name="Bullet Symbols" style:family="text">
				<style:properties style:font-name="StarSymbol" fo:font-size="9pt" style:font-name-asian="StarSymbol" style:font-size-asian="9pt" style:font-name-complex="StarSymbol" style:font-size-complex="9pt"/>
			</style:style>
		</xsl:element>
		<xsl:element name="office:automatic-styles">
			<xsl:element name="style:style">
				<xsl:attribute name="style:name">PageBreak</xsl:attribute>
				<xsl:attribute name="style:family">paragraph</xsl:attribute>
				<xsl:attribute name="style:parent-style-name">Normal</xsl:attribute>
				<xsl:element name="style:properties">
					<xsl:attribute name="fo:break-before">page</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:for-each select="/descendant::w:rPr">
				<style:style>
					<xsl:attribute name="style:name">T<xsl:value-of select="count(preceding::w:rPr)"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="@w:type">
							<xsl:choose>
								<xsl:when test="@w:type = 'character' ">
									<xsl:attribute name="style:family">text</xsl:attribute>
								</xsl:when>
								<xsl:when test="@w:type = 'list' ">
									<xsl:attribute name="style:family">text</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="style:family"><xsl:value-of select="@w:type"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="ancestor::w:pPr">
							<xsl:attribute name="style:family">paragraph</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:family">text</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="child::w:rStyle">
							<xsl:attribute name="style:parent-style-name"><xsl:value-of select="child::w:rStyle/@w:val"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:parent-style-name">Normal</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:element name="style:properties">
						<xsl:apply-templates select="child::*"/>
					</xsl:element>
				</style:style>
			</xsl:for-each>
			<xsl:for-each select="/descendant::w:pPr">
				<style:style>
					<xsl:attribute name="style:name">P<xsl:value-of select="count(preceding::w:pPr)"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="@w:type">
							<xsl:choose>
								<xsl:when test="@w:type = 'character' ">
									<xsl:attribute name="style:family">text</xsl:attribute>
								</xsl:when>
								<xsl:when test="@w:type = 'list' ">
									<xsl:attribute name="style:family">text</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="style:family"><xsl:value-of select="@w:type"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="parent::w:p">
							<xsl:attribute name="style:family">paragraph</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:family">text</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="child::w:pStyle">
							<xsl:attribute name="style:parent-style-name"><xsl:value-of select="child::w:pStyle/@w:val"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:parent-style-name">Normal</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- We don't want to change the page style if there are columns being created. 
					The Columns will be handled by using in-line sections.-->
					<xsl:if test="not(ancestor::wx:sect[1]/descendant::w:sectPr/w:cols[@w:num &gt; 1])">
						<xsl:variable name="parentpara" select="parent::w:p"/>
						<xsl:if test="generate-id(ancestor::wx:sect/descendant::w:p[1]) = generate-id($parentpara)">
							<xsl:choose>
								<xsl:when test="not(count(preceding::wx:sect) &gt; 0)">
									<xsl:attribute name="style:master-page-name">Standard</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="style:master-page-name">Standard<xsl:value-of select="number(count(preceding::wx:sect) )"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:if>
					<xsl:variable name="rootPara" select="parent::w:p"/>
					<xsl:if test="$rootPara/descendant::w:br[@w:type = 'page']">
						<!--<w:br w:type="page"/>
		<style:properties fo:margin-left="0.026cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false" fo:break-before="page"/>
								-->
						<xsl:if test="not(ancestor::wx:sect[1]/descendant::w:sectPr/w:cols[@w:num &gt; 1]) and not($rootPara/descendant::w:br/@w:type='text-wrapping')">
							<xsl:variable name="parentsect" select="ancestor::wx:sect"/>
							<xsl:choose>
								<xsl:when test="following::w:sectPr">
									<xsl:choose>
										<xsl:when test="not(count(preceding::wx:sect) &gt; 0)">
											<xsl:attribute name="style:master-page-name">Standard</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style:master-page-name">Standard<xsl:value-of select="number(count(preceding::wx:sect) )"/></xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="fo:break-before"><xsl:value-of select="$rootPara/descendant::w:br/@w:type"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:if>
					<xsl:element name="style:properties">
						<xsl:if test="parent::w:p">
							<!-- Initial indent values-->
							<!--<xsl:attribute name="fo:margin-left">0cm</xsl:attribute>
						<xsl:attribute name="fo:margin-right">0cm</xsl:attribute>
						<xsl:attribute name="fo:text-indent">0cm</xsl:attribute>-->
							<xsl:call-template name="paragraph-alignment"/>
						</xsl:if>
						<xsl:if test="not(ancestor::wx:sect = following::w:pPr/ancestor::wx:sect)">
							<!--<xsl:attribute name="fo:break-after">page</xsl:attribute>-->
						</xsl:if>
						<xsl:apply-templates select="parent::w:p/child::w:rPr/*[not(name() = 'w:tabs')]"/>
						<xsl:apply-templates select="child::*[not(name() = 'w:tabs')]"/>
					</xsl:element>
				</style:style>
			</xsl:for-each>
			<xsl:for-each select="/descendant::w:gridCol ">
				<style:style>
					<xsl:variable name="tableRoot" select="ancestor::w:tbl"/>
					<xsl:attribute name="style:name">TColumn<xsl:value-of select="count(preceding::w:gridCol)"/></xsl:attribute>
					<xsl:attribute name="style:family">table-column</xsl:attribute>
					<xsl:element name="style:properties">
						<xsl:attribute name="style:column-width"><xsl:choose><xsl:when test="$tableRoot/w:tblPr/w:tblW/@w:type = 'pct'"><xsl:variable name="pageSize" select="number(/descendant::w:body/wx:sect/w:sectPr/w:pgSz/@w:w)"/><xsl:variable name="pageLeftMar" select="number(/descendant::w:body/wx:sect/w:sectPr/w:pgMar/@w:left)"/><xsl:variable name="pageRightMar" select="number(/descendant::w:body/wx:sect/w:sectPr/w:pgMar/@w:right)"/><xsl:variable name="pctTotal" select="$tableRoot/w:tblPr/w:tblW/@w:w"/><xsl:variable name="prevCols" select="count(preceding-sibling::w:gridCol)"/><xsl:variable name="relSize" select="$tableRoot/w:tr[1]/w:tc[$prevCols+1]/w:tcPr/w:tcW/@w:w"/><!--<xsl:value-of select="$relSize"/>
							<xsl:text> </xsl:text>
							<xsl:value-of select="$pctTotal"/>
							<xsl:text> </xsl:text>
							<xsl:value-of select="$pageSize"/>
							<xsl:text> </xsl:text>--><xsl:value-of select="(number(($relSize div $pctTotal) * ($pageSize - ($pageLeftMar + $pageRightMar))) div 1440) *2.54"/><!-- 
								<w:tblPr>
					<w:tblStyle w:val="TableGrid"/>
					<w:tblW w:w="0" w:type="auto"/>
					<w:tblLook w:val="000001E0"/>
				</w:tblPr>

						
							<xsl:variable name="percentTotal" select="child::w:tblW/@w:w"/>
							<xsl:variable name="aRow" select="following-sibling::w:tr[1]/w:tc/w:tcPr/w:tcW/@w:w"/>
							<xsl:for-each select="$aRow">
						
								--></xsl:when><xsl:otherwise><xsl:value-of select="(number(@w:w) div 1440) *2.54"/></xsl:otherwise></xsl:choose><xsl:text>cm</xsl:text></xsl:attribute>
					</xsl:element>
				</style:style>
			</xsl:for-each>
			<xsl:for-each select="/descendant::w:tblPr">
				<xsl:element name="style:style">
					<xsl:attribute name="style:name">TTable<xsl:value-of select="count(preceding::w:tblPr)"/></xsl:attribute>
					<xsl:attribute name="style:family">table</xsl:attribute>
					<xsl:element name="style:properties">
						<!-- Hard coded to be over-ridden later-->
						<xsl:attribute name="table:align">left</xsl:attribute>
						<xsl:attribute name="style:writing-mode">lr-tb</xsl:attribute>
						<!-- <w:tblW w:w="5000" w:type="pct"/>-->
						<!-- Setting table margins using cell padding-->
						<xsl:if test="child::w:tblStyle/@w:val">
							<xsl:variable name="rootStyle" select="child::w:tblStyle/@w:val"/>
							<xsl:variable name="rootStyleNode" select="/descendant::w:style[@w:styleId = $rootStyle]"/>
							<xsl:variable name="paddingleft">
								<xsl:value-of select="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:left/@w:w"/>
							</xsl:variable>
							<xsl:variable name="paddingright">
								<xsl:value-of select="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:right/@w:w"/>
							</xsl:variable>
							<xsl:variable name="paddingtop">
								<xsl:value-of select="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:top/@w:w"/>
							</xsl:variable>
							<xsl:variable name="paddingbottom">
								<xsl:value-of select="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:bottom/@w:w"/>
							</xsl:variable>
							<xsl:if test="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:left">
								<xsl:attribute name="fo:margin-left">-<xsl:value-of select="(number($paddingleft) div 1440) *2.54"/>cm</xsl:attribute>
							</xsl:if>
							<!--
						<xsl:if test="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:right">
							<xsl:attribute name="fo:margin-right">-<xsl:value-of select="(number($paddingright) div 1440) *2.54"/>cm</xsl:attribute>
						</xsl:if>
						-->
						</xsl:if>
						<xsl:choose>
							<xsl:when test="child::w:tblW/@w:type ='pct'">
								<xsl:variable name="sectPr" select="/descendant::wx:sect/w:sectPr"/>
								<xsl:variable name="pageSize" select="number($sectPr/w:pgSz/@w:w)"/>
								<xsl:variable name="pageLeftMar" select="number($sectPr/w:pgMar/@w:left)"/>
								<xsl:variable name="pageRightMar" select="number($sectPr/w:pgMar/@w:right)"/>
								<xsl:attribute name="style:width"><xsl:value-of select="((    (number($sectPr/w:pgSz/@w:w) - number($pageLeftMar + $pageRightMar)  +(113 *2))div 1440)*2.54)*(number(child::w:tblW/@w:w) div 5000)"/><xsl:text>cm</xsl:text></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="colwidth" select="parent::w:tbl"/>
								<xsl:variable name="gridcols" select="$colwidth/w:tblGrid/w:gridCol"/>
								<xsl:variable name="tblsize" select="sum($gridcols/@w:w)"/>
								<xsl:if test="not($tblsize='0')">
									<xsl:attribute name="style:width"><xsl:choose><xsl:when test="child::w:tblInd"><xsl:value-of select="(number($tblsize -  child::w:tblInd/@w:w) div 1440)*2.54"/></xsl:when><xsl:otherwise><xsl:value-of select="(number($tblsize  ) div 1440)*2.54"/></xsl:otherwise></xsl:choose><xsl:text>cm</xsl:text></xsl:attribute>
								</xsl:if>
								<!-- If previous w:p has a page break, the table must have
								 the page break attribute applied to it
							-->
								<!-- May need this for tables starting on new pages-->
								<!--<xsl:if test="parent::w:tbl/preceding-sibling::w:p[1][descendant::w:br/@w:type='page']">
								<xsl:attribute name="fo:break-before">page</xsl:attribute>
							</xsl:if>-->
							</xsl:otherwise>
						</xsl:choose>
						<!-- initial values for tables-->
						<!--<xsl:attribute name="fo:border-left">0.002cm solid #000000</xsl:attribute>
					       <xsl:attribute name="fo:border-right">0.002cm solid #000000</xsl:attribute>
						<xsl:attribute name="fo:border-top">0.002cm solid #000000</xsl:attribute>
						<xsl:attribute name="fo:border-bottom">0.002cm solid #000000</xsl:attribute>
						<xsl:attribute name="fo:vertical-align">top</xsl:attribute>
						<xsl:attribute name="fo:padding-left">0.191cm</xsl:attribute>
						<xsl:attribute name="fo:padding-right">0.191cm</xsl:attribute>
						<xsl:attribute name="fo:padding-top">0cm</xsl:attribute>
						<xsl:attribute name="fo:padding-bottom">0cm</xsl:attribute>-->
						<xsl:apply-templates/>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
			<xsl:for-each select="/descendant::w:tcPr">
				<style:style>
					<xsl:attribute name="style:name">TCell<xsl:value-of select="count(preceding::w:tcPr)"/></xsl:attribute>
					<xsl:attribute name="style:family">table-cell</xsl:attribute>
					<xsl:element name="style:properties">
						<!-- Hard coded initial borders-->
						<xsl:if test="ancestor::w:tbl/w:tblPr/w:tblStyle/@w:val">
							<xsl:variable name="rootStyle" select="ancestor::w:tbl/w:tblPr/w:tblStyle/@w:val"/>
							<xsl:variable name="rootStyleNode" select="/descendant::w:style[@w:styleId = $rootStyle]"/>
							<xsl:if test="$rootStyleNode/w:tcPr/w:shd/@wx:bgcolor">
								<xsl:attribute name="fo:background-color">#<xsl:value-of select="$rootStyleNode/w:tcPr/w:shd/@wx:bgcolor"/></xsl:attribute>
							</xsl:if>
							<xsl:variable name="tblpropsright" select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/w:right"/>
							<xsl:variable name="tblpropsleft" select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/w:left"/>
							<xsl:variable name="tblpropstop" select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/w:top"/>
							<xsl:variable name="tblpropsbottom" select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/w:bottom"/>
							<xsl:variable name="paddingright">
								<xsl:value-of select="$tblpropsright/@w:w"/>
							</xsl:variable>
							<xsl:variable name="paddingleft">
								<xsl:value-of select="$tblpropsleft/@w:w"/>
							</xsl:variable>
							<xsl:variable name="paddingtop">
								<xsl:value-of select="$tblpropstop/@w:w"/>
							</xsl:variable>
							<xsl:variable name="paddingbottom">
								<xsl:value-of select="$tblpropsbottom/@w:w"/>
							</xsl:variable>
							<!--<xsl:variable name="paddingleft"><xsl:value-of select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/child::w:left/@w:w"/></xsl:variable>	
							<xsl:variable name="paddingright"><xsl:value-of select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/child::w:right/@w:w"/></xsl:variable>	
							<xsl:variable name="paddingtop"><xsl:value-of select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/child::w:top/@w:w"/></xsl:variable>	
							<xsl:variable name="paddingbottom"><xsl:value-of select="$rootStyleNode/child::w:tblPr/child::w:tblCellMar/child::w:bottom/@w:w"/></xsl:variable>	
					-->
							<xsl:if test="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:left">
								<xsl:attribute name="fo:padding-left"><xsl:value-of select="(number($paddingleft) div 1440) *2.54"/>cm</xsl:attribute>
							</xsl:if>
							<xsl:if test="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:right">
								<xsl:attribute name="fo:padding-right"><xsl:value-of select="(number($paddingright) div 1440) *2.54"/>cm</xsl:attribute>
							</xsl:if>
							<xsl:if test="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:top">
								<xsl:attribute name="fo:padding-top"><xsl:value-of select="(number($paddingtop) div 1440) *2.54"/>cm</xsl:attribute>
							</xsl:if>
							<xsl:if test="$rootStyleNode/child::w:tblPr/w:tblCellMar/w:bottom">
								<xsl:attribute name="fo:padding-bottom"><xsl:value-of select="(number($paddingbottom) div 1440) *2.54"/>cm</xsl:attribute>
							</xsl:if>
						</xsl:if>
						<xsl:variable name="cellbefore">
							<xsl:value-of select="count(ancestor::w:tc/preceding-sibling::w:tc)"/>
						</xsl:variable>
						<xsl:variable name="cellafter">
							<xsl:value-of select="count(ancestor::w:tc/following-sibling::w:tc)"/>
						</xsl:variable>
						<xsl:variable name="rowbefore">
							<xsl:value-of select="count(ancestor::w:tr/preceding-sibling::w:tr)"/>
						</xsl:variable>
						<xsl:variable name="table" select="ancestor::w:tbl/w:tblPr"/>
						<xsl:choose>
							<xsl:when test="$table/w:tblBorders">
								<!--<w:top w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:left w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:bottom w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:right w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:insideH w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:insideV w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>-->
								<xsl:variable name="Borders" select="$table/w:tblBorders"/>
								<xsl:attribute name="fo:border-top"><xsl:choose><xsl:when test="number($rowbefore) &gt; 0"><xsl:text>none</xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="(number($Borders/w:top/@wx:bdrwidth)div 1440)*2.54"/><xsl:text>cm </xsl:text></xsl:otherwise></xsl:choose><xsl:if test="not(number($rowbefore) &gt; 0)"><xsl:choose><xsl:when test="$Borders/w:top/@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="$Borders/w:top/@w:color"/></xsl:otherwise></xsl:choose></xsl:if></xsl:attribute>
								<xsl:attribute name="fo:border-bottom"><xsl:value-of select="(number($Borders/w:bottom/@wx:bdrwidth)div 1440)*2.54"/><xsl:text>cm </xsl:text><xsl:choose><xsl:when test="$Borders/w:bottom/@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="$Borders/w:bottom/@w:color"/></xsl:otherwise></xsl:choose></xsl:attribute>
								<xsl:attribute name="text:aidan"><xsl:value-of select="$cellafter"/></xsl:attribute>
								<xsl:attribute name="fo:border-right"><xsl:choose><xsl:when test="number($cellafter) &gt; 0"><xsl:text>none</xsl:text></xsl:when><xsl:otherwise><xsl:value-of select="(number($Borders/w:right/@wx:bdrwidth)div 1440)*2.54"/><xsl:text>cm </xsl:text></xsl:otherwise></xsl:choose><xsl:if test="not(number($cellafter) &gt; 0)"><xsl:choose><xsl:when test="$Borders/w:right/@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="$Borders/w:right/@w:color"/></xsl:otherwise></xsl:choose></xsl:if></xsl:attribute>
								<xsl:attribute name="fo:border-left"><xsl:value-of select="(number($Borders/w:left/@wx:bdrwidth)div 1440)*2.54"/><xsl:text>cm </xsl:text><xsl:choose><xsl:when test="$Borders/w:left/@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="$Borders/w:left/@w:color"/></xsl:otherwise></xsl:choose></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="fo:border-right"><xsl:choose><xsl:when test="number($cellafter) &gt; 0"><xsl:text>none</xsl:text></xsl:when><xsl:otherwise><xsl:text>0.002cm solid #000000</xsl:text></xsl:otherwise></xsl:choose></xsl:attribute>
								<xsl:attribute name="fo:border-left"><xsl:text>0.002cm solid #000000</xsl:text></xsl:attribute>
								<xsl:attribute name="fo:border-top"><xsl:choose><xsl:when test="number($rowbefore) &gt; 0"><xsl:text>none</xsl:text></xsl:when><xsl:otherwise><xsl:text>0.002cm solid #000000</xsl:text></xsl:otherwise></xsl:choose></xsl:attribute>
								<xsl:attribute name="fo:border-bottom">0.002cm solid #000000</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:attribute name="fo:vertical-align">top</xsl:attribute>
						<!--<xsl:attribute name="fo:padding-left">0.191cm</xsl:attribute>
						<xsl:attribute name="fo:padding-right">0.191cm</xsl:attribute>
						<xsl:attribute name="fo:padding-top">0cm</xsl:attribute>
						<xsl:attribute name="fo:padding-bottom">0cm</xsl:attribute>-->
						<xsl:apply-templates/>
					</xsl:element>
				</style:style>
			</xsl:for-each>
			<xsl:for-each select="/descendant::w:listPr">
				<xsl:variable name="currlistid" select="child::w:ilfo/@w:val"/>
				<xsl:variable name="currlist" select="."/>
				<xsl:variable name="rootlistmap" select="/descendant::w:list[child::w:ilst/@w:val=$currlistid]"/>
				<xsl:variable name="rootlistid" select="/descendant::w:list[@w:ilfo=$currlistid]/w:ilst/@w:val"/>
				<xsl:variable name="rootlist" select="/descendant::w:listDef[@w:listDefId =$rootlistid ]"/>
				<xsl:if test="not(ancestor::w:p/preceding-sibling::w:p[1]/w:pPr/w:listPr/w:ilfo/@w:val= $currlistid) ">
					<xsl:element name="text:list-style">
						<xsl:attribute name="style:name">TList<xsl:value-of select="count(preceding::w:listPr)"/></xsl:attribute>
						<xsl:variable name="currlevel" select="number(child::w:ilvl/@w:val)"/>
						<xsl:for-each select="$rootlist/child::w:lvl">
							<!--<xsl:variable name="listtype" select="$rootlist/w:lvl[@w:ilvl= $currlevel]/w:nfc/@w:val"/>-->
							<xsl:variable name="listtype" select="w:nfc/@w:val"/>
							<!--<xsl:value-of select="$currlistid"/>
					maps to<xsl:value-of select="$rootlistid"/>-->
							<xsl:choose>
								<xsl:when test="$listtype =2">
									<xsl:element name="text:list-level-style-number">
										<xsl:call-template name="list-styles-common">
											<xsl:with-param name="listtype" select="$listtype"/>
											<xsl:with-param name="rootlist" select="$rootlist"/>
											<xsl:with-param name="currlist" select="$currlist"/>
										</xsl:call-template>
									</xsl:element>
								</xsl:when>
								<xsl:when test="$listtype =23">
									<xsl:element name="text:list-level-style-bullet">
										<!-- should be bullet?-->
										<xsl:call-template name="list-styles-common">
											<xsl:with-param name="listtype" select="$listtype"/>
											<xsl:with-param name="rootlist" select="$rootlist"/>
											<xsl:with-param name="currlist" select="$currlist"/>
										</xsl:call-template>
									</xsl:element>
								</xsl:when>
								<xsl:otherwise>
									<xsl:element name="text:list-level-style-number">
										<!-- should be bullet?-->
										<xsl:call-template name="list-styles-common">
											<xsl:with-param name="listtype" select="$listtype"/>
											<xsl:with-param name="rootlist" select="$rootlist"/>
											<xsl:with-param name="currlist" select="$currlist"/>
										</xsl:call-template>
									</xsl:element>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
			<!--<style:page-master style:name="pm1">
			<style:properties fo:page-width="21.59cm" fo:page-height="27.94cm" style:num-format="1" style:print-orientation="portrait" fo:margin-top="2cm" fo:margin-bottom="2cm" fo:margin-left="2cm" fo:margin-right="2cm" style:writing-mode="lr-tb" style:footnote-max-height="0cm">
				<style:footnote-sep style:width="0.018cm" style:distance-before-sep="0.101cm" style:distance-after-sep="0.101cm" style:adjustment="left" style:rel-width="25%" style:color="#000000"/>
			</style:properties>
			<style:header-style/>
			<style:footer-style/>
		</style:page-master>
		
		<w:sectPr>
				<w:pgSz w:w="12240" w:h="15840"/>
				<w:pgMar w:top="1440" w:right="1800" w:bottom="1440" w:left="1800" w:header="708" w:footer="708" w:gutter="0"/>
				<w:cols w:space="708"/>
				<w:docGrid w:line-pitch="360"/>
			</w:sectPr>
		</wx:sect>

 -->
			<xsl:variable name="sectPr" select="/descendant::w:sectPr"/>
			<xsl:for-each select="$sectPr">
				<xsl:element name="style:page-master">
					<xsl:attribute name="style:name">pm<xsl:value-of select="count(preceding::w:sectPr)"/></xsl:attribute>
					<xsl:element name="style:properties">
						<xsl:attribute name="fo:page-width"><xsl:value-of select="(number(w:pgSz/@w:w) div 1440)*2.54"/>cm</xsl:attribute>
						<xsl:attribute name="fo:page-height"><xsl:value-of select="(number(w:pgSz/@w:h) div 1440)*2.54"/>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-top"><xsl:value-of select="(number(w:pgMar/@w:top) div 1440)*2.54"/>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-bottom"><xsl:value-of select="(number(w:pgMar/@w:bottom) div 1440)*2.54"/>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-left"><xsl:value-of select="(number(w:pgMar/@w:left + w:pgMar/@w:gutter) div 1440)*2.54"/>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-right"><xsl:value-of select="(number(w:pgMar/@w:right) div 1440)*2.54"/>cm</xsl:attribute>
						<xsl:attribute name="style:footnote-max-height"><xsl:value-of select="(number(w:pgMar/@w:footer) div 1440)*2.54"/></xsl:attribute>
						<xsl:if test="w:pgSz/@w:orient">
							<xsl:attribute name="style:print-orientation"><xsl:value-of select="w:pgSz/@w:orient"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="w:cols/@w:num">
							<!-- needs to be fixed -->
							<!--<xsl:element name="style:columns">
							<xsl:attribute name="fo:column-count"><xsl:value-of select="number(w:cols/@w:num)"/></xsl:attribute>
							<xsl:attribute name="fo:column-gap"><xsl:value-of select="(number(w:cols/@w:space)div 1440)*2.54"/></xsl:attribute>
						</xsl:element>-->
						</xsl:if>
					</xsl:element>
				</xsl:element>
				<xsl:if test="w:cols/@w:num">
					<!-- create sction property-->
					<xsl:element name="style:style">
						<xsl:attribute name="style:name">sect<xsl:value-of select="count(preceding::w:sectPr[child::w:cols/@w:num])"/></xsl:attribute>
						<xsl:attribute name="style:family">section</xsl:attribute>
						<xsl:element name="style:properties">
							<xsl:element name="style:columns">
								<xsl:attribute name="fo:column-count"><xsl:value-of select="number(w:cols/@w:num)"/></xsl:attribute>
								<xsl:attribute name="fo:column-gap"><xsl:value-of select="(number(w:cols/@w:space)div 1440)*2.54"/>cm</xsl:attribute>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
		</xsl:element>
		<office:master-styles>
			<xsl:variable name="sectPr" select="/descendant::w:sectPr"/>
			<xsl:for-each select="$sectPr">
				<!-- style:page-master style:style-->
				<xsl:element name="style:master-page">
					<xsl:choose>
						<xsl:when test="not (count(preceding::w:sectPr) &gt; 0 )">
							<xsl:attribute name="style:name">Standard</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:name">Standard<xsl:value-of select="count(preceding::w:sectPr)"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="style:page-master-name">pm<xsl:value-of select="count(preceding::w:sectPr)"/></xsl:attribute>
					<xsl:if test="following::w:sectPr">
						<xsl:attribute name="style:next-style-name">Standard<xsl:value-of select="count(preceding::w:sectPr)+1"/></xsl:attribute>
					</xsl:if>
					<!-- Headers and footers-->
					<xsl:element name="style:header-style">
						<xsl:element name="style:properties">
							<xsl:attribute name="fo:min-height"><xsl:value-of select="(number(child::w:pgMar/@w:header)div 1440)*2.54"/>cm</xsl:attribute>
							<xsl:attribute name="fo:margin-bottom">0.792cm</xsl:attribute>
							<xsl:attribute name="style:dynamic-spacing">true</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:element name="style:footer-style">
						<xsl:element name="style:properties">
							<xsl:attribute name="fo:min-height"><xsl:value-of select="(number(child::w:pgMar/@w:footer)div 1440)*2.54"/>cm</xsl:attribute>
							<xsl:attribute name="fo:margin-top">0.792cm</xsl:attribute>
							<xsl:attribute name="style:dynamic-spacing">true</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:if test="child::w:hdr">
						<xsl:element name="style:header">
							<xsl:apply-templates select="child::w:hdr[@w:type='odd']/*"/>
						</xsl:element>
						<xsl:element name="style:header-left">
							<xsl:apply-templates select="child::w:hdr[@w:type='even']/*"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="child::w:ftr">
						<xsl:element name="style:footer">
							<xsl:apply-templates select="child::w:ftr[@w:type='odd']/*"/>
						</xsl:element>
						<xsl:element name="style:footer-left">
							<xsl:apply-templates select="child::w:ftr[@w:type='even']/*"/>
						</xsl:element>
					</xsl:if>
				</xsl:element>
			</xsl:for-each>
			<!--<style:master-page style:name="Standard" style:page-master-name="pm1" style:next-style-name="Sandard1"/>
		<style:master-page style:name="Standard1" style:page-master-name="pm2"/>-->
		</office:master-styles>
	</xsl:template>
	<xsl:template name="paragraph-alignment">
		<!-- template for setting indents and alignment-->
		<xsl:choose>
			<xsl:when test="descendant::w:ind[@w:left]">
				<xsl:attribute name="fo:margin-left"><xsl:value-of select="number(((descendant::w:ind/@w:left)div 1440) *2.54)"/>cm</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="fo:margin-left">0cm</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="descendant::w:ind[@w:right]">
				<xsl:attribute name="fo:margin-right"><xsl:value-of select="number(((descendant::w:ind/@w:right)div 1440) *2.54)"/>cm</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="fo:margin-right">0cm</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="descendant::w:ind[@w:first-line]">
				<xsl:attribute name="fo:text-indent"><xsl:value-of select="number(((descendant::w:ind/@w:first-line)div 1440) *2.54)"/>cm</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="fo:text-indent">0cm</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="bidi"/>
		<!--<w:tabs>
						<w:tab w:val="left" w:pos="284"/>
						<w:tab w:val="left" w:pos="709"/>
						<w:tab w:val="left" w:pos="1134"/>
						<w:tab w:val="left" w:pos="1985"/>
					</w:tabs>-->
		<xsl:if test="descendant::w:tabs">
			<xsl:element name="style:tab-stops">
				<xsl:for-each select="descendant::w:tabs/w:tab">
					<xsl:element name="style:tab-stop">
						<xsl:attribute name="style:position"><xsl:value-of select="(number(@w:pos)div 1440)*2.54"/>cm</xsl:attribute>
						<xsl:choose>
							<xsl:when test="@w:val = 'decimal'">
								<xsl:attribute name="style:type">char</xsl:attribute>
								<xsl:attribute name="style:char"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="style:type"><xsl:value-of select="@w:val"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:if>
		<!-- line spacing-->
		<xsl:if test="descendant::w:spacing">
			<!--<xsl:attribute name="fo:line-height"><xsl:value-of select="number(((descendant::w:spacing/@w:line) div 1440)*2.54)"/>cm</xsl:attribute>-->
			<!--<w:spacing w:before="240" w:after="120"/>-->
			<xsl:choose>
				<xsl:when test="descendant::w:spacing/@w:line-rule='at-least'">
					<xsl:attribute name="style:line-height-at-least"><xsl:value-of select="number(((descendant::w:spacing/@w:line) div 1440)*2.54)"/>cm</xsl:attribute>
				</xsl:when>
				<xsl:when test="descendant::w:spacing/@w:line-rule='auto'">
					<xsl:attribute name="fo:line-height"><xsl:value-of select="(number((descendant::w:spacing/@w:line) div 240) * 100)"/>%</xsl:attribute>
				</xsl:when>
				<xsl:when test="descendant::w:spacing/@w:line-rule='exact'">
					<xsl:attribute name="fo:line-height"><xsl:value-of select="number(((descendant::w:spacing/@w:line) div 1440)*2.54)"/>cm</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="descendant::w:spacing/@w:before">
				<xsl:attribute name="fo:margin-top"><xsl:value-of select="(number(descendant::w:spacing/@w:before) div 1440 )*2.54"/>cm</xsl:attribute>
			</xsl:if>
			<xsl:if test="descendant::w:spacing/@w:after">
				<xsl:attribute name="fo:margin-bottom"><xsl:value-of select="(number(descendant::w:spacing/@w:after) div 1440 )*2.54"/>cm</xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:attribute name="style:auto-text-indent">false</xsl:attribute>
	</xsl:template>
	<xsl:template name="bidi">
		<!-- bi-directional support-->
		<xsl:if test="descendant::w:bidi">
			<xsl:attribute name="style:writing-mode">rl-tb</xsl:attribute>
			<xsl:attribute name="fo:text-align">end</xsl:attribute>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="descendant::w:jc[@w:val = 'center']">
				<xsl:attribute name="fo:text-align">center</xsl:attribute>
			</xsl:when>
			<xsl:when test="descendant::w:jc[@w:val = 'left']">
				<xsl:choose>
					<xsl:when test="descendant::w:bidi">
						<xsl:attribute name="fo:text-align">end</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="fo:text-align">start</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="descendant::w:jc[@w:val = 'right']">
				<xsl:choose>
					<xsl:when test="descendant::w:bidi">
						<xsl:attribute name="fo:text-align">start</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="fo:text-align">end</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="descendant::w:jc[@w:val = 'both']">
				<xsl:attribute name="fo:text-align">justify</xsl:attribute>
				<xsl:attribute name="style:justify-single-word">false</xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="list-styles-common">
		<xsl:param name="listtype"/>
		<xsl:param name="rootlist"/>
		<xsl:param name="currlist"/>
		<xsl:variable name="currlevel" select="number(@w:ilvl)"/>
		<xsl:variable name="startval" select="child::w:start/@w:val"/>
		<xsl:variable name="outline" select="substring-after(child::w:lvlText/@w:val, '%')"/>
		<xsl:attribute name="text:level"><xsl:value-of select="$currlevel+1"/></xsl:attribute>
		<xsl:attribute name="text:min-label-width">0.499cm</xsl:attribute>
		<xsl:choose>
			<xsl:when test="$listtype = 23">
				<xsl:attribute name="text:style-name"><xsl:text>Bullet Symbols</xsl:text></xsl:attribute>
				<!--<xsl:attribute name="style:num-format"><xsl:value-of select="child::wx:t/@wx:val"/></xsl:attribute>-->
				<!--<xsl:attribute name="text:bullet-char"><xsl:value-of select="$currlist/child::wx:t/@wx:val"/></xsl:attribute>-->
				<xsl:attribute name="text:bullet-char"><xsl:value-of select="child::w:lvlText/@w:val"/></xsl:attribute>
				<!-- Font to be used is set further down-->
				<!--<xsl:choose>
					<xsl:when test="$currlist/child::wx:t/@wx:val = '·' ">
						<xsl:attribute name="text:bullet-char">●</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="text:bullet-char"><xsl:value-of select="$currlist/child::wx:t/@wx:val"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>-->
			</xsl:when>
			<xsl:when test="($listtype &gt; 0) and ($listtype &lt; 6)">
				<xsl:if test="$startval">
					<xsl:attribute name="text:start-value"><xsl:value-of select="$startval"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="contains($outline,'%')">
					<xsl:call-template name="displaylevels">
						<xsl:with-param name="displaylevelsvalue">
							<xsl:value-of select="number(2)"/>
						</xsl:with-param>
						<xsl:with-param name="displaylevelsstring" select="$outline"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:attribute name="text:style-name"><xsl:text>Numbering Symbols</xsl:text></xsl:attribute>
				<xsl:attribute name="style:num-format"><!--<xsl:value-of select="child::wx:t/@wx:val"/>--><xsl:choose><xsl:when test="$listtype = 1">I</xsl:when><xsl:when test="$listtype = 2">i</xsl:when><xsl:when test="$listtype = 3">A</xsl:when><xsl:when test="$listtype = 4">a</xsl:when><xsl:when test="$listtype = 5">1</xsl:when></xsl:choose></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$startval">
					<xsl:attribute name="text:start-value"><xsl:value-of select="$startval"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="contains($outline,'%')">
					<xsl:call-template name="displaylevels">
						<xsl:with-param name="displaylevelsvalue">
							<xsl:value-of select="number(2)"/>
						</xsl:with-param>
						<xsl:with-param name="displaylevelsstring" select="$outline"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:attribute name="text:style-name"><xsl:text>Numbering Symbols</xsl:text></xsl:attribute>
				<xsl:attribute name="style:num-format">1</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:attribute name="style:num-suffix">.</xsl:attribute>
		<!--<xsl:value-of select="$currlevel"/>-->
		<xsl:element name="style:properties">
			<!-- Find the node that corresponds to the level being processed. We can use this to determine the indentation to be used-->
			<xsl:variable name="currNode" select="/descendant::w:listPr[child::w:ilvl/@w:val = $currlevel][child::w:ilfo/@w:val = $currlist/w:ilfo/@w:val]"/>
			<xsl:choose>
				<xsl:when test="($currNode/wx:t/@wx:wTabBefore ) and ($currNode/wx:t/@wx:wTabAfter ) ">
					<xsl:variable name="test" select="$currNode/wx:t"/>
					<xsl:attribute name="text:space-before"><xsl:value-of select="(number($test/@wx:wTabBefore)div 1440)*2.54"/><xsl:text>cm</xsl:text></xsl:attribute>
					<xsl:attribute name="text:space-after"><xsl:value-of select="(number($test/@wx:wTabAfter)div 1440)*2.54"/><xsl:text>cm</xsl:text></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="text:space-before"><xsl:value-of select="((number(child::w:pPr/w:ind/@w:left)  div 1440)*2.54) "/>cm</xsl:attribute>
					<xsl:attribute name="text:min-label-distance"><xsl:value-of select="(number($currlist/wx:t/@wx:wTabAfter) div 1440)*2.54"/>cm</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="descendant::w:rFonts/@w:ascii">
				<!--<xsl:attribute name="style:font-name"><xsl:value-of select="$currlist/wx:font/@wx:val"/></xsl:attribute>-->
				<xsl:attribute name="style:font-name"><xsl:value-of select="descendant::w:rFonts/@w:ascii"/></xsl:attribute>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template name="displaylevels">
		<xsl:param name="displaylevelsvalue"/>
		<xsl:param name="displaylevelsstring"/>
		<xsl:attribute name="text:display-levels"><xsl:value-of select="$displaylevelsvalue"/></xsl:attribute>
		<xsl:variable name="outline" select="substring-after($displaylevelsstring, '%')"/>
		<xsl:if test="contains($outline,'%')">
			<xsl:call-template name="displaylevels">
				<xsl:with-param name="displaylevelsvalue">
					<xsl:value-of select="number($displaylevelsvalue +1)"/>
				</xsl:with-param>
				<xsl:with-param name="displaylevelsstring" select="$outline"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:style">
		<xsl:element name="style:style">
			<xsl:attribute name="style:name"><xsl:value-of select="@w:styleId"/></xsl:attribute>
			<xsl:if test="child::w:basedOn">
				<xsl:attribute name="style:parent-style-name"><xsl:value-of select="child::w:basedOn/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="child::w:next">
				<xsl:attribute name="style:next-style-name"><xsl:value-of select="child::w:next/@w:val"/></xsl:attribute>
			</xsl:if>
			<!--<xsl:attribute name="style:class"></xsl:attribute>-->
			<xsl:choose>
				<xsl:when test="@w:type">
					<xsl:choose>
						<xsl:when test="@w:type = 'character' ">
							<xsl:attribute name="style:family">text</xsl:attribute>
						</xsl:when>
						<xsl:when test="@w:type = 'list' ">
							<xsl:attribute name="style:family">text</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:family"><xsl:value-of select="@w:type"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="ancestor::w:pPr">
					<xsl:attribute name="style:family">paragraph</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="style:family">text</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:element name="style:properties">
				<xsl:call-template name="paragraph-alignment"/>
				<xsl:apply-templates select="child::w:rPr/*"/>
				<xsl:apply-templates select="child::w:pPr/*"/>
			</xsl:element>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!-- 
	Graphics Handling 

-->
	<xsl:template match="w:pict">
		<!--	<draw:image draw:style-name="fr1" draw:name="Graphic2" text:anchor-type="paragraph" svg:width="2.1965inch" svg:height="0.7402inch" draw:z-index="0">-->
		<!-- <v:shape id="_x0000_i1026" type="#_x0000_t75" style="width:158.25pt;height:53.25pt">
							<v:imagedata src="http://01000002.gif" o:title="logonew"/>
						</v:shape>
-->
		<!-- Cannot load zipped Wmf file-->
		<xsl:choose>
			<xsl:when test="descendant::w:binData">
				<xsl:if test="not(contains(child::w:binData/@w:name,'.wmz'))">
					<xsl:element name="draw:image">
						<xsl:if test="child::v:shape/@style">
							<xsl:variable name="widthandheight" select="child::v:shape/@style"/>
							<xsl:variable name="widthstr" select="substring-before($widthandheight,';')"/>
							<xsl:variable name="heightstr" select="substring-after($widthandheight,';')"/>
							<xsl:variable name="widthpt" select="substring-after($widthstr,':')"/>
							<xsl:variable name="heightpt" select="substring-after($heightstr,':')"/>
							<xsl:variable name="width" select="substring-before($widthpt,'pt')"/>
							<xsl:variable name="height" select="substring-before($heightpt,'pt')"/>
							<xsl:variable name="widthcm" select="number($width)*0.0353"/>
							<xsl:variable name="heightcm" select="number($height)*0.0353"/>
							<!--<xsl:value-of select="$widthcm"/><xsl:text>cm</xsl:text><xsl:value-of select="$heightcm"/> -->
							<xsl:attribute name="svg:width"><xsl:value-of select="$widthcm"/><xsl:text>cm</xsl:text></xsl:attribute>
							<xsl:attribute name="svg:height"><xsl:value-of select="$heightcm"/><xsl:text>cm</xsl:text></xsl:attribute>
							<xsl:attribute name="text:anchor-type">paragraph</xsl:attribute>
							<xsl:if test="child::v:shape/v:imagedata/@o:title">
								<xsl:attribute name="draw:name"><xsl:value-of select="child::v:shape/v:imagedata/@o:title"/></xsl:attribute>
							</xsl:if>
							<xsl:apply-templates/>
						</xsl:if>
					</xsl:element>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:binData">
		<!--office:binary-data-->
		<xsl:element name="office:binary-data">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="v:group">
		<xsl:apply-templates/>
	</xsl:template>
	<!-- 	<v:oval id="_x0000_s1030" style="position:absolute;left:3352;top:2911;width:1975;height:1863" fillcolor="red"/>
       <v:rect id="_x0000_s1031" style="position:absolute;left:3952;top:3074;width:2838;height:1912" fillcolor="yellow" strokecolor="blue"/>

<draw:rect text:anchor-type="paragraph" draw:z-index="1" draw:style-name="gr1" draw:text-style-name="P1" svg:width="2.0634inch" svg:height="1.1362inch" svg:x="0.5953inch" svg:y="0.222inch"/>
			<draw:ellipse text:anchor-type="paragraph" draw:z-index="2" draw:style-name="gr1" draw:text-style-name="P1" svg:width="1.9382inch" svg:height="1.0425inch" svg:x="1.2098inch" svg:y="0.4827inch" draw:kind="section" draw:start-angle="338.51" draw:end-angle="241.21"/>

-->
	<xsl:template match="v:oval">
		<xsl:element name="draw:ellipse">
			<xsl:variable name="style" select="@style"/>
			<xsl:variable name="position" select="substring-after($style,'position:')"/>
			<xsl:variable name="positionval" select="substring-before($position,';')"/>
			<xsl:variable name="left" select="substring-after($style,'left:')"/>
			<xsl:variable name="leftval" select="substring-before($left,';')"/>
			<xsl:variable name="top" select="substring-after($style,'top:')"/>
			<xsl:variable name="topval" select="substring-before($top,';')"/>
			<xsl:variable name="width" select="substring-after($style,'width:')"/>
			<xsl:variable name="widthval" select="substring-before($width,';')"/>
			<xsl:variable name="height" select="substring-after($style,'height:')"/>
			<xsl:variable name="heightval" select="$height"/>
			<!--<xsl:if test="parent::v:group">
     		
			<xsl:variable name="parentgroup" select="parent::v:group"/>
			<xsl:variable name="origin" select="$coordorigin"/>
			<xsl:variable name="groupleft" select="substring-before($origin,',')"/>
			<xsl:variable name="grouptop" select="substring-after($origin,',')"/>
     		</xsl:if>     	-->
			<xsl:if test="$positionval = 'absolute'">
				<xsl:variable name="parentgroup" select="parent::v:group"/>
				<xsl:variable name="origin" select="$parentgroup/@coordorigin"/>
				<xsl:variable name="groupleft" select="substring-before($origin,',')"/>
				<xsl:variable name="grouptop" select="substring-after($origin,',')"/>
				<xsl:variable name="currsect" select="ancestor::wx:sect"/>
				<xsl:variable name="currsectPr" select="$currsect/descendant::w:sectPr/w:pgMar"/>
				<xsl:variable name="leftmar" select="$currsectPr/@w:left"/>
				<xsl:variable name="topmar" select="$currsectPr/@w:top"/>
				<!--<xsl:attribute name="text:anchor-type">page</xsl:attribute>-->
				<xsl:attribute name="text:anchor-type">page</xsl:attribute>
				<xsl:attribute name="svg:width"><xsl:value-of select="(number($widthval) div 1440)*2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:height"><xsl:value-of select="(number($heightval) div 1440)*2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:x"><xsl:value-of select="(number($topval + $topmar) div 1440)*2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:y"><xsl:value-of select="(number($leftval + $leftmar) div 1440)*2.54"/>cm</xsl:attribute>
				<!--<xsl:attribute name="svg:y"><xsl:value-of select="((number($leftval + $leftmar) -$widthval) div 1440)*2.54"/>cm</xsl:attribute>-->
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="v:rect">
		<xsl:element name="draw:rect">
			<xsl:variable name="style" select="@style"/>
			<xsl:variable name="position" select="substring-after($style,'position:')"/>
			<xsl:variable name="positionval" select="substring-before($position,';')"/>
			<xsl:variable name="left" select="substring-after($style,'left:')"/>
			<xsl:variable name="leftval" select="substring-before($left,';')"/>
			<xsl:variable name="top" select="substring-after($style,'top:')"/>
			<xsl:variable name="topval" select="substring-before($top,';')"/>
			<xsl:variable name="width" select="substring-after($style,'width:')"/>
			<xsl:variable name="widthval" select="substring-before($width,';')"/>
			<xsl:variable name="height" select="substring-after($style,'height:')"/>
			<xsl:variable name="heightval" select="$height"/>
			<xsl:if test="$positionval = 'absolute'">
				<xsl:variable name="parentgroup" select="parent::v:group"/>
				<xsl:variable name="origin" select="$parentgroup/@coordorigin"/>
				<xsl:variable name="groupleft" select="substring-before($origin,',')"/>
				<xsl:variable name="grouptop" select="substring-after($origin,',')"/>
				<xsl:variable name="currsect" select="ancestor::wx:sect"/>
				<xsl:variable name="currsectPr" select="$currsect/descendant::w:sectPr/w:pgMar"/>
				<xsl:variable name="leftmar" select="$currsectPr/@w:left"/>
				<xsl:variable name="topmar" select="$currsectPr/@w:top"/>
				<!--<xsl:attribute name="text:anchor-type">page</xsl:attribute>-->
				<xsl:attribute name="text:anchor-type">page</xsl:attribute>
				<xsl:attribute name="svg:width"><xsl:value-of select="(number($widthval) div 1440)*2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:height"><xsl:value-of select="(number($heightval) div 1440)*2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:x"><xsl:value-of select="(number($topval + $topmar) div 1440)*2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:y"><xsl:value-of select="(number($leftval + $leftmar) div 1440)*2.54"/>cm</xsl:attribute>
				<!--<xsl:attribute name="svg:y"><xsl:value-of select="((number($leftval + $leftmar) -$widthval) div 1440)*2.54"/>cm</xsl:attribute>-->
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<!-- 
	tables Handling 

-->
	<xsl:template match="w:tbl">
		<xsl:element name="table:table">
			<!--<xsl:if test="child::w:tblPr/w:tblStyle">
			<xsl:attribute name="table:style-name"><xsl:value-of select="child::w:tblPr/w:tblStyle/@w:val"/></xsl:attribute>
		</xsl:if>-->
			<xsl:apply-templates select="./*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:tblPr">
		<xsl:attribute name="table:style-name">TTable<xsl:value-of select="count(preceding::w:tblPr)"/></xsl:attribute>
	</xsl:template>
	<xsl:template match="w:tblGrid">
		<!--<xsl:attribute name="table:number-columns-repeated">
			<xsl:value-of select="count(child::w:gridCol)"/>
		</xsl:attribute>-->
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:gridCol">
		<xsl:element name="table:table-column">
			<xsl:attribute name="table:style-name">TColumn<xsl:value-of select="count(preceding::w:gridCol)"/></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<!--<w:tblGrid>
		<w:gridCol w:w="1771"/>
		<w:gridCol w:w="1771"/>
		<w:gridCol w:w="1771"/>
		<w:gridCol w:w="1771"/>
		<w:gridCol w:w="1772"/>
		</w:tblGrid>
-->
	<xsl:template match="w:tr">
		<xsl:element name="table:table-row">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:tc">
		<xsl:element name="table:table-cell">
			<xsl:attribute name="table:style-name">TCell<xsl:value-of select="count(preceding::w:tcPr)"/></xsl:attribute>
			<xsl:if test="child::w:tcPr/w:gridSpan">
				<xsl:attribute name="table:number-columns-spanned"><xsl:value-of select="child::w:tcPr/w:gridSpan/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:tcBorders">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:top">
		<xsl:choose>
			<xsl:when test="@w:val='nil' ">
				<xsl:attribute name="fo:border-top">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="@wx:bdrwidth and @w:color">
				<xsl:attribute name="fo:border-top"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/><xsl:text>cm </xsl:text><!--<xsl:attribute name="fo:border-top"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/><xsl:text>cm </xsl:text>--><xsl:choose><xsl:when test="@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="@w:color"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="@wx:bdrwidth">
					<xsl:attribute name="fo:border-top"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/>cm</xsl:attribute>
					<!--<xsl:attribute name="fo:border-top"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/>cm</xsl:attribute>-->
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:bottom">
		<xsl:choose>
			<xsl:when test="@w:val='nil' ">
				<xsl:attribute name="fo:border-bottom">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="@wx:bdrwidth and @w:color">
				<xsl:attribute name="fo:border-bottom"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/><xsl:text>cm </xsl:text><!--<xsl:attribute name="fo:border-bottom"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/><xsl:text>cm </xsl:text>--><xsl:choose><xsl:when test="@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="@w:color"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="@wx:bdrwidth">
					<xsl:attribute name="fo:border-bottom"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/>cm</xsl:attribute>
					<!--<xsl:attribute name="fo:border-bottom"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/>cm</xsl:attribute>-->
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:left">
		<xsl:choose>
			<xsl:when test="@w:val='nil' ">
				<xsl:attribute name="fo:border-left">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="@wx:bdrwidth and @w:color">
				<xsl:attribute name="fo:border-left"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/><xsl:text>cm </xsl:text><!--<xsl:attribute name="fo:border-right"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/><xsl:text>cm </xsl:text>--><xsl:choose><xsl:when test="@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="@w:color"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="@wx:bdrwidth">
					<xsl:attribute name="fo:border-left"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/>cm</xsl:attribute>
					<!--<xsl:attribute name="fo:border-left"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/>cm</xsl:attribute>-->
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:right">
		<xsl:choose>
			<xsl:when test="@w:val='nil' ">
				<xsl:attribute name="fo:border-right">none</xsl:attribute>
			</xsl:when>
			<xsl:when test="@wx:bdrwidth and @w:color">
				<xsl:attribute name="fo:border-right"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/><xsl:text>cm </xsl:text><!--<xsl:attribute name="fo:border-right"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/><xsl:text>cm </xsl:text>--><xsl:choose><xsl:when test="@w:color ='auto'"><xsl:text>solid #000000</xsl:text></xsl:when><xsl:otherwise><xsl:text>solid #</xsl:text><xsl:value-of select="@w:color"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="@wx:bdrwidth">
					<xsl:attribute name="fo:border-right"><xsl:value-of select="(number(@wx:bdrwidth) div 1440 )*2.54"/>cm</xsl:attribute>
					<!--<xsl:attribute name="fo:border-right"><xsl:value-of select="(number(@wx:bdrwidth) div 240 )*100"/>cm</xsl:attribute>-->
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:tblBorders">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:tcBorders">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="w:tblInd">
		<xsl:attribute name="fo:margin-left"><xsl:value-of select="(number(@w:w) div 1440)*2.54"/>cm</xsl:attribute>
	</xsl:template>
	<!-- Table borders

 <style:properties fo:vertical-align="top" fo:padding-left="0.191cm" fo:padding-right="0.191cm" fo:padding-top="0cm" fo:padding-bottom="0cm" fo:border-left="0.088cm solid #000000" fo:border-right="none" fo:border-top="0.088cm solid #000000" fo:border-bottom="0.088cm solid #000000"/>

<w:tblPr>
					<w:tblStyle w:val="TableGrid"/>
					<w:tblW w:w="0" w:type="auto"/>
					<w:tblInd w:w="567" w:type="dxa"/>
					<w:tblBorders>
						<w:top w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:left w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:bottom w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:right w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:insideH w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
						<w:insideV w:val="single" w:sz="24" wx:bdrwidth="60" w:space="0" w:color="auto"/>
					</w:tblBorders>
					<w:tblLook w:val="000001E0"/>
				</w:tblPr>


-->
	<!-- <style:style style:name="Tabelle7.B1" style:family="table-cell">
			<style:properties fo:vertical-align="top" fo:padding-left="0.191cm" fo:padding-right="0.191cm" fo:padding-top="0cm" fo:padding-bottom="0cm" fo:border-left="0.002cm solid #000000" fo:border-right="none" fo:border-top="none" fo:border-bottom="0.002cm solid #000000"/>
		</style:style>

	<w:tcPr>
							<w:tcW w:w="1771" w:type="dxa"/>
							<w:tcBorders>
								<w:top w:val="nil"/>
								<w:right w:val="nil"/>
							</w:tcBorders>


-->
	<!--<xsl:template match="w:gridSpan">
	<xsl:attribute name=""></xsl:attribute>
	<xsl:apply-templates/>
</xsl:template>-->
	<!--Table, Cell and Row Properties  -->
	<xsl:template match="w:tcPr"/>
	<!--<style:properties style:width="10.008cm" fo:margin-left="3.791cm" fo:margin-right="3.791cm" table:align="margins"/>-->
	<!-- 
	list Handling 

-->
	<xsl:template name="genlist">
		<xsl:variable name="currlistid" select="child::w:pPr/w:listPr/w:ilfo/@w:val"/>
		<xsl:variable name="prevPara" select="preceding-sibling::w:p"/>
		<xsl:variable name="followingPara" select="following-sibling::w:p"/>
		<xsl:variable name="prevlistid" select="$prevPara/child::w:pPr/w:listPr/w:ilfo/@w:val"/>
		<xsl:variable name="currlistlvl" select="child::w:pPr/w:listPr/w:ilvl/@w:val"/>
		<xsl:variable name="firstoccur" select="/descendant::w:pPr[w:listPr/w:ilfo/@w:val = $currlistid][1]"/>
		<xsl:element name="text:ordered-list">
			<xsl:attribute name="text:style-name">TList<xsl:value-of select="count($firstoccur/preceding::w:listPr)"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="preceding::w:pPr/w:listPr/w:ilfo/@w:val = child::w:pPr/w:listPr/w:ilfo/@w:val">
					<xsl:attribute name="text:continue-numbering">true</xsl:attribute>
					<xsl:element name="text:list-item">
						<xsl:call-template name="levels">
							<xsl:with-param name="level" select="$currlistlvl"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="text:list-item">
						<xsl:call-template name="levels">
							<xsl:with-param name="level" select="$currlistlvl"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template name="levels">
		<xsl:param name="level"/>
		<xsl:choose>
			<xsl:when test="$level = '0'">
				<xsl:call-template name="commonPara"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="text:ordered-list">
					<xsl:element name="text:list-item">
						<xsl:call-template name="levels">
							<xsl:with-param name="level" select="$level -1"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- 
	Ms Field Handling
-->
	<xsl:template match="w:instrText"/>
	<xsl:template match="w:fldChar"/>
</xsl:stylesheet>
