/*************************************************************************
 *
 *  $RCSfile: loadeventlistener.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: as $ $Date: 2002/08/12 11:41:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_HELPER_LOADEVENTLISTENER_HXX_
#define __FRAMEWORK_HELPER_LOADEVENTLISTENER_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

#ifndef __FRAMEWORK_LOADSTATE_H_
#include <loadstate.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XFRAMELOADER_HPP_
#include <com/sun/star/frame/XFrameLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HPP_
#include <com/sun/star/frame/XLoadEventListener.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

/**
    @short      react for load events of an asynchronous frame loader
    @descr      If we load something asynchronous we must wait for success.
                To get this information we can use this listener.
                It handle the uno part of this mechanism and provide the
                needed information on his c++ interface for interested code.
                An instance of this class must be passed to the load() request
                of the loader.

    @modified   12.07.2002 15:48
    @by         Andreas Schlns
 */
class LoadEventListener : public css::lang::XTypeProvider
                        , public  css::frame::XLoadEventListener // => XEventListener
                        , private ThreadHelpBase
                        , public  ::cppu::OWeakObject
{
    //_____________________________________
    // member
    private:

        /// save the state of the operation
        ELoadState m_eState;
        /// condition to make external waiting for async job possible
        ::osl::Condition m_aCondition;
        /// saved reference to the outside used async frame laoder, on which we was registered!
        css::uno::Reference< css::frame::XFrameLoader > m_xBroadcaster;

    //_____________________________________
    // uno interface
    public:

        DECLARE_XINTERFACE
        DECLARE_XTYPEPROVIDER

        //_________________________________
        /**
            @short  callbacks from the used async loader object
            @descr  The used loader, on which we are registered,
                    inform us here about success or not.
                    We save this information internaly and provide it later
                    on our c++ interface.
                    An outside code can wait for this events too by using our
                    c++ interface method "waitForFinish()".

            @param  xLoader
                        reference to the async loader object which inform us
         */
        virtual void SAL_CALL loadFinished ( const css::uno::Reference< css::frame::XFrameLoader >& xLoader ) throw (css::uno::RuntimeException);
        virtual void SAL_CALL loadCancelled( const css::uno::Reference< css::frame::XFrameLoader >& xLoader ) throw (css::uno::RuntimeException);

        //_________________________________
        /**
            @short  callbacks for dispose of our used async. frame loader
            @descr  If we are a uno listener in general, we have to accept
                    disposing requests of our broadcaster too.
                    It's not neccessary to deregister us then - we have to
                    release his reference only.

            @param  aEvent
                        describes the broadcaster and should be our used async loader object
         */
        virtual void SAL_CALL disposing( const css::lang::EventObject& aEvent ) throw(css::uno::RuntimeException);

    //_____________________________________
    // c++ interface
    public:

        //_________________________________
        /**
            @short  ctor
            @descr  It set the internal condition so our wait method will be blocked.
         */
        LoadEventListener();

        //_________________________________
        /**
            @short  set the broadcaster, where we should listen for load events
            @descr  It safe a reference to the broadcaster, on which we are registered as listener.
                    Because the connection between us and this broadaster is done outside this class
                    (see AsyncLoadThread) we will get it by calling this ctor.
                    We use ring references explicitly here!
                    - we will be registered at this broadcaster and he hold us alive
                    - and we hold this broadcaster alive, till he inform us in any way
                    We release this references by looking for load or disposing events.
                    So it's guaranteed that these two objects (we and the braodcaster)
                    will die realy if load operation is finished.
                    The outside code must organize or synchronize that.
                    But he have to wait for our waitForFinish() method ...

                    This method can be used to reset an instance of this class too.
                    If somewhere set a new broadcaster - normaly would start a new load
                    at it. Then we must reset our condition and internal state.
                    Otherwhise waitForFinish() and getState() can't work realy.
                    Of course - our user MUST set a call this set method too, even
                    it's the same as used for the last request!

            @seealso AsyncLoadThread

            @param  xBroadcaster
                        the used async frame loader, we was passed as possible listener during his load() call
                        (see AsyncLoadThread for further informations)
         */
        void setBroadcaster(const css::uno::Reference< css::frame::XFrameLoader >& xBroadcaster);

        //_________________________________
        /**
            @short  let an outside caller wait till the loader inform us
            @descr  The user of an instance of this class can use it to wait
                    for finishing of the async load process.
                    In our ctor we set an condition and reset it
                    if our loader inform us using the listener callbacks.

            @return [ELoadState]
                        it returns the state of the finished load operation
         */
        void waitForFinish();

        //_________________________________
        /**
            @short  returns the internaly safed state of the listened load operation
            @descr  If an user has wait for us (it's required to do so - otherhwise
                    the return value of this method is unspecified!) he can get the
                    state of the last operation here.

            @return [ELoadState]
                        it returns the state of the finished load operation
         */
        ELoadState getState();
};

} // namespace framework

#endif // #ifndef __FRAMEWORK_HELPER_LOADEVENTLISTENER_HXX_
