/*************************************************************************
 *
 *  $RCSfile: loadeventlistener.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: as $ $Date: 2002/08/12 11:44:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#include "helper/loadeventlistener.hxx"

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

DEFINE_XINTERFACE_2( LoadEventListener                               ,
                     OWeakObject                                     ,
                     DIRECT_INTERFACE(css::lang::XTypeProvider      ),
                     DIRECT_INTERFACE(css::frame::XLoadEventListener)
                   )

DEFINE_XTYPEPROVIDER_2( LoadEventListener             ,
                        css::lang::XTypeProvider      ,
                        css::frame::XLoadEventListener
                      )

//_________________________________________________________________________________________________________________

LoadEventListener::LoadEventListener()
        : ThreadHelpBase( & Application::GetSolarMutex() )
        , OWeakObject   (                                )
        , m_eState      ( E_UNSPECIFIED                  )
{
    m_aCondition.reset();
}

//_________________________________________________________________________________________________________________

void LoadEventListener::setBroadcaster(const css::uno::Reference< css::frame::XFrameLoader >& xBroadcaster)
{
    // If we get a new broadcaster it seams that we should be used for a new load request later.
    // Then we have to reset our internal ressources to be able for such new operation.

    m_aCondition.reset();

    /* SAFE { */
    WriteGuard aWriteLock(m_aLock);
    m_eState       = E_UNSPECIFIED;
    m_xBroadcaster = xBroadcaster;
    aWriteLock.unlock();
    /* } SAFE */
}

//_________________________________________________________________________________________________________________

void SAL_CALL LoadEventListener::loadFinished ( const css::uno::Reference< css::frame::XFrameLoader >& xLoader ) throw (css::uno::RuntimeException)
{
    /* SAFE { */
    WriteGuard aWriteLock(m_aLock);
    m_eState       = E_SUCCESS;
    m_xBroadcaster = css::uno::Reference< css::frame::XFrameLoader >();
    aWriteLock.unlock();
    /* } SAFE */

    m_aCondition.set();
}

//_________________________________________________________________________________________________________________

void SAL_CALL LoadEventListener::loadCancelled( const css::uno::Reference< css::frame::XFrameLoader >& xLoader ) throw (css::uno::RuntimeException)
{
    /* SAFE { */
    WriteGuard aWriteLock(m_aLock);
    m_eState       = E_FAILED;
    m_xBroadcaster = css::uno::Reference< css::frame::XFrameLoader >();
    aWriteLock.unlock();
    /* } SAFE */

    m_aCondition.set();
}

//_________________________________________________________________________________________________________________

void SAL_CALL LoadEventListener::disposing( const css::lang::EventObject& aEvent ) throw(css::uno::RuntimeException)
{
    /* SAFE { */
    WriteGuard aWriteLock(m_aLock);
    m_eState       = E_FAILED;
    m_xBroadcaster = css::uno::Reference< css::frame::XFrameLoader >();
    aWriteLock.unlock();
    /* } SAFE */

    m_aCondition.set();
}

//_________________________________________________________________________________________________________________

void LoadEventListener::waitForFinish()
{
    m_aCondition.wait();
}

//_________________________________________________________________________________________________________________

ELoadState LoadEventListener::getState()
{
    // At this point we shouldn't have any broadcaster.
    // Otherwhise our callbacks wasn't never called!
    // And if they wasn't used - we can't guarantee any valid value here.
    LOG_ASSERT2( m_xBroadcaster.is(), "LoadEventListener::getState()", "Unexpected situation! Returned state may be not valid." )

    /* SAFE { */
    ReadGuard aReadLock(m_aLock);
    return m_eState;
    /* } SAFE */
}

} // namespace framework
