#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.14 $
#
#   last change: $Author: vg $ $Date: 2003/05/28 12:41:19 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=.

PRJNAME=so_freetype
TARGET=so_freetype

# --- Settings -----------------------------------------------------

.INCLUDE :	settings.mk

# --- Files --------------------------------------------------------

# We use the freetype provided with XDarwin/XFree86 for
# the X11 port because there are some header conflicts
# and linktime conflicts as well.  It is simply less of
# a headache to use the one provided.
.IF "$(OS)" == "MACOSX"

dummy:
	@echo "Nothing to build for MACOSX"

.ELSE	# "$(OS)" == "MACOSX"

TARFILE_NAME=freetype-2.1.4

PATCH_FILE_NAME=freetype-2.1.4.patch

CONFIGURE_DIR=
.IF "$(GUI)"=="UNX"
#relative to CONFIGURE_DIR
CONFIGURE_ACTION=$(GNUMAKE)
CONFIGURE_FLAGS=setup CFG="--with-pic --without-zlib"

BUILD_DIR=$(CONFIGURE_DIR)
BUILD_ACTION=$(GNUMAKE)

OUT2LIB= \
	objs$/.libs$/libfreetype.a
.IF "$(OS)"=="MACOSX"
OUT2LIB+=objs$/.libs$/libfreetype.*.dylib
.ELIF "$(OS)"=="FREEBSD"
OUT2LIB+=objs$/.libs$/libfreetype.so.9*
.ELSE
OUT2LIB+=objs$/.libs$/libfreetype.so.6*
.ENDIF          # "$(OS)"=="MACOSX" || "$(OS)"=="FREEBSD"

.ELSE			# "$(GUI)"=="UNX"
.IF "$(USE_SHELL)"=="4nt"
#relative to CONFIGURE_DIR
CONFIGURE_ACTION=$(GNUMAKE)
CONFIGURE_FLAGS=setup visualc

BUILD_DIR=$(CONFIGURE_DIR)
BUILD_ACTION=$(GNUMAKE)

OUT2LIB= \
	objs$/freetype.lib

.ELSE			# "$(USE_SHELL)"=="4nt"
#relative to CONFIGURE_DIR
CONFIGURE_DIR=
CONFIGURE_ACTION=$(BACK_PATH)..$/convert.sh

BUILD_DIR=$(CONFIGURE_DIR)
BUILD_ACTION=msdev builds/win32/visualc/freetype.dsw /useenv /MAKE

OUT2LIB= \
	objs$/freetype.lib

.ENDIF			# "$(USE_SHELL)"=="4nt"
.ENDIF			# "$(GUI)"=="UNX"

OUT2INC= \
	include$/freetype$/f*.h \
	include$/freetype$/tt*.h \
	include$/ft2build.h

OUTDIR2INC= \
	include$/freetype$/internal \
	include$/freetype$/config

# --- Targets ------------------------------------------------------


.IF "$(BUILD_SOSL)"=="" || "$(GUI)"=="UNX"
.INCLUDE : set_ext.mk
.INCLUDE :	target.mk
.INCLUDE :	tg_ext.mk

.ELSE			# "$(BUILD_SOSL)"=="" || "$(GUI)"=="UNX"
.INCLUDE :	target.mk
.ENDIF			# "$(BUILD_SOSL)"=="" || "$(GUI)"=="UNX"

.ENDIF	# "$(OS)" == "MACOSX"
