#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.18.4.1 $
#
#   last change: $Author: hr $ $Date: 2003/08/15 12:00:14 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************
PRJ=..
PRJNAME=OpenOffice
TARGET=util

.INCLUDE:  settings.mk

.IF "$(BUILD_SPECIAL)"!=""
LZIPFLAGS*:=-S
.ENDIF

.IF "$(strip)"!=""
LZIPFLAGS*:=-S
.ENDIF

LZIPFLAGS+=-e $(MISC)$/lzip.log
SHARED_COM_SDK_PATH*:=.

.IF "$(BSCLIENT)"!=""
.IF "$(GUI)"=="WNT"
INSTALLDIR=\\jumbo\r-laufwerk_\ship\install\$(INPATH)\OpenOffice.org\$(WORK_STAMP)_$(CWS_WORK_STAMP)_$(LAST_MINOR).$(BUILD)
.ELSE
INSTALLDIR=/ship/install/$(INPATH)/OpenOffice.org/$(WORK_STAMP)_$(CWS_WORK_STAMP)_$(LAST_MINOR).$(BUILD)
.ENDIF
.ELSE # BSCLIENT
INSTALLDIR=$(OUT)
.ENDIF

SEARCH_DIR:=.
.IF "$(BUILD_SPECIAL)"!=""
.IF "$(GUI)"=="WNT"
SEARCH_DIR=r:\solenv\inst\ooo\$(OUTPATH)
.ENDIF
.ENDIF

.INCLUDE: target.mk

ALLTAR : pack

.IF "$(alllangext)"!=""

.IF "$(BUILD_SPECIAL)"!=""  
.IF "$(OOO_RELEASE_BUILD)"==""
pack: pack_01
.ELSE
pack: $(foreach,i,$(alllangext) pack_$i)
.ENDIF
.ELSE
pack: $(foreach,i,$(alllangext) pack_$i)
.ENDIF

pack_%:
	+-$(MKDIRHIER) $(INSTALLDIR)$/$(@:s/pack_//)$/normal
	+-$(RM) $(INSTALLDIR)$/$(@:s/pack_//)$/normal$/*
	+-$(LZIP) -p ${SEARCH_DIR} $(LZIPFLAGS) -l $(@:s/pack_//) -f openoffice.lst -d $(INSTALLDIR)$/$(@:s/pack_//) -n OfficeOSL 

test:
	+-$(LZIP) $(LZIPFLAGS) -p ${SEARCH_DIR} -l 01 -f openoffice.lst -o -n OfficeOSL 

.ELSE			# "$(alllangext)"!=""
pack:
	@+echo cannot pack nothing...

.ENDIF			# "$(alllangext)"!=""

	
