/*************************************************************************
 *
 *  $RCSfile: IEnvironment.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 12:33:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.uno;

/**
 * The interface implemented by UNO environments.
 *
 * <p>With this interface, objects can be registered at and revoked from an
 * environment.</p>
 *
 * @see com.sun.star.uno.UnoRuntime
 * @see com.sun.star.uno.IQueryInterface
 * @see com.sun.star.uno.IBridge
 * @since UDK1.0
 */
public interface IEnvironment {
    /**
     * Gets the context of this environment.
     *
     * @return the context of this environment
     */
    Object getContext();

    /**
     * Gets the name of this environment.
     *
     * @return the name of this environment
     */
    String getName();

    /**
     * Registers one UNO interface facet of an object.
     *
     * <p>Such an object will typically be one of three things:
     * <ul>
     * <li>A local Java object, to be mapped out of this environment via a given
     *     bridge.</li>
     * <li>A proxy object, mapped into this environment via some bridge
     *     <var>B1</var>, and now to be mapped out of this environment via a
     *     given bridge <var>B2</var>.</li>
     * <li>A proxy object, created as a remote object is mapped into this
     *     environment via a given bridge.</li>
     * </ul></p>
     *
     * <p>The object actually registered may differ from the specified
     * <code>object</code> that is passed as an argument.  This enables an
     * environment to work in a multi-threaded scenario, where two threads can
     * call <code>registerInterface</code> for the same combination of
     * <code>oid</code> and <code>type</code> at the same time; the race
     * condition is solved by letting one of the calls register its argument
     * <code>object</code>, ignoring the argument <code>object</code> of the
     * other call, and letting both calls return the same
     * <code>object</code>.</p>
     *
     * <p>The registered object is held only weakly by the environment.  After a
     * call to <code>registerInterface</code>, a call to
     * <code>getRegisteredInterface</code> only succeeds as long as the
     * registered object is still strongly reachable, and the registered object
     * has not been explicitly revoked by calling
     * <code>revokeInterface</code>.</p>
     *
     * @param object the object to register; must be non-null
     * @param oid in-out parameter containing the OID of <code>object</code>.
     *    This must be a non-null reference to an array of length at least one;
     *    the zeroth element is used to pass the argument in and out.  If the
     *    zeroth element is null on input, the OID will be computed and passed
     *    out (that is, the zeroth element will never be null upon normal
     *    return).
     * @param type the UNO interface type to register.  This argument must be
     *    non-null, and must denote a UNO interface type.  The given
     *    <code>object</code> should implement this <code>type</code>.
     * @return the registered object (may differ from the <code>object</code>
     *     passed in); will never be null
     */
    Object registerInterface(Object object, String[] oid, Type type);

    /**
     * Explicitly revokes a UNO interface facet.
     *
     * <p>Calls to <code>registerInterface</code> and
     * <code>revokeInterface</code> must be paired.  A facet is only removed
     * from the environment when it has been revoked as often as it has been
     * registered.  This may change in the future, so that a facet would be
     * removed upon the first call to <code>revokeInterface</code> (and calls to
     * <code>revokeInterface</code> would no longer be necessary if the calling
     * code does not want to control the temporal extent of the
     * registration).</p>
     *
     * <p>It is not an error if the specified facet is not registered at this
     * environment (either because no corresponding object has ever been
     * registered, or it has been explicitly revoked, or it is no longer
     * strongly reachable).  In such a case, this method simply does
     * nothing.</p>
     *
     * @param oid the OID of the object to revoke; must be non-null
     * @param type the UNO interface type of the object to revoke.  This
     *     argument must be non-null, and must denote a UNO interface type.
     */
    void revokeInterface(String oid, Type type);

    /**
     * Retrieves a registered object, specified by OID and UNO interface type.
     *
     * @param oid the OID of the object to retrieve; must be non-null
     * @param type the UNO interface type of the object to retrieve.  This
     *     argument must be non-null, and must denote a UNO interface type.
     * @return the registered object, or null if none is found
     */
    Object getRegisteredInterface(String oid, Type type);

    /**
     * Retrieves the OID for a registered object.
     *
     * @param object a registered object; must be non-null
     * @return the OID of the <code>object</code>; will never be null
     */
    String getRegisteredObjectIdentifier(Object object);

    /**
     * Lists the registered objects to <code>System.out</code>.
     *
     * <p>This is for debug purposes.</p>
     */
    void list();
}
