/*************************************************************************
 *
 *  $RCSfile: SimpleViewer.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 15:31:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *  
 *  Copyright (c) 2003 by Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *     
 *************************************************************************/

import javax.swing.filechooser.*;
import javax.swing.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

import com.sun.star.beans.LocalOfficeConnection;

/** A simple Applet that contains the SimpleBean.
 *
 * This applet is a sample implementation of the 
 * OpenOffice.org bean. 
 * When initally loaded the applet has two buttons
 * one for opening an existant file and one to open 
 * a blank document of a given type supported by
 * OpenOffice.org eg. Writer, Calc, Impress, .....
 *
 */
 
public class SimpleViewer extends java.applet.Applet
{
   
   /**
    * Private variables declaration - GUI components
    */
   private Panel buttonPanel;
   private JButton newDocumentButton;
   private JPopupMenu documentTypePopUp;
   private JButton openDocumentButton;
   private JTextField documentURLTextField;
   private JMenuItem item;
   private JFileChooser fileChooser;

   /**
    * Private variables declaration - SimpleBean variables
    */
   private SimpleBean simpleBean;
   

   /**
    * Initialize the Appplet
    */
   public void init()
   {
        //Initialize GUI components
        buttonPanel = new Panel();
        newDocumentButton = new JButton("New document...");
        documentTypePopUp = new JPopupMenu();
        openDocumentButton = new JButton("Open file...");
        documentURLTextField = new JTextField();
      
		//The simpleBean needs to be initialized to add it to the applet
		simpleBean = new SimpleBean();
		//Setup the connection to a local Office process
		simpleBean.setOfficeConnection(new LocalOfficeConnection());
                
       
        //Set up the Popup Menu to create a blank document
        documentTypePopUp.setToolTipText("Create an empty document");
        
        item = documentTypePopUp.add("Text Document");
        item.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent evt)
            {
                createBlankDoc("private:factory/swriter", 
                    "New text document");
            }
        });

        item = documentTypePopUp.add("Presentation Document");
        item.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent evt)
            {
                createBlankDoc("private:factory/simpress", 
                    "New presentation document");
            }
        });

        item = documentTypePopUp.add("Drawing Document");
        item.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent evt)
            {
                createBlankDoc("private:factory/sdraw", 
                    "New drawing document");
            }
        });

        item = documentTypePopUp.add("Formula Document");
        item.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent evt)
            {
                createBlankDoc("private:factory/smath", 
                    "New formula document");
            }
        });

        item = documentTypePopUp.add("Spreadsheet Document");
        item.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent evt)
            {
                createBlankDoc("private:factory/scalc", 
                    "New spreadsheet document");
            }
        });

        openDocumentButton.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent evt)
            {
                openDocument(evt);
            }
       });

       newDocumentButton.addActionListener(new ActionListener()
       {
            public void actionPerformed(ActionEvent evt)
            {
                documentTypePopUp.show((Component)evt.getSource(), 0,0);
            }
       });

       documentURLTextField.setEditable(false);
       documentURLTextField.setPreferredSize(new Dimension(200, 30));

       buttonPanel.add(newDocumentButton);
       buttonPanel.add(openDocumentButton);
       buttonPanel.add(documentURLTextField);

       setLayout(new BorderLayout());

       add(buttonPanel, BorderLayout.SOUTH);
       add(simpleBean, BorderLayout.CENTER);
       simpleBean.setMenuBarVisible(false);
   }

   /**
    * Create a blank document of type <code>desc</code>
    *
    * @param url The private internal URL of the OpenOffice.org
    *            document describing the document
    * @param desc A description of the document to be created
    */
   private void createBlankDoc(String url, String desc)
   {
       //Create a blank document
       try
       {
            documentURLTextField.setText(desc);
            //Get the office process to load the URL
            simpleBean.load(url);
       }
       catch (IOException ioe)
       {
            ioe.printStackTrace();
            //return;
       }
       simpleBean.setMenuBarVisible(true);
       return;
    }

   /**
    * Opens an existing document using the fileChooser
    *
    * @param evt A button action event
    */
   private void openDocument(ActionEvent evt)
   {
        int fileChoserRetVal = 0;
        
        //Show the fileChooser
        fileChoserRetVal = getFileChooser().showOpenDialog(this);

        if(fileChoserRetVal == JFileChooser.APPROVE_OPTION)
        {
            //Get the file selected in the fileChooser
            File file = getFileChooser().getSelectedFile();
            
            //If the file exists, get the Office process to load it
            if(file.exists())
            {
                try
                {
                    documentURLTextField.setText(file.getName());
                    simpleBean.load(file.toURL().toString());
                }
                catch (IOException ioe)
                {
                    ioe.printStackTrace();
                    return;
                }
           }
           else
           {
                //If the file does not exist create a blank writer document
                try
                {
                    documentURLTextField.setText("New text document");
                    simpleBean.load("private:factory/swriter");
                }
                catch (IOException ioe)
                {
                    ioe.printStackTrace();
                    return;
                }
           }
           simpleBean.setMenuBarVisible(true);
       }
   }
   
   /**
    * A file chooser factory.
    */
   private JFileChooser getFileChooser()
   {
        if(fileChooser == null)
        {
            fileChooser = new JFileChooser();
        }
        return fileChooser;
   }

   /**
    * An ExitListener listening for windowClosing events
    */
   private class ExitListener extends WindowAdapter
   {
        /**
         * windowClosed
         * 
         * @param e A WindowEvent for a closed Window event
         */
        public void windowClosed(WindowEvent e)
        {
            simpleBean.closeConnection();
            stop();
            System.exit(0);
        }

        /**
         * windowClosing for a closing window event
         *
         * @param e A WindowEvent for a closing window event
         */
        public void windowClosing(WindowEvent e)
        {
            ((Window)e.getSource()).dispose();
        }
   }

   public static void main(String args[])
   {
       Frame frame = new Frame("OpenOffice.org Demo");
       SimpleViewer SimpleViewer = new SimpleViewer();

       frame.setLayout(new BorderLayout());

       frame.addWindowListener(SimpleViewer.new ExitListener());

       SimpleViewer.init();
       SimpleViewer.start();

       frame.add(SimpleViewer);
       frame.setSize(640,480);
       frame.show();
   }
}
