Option Explicit

'********************************************************************************
' script to register type, filter and other informations into the office
' configuration package org.openoffice.Office.TypeDetection
'
' @author       Andreas Schlns
' @copyright    2000 by Sun Microsystems, Inc. All Rights Reserved.
'********************************************************************************
Sub Main
	Dim xSubst as Object
	Dim sProg  as String

	xSubst = createUnoService("com.sun.star.config.SpecialConfigManager")
	if ( not isnull(xSubst) ) then
		sProg = xSubst.substituteVariables("$(progpath)")
        regINI(sProg+"\regfilter.ini")
	endif
End Sub

'********************************************************************************
' open the user provided ini file and use it to register all types/filters/libs/...
' which are defined inside this file
'
' @param FileName
'        a name in system notation, which specifies the ini file
'********************************************************************************
Sub regINI( sFileName as String )

    Dim aHandle as Integer
    Dim aConfig as Object
    Dim sLine   as String
    Dim bState  as Boolean

    aHandle = FreeFile
    Open sFileName for Input as #aHandle

    aConfig = openConfig("/org.openoffice.Office.TypeDetection",true)

    Do until eof(aHandle)

        Line Input #aHandle, sLine

        if (instr(1,sLine,"#",1)=0) and (instr(1,sLine,"rem",1)=0) and (instr(1,sLine,";",1)=0) and (sLine<>"") then

            if (sLine="[type]") then
                bState = regTypeSection(aConfig,#aHandle)
            elseif (sLine="[filter]") then
                bState = regFilterSection(aConfig,#aHandle)
            elseif (sLine="[detector]") then
                bState = regDetectorSection(aConfig,#aHandle)
            endif

            if (bState=false) then
                if (msgbox("Registration of a "+sLine+" failed. Should I continue with the next item?",4)<>6 ) then
                    Exit Sub
                end if
            endif

        endif

    Loop

    Close #aHandle

    msgbox "Registration of the ini file '"+sFileName+"' was successfull."

End Sub

'********************************************************************************
' read one type section from the ini file and register her content inside
' office configuration package
'
' @return true, if registration of this section was successfully or false if not
'********************************************************************************
Function regTypeSection(  aConfig as Object  ,_
                         #aHandle as Integer ) as Boolean

    Dim sName             as String
    Dim lUINames(0)       as Variant
    Dim bPreferred        as Boolean
    Dim sMediaType        as String
    Dim sClipboardFormat  as String
    Dim lURLPattern(0)    as String
    Dim lExtensions(0)    as String
    Dim nDocumentIconID   as Integer
    Dim aUIName           as new com.sun.star.beans.PropertyValue
    Dim sLine             as String
    Dim sVal              as String
    Dim aPos              as Integer
    Dim u                 as Integer
    Dim p                 as Integer
    Dim e                 as Integer

    Do until eof(aHandle)

        Line Input #aHandle, sLine

        if (sLine="") then
            Exit Do
        endif

        if (instr(1,sLine,"#",1)=0) and (instr(1,sLine,"rem",1)=0) and (instr(1,sLine,";",1)=0) then

            if (instr(1,sLine,"name=",1)<>0) then
                sName = right(sLine,len(sLine)-5)

            elseif (instr(1,sLine,"uiname(",1)<>0) then
                aPos = instr(sLine,")=")
                if (aPos>8) then
                    ReDim Preserve lUINames(u) as Variant
                    aUIName.Name  = mid(sLine,8,aPos-8)
                    aUIName.Value = right(sLine,len(sLine)-(aPos+1))
                    lUINames(u)   = aUIName
                    u = u+1
                endif

            elseif (instr(1,sLine,"preferred=",1)<>0) then
                sVal = right(sLine,len(sLine)-5)
                if (sVal="false") or (sVal="0") then
                    bPreferred = false
                else
                    bPreferred = true
                endif

            elseif (instr(1,sLine,"mediatype=",1)<>0) then
                sMediaType = right(sLine,len(sLine)-10)

            elseif (instr(1,sLine,"clipboardformat=",1)<>0) then
                sClipboardFormat = right(sLine,len(sLine)-16)

            elseif (instr(1,sLine,"urlpattern=",1)<>0) then
                ReDim Preserve lURLPattern(p) as String
                lURLPattern(p) = right(sLine,len(sLine)-11)
                p = p+1

            elseif (instr(1,sLine,"extension=",1)<>0) then
                ReDim Preserve lExtensions(e) as String
                lExtensions(e) = right(sLine,len(sLine)-10)
                e = e+1

            elseif (instr(1,sLine,"documenticonid=",1)<>0) then
                nDocumentIconID = cint(right(sLine,len(sLine)-15))

            endif

        endif

    Loop

    regTypeSection = registerType(aConfig,sName,lUINames(),bPreferred,sMediaType,sClipboardFormat,lURLPattern(),lExtensions(),nDocumentIconID)

End Function

'********************************************************************************
' read one filter section from the ini file and register her content inside
' office configuration package
'
' @return true, if registration of this section was successfully or false if not
'********************************************************************************
Function regFilterSection(  aConfig as Object  ,_
                           #aHandle as Integer ) as Boolean
    Dim sName               as String
    Dim lUINames()          as Variant
    Dim bInstalled          as Boolean
    Dim nOrder              as Integer
    Dim sType               as String
    Dim sDocumentService    as String
    Dim sFilterService      as String
    Dim sUIComponent        as String
    Dim nFlags              as Long
    Dim lUserData()         as String
    Dim nFileFormatVersion  as Integer
    Dim sTemplateName       as String
    Dim aUIName             as new com.sun.star.beans.PropertyValue
    Dim sLine               as String
    Dim sVal                as String
    Dim aPos                as Integer
    Dim u                   as Integer
    Dim d                   as Integer

    Do until eof(aHandle)

        Line Input #aHandle, sLine

        if (sLine="") then
            Exit Do
        endif

        if (instr(1,sLine,"#",1)=0) and (instr(1,sLine,"rem",1)=0) and (instr(1,sLine,";",1)=0) then

            ' attention: It's neccessary to check for this "templatename"
            ' before we search for "name". Otherwhise "name=" is found in
            ' both strings and templatename" willn't be reached.
            if (instr(1,sLine,"templatename=",1)<>0) then
                sTemplateName = right(sLine,len(sLine)-13)

            elseif (instr(1,sLine,"name=",1)<>0) then
                sName = right(sLine,len(sLine)-5)

            elseif (instr(1,sLine,"uiname(",1)<>0) then
                aPos = instr(sLine,")=")
                if (aPos>8) then
                    ReDim Preserve lUINames(u) as Variant
                    aUIName.Name  = mid(sLine,8,aPos-8)
                    aUIName.Value = right(sLine,len(sLine)-(aPos+1))
                    lUINames(u)   = aUIName
                    u = u+1
                endif
    
            elseif (instr(1,sLine,"installed=",1)<>0) then
                sVal = right(sLine,len(sLine)-5)
                if (sVal="false") or (sVal="0") then
                    bInstalled = false
                else
                    bInstalled = true
                endif
    
            elseif (instr(1,sLine,"order=",1)<>0) then
                nOrder = cint(right(sLine,len(sLine)-6))
    
            elseif (instr(1,sLine,"type=",1)<>0) then
                sType = right(sLine,len(sLine)-5)
    
            elseif (instr(1,sLine,"documentservice=",1)<>0) then
                sDocumentService = right(sLine,len(sLine)-16)
    
            elseif (instr(1,sLine,"filterservice=",1)<>0) then
                sFilterService = right(sLine,len(sLine)-14)
    
            elseif (instr(1,sLine,"uicomponent=",1)<>0) then
                sUIComponent = right(sLine,len(sLine)-12)
    
            elseif (instr(1,sLine,"flags=",1)<>0) then
                nFlags = clng(right(sLine,len(sLine)-6))
                
            elseif (instr(1,sLine,"userdata=",1)<>0) then
                ReDim Preserve lUserData(d) as String
                lUserData(d) = right(sLine,len(sLine)-9)
                d = d+1
    
            elseif (instr(1,sLine,"fileformatversion=",1)<>0) then
                nFileFormatVersion = cint(right(sLine,len(sLine)-18))
    
            endif
            
        endif           

    Loop

    regFilterSection = registerFilter(aConfig,sName,lUINames(),bInstalled,nOrder,sType,sDocumentService,sFilterService,sUIComponent,nFlags,lUserData(),nFileFormatVersion,sTemplateName)

End Function

'********************************************************************************
' read one detector section from the ini file and register her content inside
' office configuration package
'
' @return true, if registration of this section was successfully or false if not
'********************************************************************************
Function regDetectorSection(  aConfig as Object  ,_
                             #aHandle as Integer ) as Boolean
    Dim sName    as String
    Dim lTypes() as String
    Dim sLine    as String
    Dim t        as Integer

    Do until eof(aHandle)

        Line Input #aHandle, sLine
        
        if (sLine="") then
            Exit Do
        endif

        if (instr(1,sLine,"#",1)=0) and (instr(1,sLine,"rem",1)=0) and (instr(1,sLine,";",1)=0) then

            if (instr(1,sLine,"name=",1)<>0) then
                sName = right(sLine,len(sLine)-5)
    
            elseif (instr(1,sLine,"type=",1)<>0) then
                ReDim Preserve lTypes(t) as String
                lTypes(t) = right(sLine,len(sLine)-5)
                t = t+1
    
            endif
            
        endif           

    Loop

    regDetectorSection = registerDetector(aConfig,sName,lTypes())

End Function

'********************************************************************************
' open the configuration package org.openoffice.Office.TypeDetection
' It opens the user layer of the configuration - not the share one!
'
' @param sPackage
'        describe the package which should be handled by the returned
'        configuration access object
'        e.g.: "/org.openoffice.Office.TypeDetection"
'
' @param bReadWrite
'        describe how the package should be opened (readonly/writable)
'
' @return Object
'         which provides access to the required package
'********************************************************************************
Function openConfig( sPackage   as String  ,_
                     bReadWrite as Boolean ) as Object

    Dim aConfig         as Object
    Dim lParams(1)      as new com.sun.star.beans.PropertyValue
    Dim aConfigProvider as Object

    aConfigProvider  = createUnoService("com.sun.star.configuration.ConfigurationProvider")
    lParams(0).Name  = "nodepath"
    lParams(0).Value = sPackage
    ' special mode to have access on localized entries directly!
    ' means  possibility to change e.g. "Filter/UIName/en-US" instead of "Filter/UIName"
    lParams(1).Name  = "locale"
    lParams(1).Value = "*"

    if (bReadWrite=true) then
        aConfig = aConfigProvider.createInstanceWithArguments( _
            "com.sun.star.configuration.ConfigurationUpdateAccess", _
            lParams() )
    else
        aConfig = aConfigProvider.createInstanceWithArguments( _
            "com.sun.star.configuration.ConfigurationReadAccess", _
            lParams() )
    endif
    
    if (isnull(aConfig)) then
        msgbox "Couldn't open configuration."
    end if

    openConfig = aConfig

End Function

'********************************************************************************
' register given type inside configuration
' If this type already exist it asks the user for a decision.
' In case of "OK" the type will be replaced. Otherwise nothing is done.
' @return TRUE
'           if registration was successfully
' @return FALSE
'           if type already exist and shouldn't be overwritten
'           or couldn't be created
'********************************************************************************
Function registerType(aConfig           as Object                           , _
                      sName             as String                           , _
                      lUINames()        as com.sun.star.beans.PropertyValue , _
                      bPreferred        as Boolean                          , _
                      sMediaType        as String                           , _
                      sClipboardFormat  as String                           , _
                      lURLPattern()     as String                           , _
                      lExtensions()     as String                           , _
                      nDocumentIconID   as Integer                          ) as Boolean

    Dim aTypeSet as Object
    aTypeSet = aConfig.getByName("Types")

    ' existing check for this type
    if (aTypeSet.hasByName(sName) ) then
        Dim nDecision as Integer
        nDecision = MsgBox( "The type is already present in the configuration! Overwrite?", 4 )
        if (nDecision=6) then
            ' user decided to overwrite the type
            ' We do it be deleting it and create a new entry.
            aTypeSet.removeByName(sName)
        else
            ' user decided to break this registration
            ' Return an error to the caller of this function.
            registerType = FALSE
            Exit Function
        end if
    end if

    ' create requested type entry
    ' But first build a special formated data string which present the type inside the configuration.
    Dim sData as String
    Dim i     as Integer

    if (bPreferred=TRUE) then
        sData = "1,"
    else
        sData = "0,"
    end if
    sData = sData+sMediaType+","
    sData = sData+sClipboardFormat+","
    for i=0 to ubound(lURLPattern()) step 1
        sData = sData+lURLPattern(i)
        if (i<ubound(lURLPattern())) then
            sData = sData+";"
        end if
    next i
    sData = sData+","
    for i=0 to ubound(lExtensions()) step 1
        sData = sData+lExtensions(i)
        if (i<ubound(lExtensions())) then
            sData = sData+";"
        end if
    next i
    sData = sData+","+nDocumentIconID

    Dim aNewType    as Object
    Dim aUINameList as Object

    aNewType = aTypeSet.createInstance()
    aNewType.Data = sData
    aUINameList = aNewType.getByName("UIName")
    for i=0 to ubound(lUINames()) step 1
        aUINameList.insertByName(lUINames(i).Name, lUINames(i).Value)
    next i
    aTypeSet.insertByName( sName, aNewType )
    aConfig.commitChanges()

    registerType = TRUE

End Function

'********************************************************************************
' register given filter inside configuration
' If this filter already exist it asks the user for a decision.
' In case of "OK" the filter will be replaced. Otherwise nothing is done.
' @return TRUE
'           if registration was successfully
' @return FALSE
'           if filter already exist and shouldn't be overwritten
'           or couldn't be created
'********************************************************************************
Function registerFilter(aConfig             as Object                           , _
                        sName               as String                           , _
                        lUINames()          as com.sun.star.beans.PropertyValue , _
                        bInstalled          as Boolean                          , _
                        nOrder              as Integer                          , _
                        sType               as String                           , _
                        sDocumentService    as String                           , _
                        sFilterService      as String                           , _
                        sUIComponent        as String                           , _
                        nFlags              as Long                          	, _
                        lUserData()         as String                           , _
                        nFileFormatVersion  as Integer                          , _
                        sTemplateName       as String                           ) as Boolean

    Dim aFilterSet as Object
    aFilterSet = aConfig.getByName("Filters")

    ' existing check for this type
    if (aFilterSet.hasByName(sName) ) then
        Dim nDecision as Integer
        nDecision = MsgBox( "The filter is already present in the configuration! Overwrite?", 4 )
        if (nDecision=6) then
            ' user decided to overwrite the filter
            ' We do it be deleting it and create a new entry.
            aFilterSet.removeByName(sName)
        else
            ' user decided to break this registration
            ' Return an error to the caller of this function.
            registerFilter = FALSE
            Exit Function
        end if
    end if

    ' create requested filter entry
    ' But first build a special formated data string which present the filter inside the configuration.
    ' Format = "<Order>,<Type>,<DocumentService>,<FilterService>,<Flags>,<UserData(0)[;UserData(1)]>,<FileFormatVersion>,<TemplateName>,<UIComponent>"
    Dim sData as String
    Dim i     as Integer

    sData = ""
    sData = sData+nOrder+","
    sData = sData+sType+","
    sData = sData+sDocumentService+","
    sData = sData+sFilterService+","
    sData = sData+nFlags+","
    for i=0 to ubound(lUserData()) step 1
        sData = sData+lUserData(i)
        if (i<ubound(lUserData())) then
            sData = sData+";"
        end if
    next i
    sData = sData+","+nFileFormatVersion
    sData = sData+","+sTemplateName
    sData = sData+","+sUIComponent

    Dim aNewFilter  as Object
    Dim aUINameList as Object

    aNewFilter = aFilterSet.createInstance()
    aNewFilter.Installed = bInstalled
    aNewFilter.Data = sData
    aUINameList = aNewFilter.getByName("UIName")
    for i=0 to ubound(lUINames()) step 1
        aUINameList.insertByName(lUINames(i).Name, lUINames(i).Value)
    next i
    aFilterSet.insertByName( sName, aNewFilter )
    aConfig.commitChanges()

    registerFilter = TRUE

End Function

'********************************************************************************
' register given detect service inside configuration
' If this service already exist it asks the user for a decision.
' In case of "OK" the entry will be replaced. Otherwise nothing is done.
' @return TRUE
'           if registration was successfully
' @return FALSE
'           if detect service already exist and shouldn't be overwritten
'           or couldn't be created
'********************************************************************************
Function registerDetector(aConfig  as Object , _
                          sName    as String , _
                          lTypes() as String ) as Boolean

    Dim aDetectorSet as Object
    aDetectorSet = aConfig.getByName("DetectServices")

    ' existing check for this type
    if (aDetectorSet.hasByName(sName) ) then
        Dim nDecision as Integer
        nDecision = MsgBox( "The detect service is already present in the configuration! Overwrite?", 4 )
        if (nDecision=6) then
            ' user decided to overwrite the entry
            ' We do it be deleting it and create a new one.
            aDetectorSet.removeByName(sName)
        else
            ' user decided to break this registration
            ' Return an error to the caller of this function.
            registerDetector = FALSE
            Exit Function
        end if
    end if

    ' create requested detector entry
    Dim aNewDetector as Object
    Dim aTypeList as Object

    aNewDetector = aDetectorSet.createInstance()
    aNewDetector.Types = lTypes()
    aDetectorSet.insertByName( sName, aNewDetector )
    aConfig.commitChanges()

    registerDetector = TRUE

End Function
