
package org.netbeans.modules.openoffice.wizard;


import java.io.*;
import java.lang.*;
import java.beans.*;
import java.util.*;
import java.beans.PropertyChangeSupport;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.ClassElement;
import org.openide.cookies.SourceCookie;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.src.Type;
import org.openide.src.Import;


/** Represents a Service object in the Repository.
 *
 * @author  Michael Bohn
 *
 */


public class OOServiceData  {

    
    
    protected ClassElement original_outerclass;
    protected ClassElement customized_outerclass;
    protected ClassElement original_innerclass;
    protected ClassElement customized_innerclass;
    protected String PackageName;
    protected Vector InterfaceObjects;       
   
    
       
  public OOServiceData() 
    {
      //TopManager.getDefault().notify(new NotifyDescriptor.Message("bin in dtor von ServiceData"));
      InterfaceObjects = new Vector();      
    }

  private void init () 
    {
      
    }
    
  public void setTarget(DataObject dataobject)
  {

     SourceCookie sourcecookie = (SourceCookie)dataobject.getCookie(SourceCookie.class);
     if(sourcecookie == null)
        {
          // when can this option raise up      
        }   
     ClassElement aclasselement[] = sourcecookie.getSource().getClasses();
     try
       {
          if(aclasselement == null || aclasselement.length == 0)
            {
             // what should we do, if the template does not contain a class
            }else
                { //we have to aquire the innner class
                  original_outerclass = (ClassElement) aclasselement[0].clone();
                  customized_outerclass = (ClassElement) aclasselement[0].clone();
                  ClassElement classelement[] = original_outerclass.getClasses() ;
                  ClassElement classelement1[] = customized_outerclass.getClasses() ;
                  original_innerclass = classelement[0];
                  customized_innerclass = classelement1[0];
                  //now we have the all the classes 
                }  
       } catch(Exception e){}
        
  }
  
  public void setTargetFolder(DataFolder datafolder)
  {
    this.PackageName = datafolder.getPrimaryFile().getPackageNameExt('.', '.');
  }
  
  
  
  public void setClassName(String TargetName)
  {

   try
   {
    String alter_Class_Name = this.customized_innerclass.getName().toString();
    String neuer_Class_Name = TargetName + "Implementation";
        
    this.customized_innerclass.setName(Identifier.create(neuer_Class_Name));
    this.customized_outerclass.setName(Identifier.create(TargetName));
           
    //we have to exchange the source code of all methods of the inner class
    MethodElement MElements[] = this.customized_innerclass.getMethods();
    for(int i = 0;i <= MElements.length-1;i = i+1)
     {  
      String helpstring1 = "";
      MethodElement MElement = (MethodElement) MElements[i].clone();
    
      String helpstring = MElement.getBody().toString();
      int start = 1;
      int ende = helpstring.indexOf(alter_Class_Name);
      if (ende != -1) 
         {
          while(ende != -1)
           { 
            helpstring1 = helpstring1 + helpstring.substring(start,ende) + neuer_Class_Name ;
            start = ende + alter_Class_Name.length() ;
            ende = helpstring.indexOf(alter_Class_Name,start);
           }
          helpstring1 = helpstring1 + helpstring.substring(start,helpstring.length());
          try {
               MElement.setBody(helpstring1);
               this.customized_innerclass.removeMethod(MElements[i]);  
               this.customized_innerclass.addMethod(MElement);  
              }catch (Exception e){e.printStackTrace(System.out);}
                     
         }
    }
    // now we change the name in the outer class
   MethodElement MElements1[] = this.customized_outerclass.getMethods();
   for(int i = 0;i <= MElements1.length-1;i = i+1)
    {  
      String helpstring11 = "";
      MethodElement MElement1 = (MethodElement) MElements1[i].clone();
      String helpstring2 = MElement1.getBody().toString();
      int start1 = 1;
      int ende1 = helpstring2.indexOf(alter_Class_Name);
      if (ende1 != -1) 
         {
           while(ende1 != -1)
             { 
               helpstring11 = helpstring11 + helpstring2.substring(start1,ende1) + neuer_Class_Name;
               start1 = ende1 + alter_Class_Name.length() ;
               ende1 = helpstring2.indexOf(alter_Class_Name,start1);
             }
           helpstring11 = helpstring11 + helpstring2.substring(start1,helpstring2.length());
           try {
                MElement1.setBody(helpstring11);
                this.customized_outerclass.removeMethod(MElements1[i]);  
                this.customized_outerclass.addMethod(MElement1);  
               }catch (Exception e){e.printStackTrace(System.out);}
         }
     }
   }catch(Exception e){}
  }
  
  public String getClassName()
  {
     
     return this.customized_outerclass.getName().toString();         
  }
    
  public void setPackage(String  TargetPackage)
  {
    this.PackageName = TargetPackage;        
  }
    
  public String getPackage()
  {
    return this.PackageName;        
  }
  
  
  
  public boolean addIDLInterface(IDLInterface aIDLInterface)
  { 
    //take a look into the list, if the new interface 
    // already exsists  
    for(int i=0; i< InterfaceObjects.size();i++)
     {  Object aHelper = InterfaceObjects.get(i);
       if (aHelper instanceof IDLInterface)
       {  
          if (((IDLInterface)aHelper).equals(aIDLInterface))
          {return false;}    
          
       }        
    }       
    
    InterfaceObjects.add(aIDLInterface);
    this.setInterface(aIDLInterface);
    return true;
    
  }
  
  public void removeIDLInterface( String aInterfaceName ) {
      for ( int i = 0 ; i < InterfaceObjects.size(); i++ ) {
          Object aHelper = InterfaceObjects.get( i );
          if ( ( ( IDLInterface ) aHelper ).getIDLName().getName()
          == aInterfaceName ) {
              removeInterface( ( IDLInterface ) aHelper );
              
              InterfaceObjects.remove( i );
          }
      }
  }
  
  
  public Identifier[] getInterfaces()
  { 
    return this.customized_innerclass.getInterfaces();
  }
  
  
  public void setInterface(IDLInterface newInterface)
  { 
   
     
   try
    {
     // add the new interface   
     // I have to take the detour over the Identifier.create, because we want to
     // insert the interfaces into the class without the package names.   
     this.customized_innerclass.addInterface(Identifier.create(newInterface.getIDLName().getName()));
     // The new interface is in the declaration now we habe to put the interface into the 
     // methode getType    
     MethodElement aMethodeSrc = this.customized_innerclass.getMethod(Identifier.create("getTypes"), new Type [0]);
     MethodElement aMethodeDes = (MethodElement) aMethodeSrc.clone();
     String MethodString = aMethodeDes.getBody();
     int start = MethodString.indexOf("new Type(");
     String MethodString1 = MethodString.substring(1,start) + "new Type( " + newInterface.getIDLName().getName() + ".class),\n" + MethodString.substring(start,MethodString.length());
     this.customized_innerclass.removeMethod(aMethodeSrc);
     aMethodeDes.setBody(MethodString1);
     this.customized_innerclass.addMethod(aMethodeDes);
     // interfaces are done - now we have to add the methodes 

      
   }catch(Exception e){}
  }
  
 public void removeInterface(IDLInterface newInterface)
  { 
   
     
   try
    {
     // add the new interface   
     // I have to take the detour over the Identifier.create, because we want to
     // insert the interfaces into the class without the package names.   
     this.customized_innerclass.removeInterface(Identifier.create(newInterface.getIDLName().getName()));
     // The new interface is in the declaration now we habe to put the interface into the 
     // methode getType    
     MethodElement aMethodeSrc = this.customized_innerclass.getMethod(Identifier.create("getTypes"), new Type [0]);
     MethodElement aMethodeDes = (MethodElement) aMethodeSrc.clone();
     String MethodString = aMethodeDes.getBody();
     int ende = MethodString.indexOf("new Type( " + newInterface.getIDLName().getName() + ".class),\n" );
     int start = MethodString.indexOf("new Type( ",ende + 1 );
     String MethodString1 = MethodString.substring(1,ende)+ MethodString.substring(start,MethodString.length());
     this.customized_innerclass.removeMethod(aMethodeSrc);
     aMethodeDes.setBody(MethodString1);
     this.customized_innerclass.addMethod(aMethodeDes);
             
   }catch(Exception e){}
  }
  
 public Import[] getImports()
  { Import[] aImports = new Import[InterfaceObjects.size()];
    
    for(int i=0;i < InterfaceObjects.size();i++)
     { 
       aImports[i]= new Import(Identifier.create(((IDLInterface)InterfaceObjects.get(i)).getIDLName().getQualifier()) ,true);
     }  
    return aImports;
  }
  
  public void setServiceName(String ServInterfaces)
  { 
    try
    {
        this.customized_innerclass.getField(Identifier.create("__serviceName")).setInitValue("\"" + ServInterfaces + "\"");            
    } catch(Exception e){}
  }
  
  public String getServiceName()
    {
       return this.customized_innerclass.getField(Identifier.create("__serviceName")).getInitValue();          
    }
    
  public ClassElement getInnerClass()
   { 
      return this.customized_innerclass;
      
   }
   
  public ClassElement getOuterClass()
   {
      for(int i=0;i < InterfaceObjects.size();i++)
      { 
         try
         {
              this.customized_innerclass.addMethods(((IDLInterface)InterfaceObjects.get(i)).getMethodes());
         }catch(Exception e){}     
              
      }  
      
      
     return this.customized_outerclass;
   }

   public final Vector getIDLInterfaces() {
       return( this.InterfaceObjects );
   }
   
}
