
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.AttributeCreator;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateAttributeAction extends NodeAction
    implements Create
{

    public CreateAttributeAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((AttributeCreator)anode[0].getCookie(AttributeCreator.class)).createAttribute();
    }

    protected boolean enable(Node anode[])
    {
        return anode.length == 1 && anode[0].getCookie(AttributeCreator.class) != null;
    }

    public String getName()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateAttribute");
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_Attribute");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }
       
}
