
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.ValueBoxCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class CreateValueBoxAction extends NodeAction
    implements Create
{

    public CreateValueBoxAction()
    {
    }

    public boolean enable(Node anode[])
    {
        if(anode.length != 1)
            return false;
        else
            return  anode[0].getCookie(ValueBoxCreator.class) != null ;
        
      
    }

    public void performAction(Node anode[])
    {
        if(enable(anode))
        {
            ValueBoxCreator valueboxcreator = (ValueBoxCreator)anode[0].getCookie(ValueBoxCreator.class);
            valueboxcreator.createValueBox();
        }
    }

    public String getName()
    {
        return NbBundle.getBundle(CreateValueBoxAction.class).getString("TXT_CreateValueBox");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public String toString()
    {
        return NbBundle.getBundle(CreateValueBoxAction.class).getString("TXT_ValueBox");
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

   
}
