
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.ConstantsPanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.ConstPanel;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.openide.nodes.AbstractNode;
import java.util.Vector;
import org.openide.nodes.Node;
import org.netbeans.modules.openoffice.wizard.util.ConstantCreator;
import org.openide.util.actions.SystemAction;
import org.netbeans.modules.openoffice.wizard.actions.idl.CreateConstantAction;
import org.netbeans.modules.openoffice.wizard.actions.idl.EditAction;
import org.netbeans.modules.openoffice.wizard.actions.idl.RenameAction;
import org.netbeans.modules.openoffice.wizard.actions.idl.DestroyAction;
import org.openide.TopManager;
import org.openide.DialogDescriptor;
import java.util.ResourceBundle;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class ConstantsNode extends MovableNode
implements org.openide.nodes.Node.Cookie, ConstantCreator {

    public ConstantsNode(NameKey namedkey)
    {
        super(namedkey);
        getCookieSet().add(this);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/constants");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
          s1 = s1 + "    ";
         s = s1 + "constants " + getName() + " {\n";
         Node anode[] = getChildren().getNodes();
         for(int k = 0; k < anode.length; k++)
        {
            s = s + ((BaseNode)anode[k]).generateSelf(i + 1);
            s = s + "\n";
        }

        s = s + s1 + "};\n";
        return s;
    }

    public SystemAction[] createActions()
    {
        return (new SystemAction[] {
            SystemAction.get(CreateConstantAction.class),
            SystemAction.get(DestroyAction.class), 
            SystemAction.get(EditAction.class)
        });
    }

    public BasePanel getEditPanel()
    {
        ConstantsPanel constantspanel = new ConstantsPanel();
        constantspanel.setName( getName() );
        return constantspanel;
    }

    public void reInit( BasePanel basepanel )
    {
        if ( basepanel instanceof ConstantsPanel ) {
            String s = ( ( ConstantsPanel ) basepanel ).getName();
            if ( !key.getName().equals( s ) )
            {
                setName( s );
                key.setName( s );
            }
        }
    }

    
    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/constants";
}
