
package org.netbeans.modules.openoffice.wizard.nodes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.util.*;
import org.netbeans.modules.openoffice.wizard.panels.idl.EnumPanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.ModuleCreatePanel;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.wizard.actions.idl.*;
import org.netbeans.modules.openoffice.wizard.util.EnumEntryCreator;
import org.openide.TopManager;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;
import org.openide.DialogDescriptor;


public class EnumNode extends MovableNode
    implements org.openide.nodes.Node.Cookie, EnumEntryCreator
{

    public EnumNode(NameKey namedkey)
    {
        super(namedkey);
        getCookieSet().add(this);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/enum");
        buildEntries(((EnumKey)key).getValuesAndClear());
    }

    public SystemAction[] createActions()
    {
        return (new SystemAction[] {
            SystemAction.get(CreateEnumEntryAction.class),
            SystemAction.get(DestroyAction.class),
            SystemAction.get(EditAction.class)
        });
    }

    public String generateSelf(int i)
    {
        String s = "";
        for(int j = 0; j < i; j++)
            s = s + "    ";

        s = s + "enum " + getName() + " {";
        Children children = getChildren();
        Node anode[] = children.getNodes();
        for(int k = 0; k < anode.length; k++)
        {
            if(k != 0)
                s = s + ", ";
            s = s + ((BaseNode)anode[k]).generateSelf(i);
        }

        s = s + "};\n";
        return s;
    }

    public void createEnumEntry()
    {
        ModuleCreatePanel modulepanel = new ModuleCreatePanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(modulepanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateEntry")); 
        dialog = TopManager.getDefault().createDialog(exdialogdescriptor);
        dialog.setVisible(true);    
        String s = modulepanel.getName();
        NameKey namedkey = new NameKey(13, s);
       ((IDLBaseChildren)getChildren()).addKey(namedkey);
        
       
       
        
    }

    public BasePanel getEditPanel()
    {
        EnumPanel enumpanel = new EnumPanel();
        enumpanel.setName(getName());
        ArrayList arraylist = ((IDLBaseChildren)getChildren()).getKeys();
        Iterator iterator = arraylist.iterator();
        String s = "";
        for(int i = 0; iterator.hasNext(); i++)
        {
            if(i != 0)
                s = s + ", ";
            s = s + ((NameKey)iterator.next()).getName();
        }

        enumpanel.setValues(s);
        return enumpanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof EnumPanel)
        {
            String s = ((EnumPanel)BasePanel).getName();
            String s1 = ((EnumPanel)BasePanel).getValues();
            EnumKey enumkey = (EnumKey)key;
            if(!enumkey.getName().equals(s))
            {
                setName(s);
                enumkey.setName(s);
            }
            buildEntries(s1);
        }
    }

    private void buildEntries(String s)
    {
        StringTokenizer stringtokenizer = new StringTokenizer(s, ",");
        ArrayList arraylist = new ArrayList();
        String s1;
        for(; stringtokenizer.hasMoreTokens(); arraylist.add(new NameKey(13, s1)))
            s1 = stringtokenizer.nextToken().trim();

        ((IDLBaseChildren)getChildren()).removeAllKeys(false);
        ((IDLBaseChildren)getChildren()).addKeys(arraylist);
    }

   public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/enum";
    
}
