
package org.netbeans.modules.openoffice.wizard.panels.idl;

import java.awt.*;
import java.util.ResourceBundle;
import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
//import org.netbeans.modules.openoffice.wizard.nodes.utils.IdlUtilities;


public class AliasPanel extends BasePanel
    implements DocumentListener
{

    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField name;
    private JTextField type;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle");    
        
        
    public AliasPanel()
    {
        initComponents();
        postInitComponents();
    }

    public String getName()
    {
        return name.getText().trim();
    }

    public void setName(String s)
    {
        name.setText(s);
    }

    public String getType()
    {
        return type.getText().trim();
    }

    public void setType(String s)
    {
        type.setText(s);
    }

   

    private void postInitComponents()
    {
        name.getDocument().addDocumentListener(this);
        type.getDocument().addDocumentListener(this);
       
    }

    private void initComponents()
    {
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();
        jLabel3 = new JLabel();
        name = new JTextField();
        type = new JTextField();
        
        setLayout(new GridBagLayout());
        setPreferredSize(new Dimension(250, 80));
        jLabel1.setText(bundle.getString("TXT_ModuleName"));
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(8, 8, 4, 4);
        gridbagconstraints.anchor = 17;
        add(jLabel1, gridbagconstraints);
        jLabel2.setText(bundle.getString("TXT_Type"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.insets = new Insets(4, 8, 4, 4);
        gridbagconstraints.anchor = 17;
        add(jLabel2, gridbagconstraints);
        
        name.setPreferredSize(new Dimension(100, 16));
        name.setToolTipText(bundle.getString("TIP_AliasName"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(8, 4, 4, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(name, gridbagconstraints);
        type.setPreferredSize(new Dimension(100, 16));
        type.setToolTipText(bundle.getString("TIP_AliasType"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(4, 4, 4, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(type, gridbagconstraints);
        
    }

    public void removeUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void changedUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void insertUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    private void checkState()
    {
//        if(type.getText().length() > 0 && IdlUtilities.isValidIDLIdentifier(name.getText()) && IdlUtilities.validLength(length.getText()))
//            enableOk();
//        else
//            disableOk();
    }

    

}
