
package org.netbeans.modules.openoffice.wizard.panels.idl;

import java.beans.*;
import javax.swing.JPanel;

public class BasePanel extends JPanel
{

    public BasePanel()
    {
        listeners = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener)
    {
        listeners.addPropertyChangeListener(propertychangelistener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener)
    {
        listeners.removePropertyChangeListener(propertychangelistener);
    }

    public void enableOk()
    {
        PropertyChangeEvent propertychangeevent = new PropertyChangeEvent(this, "Ok", null, new Boolean(true));
        listeners.firePropertyChange(propertychangeevent);
    }

    public void disableOk()
    {
        PropertyChangeEvent propertychangeevent = new PropertyChangeEvent(this, "Ok", null, new Boolean(false));
        listeners.firePropertyChange(propertychangeevent);
    }

    public void enableCancel()
    {
        PropertyChangeEvent propertychangeevent = new PropertyChangeEvent(this, "Cancel", new Boolean(true), null);
        listeners.firePropertyChange(propertychangeevent);
    }

    public void disableCancel()
    {
        PropertyChangeEvent propertychangeevent = new PropertyChangeEvent(this, "Cancel", new Boolean(false), null);
        listeners.firePropertyChange(propertychangeevent);
    }

    private PropertyChangeSupport listeners;
}
