/*************************************************************************
 *
 *  $RCSfile: dbexch.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2001/08/09 15:12:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SBA_DBEXCH_HXX
#define _SBA_DBEXCH_HXX

#ifndef _SBA_DBDATDEF_HXX
#include "dbdatdef.hxx"
#endif

#ifndef _SBA_DBDEFOBJ_HXX
#include "dbdefobj.hxx"
#endif

#ifndef _SBA_SBADB_HXX
#include "sbadb.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

namespace com { namespace sun { namespace star { namespace beans { 
	class XPropertySet;
}}}}

#define SBA_DATATYPE_INTERNAL_EXPLOREREXCHANGE	"SbaInternal - transfer SbaExplorerExchObj"

//==================================================================
// SbaCopyTableInfo
// Info ueber die Zielspalte beim Kopieren
//==================================================================
class SbaCopyTableInfo
{
	long nSourceColumn;
	long nDestColumn;
	String aFieldName;

public:
	SbaCopyTableInfo( const String& rFieldName, long nDestCol, long nSourceCol );
	~SbaCopyTableInfo();

	long GetSourceColumn() { return nSourceColumn; }
	long GetDestColumn() { return nDestColumn; }
};

DECLARE_LIST( SbaCopyTableInfoList, SbaCopyTableInfo* );


//==================================================================
// SbaRefContainer :
// Container, auf den Smartpointer gehalten werden koennen
//==================================================================
class SbaRefContainer : public SvRefBase, public Container
{
public:
	SbaRefContainer();
	virtual ~SbaRefContainer();
};

SV_DECL_IMPL_REF( SbaRefContainer );


//==================================================================
// SbaDataExchObj :
// Basisklasse fuer den Datenaustausch in SBA
//==================================================================
class SbaDataExchObj : public SvDataMemberObject
{
	SvRefBaseRef xExchObj;
protected:
	static String aDataExchangeFormat;
	static String aFormExchangeFormat;
	static String aReportExchangeFormat;
	static String aRTFExchangeFormat;
	static String aHTMLExchangeFormat;

public:
	TYPEINFO();
	SbaDataExchObj();
	virtual ~SbaDataExchObj();

	virtual void		SetExchObj( SvRefBase* pExchObj ){ xExchObj = pExchObj; }
	virtual SvRefBase*	GetExchObj(){ return xExchObj; }

	virtual BOOL GetData( SvData* );
	//virtual BOOL SetData( SvData * );
	virtual void SetBookmark( const String& rURL, const String& rLinkName );

};

SV_DECL_IMPL_REF( SbaDataExchObj );


//==================================================================
// SbaExplorerExchObj :
// Zusaetzliche Daten fuer den Datenaustausch im Explorer
//==================================================================
class SbaTableDef;
class SbaColumnList;
class SbaExplorerExchObj : public SbaDataExchObj
{
public:
	enum ACTION_TYPE { AT_COPY, AT_MOVE, AT_UNDEF,AT_APPEND };

private:
	// entweder ist m_xSourceDef gueltig ...
	SbaDBDefRef		m_xSourceDef;
	// ... oder es muss erst aus den folgenden Angaben zusammengebastelt werden
	DBObject		m_eKind;
	String			m_sName;
	String			m_aDataExchange;
	String			m_aDbName;

	SbaCopyTableInfoList aFieldNameList;
	// in Create...Def interesant
	void*			m_vColumns;		// Welche Spalten "ubernommen werden sollen
	void*			m_mNameMapping;
	ACTION_TYPE		m_atDoingCurrently;
	USHORT			m_nLastAction; // welche Aktion im CopyDialog als letztes ausgefuehrt wurde

	static BOOL CopyIndexes( SbaTableDef* pSourceTableDef, SbaTableDef* pDestTableDef );
	static BOOL CopyStructure( SbaDBDataDef* pSourceDef, SbaTableDef* pDestDef );

	BOOL CreateTableDef( SbaDatabase* pDestDatabase );
	BOOL CreateQueryDef( SbaDatabase* pDestDatabase );
	BOOL CreateFileDef( SbaDatabase* pDestDatabase, DBObject eDropObj );


	static String ShortenTableName( const String& rName, ULONG nNewLength, SbaDatabase* pDestDatabase );

	virtual BOOL DeleteSourceDefAfterCopy();

	void	ShowCreationError(const SdbStatus& rSourceError, const SdbStatus& rDestError);
		// von Create...Def benutzt

	// get the database and the def object
	BOOL	GetDBDef();
	// release the database and the def object -> must be called after all is done
	void	ReleaseDBDef();

public:
	TYPEINFO();
	SbaExplorerExchObj( SbaDBDef* pSourceDef, const String& rExchString = String() );
	SbaExplorerExchObj( SbaDatabase* pDB, DBObject eKind, const String& rName, const String& rExchString = String() );
		// zweiter Constructor ist fuer 'lazy init', das Def-Objet wird erst geoeffnet, wenn es
		// benoetigt wird
	virtual ~SbaExplorerExchObj();

	virtual BOOL GetData( SvData* );
	virtual BOOL GetData( SbaDBDataDef* pDestDef, SdbCursor* pDestCursor=NULL,BOOL bSetAutoIncrement=FALSE );
	virtual BOOL GetData( const ::com::sun::star::uno::Reference < ::com::sun::star::beans::XPropertySet >& xDataSource );
		// try to construct a SbaDBDataDef from the properties of the data source and call a GetData on this definition

	virtual BOOL QueryInsertObject( DBObject eObj );
	virtual BOOL CreateDestDef( SbaDatabase* pDestDatabase, ACTION_TYPE atHow, DBObject eDropObj,USHORT nLastAction );

	virtual SbaDBDefRef GetSourceDef();
	// void *m_vColumns is a vector<ULONG>. if m_vColumns == NULL then a vector<ULONG> will be allocated
	// void* _mNameMapping is map<String,String,SbaStringCompare>
	static BOOL CheckColumnMerge(const SbaColumnList& rSourceCols,const SbaColumnList& rDestCols,void *&m_vColumns,void* _mNameMapping);
};

SV_DECL_IMPL_REF( SbaExplorerExchObj );
// ==============================================================================================
// SbaRTFExchObj
// ==============================================================================================
class SbaRTFExchObj : public SbaDataExchObj
{
	SbaDatabase* m_pDatabase;
public:
	TYPEINFO();
	SbaRTFExchObj(SbaDatabase *pDatabase) : m_pDatabase(pDatabase){};
	virtual BOOL GetData(SvData* pData);
	virtual BOOL SetData(SvData* pData);
	virtual BOOL InsertRTFTable(SvStorageStreamRef &rStream);
};
SV_DECL_IMPL_REF( SbaRTFExchObj );
// ==============================================================================================
// SbaHTMLExchObj
// ==============================================================================================
class SbaHTMLExchObj : public SbaDataExchObj
{
	SbaDatabase* m_pDatabase;
public:
	TYPEINFO();
	SbaHTMLExchObj(SbaDatabase *pDatabase) : m_pDatabase(pDatabase){};
	virtual BOOL GetData(SvData* pData);
	virtual BOOL SetData(SvData* pData);
	virtual BOOL InsertHTMLTable(SvStorageStreamRef &rStream);
};
SV_DECL_IMPL_REF( SbaHTMLExchObj );

#endif

