/*************************************************************************
 *
 *  $RCSfile: sbahints.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SBA_SBAHINTS_HXX
#define _SBA_SBAHINTS_HXX

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif

#ifndef _SBA_DBDEFOBJ_HXX
#include "dbdefobj.hxx"
#endif

#ifndef _SBA_DBQRYOBJ_HXX
#include "dbqryobj.hxx"
#endif

#ifndef _SBA_SBADB_HXX
#include "sbadb.hxx"
#endif

class SbaQueryObj;

//==================================================================
// SbaObjectExt
//==================================================================
class SbaHint : public SfxHint
{
public:
	TYPEINFO();
};

//==================================================================
// SbaDBDefHint
// nur synchron ausfuehren
//==================================================================
class SbaDBDefHint : public SbaHint
{
public:
	enum SbaDBDefAction
	{
		dbCreate,		// Object ist erzeugt worden
		dbRename,		// Object ist umbenannt
		dbDelete,		// Object geloescht
		dbRelease
	};

	SbaDBDef*		pDBDef;
	SbaDBDefAction	eAction;
	BOOL			bDenyRelease;

public:
	SbaDBDefHint(SbaDBDef* pDef, SbaDBDefAction eAc)
				:pDBDef(pDef), eAction(eAc), bDenyRelease(FALSE){}

	TYPEINFO();
	SbaDBDef* GetDBDef() const {return pDBDef;}
	SbaDatabase* GetDatabase() const {return pDBDef->GetDatabase();}
	SbaDBDefAction GetAction() const {return eAction;}
	BOOL CanRelease() const {return !bDenyRelease;}
	void DenyRelease() {bDenyRelease = TRUE;}
};

//==================================================================
// SbaDBHint
// nur synchron ausfuehren!!
//==================================================================
class SbaDBHint : public SbaHint
{
public:
	enum SbaDBAction
	{
		dbRename,
		dbDelete,
		dbRelease		// Datenbank soll freigegeben werden
	};

	SbaDatabase*	pDatabase;
	SbaDBAction		eAction;
	BOOL			bDenyRelease;

public:
	SbaDBHint(SbaDatabase* pDB, SbaDBAction eAc)
			:pDatabase(pDB), eAction(eAc), bDenyRelease(FALSE){}
	TYPEINFO();

	SbaDatabase* GetDatabase() const {return pDatabase;}
	SbaDBAction GetAction() const {return eAction;}
	BOOL CanRelease() const {return !bDenyRelease;}
	void DenyRelease() {bDenyRelease = TRUE;}
};

class SbaQueryChangedHint : public SbaHint
{
	String aDatabaseName;
	String aName;
	String aStatement;

public:
	TYPEINFO();
	SbaQueryChangedHint(const String& rDB, const String& rName, const String& rStatement)
				:aDatabaseName(rDB),aName(rName),aStatement(rStatement){}
	const String& DatabaseName() const {return aDatabaseName;}
	const String& Name() const {return aName;}
	const String& Statement() const {return aStatement;}
};

class SbaQueryReceivedHint : public SbaHint
{
public:
	TYPEINFO();
	SbaQueryReceivedHint(){}
};

class SbaViewUpdateQueryHint : public SbaHint
{
	String aStatement;
public:
	TYPEINFO();
	SbaViewUpdateQueryHint(const String& rStatement):aStatement(rStatement){}
	const String& Statement() const {return aStatement;}
};

#endif
