/*************************************************************************
 *
 *  $RCSfile: sbaexpl2.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _OFA_SBAEXPL2_HXX
#define _OFA_SBAEXPL2_HXX

#ifndef _OFA_SBAEXPL_HXX
#include "sbaexpl.hxx"
#endif

#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif

#ifndef _EXPCONT_HXX //autogen
#include <sfx2/expcont.hxx>
#endif

#ifndef _EXPLMENU_HXX //autogen
#include <sfx2/explmenu.hxx>
#endif

#ifndef _ICON_HXX //autogen
#include <vcl/icon.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif


class SbaDatabase;
class SbaDatabaseContainer;

//-------------------------------------------------------------------------
// Container von Queries(Explorer)

class SbaQueryContainer: public SbaDBFolder
{
	friend class SbaQueryContent;

public:
	TYPEINFO();
	SbaQueryContainer();

protected:
	virtual Image GetImage( SfxExplorerContentImage eImage );
	virtual void Load(BOOL);
	virtual Icon GetIcon();
	virtual String ToURL() const;
	virtual String GetUniqueName();
	virtual void CallWizardImpl();
};

//-------------------------------------------------------------------------
// eine Tabelle

class SbaQueryContent: public SbaDBContent
{
protected:
	SbaQueryContent():SbaDBContent(dbQuery,CONTENT_URLTOOPEN |
								   CONTENT_INPLACECONSTRUCTION |
								   CONTENT_BROWSERVIEWAVAILABLE, TRUE){}

	SbaQueryContent(SfxExplorerContentStyle nStyle);

public:
	TYPEINFO();
	SbaQueryContent(const String& rTitle, SbaDatabase* pDatabase);
	SbaQueryContent(SbaDBDef& rObj);

protected:
	virtual Image GetImage( SfxExplorerContentImage eImage );
	virtual void Destroy();

	virtual BOOL Initialize(const String&);
	virtual BOOL Initialize(SfxExplorerContent* pParent);
	virtual void Open(const String& rTargetFrame);
	virtual void PrepareContextMenu( SfxExplorerContextMenu& rMenu );
	virtual BOOL TitleEdited(SfxExplorerContentView*, const String& rNewTitel);
	virtual BOOL Save();

private:
	DECL_LINK(OnDesignView, void* );
	DECL_LINK(OnSQLView,void*);
};

// Content der nur ueber URL erzeugt wird
class SbaStatementContent: public SbaQueryContent
{
	SbaStatementContent();
	String aStatement;

public:
	TYPEINFO();
	virtual BOOL Initialize(const String&);
	virtual String ToURL() const;
	virtual BOOL QueryFeature(SfxExplorerFeature eFeature);

protected:
	virtual SbaDBDef* GetDBObj() const;
};

#endif


