/*************************************************************************
 *
 *  $RCSfile: file.c,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:41:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "system.h"
#include <osl/file.h>

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif


oslFileError SAL_CALL osl_openDirectory( rtl_uString *strDirectoryPath, oslDirectory *pDirectory) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_getNextDirectoryItem( oslDirectory Directory, oslDirectoryItem *pItem, sal_uInt32	 uHint ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_closeDirectory( oslDirectory Directory ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_getDirectoryItem( rtl_uString *strFilePath, oslDirectoryItem *pItem ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_acquireDirectoryItem( oslDirectoryItem Item ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_releaseDirectoryItem( oslDirectoryItem Item ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_getFileStatus( oslDirectoryItem Item, oslFileStatus *pStatus, sal_uInt32 uFieldMask ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_unmountVolumeDevice( oslVolumeDeviceHandle Handle ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_automountVolumeDevice( oslVolumeDeviceHandle Handle ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_releaseVolumeDeviceHandle( oslVolumeDeviceHandle Handle ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_getVolumeDeviceMountPath( oslVolumeDeviceHandle Handle, rtl_uString **pstrPath )
{

    sal_Char Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getVolumeDeviceMountPath\n");
#endif

    if ( pstrPath == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out osl_getVolumeDeviceMountPath, invalid argument \n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");

    rtl_uString_newFromAscii(pstrPath,Buffer);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_getVolumeInformation( rtl_uString *strDirectory, oslVolumeInfo *pInfo, sal_uInt32 uFieldMask ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_openFile( rtl_uString *strPath, oslFileHandle *pHandle, sal_uInt32 uFlags ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_setFilePos( oslFileHandle Handle, sal_uInt32 uHow, sal_uInt64 uPos ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_getFilePos( oslFileHandle Handle, sal_uInt64 *pPos ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_setFileSize( oslFileHandle Handle, sal_uInt64 uSize ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_readFile( oslFileHandle Handle, void *pBuffer, sal_uInt64 uBytesRequested, sal_uInt64 *pBytesRead ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_writeFile( oslFileHandle Handle, const void *pBuffer, sal_uInt64 uBytesToWrite, sal_uInt64 *pBytesWritten ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_closeFile( oslFileHandle Handle ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_createDirectoryItemFromHandle( oslFileHandle Handle, oslDirectoryItem *pItem ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_createDirectory( rtl_uString* strPath ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_removeDirectory( rtl_uString* strPath ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_removeFile( rtl_uString* strPath ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_copyFile( rtl_uString* strPath, rtl_uString *strDestPath ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_moveFile( rtl_uString* strPath, rtl_uString *strDestPath ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_getCanonicalName( rtl_uString *strRequested, rtl_uString **strValid)
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getCanonicalName\n");
#endif

    if ( strValid == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getCanonicalName, invalid argument\n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");

    rtl_uString_newFromAscii(strValid,strRequested);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_getAbsolutePath( rtl_uString* strDirBase, rtl_uString *strRelative, rtl_uString **strAbsolute )
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getAbsolutePath\n");
#endif

    if ( strAbsolute == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getAbsolutePath, invalid argument\n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(strAbsolute,Buffer);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_normalizePath( rtl_uString *strSysPath, rtl_uString **strPath )
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_normalizePath\n");
#endif

    if ( strPath == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_normalizePath, invalid argument\n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(strPath,Buffer);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_getNormalizedPathFromFileURL( rtl_uString *urlPath, rtl_uString **strPath )
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getNormalizedPathFromFileURL\n");
#endif

    if ( strPath == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getNormalizedPathFromFileURL, invalid argument\n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(strPath,Buffer);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_getFileURLFromNormalizedPath( rtl_uString *normPath, rtl_uString **strPath)
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getFileURLFromNormalizedPath\n");
#endif

    if ( strPath == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getFileURLFromNormalizedPath, invalid argument\n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(strPath,Buffer);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_getSystemPathFromNormalizedPath( rtl_uString *normPath, rtl_uString **strPath)
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_getSystemPathFromNormalizedPath\n");
#endif

    if ( strPath == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_getSystemPathFromNormalizedPath, invalid argument\n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(strPath,Buffer);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_searchNormalizedPath( rtl_uString *filePath, rtl_uString *searchPath, rtl_uString **strPath )
{
    sal_Char  Buffer[PATH_MAX] = "";

#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"In  osl_searchNormalizedPath\n");
#endif

    if ( strPath == NULL )
    {
#if OSL_DEBUG_LEVEL > 1
        fprintf(stderr,"Out  osl_searchNormalizedPath, invalid argument\n");
#endif
        return osl_File_E_INVAL;
    }

    strcpy( Buffer, "test");
    rtl_uString_newFromAscii(strPath,Buffer);

    return osl_File_E_None;
}

oslFileError SAL_CALL osl_setFileAttributes( rtl_uString *filePath, sal_uInt64 uAttributes ) { return osl_File_E_ACCES; }

oslFileError SAL_CALL osl_setFileTime( rtl_uString *filePath, TimeValue *aCreationTime, TimeValue *aLastAccessTime, TimeValue *aLastWriteTime) { return osl_File_E_ACCES; }


