/*************************************************************************
 *
 *  $RCSfile: inetdns.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <premac.h>
#include <OpenTptInternet.h>
#include <Threads.h>
#include <postmac.h>

#include <osl/socket.h>

#include "sockimpl.h"

typedef struct TService {
	InetSvcRef	isRef;
	OTSyncEvent	fOpenComplete;
} TService;

typedef struct THostInfo {
	InetHostInfo	hostInfo;
	OTSyncEvent		fCompleted;
} THostInfo;

typedef struct TDomainInfo {
	InetDomainName	name;
	OTSyncEvent		fCompleted;
} TDomainInfo;


/* extern int __dllentry_force_link; */

/*****************************************************************************/
/* Functions for handling event gates */
/*****************************************************************************/

static pascal void ServiceNotifier(void *context, OTEventCode code, OTResult result, void *cookie)
{
/*	__dllentry_force_link = 1; */

	switch (code) {
		case T_OPENCOMPLETE: {
			TService *service = (TService *)context;
			service->isRef = (InetSvcRef)cookie;
			OTSetEvent(&service->fOpenComplete, result);
			break;
		}
		case T_DNRSTRINGTOADDRCOMPLETE: {
			THostInfo *info = (THostInfo *)cookie;
			OTSetEvent(&info->fCompleted, result);
			break;
		}
		case T_DNRADDRTONAMECOMPLETE: {
			TDomainInfo	*domain = (TDomainInfo *)cookie;
			OTSetEvent(&domain->fCompleted, result);
			break;
		}
		default:
			return;
	}
}

static TService *OTGetInetService(void)
{
	static TService	*svc = NULL;
	static sal_Bool	inProgress = false;

	while (inProgress)
		YieldToAnyThread();

	if (svc == NULL) {
		OSStatus	status;

		inProgress = true;
		svc = OTAllocMem(sizeof(TService));

		if (svc != NULL) {
			OTResetEvent(&svc->fOpenComplete);
			status = OTAsyncOpenInternetServices(kDefaultInternetServicesPath, 0, ServiceNotifier, svc);
			if (status == kOTNoError)
				status = OTGetEvent(&svc->fOpenComplete);
			if (status != kOTNoError) {
				OTFreeMem(svc);
				svc = NULL;
			}

		} else
			status = kENOMEMErr;
		inProgress = false;
	}
	return svc;
}

OSStatus OTResolveInetHostName(const sal_Char *pszHostName, InetHostInfo *pHostInfo)
{
	THostInfo	info;
	OSStatus	status;
	TService	*service = OTGetInetService();

	OTResetEvent(&info.fCompleted);
	status = OTInetStringToAddress(service->isRef, (sal_Char *)pszHostName, (InetHostInfo *)&info);
	if (status == kOTNoError)
		status = OTGetEvent(&info.fCompleted);
	if (status == kOTNoError)
	{
		int len = strlen(info.hostInfo.name);

		if (len > 0 && info.hostInfo.name[len-1] == '.')
			info.hostInfo.name[len-1] = '\0';
		*pHostInfo = info.hostInfo;
	}

	return status;
}

OSStatus OTResolveInetHost(InetHost host, InetDomainName name)
{
	OSStatus	status;
	TDomainInfo	domain;
	TService	*service = OTGetInetService();

	OTResetEvent(&domain.fCompleted);
	status = OTInetAddressToName(service->isRef, host, (sal_Char *)&domain);
	if (status == kOTNoError)
		status = OTGetEvent(&domain.fCompleted);
	if (status == kOTNoError)
	{
		int len = strlen(domain.name);

		if (len > 0 && domain.name[len-1] == '.')
			domain.name[len-1] = '\0';
		OTStrCopy(name, domain.name);
	}

	return status;
}

