/*************************************************************************
 *
 *  $RCSfile: ShellExecuteEx.c,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2001/05/21 11:17:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>
#include <systools/win32/StrConvert.h>

#include <shellapi.h>

#define DLL_EXPORT extern


DLL_EXPORT BOOL WINAPI ShellExecuteExW_9x (
	LPSHELLEXECUTEINFOW lpExecInfo )
{
	SHELLEXECUTEINFOA   seiA;
	LPSTR               lpVerbA       = NULL;
    LPSTR               lpFileA       = NULL;
    LPSTR               lpParametersA = NULL;
    LPSTR               lpDirectoryA  = NULL;

    LPCWSTR             lpVerbW;
    LPCWSTR             lpFileW;
    LPCWSTR             lpParametersW;
    LPCWSTR             lpDirectoryW;
    
	DWORD		        dwLastError;
    BOOL                bRet;

    __try
    {
        // save the values
        lpVerbW       = lpExecInfo->lpVerb;
        lpFileW       = lpExecInfo->lpFile;
        lpParametersW = lpExecInfo->lpParameters;
        lpDirectoryW  = lpExecInfo->lpDirectory;

        ZeroMemory( &seiA, sizeof( seiA ) );

        // copy the whole structure, the SHELLEXECUTEINFOA
        // and the SHELLEXECUTEINFOW structure should have
        // the same size
        memcpy( &seiA, lpExecInfo, sizeof( seiA ) );
        
        if ( lpVerbW )
	        AllocNecessarySpaceAndCopyWStr2Str( lpVerbW, &lpVerbA );

        if ( lpFileW )
	        AllocNecessarySpaceAndCopyWStr2Str( lpFileW, &lpFileA );

        if ( lpParametersW )
            AllocNecessarySpaceAndCopyWStr2Str( lpParametersW, &lpParametersA );

        if ( lpDirectoryW )
            AllocNecessarySpaceAndCopyWStr2Str( lpDirectoryW, &lpDirectoryA );

        seiA.lpVerb       = lpVerbA;
        seiA.lpFile       = lpFileA;
        seiA.lpParameters = lpParametersA;
        seiA.lpDirectory  = lpDirectoryA;

        bRet = ShellExecuteExA( &seiA );
    
        dwLastError = GetLastError( );

        // copy back the results
        memcpy( lpExecInfo, &seiA, sizeof( seiA ) );

        // restore the values
        lpExecInfo->lpVerb       = lpVerbW;
        lpExecInfo->lpFile       = lpFileW;
        lpExecInfo->lpParameters = lpParametersW;
        lpExecInfo->lpDirectory  = lpDirectoryW;
	    
	    // free the allocated resources
	    FreeSpaceStr( (LPSTR)lpVerbA );
        FreeSpaceStr( (LPSTR)lpFileA );
        FreeSpaceStr( (LPSTR)lpParametersA );
        FreeSpaceStr( (LPSTR)lpDirectoryA );

	    SetLastError( dwLastError );
    }
    __except( EXCEPTION_EXECUTE_HANDLER )
    {
        bRet = FALSE;
    }

	return bRet;
}





