/*************************************************************************
 *
 *  $RCSfile: DispatcherAdapterBase.java,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 11:14:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.sandbox.generic;

/**
 * Dies ist die Superklasse fuer alle fuer JavaScript generierten
 * Callback-Klassen. Sie enthaelt das JavaCallee-Interface, an das die
 * Methodenaufrufe weitergeleitet werden und das Objekt, auf
 * das sich die Aufrufe beziehen. Es werden Methoden zur Verfuegung
 * gestellt, mit denen die Returnwerte in Basistypen umgewandelt
 * werden koennen.
 * <BR>
 * @version     $Version: 1.1 $
 * @author      Markus Meyer
 * @see			com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory
 * @see			stardiv.gerufen.Dispatcher
 */
abstract public class DispatcherAdapterBase {
	public static IInvokeSec __iInvokeSec = null;

	private Dispatcher	dispatcher;
	protected Object		object;
	public static final boolean DEBUG = true;


	private Object invokeSec(String methodName, Object params[]) throws Exception {
		Object result = null;

		if(__iInvokeSec != null)
			result = __iInvokeSec.invokeSec(dispatcher, object, methodName, params);
		else
			result = dispatcher.invoke(object, methodName, params);

		return result;
	}


    /**
     * Der Aufrufverarbeiter und das Objekt auf das sich die Aufrufe
     * beziehen werden gesetzt.
     * Wird von Java eine Benachrichtigung aufgefangen, dann wird
     * sie Dispatcher weitergeleitet.
     *
     * @param Dispatcherer   ist der Empfaenger der Aufrufe.
     * @param object      ist das Objekt, auf das sich die Aufrufe beziehen.
     *
     * @see com.sun.star.lib.sandbox.generic.Dispatcherer#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     */
	public void setObject(Dispatcher dispatcher, Object object) {
	    this.dispatcher = dispatcher;
	    this.object = object;
	}

	public Object getObject() {
		return object;
	}

	/** 
	*/
	public boolean equals(Object obj)
	{
		if ((this.object != null) && (obj instanceof DispatcherAdapterBase))
			return (this.object.equals(((DispatcherAdapterBase)obj).object));
		else
			return false;
	}

	public int hashCode()
	{
		if (this.object == null)
			return 0;
		else
			return this.object.hashCode();
	}
	
	/**
	 * Ruft mit den uebergebenen Argumenten den JavDispatcherer auf.<BR>
	 * <pre>
	 * Object Dispatcherer.invoke( object, aMethodeName, aParams );
	 * </pre>
	 *
	 * @see #setObject(stardiv.js.ip.JavDispatcherer, java.lang.Object)
     * @see stardiv.js.ip.JavDispatcherer#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
	 */
	protected void invokeV(String aMethodName, Object[] aParams) throws Exception {
		invokeSec(aMethodName, aParams);
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den JavDispatcherer auf.<BR>
	 * <pre>
	 * Object Dispatcherer.invoke( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte Dispatcherer und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in einen "boolean" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird "false" zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.JavDispatcherer, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected boolean invokeZ(String aMethodName, Object[] aParams) throws Exception {
	    return ((Boolean)invokeSec(aMethodName, aParams)).booleanValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in ein "byte" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird 0 zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected byte invokeB(String aMethodName, Object[] aParams) throws Exception {
	    return ((Byte)invokeSec(aMethodName, aParams)).byteValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in ein "short" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird 0 zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected short invokeS(String aMethodName, Object[] aParams) throws Exception {
	    return ((Short)invokeSec(aMethodName, aParams)).shortValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in ein "char" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird 0 zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected char invokeC(String aMethodName, Object[] aParams) throws Exception {
	    return ((Character)invokeSec(aMethodName, aParams)).charValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in ein "int" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird 0 zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected int invokeI(String aMethodName, Object[] aParams) throws Exception {
		return ((Integer)invokeSec( aMethodName, aParams )).intValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in ein "long" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird 0 zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected long invokeJ(String aMethodName, Object[] aParams) throws Exception {
		return ((Long)invokeSec(aMethodName, aParams)).longValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in ein "float" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird 0 zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected float invokeF(String aMethodName, Object[] aParams) throws Exception {
	    return ((Float)invokeSec(aMethodName, aParams)).floatValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 * Der Rueckgabewert wird in ein "double" konvertiert. Ist eine
	 * Konvertierung nicht moeglich, wird 0 zurueckgegeben.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected double invokeD(String aMethodName, Object[] aParams) throws Exception {
		return ((Double)invokeSec(aMethodName, aParams)).doubleValue();
	}

	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Die Objekte dispatcher und object sind in setObject() uebergeben worden.
	 *
	 * @see #setObject(stardiv.js.ip.Javdispatcher, java.lang.Object)
     * @see stardiv.js.ip.Javdispatcher#invoke(java.lang.Object, java.lang.String, java.lang.Object[])
     * @see stardiv.js.ip.CallJava#convertTo(java.lang.Object, int, java.lang.Class)
	 */
	protected Object invokeL(String aMethodName, Object[] aParams) throws Exception {
	    return invokeSec(aMethodName, aParams);
	}
	
	/**
	 * Ruft mit den uebergebenen Argumenten den Javdispatcher auf.<BR>
	 * <pre>
	 * Object invokeSec( object, aMethodeName, aParams );
	 * </pre>
	 * Der Parameter aRetClassName zeigt an, in welchen Typ der
	 * Rueckgabewert konvertiert werden soll.
	 * Der Rueckgabewert wird entspechend den Richtlinien unter
	 * <a href="concepts.html#LiveConnect">LiveConnect</a>
	 * Konvertiert. Ist dies nicht moeglich, wird null zurueckgegeben.
	 */
	protected Object invokeL(String aRetClassName, String aMethodName, Object[] aParams) throws Exception {
	    Object aRet = invokeSec(aMethodName, aParams);
//  	    if( aRet != null )
//  	    {
//      	    try
//      	    {
//      	        Class aRetClass = Class.forName( aRetClassName );
//      	        aRet = CallJava.convertTo( aRet, UnionAccess.OBJECT, aRetClass );
//      	    }
//              catch( JSException e )
//      	    { return aRet = null; }
//              catch( ClassNotFoundException e )
//      	    { return aRet = null; }
//      	}
	    return aRet;
	}
}

