/*************************************************************************
 *
 *  $RCSfile: XclImpCharts.hxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: rt $ $Date: 2003/05/21 08:00:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef SC_XCLIMPCHARTS_HXX
#define SC_XCLIMPCHARTS_HXX

#ifndef _COM_SUN_STAR_CHART_XDIAGRAM_HPP_
#include <com/sun/star/chart/XDiagram.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _STACK_HXX
#include <tools/stack.hxx>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _TOOLS_COLOR_HXX
#include <tools/color.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif
#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"
#endif

#ifndef SC_XLSTYLE_HXX
#include "xlstyle.hxx"
#endif
#ifndef SC_XISTREAM_HXX
#include "xistream.hxx"
#endif
#ifndef SC_XIROOT_HXX
#include "xiroot.hxx"
#endif

#ifndef SC_XCLCHARTSAPIHELPER_HXX
#include "XclChartsApiHelper.hxx"
#endif
#ifndef _CHRTDEFS_HXX
#include "chrtdefs.hxx"
#endif
#ifndef _ROOT_HXX
#include "root.hxx"
#endif


class ScfProgressBar;
class XclImpFont;
class ExcelToSc8;


//___________________________________________________________________

enum XclImpChart_State  // internal import state
{
	csUnknown,			// unknown rec groups
    csKeepState,        // keep current state if BEGIN record occurs
	csGlobal,			// lowest level
	csChart,			// chart base info
	csChartFrame,		// chart shape (line/area)
	csSeries,			// a series with formats
	csPointFormat,		// format of a data point or a series
	csDefText,			// a default text
	csAxisParent,		// an axes set
	csAxis,				// axis (X, Y or Z)
	csFormat,			// chart format
	csLegend,			// legend
	csLegendText,		// text in a legend
	csLegendFrame,		// shape of the legend
	csDropbar,			// dropbar (stock charts)
	csDataFormat,		// data format (all series)
	csTitle,			// text of chart title
	csText,				// unknown text (becomes title or data caption)
	csTextFrame,		// shape of an unknown text
	csPlotarea			// diagram area in 2D charts
};



class XclImpChart_StateStack : protected Stack
{
public:
	Stack::Clear;
	Stack::Count;

    inline void                 Push( XclImpChart_State eState )
                                                { Stack::Push( (void*) eState ); }
    inline XclImpChart_State    Pop()           { return (XclImpChart_State)(ULONG) Stack::Pop(); }
    inline XclImpChart_State    Top() const     { return (XclImpChart_State)(ULONG) Stack::Top(); }
};


//___________________________________________________________________


struct XclImpChart_Pos
{
	INT32						nPosX;
	INT32						nPosY;
	UINT32						nWidth;
	UINT32						nHeight;

    inline                      XclImpChart_Pos();
};

inline XclImpChart_Pos::XclImpChart_Pos()
{
	nPosX = nPosY = 0;
	nWidth = nHeight = 0;
}


//___________________________________________________________________

struct XclImpChart_Lineformat
{
	ColorData					nLineColor;
	UINT16						nPattern;				// 0=solid, 1=dash, 2=dot, 3=dash-dot,
														// 4=dash-dot-dot, 5=none, 6=dark gray,
														// 7=medium gray, 8=light gray
	INT16						nWeight;				// -1=hairline, 0=single, 1=double, 2=triple
	BOOL						bAuto			: 1;	// Autoformat
	BOOL						bDrawTick 		: 1;

                                XclImpChart_Lineformat( XclImpStream& rStrm );
};


//___________________________________________________________________

class XclImpChart_FillData : private XclImpRoot
{
private:
    SfxItemSet                  maItemSet;      /// Translated fill items.
    CSS::drawing::BitmapMode    meMode;         /// Stretched/stacked bitmaps.

public:
    explicit                    XclImpChart_FillData( const XclImpRoot& rRoot );

    /** Reads the GELFRAME record (hatches, bitmaps, textures). */
    void                        ReadGelframe( XclImpStream& rStrm );
    /** Reads the PICF record (bitmap options). */
    void                        ReadPicf( XclImpStream& rStrm );

    /** Tries to fill the passed struct with gradient data.
        @return  true on success (if the item set contains gradient data). */
    bool                        GetGradient( CSS::awt::Gradient& rGradient ) const;
    /** Tries to return an XBitmap interface in the passed reference.
        @return  true on success (if the item set contains bitmap data). */
    bool                        GetBitmap( CSS::uno::Reference< CSS::awt::XBitmap >& rXBitmap ) const;
    /** Returns the bitmap mode. */
    inline CSS::drawing::BitmapMode GetBitmapMode() const { return meMode; }
};


//___________________________________________________________________

struct XclImpChart_Areaformat
{
	ColorData					nForeColor;
	ColorData					nBackColor;
	UINT16						nPattern;
    XclImpChart_FillData*       pFillData;
	BOOL						bAuto			: 1;
	BOOL						bInvertIfNeg	: 1;	// switch backgr and foregr

                                XclImpChart_Areaformat( XclImpStream& rStrm );
                                ~XclImpChart_Areaformat();
};


//___________________________________________________________________

struct XclImpChart_MarkerFormat
{
	ColorData					nForeColor;
	ColorData					nBackColor;
	UINT16						nMarkerType;		// 0=no marker, 1=square, 2=diamond, 3=triangle
													// 4=X, 5=star, 6=Dow-Jones, 7=standard deviation
													// 8=circle, 9=plus sign
	UINT32						nMarkerSize;
	BOOL						bAutoColor : 1;
	BOOL						bBackgroundNone : 1;
	BOOL						bForegroundNone : 1;

                                XclImpChart_MarkerFormat( XclImpStream& rStrm );
};


//___________________________________________________________________

struct XclImpChart_3DDataFormat
{
	UINT8						nBase;
	UINT8						nTop;
    inline                      XclImpChart_3DDataFormat( UINT8 nB, UINT8 nT );
};


inline XclImpChart_3DDataFormat::XclImpChart_3DDataFormat( UINT8 nB, UINT8 nT ) :
	nBase( nB ),
	nTop( nT )
{
}


//___________________________________________________________________

struct XclImpChart_Text
{
	String*						pString;
    const XclImpFont*           pFont;              // pointer to font buffer, do not delete

    XclImpChart_Lineformat*     pLine;              // shape border
    XclImpChart_Areaformat*     pArea;              // shape background

    XclImpChart_Pos             aPos;

    XclTextOrient               eRot;
	UINT16						nRot;				// 0...90 = 0...90, 91...180 = -1...-90, 255 = stacked

	UINT8						nAlignHor;			// 1=left, 2=center, 3=right, 4=justify
	UINT8						nAlignVert;			// 1=top, 2=center, 3=bottom, 4=justify

	UINT16						nMode;				// 1=transparent, 2=opaque

	UINT8						nDataLabelPlace;	// 1=outside (bar, pie), 2=inside (bar, pie)
													// 3=center (bar, line, pie), 4=axis (bar)
													// 5=above (line), 6=below (line)
													// 7=left (line), 8=right (line)
													// 9=auto (pie), 10=moved by user
													// 0=auto (pie), right (line), outside (bar),
													//		center (stacked bar)

	ColorData					nTextColor;

	UINT16						nLinkObj;			// 1 = chart title, 2 = Y axis, 3 = X axis
													// 4 = data point, 7 = Z axis
	UINT16						nLinkSer;			// number of series
	UINT16						nLinkPoint;			// number of data point

	BOOL						bAutoColor	: 1;
	BOOL						bShowKey	: 1;	// draw data label with legend key
	BOOL						bShowVal	: 1;	// text of label is the value of the data point
	BOOL						bVertical	: 1;	// text is vertical
	BOOL						bAutoText	: 1;	// generated
	BOOL						bGenerated	: 1;	// default or unmodified
	BOOL						bDeleted	: 1;	// automatic text label has been deleted by user
	BOOL						bAutoBackgr	: 1;	// background is set automaticaly
	BOOL						bShowLabPrct: 1;	// Pie-Chart: show category label and value as percentage
	BOOL						bShowPrct	: 1;	// Pie-Chart: show value as percentage
	BOOL						bShowBSize	: 1;	// show bubble sizes
	BOOL						bShowLabel	: 1;	// text of label is the category name

                                XclImpChart_Text();
                                XclImpChart_Text( XclImpStream& rStrm );
                                ~XclImpChart_Text();
};


//___________________________________________________________________

class XclImpChart_LinkedData
{
private:
    enum { dsNull, dsFirst, dsRows, dsCols }
                                eState;

    ScRangeListRef              xValList;       // series values
    ScRangeListRef              xTitleList;     // series titles
    ScRangeListRef              xCatList;       // category names (XY chart: X values)
    BOOL                        bHasCatList;

	UINT16						nSerCnt;
    USHORT                      nMinColVal;
    USHORT                      nMinRowVal;

    void                        UpdateMinValues( const ScRange& rRange );

public:
                                XclImpChart_LinkedData();

    void                        AppendValues( const ScRange& rRange );
    void                        AppendTitle( const ScRange& rRange );
    void                        AppendCatNames( const ScRange& rRange );

    inline BOOL                 HasCatNames() const     { return bHasCatList; }
	inline BOOL					GetDir() const			{ return eState != dsRows; }
	void						GetDir( const ScRange& rRange );
    inline const ScRangeListRef& GetRangeList() const    { return xValList; }

                                // close current data series
    void                        EndSeries();

                                // close all data series
                                // return = TRUE -> no titles (invalid ranges)
	BOOL						Close();
};


//___________________________________________________________________

struct XclImpChart_Point
{
	const UINT32				nPointNum;

    XclImpChart_Lineformat*     pLine;
    XclImpChart_Areaformat*     pArea;
    XclImpChart_Text*           pText;
    XclImpChart_MarkerFormat*   pMarker;    // MARKERFORMAT
    XclImpChart_3DDataFormat*   p3DData;    // 3DDATAFORMAT
	UINT16*						pPieDist;	// PIEFORMAT
	UINT16*						pLabel;		// ATTACHEDLABEL

                                XclImpChart_Point( UINT32 nPointNum );
                                ~XclImpChart_Point();

    void                        Update( const XclImpChart_Point& rPoint );
	BOOL						HasAttachedLabel();
};


//___________________________________________________________________

class XclImpChart_PointList : protected List
{
private:
    XclImpChart_Point*          Find( UINT16 nPoint );
protected:
public:
                                XclImpChart_PointList()    {}
    virtual                     ~XclImpChart_PointList();

								List::Count;

    inline XclImpChart_Point*   First() { return (XclImpChart_Point*) List::First(); }
    inline XclImpChart_Point*   Next()  { return (XclImpChart_Point*) List::Next(); }
    inline const XclImpChart_Point*
								Get( UINT32 nIndex ) const;

    inline void                 Append( XclImpChart_Point* pNew );
    XclImpChart_Point&          GetPoint( UINT16 nPoint );
	BOOL						HasAttachedLabel();
};


inline const XclImpChart_Point* XclImpChart_PointList::Get( UINT32 nIndex ) const
{
    return (const XclImpChart_Point*) List::GetObject( nIndex );
}

inline void XclImpChart_PointList::Append( XclImpChart_Point* pNew )
{
	List::Insert( pNew, LIST_APPEND );
}


//___________________________________________________________________

struct XclImpChart_Series
{
	UINT16						nSerInd;	// index of series
	UINT16						nSerNum;	// number of series
    XclImpChart_Point*          pAll;       // formats for series
    XclImpChart_PointList*      pSpec;      // list of different points
	BOOL						bSecondary : 1;

                                XclImpChart_Series( UINT16 nSerI );
                                ~XclImpChart_Series();

    XclImpChart_Point&          GetPoint( UINT16 nPointNum );
    BOOL                        HasAttachedLabel();

    sal_uInt32                  GetProgressSize() const;
};


//___________________________________________________________________

class XclImpChart_SeriesList : protected List
{
private:
    XclImpChart_Series*         pCurrSer;
    XclImpChart_Point*          pAll;

    XclImpChart_Series*         Find( UINT16 nSerInd );

protected:
public:
                                XclImpChart_SeriesList();
    virtual                     ~XclImpChart_SeriesList();

								List::Count;

    inline XclImpChart_Series*  First() { return (XclImpChart_Series*) List::First(); }
    inline XclImpChart_Series*  Next()  { return (XclImpChart_Series*) List::Next(); }
    inline const XclImpChart_Series*
								Get( UINT32 nIndex ) const;
    const XclImpChart_Series*   FindBySerNum( UINT32 nSerNum ) const;
    inline const XclImpChart_Point*
								GetGlobalFormatPtr() const	{ return pAll; }

    inline void                 Append( XclImpChart_Series* pSer );

    XclImpChart_Series&         GetSeries( UINT16 nSerInd );
    XclImpChart_Point&          GetPoint( UINT16 nSerInd, UINT16 nPointNum );
    XclImpChart_Point&          GetGlobalFormat();
	BOOL						HasAttachedLabel();

	void						SetSeriesNumber( UINT16 nSerInd, UINT16 nSerNum );
	void						SetSecondaryFlag( UINT16 nSerInd );

    sal_uInt32                  GetProgressSize() const;
};

inline const XclImpChart_Series* XclImpChart_SeriesList::Get( UINT32 nIndex ) const
{
    return (const XclImpChart_Series*) List::GetObject( nIndex );
}

inline void XclImpChart_SeriesList::Append( XclImpChart_Series* pSer )
{
	List::Insert( pSer, LIST_APPEND );
}


//___________________________________________________________________

struct XclImpChart_ValueRange
{
	double						fMin;
	double						fMax;
	double						fMajorInc;
	double						fMinorInc;
	double						fCross;
	BOOL						bAutoMin	: 1;
	BOOL						bAutoMax	: 1;
	BOOL						bAutoMajor	: 1;
	BOOL						bAutoMinor	: 1;
	BOOL						bAutoCross	: 1;
	BOOL						bLogScale	: 1;
	BOOL						bReverse	: 1;
	BOOL						bMaxCross	: 1;

                                XclImpChart_ValueRange( XclImpStream& rStrm );
};


//___________________________________________________________________

struct XclImpChart_Tick
{
	UINT8						nMajor;					// Tick marks
	UINT8						nMinor;
	UINT8						nLabel;

    XclTextOrient               eRot;                   // Ausrichtung Text
	UINT16						nRot;

	ColorData					nTextColor;

	BOOL						bTransparent	: 1;	// background opaque / transparent
	BOOL						bAutoColor		: 1;	// Textfarbe automatisch
	BOOL						bAutoBack		: 1;	// Texthintergrund automatisch
	BOOL						bAutoRot		: 1;

                                XclImpChart_Tick( XclImpStream& rStrm );
};


//___________________________________________________________________

struct XclImpChart_Axis
{
    XclImpChart_ValueRange*     pValueRange;
    XclImpChart_Tick*           pTick;

    XclImpChart_Lineformat*     pAxisLine;          // axis line
    XclImpChart_Lineformat*     pMajorLine;         // major grid
    XclImpChart_Lineformat*     pMinorLine;         // minor grid
    XclImpChart_Lineformat*     pWallLine;          // X axis = wall, Y axis = floor
    XclImpChart_Areaformat*     pWallArea;          // X axis = wall, Y axis = floor

    XclImpChart_Text*           pTitle;             // axis title
    XclImpChart_Text*           pCaptionText;       // axis caption

	UINT32						nNumForm;
	BOOL						bBreakText;

                                XclImpChart_Axis();
                                ~XclImpChart_Axis();

    sal_Bool                    HasCaption() const;
    sal_uInt32                  GetProgressSize() const;
};


//___________________________________________________________________

struct XclImpChart_AxesSet
{
    XclImpChart_Axis*           pCatAxis;
    XclImpChart_Axis*           pValueAxis;
    XclImpChart_Axis*           pSeriesAxis;

    XclImpChart_Pos             aPos;

    inline                      XclImpChart_AxesSet();
                                ~XclImpChart_AxesSet();

    sal_uInt32                  GetProgressSize() const;
};

inline XclImpChart_AxesSet::XclImpChart_AxesSet() :
	pCatAxis( NULL ),
	pValueAxis( NULL ),
	pSeriesAxis( NULL )
{
}


//___________________________________________________________________

struct XclImpChart_Data3D
{
	UINT16						nRot;				// 0...360
	INT16						nElev;				// -90...+90
	UINT16						nDist;				// 0...100
	UINT16						nHeight;			// height of plot volume relative to width and depth
	UINT16						nDepth;				// Depth of points relative to width
	UINT16						nGap;				// space between series
	BOOL						bPersp		: 1;	// perspective transform
	BOOL						bCluster	: 1;	// clustered or stacked
	BOOL						b3DScaling	: 1;	// use auto scaling
	BOOL						b2DWalls	: 1;	// use 2D walls and gridlines

                                XclImpChart_Data3D( XclImpStream& rStrm );
};


//___________________________________________________________________

struct XclImpChart_Dropbar
{
	UINT16						nGap;		// 0...100%
    XclImpChart_Lineformat*     pLine;
    XclImpChart_Areaformat*     pArea;

                                XclImpChart_Dropbar();
                                XclImpChart_Dropbar( XclImpStream& rStrm );
                                ~XclImpChart_Dropbar();
};


//___________________________________________________________________

struct XclImpChart_Legend
{
    XclImpChart_Pos             aPos;

    XclImpChart_Lineformat*     pLine;
    XclImpChart_Areaformat*     pArea;
    XclImpChart_Text*           pText;

	UINT8						nType;					// 0=bottom, 1=corner, 2=top, 3=right, 4=left,
														// 7=not docked or inside the plot area
	UINT8						nSpacing;				// 0=close, 1=medium, 2=open
	BOOL						bDocked			: 1;
	BOOL						bAutoSeries		: 1;	// automatic series distribution
	BOOL						bAutoPosX		: 1;
	BOOL						bAutoPosY		: 1;
	BOOL						bVert			: 1;	// =TRUE -> single column of entries,
														// =FALSE -> horizontal legend,
														//  manual sized: always FALSE
	BOOL						bWasDataTable	: 1;

                                XclImpChart_Legend( XclImpStream& rStrm );
                                ~XclImpChart_Legend();
};


//___________________________________________________________________

class XclImpChart : public ExcRoot
{
protected:
    XclImpChart_StateStack*     pStateStack;
    XclImpChart_State           eNewState;

    sal_Int32                   nProgressSeg;   // progress segment index

    XclImpChart_LinkedData*     pSourceData;

    XclImpChart_Lineformat*     pLine;
    XclImpChart_Areaformat*     pArea;

    XclImpChart_Lineformat*     pPlotLine;
    XclImpChart_Areaformat*     pPlotArea;

    XclImpChart_Text*           pChartTitle;

    XclImpChart_SeriesList*     pSeries;
	UINT16						nCurSeries;
    XclImpChart_Point*          pLastDataPoint;

    XclImpChart_AxesSet*        pPrimAS;
    XclImpChart_AxesSet*        pSecAS;

    XclImpChart_Data3D*         p3D;
    XclImpChart_Legend*         pLegend;
    XclImpChart_Dropbar*        pUpBar;
    XclImpChart_Dropbar*        pDownBar;
    XclImpChart_Lineformat*     pHiLoLine;

	INT16						nCurrDefText;		// number of default text
    XclImpChart_Text*           pDefText0;          // data labels as categories
    XclImpChart_Text*           pDefText1;          // data labels as value/perc.
    XclImpChart_Text*           pDefText2;          // all text
    XclImpChart_Text*           pNewText;           // unlinked text

	// pointers to current struct pointers
    XclImpChart_Lineformat**    ppCurrLine;
    XclImpChart_Areaformat**    ppCurrArea;
    XclImpChart_Text**          ppCurrText;
    XclImpChart_AxesSet*        pCurrAS;
    XclImpChart_Axis*           pCurrAxis;
    XclImpChart_Dropbar*        pCurrBar;

    XclLineMultiPSHelper        aLineMultiPSHelper;
    XclAreaMultiPSHelper        aAreaMultiPSHelper;
    XclFontMultiPSHelper        aFontMultiPSHelper;

    XclChartType                eChartType;
	UINT16						nMaxPieDist;
	UINT16						nRowOffset;

	BOOL						bSecondary			: 1;	// has secondary Y axis
	BOOL						bStock				: 1;
	BOOL						bSpline				: 1;

public:
	BOOL						bHasSeriesNames		: 1;
	BOOL						bHasCategoryNames	: 1;
	UINT16						nBaseTab;

protected:
                                // for derived classes
    virtual void                ApplyExt( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
                                // after Apply(), before unlock
    virtual void                ApplyExtPost( CSS::uno::Reference< CSS::lang::XComponent > xComponent );

    void                        UpdateState( XclImpChart_State eState );
    void                        MoveNewTextTo( XclImpChart_Text*& rpDest );
	void						LinkNewText();

    void                        EndAxis();
	void						EndSerValues();

    XclImpChart_Point&          GetPoint( UINT16 nSerInd, UINT16 nPointNum );
    XclImpChart_Point&          GetGlobalFormat();

    sal_Bool                    SetLineFormat(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclImpChart_Lineformat* pLineFormat );
    sal_Bool                    SetLineFormat(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclImpChart_Lineformat* pLineFormat );

    sal_Bool                    SetAreaFormat(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclImpChart_Areaformat* pAreaFormat );
    sal_Bool                    SetAreaFormat(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclImpChart_Areaformat* pAreaFormat );

    void                        SetFrameFormat(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclImpChart_Lineformat* pLine,
                                    const XclImpChart_Areaformat* pArea );
    void                        SetFrameFormat(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclImpChart_Lineformat* pLine,
                                    const XclImpChart_Areaformat* pArea );

    void                        SetTextData(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclImpChart_Text* pTextData,
                                    const XclImpChart_Text* pDefText );
    void                        SetTextData(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xTextShape,
                                    const XclImpChart_Text* pTextData,
                                    const XclImpChart_Text* pDefText,
                                    const Size& rRealSize );

    void                        SetDataCaption(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const UINT16* pFlags,
                                    const XclImpChart_Text* pTextData,
                                    const XclImpChart_Text* pDefText0,
                                    const XclImpChart_Text* pDefText1 );

    void                        SetDataRowProperties(
                                    CSS::uno::Reference< CSS::chart::XDiagram > xDiagram,
                                    ScfProgressBar& rProgress );

public:
                                XclImpChart( RootData& rRoot );
                                XclImpChart( XclImpChart& rCpy );         // flat copy, deletes pointers in rCpy
    virtual                     ~XclImpChart();

    void                        Reset();
    void                        InitProgress( ScfProgressBar& rProgress );

    void                        Apply(
                                    CSS::uno::Reference< CSS::lang::XComponent > xComponent,
                                    const Rectangle& rAnchor, ScfProgressBar& rProgress ); // common

	// common
    inline XclChartType         GetChartType() const    { return eChartType; }
    inline XclImpChart_State    GetState() const        { return pStateStack->Top(); }

	void						ReadBegin();
	void						ReadEnd();
	void						ReadChart();

	// FRAME group
	void						ReadFrame();
    void                        ReadLineformat( XclImpStream& rStrm );
    void                        ReadAreaformat( XclImpStream& rStrm );
    void                        ReadGelframe( XclImpStream& rStrm );
    void                        ReadPicf( XclImpStream& rStrm );

	// TEXT group
    void                        ReadText( XclImpStream& rStrm );
    void                        ReadFontx( XclImpStream& rStrm );
    void                        ReadSeriestext( XclImpStream& rStrm );
    void                        ReadObjectlink( XclImpStream& rStrm );
    void                        ReadDefaulttext( XclImpStream& rStrm );

	// SERIES group
	void						ReadSeries();
    void                        ReadSertocrt( XclImpStream& rStrm );
    void                        ReadAi( XclImpStream& rStrm, ExcelToSc8& rFmlConv );
	void						CloseSourceData();
    inline const XclImpChart_LinkedData*
								GetSourceData() const	{ return pSourceData; }
    inline BOOL                 HasXValues() const      { return pSourceData ? pSourceData->HasCatNames() : FALSE; }

	// DATAFORMAT group
    void                        ReadDataformat( XclImpStream& rStrm );
    void                        Read3DDataformat( XclImpStream& rStrm );
    void                        ReadPieformat( XclImpStream& rStrm );
    void                        ReadMarkerformat( XclImpStream& rStrm );
    void                        ReadSerfmt( XclImpStream& rStrm );
    void                        ReadAttachedlabel( XclImpStream& rStrm );

	// AXIS group
    void                        ReadAxesused( XclImpStream& rStrm );
    void                        ReadAxisparent( XclImpStream& rStrm );
    void                        ReadAxis( XclImpStream& rStrm );
    void                        ReadCatserrange( XclImpStream& rStrm );
    void                        ReadValuerange( XclImpStream& rStrm );
    void                        ReadTick( XclImpStream& rStrm );
    void                        ReadIfmt( XclImpStream& rStrm );
    void                        ReadAxislineformat( XclImpStream& rStrm );
	void						ReadPlotarea();

	// CHARTFORMAT group
	void						ReadChartformat();
    void                        Read3D( XclImpStream& rStrm );
    void                        ReadLegend( XclImpStream& rStrm );
    void                        ReadDropbar( XclImpStream& rStrm );
    void                        ReadChartline( XclImpStream& rStrm );
};


//___________________________________________________________________

class XclImpChartLine : public XclImpChart
{
private:
protected:
	BOOL						bStacked		: 1;
	BOOL						bCatAsPercent	: 1;
	BOOL						bHasShadow		: 1;

    virtual void                ApplyExt( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
    virtual void                ApplyExtPost( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
public:
                                XclImpChartLine( XclImpChart& rChart, XclImpStream& rStrm, BOOL bArea );
    virtual                     ~XclImpChartLine();
};


//___________________________________________________________________

class XclImpChartBar : public XclImpChart
{
private:
protected:
	INT16						nSpaceBeetwBar;			// % of bar width
	INT16						nSpaceBeetwCat;			// % of bar width
	BOOL						bHorizontal		: 1;	// FALSE = column, TRUE = bar
	BOOL						bStacked		: 1;
	BOOL						bCatAsPercent	: 1;
	BOOL						bHasShadow		: 1;

    virtual void                ApplyExt( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
public:
                                XclImpChartBar( XclImpChart& rChart, XclImpStream& rStrm );
    virtual                     ~XclImpChartBar();
};


//___________________________________________________________________

class XclImpChartPie : public XclImpChart
{
private:
protected:
	UINT16						nAngleFirstSlice;	// in degrees
	UINT16						nHoleSize;			// size of hole in %
	BOOL						bHasShadow			: 1;
	BOOL						bShowLeaderLines	: 1;

    virtual void                ApplyExt( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
public:
                                XclImpChartPie( XclImpChart& rChart, XclImpStream& rStrm );
    virtual                     ~XclImpChartPie();
};


//___________________________________________________________________

class XclImpChartRadar : public XclImpChart
{
private:
protected:
    virtual void                ApplyExt( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
public:
                                XclImpChartRadar( XclImpChart& rChart );
    virtual                     ~XclImpChartRadar();
};


//___________________________________________________________________

class XclImpChartSurface : public XclImpChart
{
private:
protected:
    virtual void                ApplyExt( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
public:
                                XclImpChartSurface( XclImpChart& rChart );
    virtual                     ~XclImpChartSurface();
};


//___________________________________________________________________

class XclImpChartScatter : public XclImpChart
{
private:
protected:
	UINT16						nBubbleSizeRatio;		// % of largest bubble comp. to chart in general
	UINT16						nBubbleSize;			// 1 = bubble size is area, 2 = ~ is width
	BOOL						bBubbles		: 1;	// bubble series
	BOOL						bShowNegBubbles	: 1;
	BOOL						bHasShadows		: 1;

    virtual void                ApplyExt( CSS::uno::Reference< CSS::lang::XComponent > xComponent );
public:
                                XclImpChartScatter( XclImpChart& rChart, XclImpStream& rStrm );
    virtual                     ~XclImpChartScatter();
};


//___________________________________________________________________

#endif

