/*************************************************************************
 *
 *  $RCSfile: dgrdata.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: bm $ $Date: 2002/08/08 13:49:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_DGRDATA_HXX
#define _SCH_DGRDATA_HXX

#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif
#ifndef _STDCTRL_HXX
#include <svtools/stdctrl.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFX_CHILDWIN_HXX
#include <sfx2/childwin.hxx>
#endif
#ifndef _BASEDLGS_HXX
#include <sfx2/basedlgs.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif

#include "databrws.hxx"

/** This is an implementation of SfxChildWindow.  Its purpose is to track and
    store the window position and size (stored in Views.xml)
 */
class SchDiagramDataWrapper : public SfxChildWindow
{
 public:
	SchDiagramDataWrapper(Window* pParent, USHORT nId,
						  SfxBindings* pBindings, SfxChildWinInfo* pInfo);

	SFX_DECL_CHILDWINDOW(SchDiagramDataWrapper);
};

/** This is the data edit dialog window
 */
class SchDiagramDataWindow : public SfxFloatingWindow, public SfxListener
{
private:
	BOOL                bReadOnly;
	ChartDataBrowseBox	aBrwData;
	ToolBox				aTbxData;
	SfxBindings*		pBindings;

	ImageList		maToolboxImageList;
	ImageList		maToolboxImageListHighContrast;

    /// handles actions of the toolbox
	DECL_LINK( ToolboxHdl, void* );
    /// is called, if the cursor of the table has moved
	DECL_LINK( BrowserCursorMovedHdl, void*);
    /// this is called if MiscOptions change, esp. High-Contrast mode
    DECL_LINK( MiscHdl, void* );
    /// is called when the contents of the edit cell changes
    DECL_LINK( CellModified, void* );

	void UpdateData();
    void Transfer ();
    void ApplyImageList();

    /** notifySystemWindow adds or remove the given window _pToRegister at the Systemwindow found when search _pWindow.
		@param	_pWindow
			The window which is used to search for the SystemWindow.
		@param	_pToRegister
			The window which should be added or removed on the TaskPaneList.
		@param	_rMemFunc
			The member function which should be called at the SystemWindow when found.
			Possible values are: 
			::comphelper::mem_fun(&TaskPaneList::AddWindow) 
			::comphelper::mem_fun(&TaskPaneList::RemoveWindow)

        @note this code is taken from dbaccess/source/ui/inc/UITools.hxx
	*/
	void notifySystemWindow( Window* _pWindow,
                             Window* _pToRegister, 
                             ::comphelper::mem_fun1_t< TaskPaneList, Window* > _rMemFunc );

protected:
	virtual void SFX_NOTIFY( SfxBroadcaster & rBC, const TypeId & rBCType,
                             const SfxHint & rHint, const TypeId & rHintType );
	virtual void FillInfo( SfxChildWinInfo & ) const;

public:
	void SetReadOnly( const BOOL b );
	SchDiagramDataWindow( Window* pParent, SfxBindings * pBind, SfxChildWindow * pChild );
	virtual ~SchDiagramDataWindow();

    // FloatingWindow
	virtual void Resize();

    // SystemWindow (base of FloatingWindow)
	virtual BOOL Close();
};

#endif	// _SCH_DGRDATA_HXX
